set terminal postscript portrait color enhanced  "Times-Roman, 25"

set output "GrandGanonicalWeissTempere2016Fig1.ps"


set size 1.4,0.65


#set multiplot


#set size 1.25,0.38

set nokey
set ylabel "{/Symbol D}{/Times-Italic N}" offset 1.5,0
set xlabel "{/Times-Italic T / T}_0"


#set label "(a)" at 0.00005,70 

set origin 0.0,0.75

set logscale x
set logscale y


set nolabel

#set ylabel "{/Symbol D}{/Times-Italic n}_0" offset 1.5,0

set format x "10^{%T}"

#set label "(b)" at 0.00001,70 

set origin 0.0,0.35

unset logscale y

set logscale x

plot[0.000001:2][0:110] "run0ww100N2000Nmax.dat" u 1:8 with lines lw 6 lt 3 lc rgb 'black', (x*0.5*0.312*10**8)**(0.5) with lines lw 8 lt 1 lc rgb 'green' , "GCE2b.dat" u 1:5 with lines lw 5 lt 5 lc rgb 'magenta', "GCE3b.dat" u 1:5 with lines lw 5 lt 5 lc rgb 'magenta', "GCE1b.dat" u 1:5 with lines lw 5 lt 5 lc rgb 'magenta', "GCE3bnew.dat" u 1:5 with lines lw 3 lt 3 lc rgb 'magenta', "GCE1bnew.dat" u 1:5 with lines lw 3 lt 3 lc rgb 'magenta', "GCE2bnew.dat" u 1:5 with lines lw 3 lt 3 lc rgb 'magenta' 



#, "GCE2new.dat" u 1:8 with lines lw 3 lt 3 lc rgb 'magenta', "GCE3new.dat" u 1:8 with lines lw 3 lt 3 lc rgb 'magenta', "GCE1new.dat" u 1:8 with lines lw 3 lt 3 lc rgb 'magenta'

set nolabel

set ylabel "<{/Times-Italic n}_0>" offset 1.5,0


set label "(c)" at 0.00005,70 

set origin 0.0,-0.025

set logscale x

