import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import scipy.constants as constants

a0 = constants.physical_constants['Bohr radius'][0]
au = constants.physical_constants['Hartree energy'][0]
u = constants.u
h = constants.h
c = constants.c
hbar = h/(2*np.pi)

files = ["1S","3S","3P","1P","1D","3D"]
labels = ["$^1\Sigma^+$","$^3\Sigma^+$","$^3\Pi$","$^1\Pi$","$^1\Delta$","$^3\Delta$"]

plt.figure(figsize=(5.5,8))
for i, (fn,label) in enumerate(zip(files,labels)):
    df = pd.read_csv(fn+'.csv')
    x = 1e9*df['R']*a0 #convert Bohr to nm
    for j in range(1,5):
        #convert atomic units (hartree) to THz
        try:
            plt.plot(x, 1e-12* (df['(%s)'%j+fn]+0.29661)*au/h, color='C%s'%i, 
                     label=label if j==1 else None, alpha=1/j**0.5) 
        except: break
    
plt.arrow(0.8, 0, 0, constants.c/817e3, ls='--', color='C1', fill=False, 
          length_includes_head=True, head_width=0.03, head_length=20, label='817 nm')
plt.arrow(0.7, 0, 0, constants.c/938e3, ls='--', color='C2', fill=False, 
          length_includes_head=True, head_width=0.03, head_length=20, label='938 nm')
plt.arrow(0.6, 0, 0, constants.c/1064e3, ls='--', color='C0', fill=False, 
          length_includes_head=True, head_width=0.03, head_length=20, label='1064 nm')
plt.annotate('5s + 6s', (1.,7))
plt.annotate('5s + 6p', (1.,350))
plt.annotate('5p + 6s', (1.,385))
plt.annotate('5s + 5d', (1.,438))
plt.annotate('X$^1\Sigma^+$', (.6,-110), va='center', ha='center', color='C0')
plt.annotate('a$^3\Sigma^+$', (.53,-25), va='center', ha='center', color='C1')
plt.annotate('b$^3\Pi$', (.47,130), va='center', ha='center', color='C2')
plt.annotate('A$^1\Sigma^+$', (.5,230), va='center', ha='center', color='C0', alpha=0.7)
plt.annotate('c$^3\Sigma^+$', (.58,290), va='center', ha='center', color='C0', alpha=0.6)
plt.hlines(0, 0,2, ls='--', color='k', alpha=0.25, lw=2)
plt.legend()
plt.xlim(0.25,1.3)
plt.ylim(-130,470)
plt.xlabel('Internuclear separation (nm)')
plt.ylabel('Energy / h (THz)')
plt.tight_layout()
plt.savefig('annotated_RbCs_potentials.pdf')