# -*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
plt.style.use(r'~/.matplotlib/vinstyle.mplstyle')
import os
import time
import sys
sys.path.append(r'Z:\Tweezer\People\Stefan\general-python')
sys.path.append(r'Z:\Tweezer\Code\Python 3.5\PyDex')
sys.path.append(r'Z:\Tweezer\Code\Python 3.5\PyDex\imageanalysis')
from fitandgraph import fit
from histoHandler import histo_handler

plt.close('all')

fname = r'Comp0.Measure{0}.dat'
flist = [fname.format(i) for i in [14,15,16,17,18,20]]
volts = np.array([0.5,0.6948,0.0164,-0.3392,-0.6948,-0.8371])
fields = np.array([201.36, 201.91,200,199,198,197.6]) - 197.1
centre_guess = [500,600,400,300,150,50]
inds = list(reversed(np.argsort(fields)))
plot = np.ones(len(fields))
fig, axs = plt.subplots(len(fields), 1, sharex=True, figsize=(6,6))
plt.subplots_adjust(hspace=0.0)

rslts = pd.DataFrame(np.zeros((len(flist),5)),columns=['B field (G)','Centre', 'Error in Centre',
                     'Offset', 'Error in Offset'])

scale = 2*(36.67e-3/2*0.84) /(np.pi* 1.53e-6**2)/1e7

for i, (B, fn, plot_fit,c) in enumerate(zip(fields, flist, plot, centre_guess)):
    df = pd.read_csv(fn, skiprows=2)
    # x = 0.5*(56+72)*np.sqrt(df['User variable']) # scaling to trap freq
    x = df['User variable']*scale # scaling to intensity
    y = df['0 atom survival probability']
    ey = df['Error in 0 atom survival probability']

    axs[inds[i]].errorbar(x, y, yerr=ey, fmt='o', label='%.1f G'%B, ms=4)
    if plot_fit == 1: 
        f = fit(x, y, ey, param = [0.35,c, 50,0.35]) # B*11.7+24, 5 # B*0.3,0.2
        axs[inds[i]].plot(*f.applyFit(f.offGauss,bounds=[[0,0,0.001,0.1],[0.9,1000,100,0.6]]))
        print(f.report())
        rslts['B field (G)'][i] = B
        rslts['Centre'][i] = f.ps[1]
        rslts['Error in Centre'][i] = f.perrs[1]
        rslts['Offset'][i] = f.ps[-1]
        rslts['Error in Offset'][i] = f.perrs[-1]
    
       
    axs[inds[i]].set_ylim(0.2, 0.9)
    axs[inds[i]].legend()
    
    
axs[len(axs)//2].set_ylabel('0 atom survival probability')
# axs[-1].set_xlabel('Cs Trap Frequency (kHz)')
axs[-1].set_xlabel('1064 Tweezer Intensity (kW/cm$^2$)')
#axs[-1].set_xlabel('1064 Power (V)')
plt.tight_layout()
plt.subplots_adjust(hspace=0.0, top=0.98, bottom=0.1, left=0.15, right=0.95)
plt.show()

#%%
def sqrt(x, a, b):
    return a*x**0.5 + b
plt.figure()
g = fit(rslts['B field (G)'], rslts['Centre'], rslts['Error in Centre'])
plt.errorbar(g.x, g.y, yerr=g.yerr, fmt='x')
xth = np.linspace(0, max(rslts['B field (G)']), 100)
g.getBestFit(g.linear)
g.args = ['a', 'b']
plt.plot(xth, g.linear(xth, *g.ps))
print(g.report())

plt.xlabel('B field (G) + 197.1G')
plt.ylabel('Loss Centre (mW)')    
y0, y1 = plt.ylim()
ax = plt.gca().twinx()
ax.set_ylim(y0, y1)
yax = np.linspace(y0,y1,7)
ax.set_yticks(yax)
ax.set_yticklabels(['%.2f'%y for y in yax*2/np.pi/(1.5e-4)**2/1e9])
ax.set_ylabel(r'1064 Tweezer Intensity $\times10^9$ (mW/cm$^2$)')
plt.tight_layout()
plt.show()

#%%
plt.figure()
g = fit(rslts['Centre'], rslts['B field (G)'])
plt.scatter(g.x, g.y)
plt.plot(*g.applyFit(g.linear))
print(g.report())
plt.title('Position of loss feature')
plt.ylabel('B field (G) + 197.1G')
plt.xlabel('1064 Tweezer Intensity (kW/cm$^2$)')    
plt.show()


#%%
plt.figure()
g = fit(rslts['B field (G)'], rslts['Offset'], rslts['Error in Offset'])
plt.errorbar(g.x, g.y, yerr=g.yerr, fmt='o')
#plt.errorbar(fields[:3], mean[0][:3], yerr=mean[1][:3], fmt='o')
plt.xlabel('B field (G) + 197.1G')
plt.ylabel('Fitted offset')
plt.tight_layout()
plt.show()