import os
os.chdir(os.path.dirname(__file__))
import numpy as np
import matplotlib.pyplot as plt

# columns: B (G), Cs, RbCs, Rb
plt.figure(figsize=(2,6.5))
data = np.genfromtxt("ScatteringLengths.csv", delimiter=',')
inds = np.logical_and(data[:,0]>178, data[:,0]<210)
i0, i1 = np.where(np.diff(data[inds,2])< -10)[0] + 1
# i0 = np.where(np.diff(data[inds,2])< -10)[0][0] + 1
plt.plot(data[inds,2][:i0], data[inds,0][:i0])
# plt.plot(data[inds,2][i0:], data[inds,0][i0:], color='C0')
plt.plot(data[inds,2][i0:i1], data[inds,0][i0:i1], color='C0')
plt.plot(data[inds,2][i1:], data[inds,0][i1:], color='C0')
plt.xlim(500,900)
plt.xticks([550,700,850])
plt.ylim(178,210)
plt.xlabel('Scattering Length ($a_0$)')
plt.ylabel('Magnetic Field (G)')
plt.savefig('scattering_length.svg')

#### OLD
# from __future__ import division
# import matplotlib.pyplot as pyplot
# import matplotlib.figure as figure
# import numpy
# from matplotlib import gridspec
# ############################### JQC Colours ############################################
# JQC = {'red'     :(198.0/255.0, 62.0/255.0, 98.0/255.0), \
#        'blue'    :(0.0/255.0, 70.0/255.0, 127.0/255.0), \
#        'purple'  :(126.0/255.0, 29.0/255.0, 123.0/255.0)}

# #Define Figure Space
# Scaling = 0.68
# FigRatio = numpy.array((10, 8.25))
# fig = pyplot.figure( figsize=FigRatio*Scaling, dpi=100)

# #Specify grid - No. of rows, No. of columns
# gs = gridspec.GridSpec(1,1,
#                        width_ratios=[1],
#                        height_ratios=[1]
#                        )

# pyplot.subplot(gs[0])
# sub = pyplot.gca()	

# Data = numpy.genfromtxt("ScatteringLengths.csv", delimiter=',')
# sub.plot(Data[:,0], Data[:,2], color=JQC['blue'])
# sub.plot(Data[:,0], Data[:,1], color=JQC['red'])
# sub.plot(Data[:,0], Data[:,3], color=JQC['purple'])
# sub.set_xlim(0, 400)
# sub.set_ylim(-1000, 3000)
# sub.set_ylabel("Scattering Length ($a_{0}$)", fontsize=14)
# sub.set_xlabel("Magnetic Field (G)", fontsize=14)
# sub.set_xticks([0, 100, 200, 300, 400])


# sub.set_yticks([-1000,0,1000,2000,3000])
# sub.axhline(0, xmin=0, xmax=1, linestyle='dashed', color='black')



# #pyplot.axhline(0, xmin=0.29, xmax=1, linestyle='dashed', color='black')
# fig.subplots_adjust(wspace = 0. , hspace =0.,right =0.97,top=0.93,left=0.14,bottom=0.13)
# # fig.savefig("Poster_ScatteringLength.png", dpi=300)
# fig.show()