# -*- coding: utf-8 -*-
import numpy as np
from scipy.signal import tukey, blackmanharris
import matplotlib.pyplot as plt
plt.style.use('../../vinstyle.mplstyle')

n = 1000
x = np.linspace(0,n,n); 
plt.fill_between(x, np.ones(n), color='C4', label='Square'); 
plt.fill_between(x, tukey(n)**0.5, color='C2', label=r'$\sqrt{\mathrm{Tukey}}$'); 
plt.fill_between(x, blackmanharris(n), color='C0', label='Blackman-Harris')
plt.axis('off')
plt.ylim(0,1)
plt.legend(loc='lower center', fontsize=14)
plt.savefig('Pulse_shapes.svg')