import matplotlib.pyplot as plt
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import pandas as pd
import sys
sys.path.append('../..')
from fitandgraph import fit


data = pd.read_csv('rabi_freq.csv')
data['P0'] = 1-data['P0']
rabis = list(set(data['Rabi']*0.35875))  # Rabi frequency in kHz
plt.figure(figsize=(7,4))
for det in set(data['Detuning']):
    df = data[abs(data['Detuning']-det)<1e-2]
    mean = df.groupby(['Rabi','Detuning']).mean().values.flatten()
    err = df.groupby(['Rabi','Detuning']).std().values.flatten()/(3-1)**0.5
    c = plt.errorbar(rabis, mean, err, fmt='o', label=str(int(det)))[0].get_color()
    f = fit(rabis, mean, err, [-0.1,3+det/2,2,0.05])
    plt.plot(*f.applyFit(f.offGauss), color=c)

plt.xlabel('Mean Rabi Frequency (kHz)')
plt.ylabel('$1 - P(n=0)$')
plt.yscale('log')
plt.legend(title='$\delta$ (kHz)')
plt.tight_layout()
plt.savefig('Simulation_Rabi.pdf')
plt.show()