import matplotlib.pyplot as plt
import numpy as np
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
     
pure, prob = np.loadtxt('OPpurity.csv', delimiter=',').T
plt.figure(figsize=(7,5))
ax1 = plt.subplot(111)
ax1.loglog(pure, 1-prob, 'o')
plt.xlabel('Polarisation Purity ($\Gamma_{OP} / \Gamma_{DP}$)')
plt.ylabel('$1 - P(n=0)$') 
print(pure[np.argmin(abs(prob-0.95))])
plt.fill_between([7,20000],[0.05,0.05],[1,1], color='C1', alpha=0.3)
plt.xlim(7,20000)
plt.ylim(1e-2,1)
plt.savefig('OPpurity.svg')
plt.show()
