import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import curve_fit
import lmfit
import os
os.chdir(os.path.dirname(__file__))
plt.style.use(r'../../vinstyle.mplstyle')
from RRtemperatureMC import TemperatureMonteCarlo
from uncertainties import ufloat



### release and recapture

Cs_938 = TemperatureMonteCarlo(
                  T  = 20e-6,
                  species = 'Cs',
                  num_sims = 1000,                
                  lm = 938e-9,
                  wr = 1.16e-6,
                  power = 4.1*0.726, # mW
                  polarisibility = 2880,  # a0^3
                  )

params = lmfit.Parameters()
params.add('T', value = 10e-6, min=0, vary=True)
params.add('amp', value = 0.97, vary=False)
times, data, errs = Cs_938.getMeasuredData('ROI0_Re_Measure1_RR.dat', omit=[])
mini = lmfit.Minimizer(Cs_938.residual, params, fcn_args=(times, data, errs))
results=mini.minimize(method='nelder', tol = 0.1)
# print(lmfit.fit_report(results))
opt = results.params
print('Release and Recapture:')
print('T = ',ufloat(opt['T'].value, opt['T'].stderr)*1e6, ' uK')        
xfit = np.linspace(0, np.max(times+3), 100)
yfit = Cs_938.runSimulation(opt['amp'], opt['T'], xfit, num_sims = 7000)

#%% plot
fig, (ax0, ax1) = plt.subplots(1, 2, sharey=False, figsize=(8,3))
ax0.errorbar(times, data, yerr = errs, marker = 'o', linestyle = 'none')#
ax0.plot(xfit, yfit)#
ax0.set_xlabel('$\mathrm{Release \ time \ ( \mu s)}$')
ax0.set_ylabel('$\mathrm{Recapture \ probability}$')

ax0.annotate('(b)', (170, 0.87))


### Heating rate
x = [0.005,0.020,0.200,5,0.5,3,2,1,4]
y = [20,24,21,135,28,80,65,51,110]
err = [2,7,6,1,2,10,9,5,5]
ax1.errorbar(x, y, yerr=err, fmt='o'); 
popt, pcov = curve_fit(lambda t,m,c: m*t+c, x, y, sigma=err)
t = np.linspace(0,5,200)
ax1.plot(t, t*popt[0] + popt[1])
ax1.set_xlabel('Hold Time (s)');
ax1.set_ylabel('Temperature ($\mu$K)')
ax1.annotate('(c)', (0.1, 120))
plt.tight_layout()
plt.savefig('temperature.svg', bbox_inches='tight')
plt.show()
