import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit

fig, axs = plt.subplots(1,2, figsize=(8,3), sharey=True)
plt.subplots_adjust(wspace=0.07)

### set QWP
for i in range(2):
    f = fit(param=[-0.6, 340, 6, 1])
    f.load('qwp/ROI%s_Re_Measure0.dat'%i)
    axs[0].errorbar(f.x, f.y, f.yerr, fmt='o', color='C%s'%(2-i), 
                    label='Rb' if i else 'Cs')
    axs[0].plot(*f.applyFit(f.offGauss), color='C%s'%(2-i))
    print('QWP: \n', f.report())
    
axs[0].set_xlabel('Waveplate Angle ($^\circ$)')
axs[0].set_ylabel(r'$|\downarrow\rangle$ Probability')
axs[0].annotate('(a)', (337, 0.9))
    
### set shims
for i in range(2):
    f = fit(param=[-0.6, 0, .2, 1])
    f.load('shims/ROI%s_Re_Measure0.dat'%i) # EW
    f.x *= 0.5107
    axs[1].errorbar(f.x, f.y, f.yerr, fmt='o', color='C%s'%(2-i), 
                    label='Rb' if i else 'Cs')
    axs[1].plot(*f.applyFit(f.offGauss), color='C%s'%(2-i))
    print('EW shim: \n', f.report())
    
axs[1].set_xlabel('E/W Shim Field (G)')
axs[1].annotate('(b)', (-0.5, 0.9))
axs[1].legend()

for i in range(2):
    f = fit(param=[-0.6, .3, .2, 1])
    f.load('shims/ROI%s_Re_Measure1.dat'%i) # EW
    f.x *= 0.5089
    # axs[2].errorbar(f.x, f.y, f.yerr, fmt='o', color='C%s'%(2-i), 
    #                 label='Rb' if i else 'Cs')
    # axs[2].plot(*f.applyFit(f.offGauss), color='C%s'%(2-i))
    f.getBestFit(f.offGauss)
    print('UD shim: ', f.report())

# axs[2].set_xlabel('U/D Shim Field (G)')
plt.savefig('op_opt.svg')