import numpy as np
import matplotlib.pyplot as plt
plt.style.use('../../../vinstyle.mplstyle')
import os
os.chdir(os.path.dirname(__file__))
import arrayFitter as af
import json

#%%
o = af.imageArray((7,1), 47) 

def crestfactor(freqs, phases, amps=[0.183,0.189,0.195,0.2,0.201,0.2,0.195] ):
    t = np.arange(int(1.024e6*2*np.pi))
    y = np.zeros(len(t))    
    for f, p, a in zip(freqs, phases, amps):
        y += 282*a*np.sin(t*f/1024 + p*np.pi/180)
    rms = np.sqrt(np.mean(y**2))
    return ( np.max(y)/rms, rms)
    

imname = 'Amp_{0}_phase/{1}.bmp'
scales = ['%.2f'%x for x in np.linspace(1,40,10)]
ims = {}
fits = {}
sums = {}
v = {}
for t in ['same', 'random', 'optimised']:
    ims[t] = []
    fits[t] = []
    sums[t] = []
    with open(os.path.dirname(imname).format(t)+'/7x1_{}_phase.awg'.format(t)) as jfile:
        param = json.load(jfile)['segments'][0]['Ch0']
    v[t] = {}
    v[t]['crest'], v[t]['rms'] = crestfactor(param['freq']['start_freq_MHz'], 
                                             param['freq']['start_phase'])
    for s in scales:
        o.fitImage(imname.format(t, s))
        o.getScaleFactors(2)
        fits[t].append(o.df['I0'])
        ims[t].append(o._imvals.copy())
        flat = ims[t][-1].sum(axis=1)
        sums[t].append(flat[195:850].sum()/(flat[:195].sum() + flat[850:].sum()))

#%%

out1 = []
out2 = [np.array(scales, dtype=float)/20*v['same']['rms']]

# from matplotlib import colors
# red = np.array(colors.to_rgba('C1')[:-1])
fig, (ax1, ax2) = plt.subplots(1,2, gridspec_kw={'width_ratios':[3,1]}, figsize=(9,4.2)) #, figsize=(7.5,5.5))
ref = np.max(ims['random'][5][:,80])
for key in ['same', 'random', 'optimised']: 
    ax1.plot(ims[key][5][:,80]/ref, label=key)
    out1.append(ims[key][5][:,80]/ref)
    ax2.plot(out2[0], sums[key], '-o', label=key)
    out2.append(sums[key])

ax1.set_xlabel('Pixel')
ax1.set_ylabel('Intensity')
ax1.text(-80, 1.14, '(a)')
ax1.fill_between([0,195], 0, 1, color='C4', alpha=0.1)
ax1.fill_between([850,1080], 0, 1, color='C4', alpha=0.1)
ax1.fill_between([195,850], 0, 1, color='C3', alpha=0.1)
ax1.text(480,0.9,'in', color='C3')
ax1.text(50,0.9,'out', color='C4')
ax1.set_xlim(0,1080)
ax1.set_ylim(0,1)
ax1.legend(title='Phase', bbox_to_anchor=(0.75,1.3), loc='upper left')

ax2.vlines([116.5]*2, 3.5, 33, color='k', ls='--')
ax2.set_xlabel('$V_\mathrm{rms}$ (mV)')
ax2.set_ylabel('$P_\mathrm{in}/P_\mathrm{out}$')
ax2.text(-240/1080*212, 39, '(b)')
ax2.set_xlim(0,212)
ax2.set_ylim()

plt.tight_layout()
plt.subplots_adjust(wspace=0.3)
plt.savefig('Phases.pdf')
plt.show()

np.savetxt('1.7a_data.csv', np.array(out1).T, delimiter=',', 
           header='Same_phase,Random_phase,Optimised_phase')
np.savetxt('1.7b_data.csv', np.array(out2).T, delimiter=',',
           header='V_rms (mV),Pin/Pout_Same,Pin/Pout_Random,Pin/Pout_Optimised')