"""Feshbach Resonance Theory plots
(a) bound state from closed channel tuned into resonance
(b) RbCs FRs between 175-200G
"""
import numpy as np
import matplotlib.pyplot as plt
from math import gamma
plt.style.use('../../../vinstyle.mplstyle')
from matplotlib.collections import LineCollection
from matplotlib import colors
import os
os.chdir(os.path.dirname(__file__))


c1 = np.array(colors.to_rgba('C1'))
c2 = np.array(colors.to_rgba('C2'))
x = np.array([np.linspace(0,1,256)]*3+[np.ones(256)]).T
cmap12 = colors.ListedColormap((c2-c1)*x + np.outer(c1, np.ones(256)).T)
cmap21 = colors.ListedColormap((c1-c2)*x + np.outer(c2, np.ones(256)).T)

fig, (ax1,ax3) = plt.subplots(1,2, figsize=(8,4))

# molecular potentials
x = np.linspace(0.4,3,500)
ax1.plot(x, -10/x**3+1/x**6, color='C2')
ax1.plot(x, -10/x**3+1/x**6 + 7, color='C1')
ax1.hlines(1, 0.48, 1.18, color='C1')
ax1.hlines(0,0,max(x),linestyles='dashed', color='k', alpha=0.3)
ax1.set_yticks([0])
ax1.set_xticks([])
ax1.set_xlabel('Internuclear Separation')
ax1.set_xlim(0.3,3)
ax1.set_ylabel('Energy')
ax1.set_ylim(-27,13)
ax1.annotate('(a)', (0.5,8))

def lc_gradient(x, y, cmap):
    cs = np.linspace(0,510,len(x))
    points = np.array([x, y]).T.reshape(-1, 1, 2)
    segments = np.concatenate([points[:-1], points[1:]], axis=1)
    lc = LineCollection(segments, cmap=cmap)
    lc.set_array(cs)
    return lc

# avoided crossing
subax = plt.axes([0.26,0.28,0.15,0.28])
x = np.linspace(-2,-0.01,200)
subax.add_collection(lc_gradient(x, -1/x, cmap12))
x = np.linspace(0.01,2,200)
subax.add_collection(lc_gradient(x-1, -1/x, cmap21))
# subax.plot(x-1, -1/x, color='k')
subax.hlines(0, -2,1, linestyles='dashed', color='C1', alpha=0.3)
subax.plot([-0.8,-0.2],[-3,3], 'C2--', alpha=0.3)
subax.set_xlim(-2,1)
subax.set_ylim(-3,3)
subax.set_xticks([])
subax.set_yticks([])
subax.set_xlabel('Magnetic Field')
subax.set_ylabel('Energy')

# Feshbach states
Data = np.genfromtxt("BoundStates.csv", delimiter=',')
B = Data[:,0]
i0 = np.where(np.logical_and(B >= 180, B < 200))[0]
ax3.plot(Data[i0,0], Data[i0,3], color='C1')
i1 = np.where(B <= 182.5)[0]
ax3.plot(Data[i1,0], Data[i1,3], color='C0')
ax3.plot(Data[:,0], Data[:,1], color='k')
ax3.set_xlim(175, 200)
ax3.set_ylim(-3.2, 0)
ax3.set_ylabel("Energy / $h$ (MHz)")
ax3.set_xlabel("Magnetic Field (G)")
# ax3.set_xticks([175, 180, 185, 190, 195, 200])
ax3.hlines(0,175,200,linestyles='dashed', color='k', alpha=0.5)
ax3.annotate('(b)', (177,-0.4))
ax3.annotate(r'|-1(1,3)s(1,3)$\rangle$', (191,-2.5), color='C1', rotation=90)
ax3.annotate(r'|-6(2,4)d(2,4)$\rangle$', (176.5,-2.5), color='C0', rotation=88)
plt.tight_layout()
plt.savefig('FR_and_FBstates.svg')
