import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit, weighted_std

fig, (ax1, ax2) = plt.subplots(1,2, sharey=True, figsize=(8,3))

# sweep duration
for m in [25,26]:
    df = pd.read_csv('Comp0.Measure%s.dat'%m, skiprows=2)
    df['x'] = df['User variable']
    df.rename(columns={'0 atom survival probability':'y', 
                'Error in 0 atom survival probability':'yerr'},inplace=True)
    ave = df.groupby(df.x).apply(lambda v: np.average(v.y, weights=v.yerr))
    averr = df.groupby(df.x).apply(weighted_std) # ##df.groupby(df.x).apply(lambda v: 1/np.sqrt(np.sum(1/v.yerr**2)))#
    label = 'Overlapped' if m==25 else 'Displaced'
    c = ax1.errorbar(ave.keys(), ave, yerr=averr, fmt='o', label=label)[0].get_color()
    np.savetxt('Duration_%s.csv'%label, np.array((ave.keys(), ave, averr)),
        header='# Duration of sweep (ms),2-body loss,Error in 2-body loss')
    f = fit(ave.keys(), ave.values, erry=averr, param = [1,0.7,0.5,0.2])  
    ax1.plot(*f.applyFit(f.knifeEdge), color=c)
    print(f.report())

ax1.legend()
ax1.set_ylabel(r'$P_{2\rightarrow 0}$')
ax1.set_xlabel('Duration of Sweep (ms)')
ax1.text(1.1, 0.61, '(a)')

#sweep hybridicity
df = pd.read_csv('Comp0.Measure3.dat', skiprows=2)
df['x'] = df['User variable']
df.rename(columns={'0 atom survival probability':'y', 
            'Error in 0 atom survival probability':'yerr'},inplace=True)
ave = df.groupby(df.x).apply(lambda v: np.average(v.y, weights=v.yerr))
averr = df.groupby(df.x).apply(weighted_std) # ##df.groupby(df.x).apply(lambda v: 1/np.sqrt(np.sum(1/v.yerr**2)))#
c = ax2.errorbar(ave.keys(), ave, yerr=averr, fmt='o', label=label)[0].get_color()
np.savetxt('Hybridicity.csv', np.array((ave.keys(), ave, averr)),
    header='# Hybridicity of sweep,2-body loss,Error in 2-body loss')
f = fit(ave.keys(), ave.values, erry=averr, param = [-0.3,0.66,0.1,0.8])  
ax2.plot(*f.applyFit(f.offGauss), color=c)
print(f.report())
ax2.set_xlabel('Hybridicity')
ax2.set_xticks(np.arange(0.1,1,0.2))
ax2.text(0.45, 0.61, '(b)')
ax2.set_xlim(-0.02,0.93)

plt.ylim(0,0.7)
# plt.tight_layout()
plt.subplots_adjust(wspace=0.03)

ax2.vlines(0.1, 0, 0.8, alpha=0.5, color='C2', linestyle='dashed', lw=4)
ax2.vlines(0.9, 0, 0.8, alpha=0.5, color='C3', linestyle='dotted', lw=4)

# trajectory
def minJerk(t,d,T):
    """
    This funtion is the smoothstep function used by the Ni group, which has minimum jerk. 
    t: sample/time
    d: total distance/frequency spanned
    T: total duration/number of samples desired
    """
    return d*(10*(t/T)**3 - 15*(t/T)**4 + 6*(t/T)**5)

def hybridJerk(t,d,T,a):
    """control the fraction of the trajectory that is minimum jerk.
    t: sample/time
    d: total distance/frequency spanned
    T: total duration/number of samples desired
    a: percentage of trajectory being minimum jerk (a=0 is 100% minimum jerk, a=1 is fully linear motion.
    """
    if(a==1):
        return d/T*t
    else:
        a1 = int(0.5*T*(1.-a))  # Handles the first portion of the acceleration.
        a2 = int(T-0.5*T*(1-a)) # Handles the linear part of the trajectory.
        a3 = int(T)             # Handles the last part of the deceleration.
        return np.concatenate((minJerk(t[:a1], 2*d/(2+15./4.*a/(1-a)), T*(1-a)),
            15.*d/(8*T + 7*T*a)*t[a1:a2] + 7*d*(a-1)/(2.*(8+7*a)),
            minJerk(t[a2:a3]-T*a, 2.*d/(2+15./4*a/(1 - a)), T*(1 - a)) + a*15*d/(8 + 7*a)))

subax = plt.axes([0.605,0.21,0.16,0.32])
t = np.arange(500)
subax.plot(t/500, hybridJerk(t, 4.5, 500, 0.1), '--', lw=3, label='0.1', color='C2')
subax.plot(t/500, hybridJerk(t, 4.5, 500, 0.9), ':', lw=3, label='0.9', color='C3')
subax.set_xlabel('Time', fontsize=13)
subax.set_ylabel('Distance', fontsize=13)
subax.set_yticks([])
subax.set_xticks([])
# subax.legend(title='Hybridicity', fontsize=13, title_fontsize=13)

plt.savefig('Associate_optimise.pdf',bbox_inches='tight')