"""Explain 2-body loss probabilities"""
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit

df = pd.read_csv('Comp0.Measure11.dat', skiprows=2)
x = df['User variable']*2.143 + 194.97 # B field in G

key = '%s atom survival probability'
plt.figure(figsize=(5,3))
ms = ['o', 'x', '^']
for i in range(3):
    col = 'C0' if not i else 'C%s'%(i+2)
    c = plt.errorbar(x, df[key%i], df['Error in '+key%i], color=col, fmt=ms[i], label=r'$2\rightarrow %s$'%i)[0].get_color()
    if not i%2:
        p0 = [-0.6, 197, 0.2, -0.6, 196.7, 0.01, 0.7] if i else [0.6, 197, 0.2, 0.6, 196.7, 0.01, 0.1]
        f = fit(x, df[key%i], df['Error in '+key%i], p0)
        plt.plot(*f.applyFit(f.doubleGauss), color=c)
plt.xlabel('B Field (G)')
plt.ylabel('Probability')
plt.legend()
plt.savefig('Comp0.Measure11_Losses.svg')