import matplotlib.pyplot as plt
import numpy as np
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')

t = np.linspace(0,4*(2/np.pi)**0.5,1000000)
# square pulse from 3.5T to 4.5T
sq = (t%(max(t)/2-0.5) < 1).astype(float) * (t//(max(t)/2-0.5)==1).astype(float) + 1/2**14

# blackman digitized to 14 bits
t2 = (t-max(t)/2+50/21/2)*21/50
b = 21/50 - 0.5*np.cos(2*np.pi*t2) + 2/25*np.cos(4*np.pi*t2)
# first zero is at 2pi t' = pi
b[t<max(t)/2-50/21/2] = 1/2**14
b[t>max(t)/2+50/21/2] = 1/2**14
bp = np.digitize(b, np.linspace(0,max(b),int(2**14)))/2**14
# blackman-harris
t2 = (t-max(t)/2+0.5/0.35875)*0.35875
bh = 0.35875 - 0.48829*np.cos(2*np.pi*t2) +0.14128*np.cos(4*np.pi*t2) - 0.01168*np.cos(6*np.pi*t2)
bh[t<max(t)/2-0.5/0.35875] = 1/2**14
bh[t>max(t)/2+0.5/0.35875] = 1/2**14
bh = (np.digitize(bh, np.linspace(0,max(bh),int(2**14)))/2**14)

# tukey window
from scipy.signal import tukey
a = 2/3
ind = np.argmin(abs(t-max(t)/2+0.5/(1-a/2)))
tk = np.concatenate((np.ones(ind)/2**14, tukey(len(t)-2*ind, a), np.ones(ind)/2**14))

#%%
fig, ax = plt.subplot_mosaic([['upper left','right'],['lower left','right']], 
                             figsize=(10,5), constrained_layout=True)
# plt.subplots_adjust(wspace=0.3)
fs = np.fft.fftfreq(len(t), max(t)/len(t))
T =  t - max(t)/2
ax['upper left'].plot(T, sq, label='Square', color='C2')
ax['upper left'].plot(T, bh, label='Blackman-Harris', color='C0')
ax['upper left'].plot(T, tk, label='Tukey', color='C4')
# ax['upper left'].legend()
ax['upper left'].set_xlabel('Time')
ax['upper left'].set_ylabel('Amplitude')
ax['upper left'].text(-1.6,0.8,'(a)')

# np.savetxt('Fig3a_data.csv', np.array([t, sq, tk, bh]).T, delimiter=',', 
    # header='Time from centre of pulse (arbitrary units),Square pulse amplitude,Tukey pulse amplitude,Blackman-Harris pulse amplitude')

outarr = np.array([fs])
for y, colour, label in zip([sq, tk, bh], ['C2','C4','C0'],['$\mathcal{F}$[Square]', '$\mathcal{F}$[Tukey]', '$\mathcal{F}$[Blackman-Harris]']):
    ft = np.abs(np.fft.fft(y))
    outarr = np.concatenate((outarr, [ft]))
    ax['lower left'].plot(fs, 20*np.log10(ft/np.max(ft)) , color=colour, label=label)
# np.savetxt('Fig3b_data.csv', outarr.T, delimiter=',',
#     header='Frequency (1/time),Fourier transform of square pulse (dB),Fourier transform of Tukey pulse (dB),Fourier transform of Blackman-Harris pulse (dB)')
ax['lower left'].set_xlabel('Frequency')
ax['lower left'].set_ylabel('Amplitude (dB)')
ax['lower left'].set_ylim(-150,0)
ax['lower left'].set_xlim(-30,30)
ax['lower left'].text(-27,-30 ,'(b)')

rabis, psquare, pblack, ptukey = np.loadtxt('Fig3c_data.csv', delimiter=',').T
ax['right'].semilogy(rabis, psquare, label='Square', color='C2')
ax['right'].semilogy(rabis, pblack, label='Blackman-Harris', color='C0')
ax['right'].semilogy(rabis, ptukey, label='$\sqrt{Tukey}$', color='C4')  # 
ymin = min(ax['right'].get_ylim())
ax['right'].set_xlabel('Rabi Frequency (kHz)')
ax['right'].set_ylabel(r'$1 - P(n=0)$')
ax['right'].set_xlim(min(rabis), max(rabis))
ax['right'].set_ylim(ymin, 1)
ax['right'].text(15,0.1, '(c)')
plt.savefig('Pulse_shaping.pdf', bbox_inches='tight')
plt.show()