from skimage.filters import threshold_minimum
from astropy.stats import binom_conf_interval
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))

df = pd.read_csv('all_roi_counts.csv')

for i in range(10):
    key = 'ROI%s'%i
    thresh = threshold_minimum(df[key])
    p1 = sum(df[key] > thresh)
    conf = binom_conf_interval(p1, len(df[key]), interval='jeffreys')
    LP = p1/len(df[key])
    uplperr = conf[1] - LP # 1 sigma confidence above mean
    lolperr = LP - conf[0] # 1 sigma confidence below mean

    print('LP ', key, ' = %.3g + %.1g - %.1g'%(LP, uplperr, lolperr))
    
from uncertainties import ufloat
print(ufloat(0.898,.002)*ufloat(0.82,.003))

#%%
import matplotlib.pyplot as plt
plt.style.use('../../vinstyle.mplstyle')
import numpy as np
n = 300
N = len(df)//n
csLP = np.zeros((2,N))
csthresh = threshold_minimum(df['ROI9'])
rbLP = np.zeros((2,N))
rbthresh = threshold_minimum(df['ROI8'])
for i in range(N):
    csLP[0][i] = sum(df['ROI9'][i*n:(i+1)*n] > csthresh)/n
    conf = binom_conf_interval(csLP[0][i]*n, n, interval='jeffreys')
    csLP[1][i] = 0.5*(conf[1]-conf[0])
    rbLP[0][i] = sum(df['ROI8'][i*n:(i+1)*n] > rbthresh)/n
    conf = binom_conf_interval(rbLP[0][i]*n, n, interval='jeffreys')
    rbLP[1][i] = 0.5*(conf[1]-conf[0])

t = np.array([(df['Time_(s)'][300*i] - df['Time_(s)'][0])/3600 for i in range(N)])
plt.errorbar(t, csLP[0], yerr=csLP[1], label='Cs', color='C2')
inds = np.where(rbLP[0] > 0.5)[0]
rbLP = rbLP[:, inds]
plt.errorbar(t[inds], rbLP[0], yerr=rbLP[1], label='Rb', color='C1')
plt.xlabel('Time (hours)')
plt.ylabel('Probability')
plt.legend()
plt.savefig('RbCs_LP.svg')
#%%
def weighted_std(y, yerr):
    average = np.ma.average(y, weights=yerr, axis=0)
    variance = np.dot(yerr, (y - average)**2) / yerr.sum()
    return max(np.sqrt(variance), 1/np.sqrt(np.sum(1/yerr**2)))
    
cs = ufloat(csLP[0].mean(), weighted_std(csLP[0], csLP[1]))
print('Cs: ', cs)
rb = ufloat(rbLP[0].mean(), weighted_std(rbLP[0], rbLP[1]))
print('Rb: ', rb)
print('Rb+Cs: ', rb*cs)