# -*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt
plt.style.use(r'Z:\Tweezer\People\Stefan\DUdefault.mplstyle')
import os
import time
import sys
sys.path.append(r'Z:\Tweezer\People\Stefan\general-python')
sys.path.append(r'Z:\Tweezer\Code\Python 3.5\PyDex')
sys.path.append(r'Z:\Tweezer\Code\Python 3.5\PyDex\imageanalysis')
from fitandgraph import fit, data, getDAQPowers
from histoHandler import histo_handler

plt.figure()
    
v = [98.3, 98.2, 98.1, 98.4, 98.0, 98.5, 97.9, 97.8, 98.6, 97.7, 98.7, 98.8, 97.6]
sp = []
sperr = []
cmap = plt.get_cmap('twilight')
for i in range(8,21):
    filename = r'Z:\Tweezer\Experimental Results\2022\July\02\Measure{0}\ROI0_Re_Measure{0}.dat'.format(i)
    hh = histo_handler()
    _ = hh.load(filename)
    
    hh.sort_dict()
    # for i in range()
    
    f = fit((np.array(hh.stats['User variable'])), # x  hh.stats['User variable'] (2*95+266.65)-2*V
        np.array(hh.stats['Loading probability']), # y
        erry = np.array(hh.stats['Error in Loading probability']), # error
        # param = [-0.4,98.3,0.5,1]) # estimate of parameters [-0.5,1.5,0.8,1] [-0.5,0.9,0.1,-0.5,1.16,0.1,1]
        param = [-0.4,101.5,0.5,1]) # estimate of parameters [-0.5,1.5,0.8,1] [-0.5,0.9,0.1,-0.5,1.16,0.1,1]
    # A, x0, FWHM, y0)x, A1, x1, FWHM1, A2, x2, FWHM2, y0
    plt.title(filename, fontsize=11)
    c = plt.errorbar(f.x, f.y, yerr=f.yerr, fmt='o', c=cmap(v[i-8]-97.6))[0].get_color()
    h = f.x
    sp.append(f.y)
    sperr.append(f.yerr)
    x, y = f.applyFit(f.offGauss) #, bounds=[[0.1,99.8,0.002,0.01],[0.7,99.9,0.1,0.3]])
    plt.plot(x,y, color=c)
    print(f.report())

plt.xlabel(r"AWG Frequency (MHz)")
plt.ylabel(r'Survival Probability')

inds = np.argsort(v)
sp = np.array(sp)[inds, :]
sperr = np.array(sperr)[inds, :]
#%%
plt.figure()
plt.imshow(sp, cmap='hot', extent=(min(h),max(h),max(v),min(v)), aspect='equal')
plt.xlabel('AWG H (MHz)')
plt.ylabel('AWG V (MHz)')
c = plt.colorbar()
c.set_label('Survival Probability')
plt.show()

#%%
vs = sorted(v)
for i in range(5,8):
    f = fit(vs, sp[:,i], sperr[:,i], param=[-0.5,98.1,0.5,1])
    c = plt.errorbar(f.x, f.y, f.yerr, fmt='o', label=str(h[i]))[0].get_color()
    plt.plot(*f.applyFit(f.offGauss), color=c)
    print(f.report())
plt.legend(title='H Freq (MHz)')
plt.xlabel('V Freq (MHz)')
plt.ylabel('Survival Probability')