import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
from skimage.filters import threshold_minimum
from scipy.stats import norm
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit

def get_fidelity(thresh, c0, w0, c1, w1):
    """Calculate the fidelity assuming a normal distribution for peak 1
    centred about p1 with std dev w1 and peak 2 centred around
    p2 with std dev w2. Optionally supply a threshold thresh, otherwise
    use self.thresh"""
    # fidelity = 1 - P(false positives) - P(false negatives)
    fidelity = norm.cdf(thresh,c0, w0) - norm.cdf(thresh, c1, w1)
    # error is largest fidelity - smallest fidelity from uncertainty in peaks
    return fidelity

df = pd.read_csv('opt_hist_0_3x3.csv', skiprows=2)
counts = df['Counts']-697*9
occ, bins, bars = plt.hist(counts, bins=70, alpha=0.5)
ymin, ymax = plt.ylim()
f = fit(bins[:-1]+0.5*(bins[1]-bins[0]), occ, param=[50, 300, 30, 50, 600, 30])
plt.plot(*f.applyFit(lambda x, a0, c0, g0, a1, c1, g1: f.doubleGauss(
    x, a0, c0, g0, a1, c1, g1, 0)), color='C1')
peaks = (f.ps[1], f.ps[2], f.ps[4], f.ps[5])
plt.vlines(threshold_minimum(counts), ymin, ymax, colors='C1')
# threshs = np.linspace(min(f.ps[1],f.ps[4])+f.ps[2], max(f.ps[1], f.ps[4]),20)
# thresh = threshs[np.argmax([get_fidelity(t, *peaks) for t in threshs])]
# plt.vlines(thresh, ymin, ymax, colors='C1')
plt.xlabel('Integrated Counts')
plt.ylabel('Occurrences')
plt.ylim(ymin, ymax)
plt.xlim(200,750)
plt.annotate('0', (310, 25), ha='center')
plt.annotate('1', (620, 25), ha='center')
plt.savefig('OptimumHistogram.pdf')