import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))
import sys
sys.path.append('../..')
from fitandgraph import fit

plt.style.use('~/.matplotlib/vinstyle.mplstyle')

theory_data = pd.DataFrame()
dat = np.genfromtxt('t2')[:,:-4]
dat = np.split(dat, np.where(np.diff(dat[:,0])<0)[0]+1)
for state,pltdat in enumerate(dat):
    plt.plot(pltdat[:,0], pltdat[:,1], marker='x', linestyle='solid', c='grey')
    for field,energy in zip(pltdat[:,0],pltdat[:,1]):
        theory_data.loc[field,'state_{}'.format(state)] = energy
        
theory_data = theory_data.sort_index()


exp_data = pd.read_csv('experiment_data_with_fits.csv')
cs = ['C2', 'orange', 'green', 'C1', 'C0', 'C8', 'C8']
for state in [0,1,2,3,4,6]:
    df = exp_data[exp_data['state'] == state]
    plt.errorbar(df['field (G)'], df['Centre below threshold (threshold fit)'], c=cs[state],
         yerr=np.sqrt(df['Centre_err']**2 + (0.1*df['Width'])**2), fmt='o')

plt.xlabel('Magnetic Field (G)')
plt.ylabel('Binding Energy / $h$ (MHz)')
plt.xlim(172,200)
plt.ylim(-40,1)
plt.savefig('FB_binding_energies.svg', bbox_inches='tight')
plt.show()
