import numpy as np
import matplotlib.pyplot as plt
import os
os.chdir(os.path.dirname(__file__))
from matplotlib.collections import LineCollection
from matplotlib import colors

imn = 'Im_23Jun2022_%s.asc'
imids = ['3602_0', '3602_1_2', '4000_1_10', '4005_1_0', '4012_1_01']
vmaxs = [950] + [900]*4
c1 = np.array((1,1,1,1))
cmaps = ['Greys']
cinds = [4, 3, 0, 3]
for c in cinds:
    c2 = np.array(colors.to_rgba('C%s'%c))
    x = np.array([np.linspace(0,1,256)]*3+[np.ones(256)]).T
    cmaps.append(colors.ListedColormap((c2-c1)*x + np.outer(c1, np.ones(256)).T))


for i, v, c in zip(imids, vmaxs, cmaps):
    im = np.genfromtxt(imn%i, delimiter=' ')[:,1:][19:33,30:34]
    plt.imshow(np.rot90(im), cmap=c, vmin=735, vmax=v)
    plt.axis('off')
    plt.savefig(i+'.svg')
    plt.show()