"""Explain 2-body loss probabilities"""
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit

df = pd.read_csv('Comp0.Measure22.dat', skiprows=2)
x = df['User variable']*2.77 + 200.05 # B field in G
key = '%s atom survival probability'
plt.figure(figsize=(5,3))
ms = ['o', 'x', '^']
for i in range(3):
    col = 'C0' if not i else 'C%s'%(i+2)
    c = plt.errorbar(x, df[key%i], df['Error in '+key%i], color=col, fmt=ms[i], label=r'$2\rightarrow %s$'%i)[0].get_color()
    if not i%2:
        p0 = [-0.6, 198.6, 0.2, 0.2] if i else [0.6, 198.6, 0.2, 0.7]
        f = fit(x, df[key%i], df['Error in '+key%i], p0)
        plt.plot(*f.applyFit(f.offGauss), color=c)
plt.xlabel('B Field (G)')
plt.ylabel('Probability')
plt.legend()
plt.savefig('Comp0.Measure22_Losses.svg')