import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit, weighted_std

plt.figure(figsize=(6,3))
for m in [7,8]:
    df = pd.read_csv('Comp0.Measure%s.dat'%m, skiprows=2)
    df['x'] = 194.97 + 2.143*df['User variable']
    df.rename(columns={'0 atom survival probability':'y', 
                'Error in 0 atom survival probability':'yerr'},inplace=True)
    ave = df.groupby(df.x).apply(lambda v: np.average(v.y, weights=v.yerr))
    averr = df.groupby(df.x).apply(weighted_std) # ##df.groupby(df.x).apply(lambda v: 1/np.sqrt(np.sum(1/v.yerr**2)))#
    
    plt.errorbar(ave.keys(), ave, yerr=averr, fmt='o', c='C0' if m==7 else 'C8',
        label=r'$\leftarrow$ramp' if m==7 else r'$\rightleftarrows$ ramp')
    np.savetxt('197G_Measure%s.csv'%(m), np.array((ave.keys(), ave, averr)),
        header='# Field at end of ramp (G),2-body loss,Error in 2-body loss')
    f = fit(ave.keys(), ave.values, erry=averr, param = [197.5,-0.3,0.1,0.5])  
    if m == 7:
        plt.plot(*f.applyFit(f.knifeEdge), color='C0')
        print(f.report())
    else: 
        f.p0 = None
        plt.plot(*f.applyFit(f.linear), color='C8')
plt.legend()
ylim = plt.ylim()
plt.vlines(197.06, 0, 1, colors='k', ls='--', alpha=0.5)
plt.ylim(0, ylim[1])
plt.xlabel('Field at end of ramp (G)')
plt.ylabel(r'$P_{2\rightarrow 0}$')
plt.tight_layout()
plt.savefig('Associate_ramp.pdf')