import numpy as np
import matplotlib.pyplot as plt
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit

#### load data fomr eject measurements    
v = [98.3, 98.2, 98.1, 98.4, 98.0, 98.5, 97.9, 97.8, 98.6, 97.7, 98.7, 98.8, 97.6]
sp = []
sperr = []
cmap = plt.get_cmap('twilight')
f = fit([-0.4,101.5,0.5,1])
for i in range(8,21):
    f.load('eject/ROI0_Re_Measure%s.dat'%i)
    h = f.x
    sp.append(f.y)
    sperr.append(f.yerr)


inds = np.argsort(v)
sp = np.array(sp)[inds, :]
sperr = np.array(sperr)[inds, :]


#%% plot
fig, (ax0, ax1) = plt.subplots(1, 2, figsize=(9,4))

### 938 position and 817 power
ax0.plot(np.concatenate((np.ones(5),np.linspace(1,0,4),np.zeros(20),
                        np.linspace(0,1,4),np.ones(5)))*4.5, color='C2',lw=4)
ax0.set_ylabel('$x_{938}$ ($\mu$m)', color='C2')
ax0.set_xticks([])
ax0.set_xlabel('Time')
ax0.annotate('sweep', (4,2), ha='center', va='center', rotation=90, color='C2')
ax0.annotate('sweep', (33,2), ha='center', va='center', rotation=90, color='C2')
ax0.text(-7, 5, '(a)', ha='center')
ax2 = ax0.twinx()
ax2.plot(np.concatenate((np.zeros(10), np.linspace(0,1,4), np.ones(10),
                np.linspace(1,0,4), np.zeros(10)))*5, color='C1',lw=4)
ax2.set_ylabel('$P_{817}$ (mW)', color='C1')
ax2.annotate('ramp up', (14,2), ha='center', va='center', rotation=90, color='C1')
ax2.annotate('ramp down', (23,2), ha='center', va='center', rotation=90, color='C1')

# centre H 101.4MHz V 98.13 MHz
im = ax1.imshow(sp, cmap='hot', extent=((min(h)-101.4)*1.982, (max(h)-101.4)*1.982,
            (min(v)-98.13)*1.854,(max(v)-98.13)*1.854), aspect='equal')
ax1.set_xlabel('$x_{817}$ ($\mu$m)')
ax1.set_ylabel('$y_{817}$ ($\mu$m)')
c = plt.colorbar(im, ax=ax1, location='top')
c.set_label('Survival Probability')
ax1.text(-2.2, 2.13, '(b)', ha='center')
plt.tight_layout()
plt.savefig('eject_overlap.pdf', bbox_inches='tight')