import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import os
os.chdir(os.path.dirname(__file__))
plt.style.use('../../vinstyle.mplstyle')
import sys
sys.path.append('../..')
from fitandgraph import fit

fig, axs = plt.subplots(1,2, figsize=(8,3), sharey=False)

### OP time
for i in range(2):
    f = fit(param=[0.6,2,0.1])
    f.load('op_time/ROI%s_Re_Measure4.dat'%i)
    axs[0].errorbar(f.x, f.y, f.yerr, fmt='o', color='C%s'%(2-i), 
                    label='Rb' if i else 'Cs')
    axs[0].plot(*f.applyFit(f.offeDecay), color='C%s'%(2-i))
    print('OP time: \n', f.report())
    
axs[0].set_xlabel('OP Pulse Duration ($\mu$s)')
axs[0].set_ylabel(r'$|\downarrow\rangle$ Probability')
axs[0].set_xlim(-0.2,70)
axs[0].annotate('(a)', (5, 0.47))
    
### depump time
for i in range(2):
    f = fit(param=[-0.6, 20,0.8])
    f.load('op_depump/ROI%s_Re_Measure6.dat'%i) # EW
    axs[1].errorbar(f.x, f.y, f.yerr, fmt='o', color='C%s'%(2-i), 
                    label='Rb' if i else 'Cs')
    axs[1].plot(*f.applyFit(f.offeDecay), color='C%s'%(2-i))
    print('Depump time: \n', f.report())
    
axs[1].set_xlabel('Depump Pulse Duration (ms)')
axs[1].set_ylabel(r'$|\downarrow\rangle$ Probability')
axs[1].annotate('(b)', (-0.5, 0.8))
axs[1].legend()

plt.tight_layout()
plt.savefig('op_times.svg')