import os
os.chdir(os.path.dirname(__file__))
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

df = pd.read_csv('DE_H_817.csv')
freqs = sorted(set(df['Frequency (MHz)']))
amps  = sorted(set(df['RF Amplitude (mV)']))
de = np.flipud(np.reshape(df['Relative Optical Power'].values, (120,160)))

#%%
im = plt.imshow(de, cmap='plasma', extent=(min(freqs),max(freqs),min(amps),max(amps)), aspect='auto')
cbar = plt.colorbar(im, label='Optical Power')
c = plt.contour(freqs, amps, np.flipud(de), levels=np.linspace(0,1,20), cmap='Purples')
cbar.add_lines(c)
plt.xlabel('RF Frequency (MHz)')
plt.ylabel('RF Amplitude (mV)')
plt.savefig('DE.svg')