#/usr/bin/env python 
import sys,os
import matplotlib.pyplot as plt
import math as m
import numpy as np
#import scipy as sp
from scipy.integrate import quad
from scipy import interpolate
from scipy import integrate
import scipy.optimize
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
CWD = os.getcwd()

#User-definied width of the trapezod for integration 
tick = 0.05

#Conversion factors and constants
cm2hart=(1./219474.63067)
cm2ghz=29.9702547
ghz2cm=(1./29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1./1.889725989)
infnty = 10000 
zero = 0.0E0
PI = m.pi
ghz2hart = 1.5198285E-7
amu2au = 1822.88839
Li6_mass = 6.015122795e0
Li7_mass = 7.01600455e0
Li77_mu = Li7_mass*Li7_mass/(Li7_mass+Li7_mass)
Li67_mu = Li6_mass*Li7_mass/(Li6_mass+Li7_mass)
Li66_mu = Li6_mass*Li6_mass/(Li6_mass+Li6_mass)

#Li2 potential parameters taken from Le Roy et al JCP 131 204309 (2009)
De_cm=8516.709
De_ghz=De_cm*cm2ghz
Re_angst=2.672993
Rref_angst=3.85
C6=6.71527E+6
C8=1.12588E+8
C10=2.78604E+9
Ulr_re=C6/(Re_angst**6) + C8/(Re_angst**8) + C10/(Re_angst**10)
Beta_inf=m.log(2*De_cm/Ulr_re)
Beta_0 = -2.89828701
Beta_1 = -1.309265
Beta_2 = -2.018507
Beta_3 = -1.38162
Beta_4 = -1.21933
Beta_5 =  0.3463
Beta_6 =  0.1061
Beta_7 = -0.1886
Beta_8 =  1.671
Beta_9 = 10.943
Beta_10=  3.944
Beta_11=-27.23
Beta_12=-11.49
Beta_13= 56.7
Beta_14= 38.9
Beta_15=-37.4
Beta_16=-33.0
p_ad=6
q_ad=6
u_0=0.19410
u_1=-0.0116
u_2=0.397
u_inf=0.0

#Routine for sampling Julienne and Hutson's trial BOB function 
Re_JMH=5.0517
def JMH(rbohr):
  dScm=-0.6678
  dVcm=float(dScm)*(float(rbohr)-float(Re_JMH))**2
#  dSghz=float(dScm)*float(cm2ghz)
#  dVghz = float(dSghz)*(float(rbohr)-float(Re_JMH))**2
  return dVcm
  
#Routine for sampling Le Roy et al's potential function
def Vmlr(rbohr):
  rangst = rbohr*bohr2angs
  Ulr = C6/(rangst**6) + C8/(rangst**8) + C10/(rangst**10)
  yref_p = (rangst**5-Rref_angst**5)/(rangst**5+Rref_angst**5)
  yref_q = (rangst**3-Rref_angst**3)/(rangst**3+Rref_angst**3)
  yeq_p  = (rangst**5-Re_angst**5) / (rangst**5+Re_angst**5)
  Beta_N = m.fsum([Beta_0 * yref_q**0 , Beta_1 * yref_q**1 ,
                   Beta_2 * yref_q**2 , Beta_3 * yref_q**3 ,
                   Beta_4 * yref_q**4 , Beta_5 * yref_q**5 ,  
                   Beta_6 * yref_q**6 , Beta_7 * yref_q**7 ,  
                   Beta_8 * yref_q**8 , Beta_9 * yref_q**9 , 
                   Beta_10* yref_q**10, Beta_11* yref_q**11,  
                   Beta_12* yref_q**12, Beta_13* yref_q**13,  
                   Beta_14* yref_q**14, Beta_15* yref_q**15,  
                   Beta_16* yref_q**16])
  Beta   = Beta_inf * yref_p  + ( 1 - yref_p ) * Beta_N

#  Vcm = De_cm - Ulr + (4*De_cm)**(-1)*(Ulr)**2
  Vcm = De_cm * (1-(Ulr/Ulr_re)*(m.exp(-Beta*yeq_p)))**2
  Vghz = Vcm*cm2ghz
  return Vghz

#This routine is similar to Vmlr, except it sets the asymptote to zero
#and has ability to add a correction 
asymp_mlr = Vmlr(infnty)
#print "De_ghz,asymp_mlr= ",De_ghz,asymp_mlr
def Vmlr0(rbohr,dV):
  Vghz = Vmlr(rbohr) - asymp_mlr + dV
  return Vghz

#Here R0 is determined numerically
R0 = scipy.optimize.newton(Vmlr0, 3.4, args=(zero,), tol=1E-10, maxiter=25000)
#print "R0 = ",R0

#This routine interpolates DBOC functions and adds a potential value
def VdV(rbohr,r,DBOC):
    f = interpolate.interp1d(r,DBOC,kind='cubic')
    ynew = f(rbohr)
    val = Vmlr0(rbohr,zero) + ynew
    return val

#This routine interpolates DBOC functions without adding a potential value
def dV(rbohr,r,DBOC):
    f = interpolate.interp1d(r,DBOC,kind='cubic')
    val = f(rbohr)
    return val

# Read in DBOC data (file units are bohr, cm-1)
LiLi=open(CWD+"/RCCSD_LiLi.dat")
LRfile=open(CWD+"/LeRoy_LiLi.dat")
Cxfile=open(CWD+"/Coxon_LiLi.dat")

LeRoy_r=[]
LeRoy_DBOC=[]
Coxon_r=[]
Coxon_DBOC=[]
Hutson_r=[]
Hutson_DBOC=[]
LiLi_r=[]
LiLi_DBOC=[]

#All energies read in are immediately converted to GHz
for line in LiLi:
    line=line.rstrip("\n")
    data=line.split()
    LiLi_r.append(float(data[0]))
    LiLi_DBOC.append(cm2ghz*float(data[1]))
for line in LRfile:
    line=line.rstrip("\n")
    data=line.split()
    LeRoy_r.append(float(data[0]))
    LeRoy_DBOC.append(cm2ghz*float(data[1]))
for line in Cxfile:
    line=line.rstrip("\n")
    data=line.split()
    Coxon_r.append(float(data[0]))
    Coxon_DBOC.append(cm2ghz*float(data[1]))
    Hutson_r.append(float(data[0]))
    if float(data[0])>Re_JMH: 
      Hutson_DBOC.append(zero) 
    else:
      Hutson_DBOC.append(cm2ghz*float(JMH(data[0])))
#    print "Hutson ",Hutson_r[-1],Hutson_DBOC[-1]

frac7 = []
LeRoy7 = []
Coxon7 = []
Hutson7 = []
x_frac = []
y_frac = []
y_LeRoy = []
y_Coxon = []
y_Hutson = []
intfrac7 = []
intLeRoy = []
intCoxon = []
intHutson = []
print_frac = []
print_LeRoy = []
print_Coxon = []
print_Hutson = []
frac_r = []
x_Coxon = []
frac_fin = []
for i in np.arange(3.4, 19.95, tick):
    V_i = m.sqrt(m.fabs(Vmlr0(i,zero)))
    #if i>5.049:
      #if i<5.051:
        #print "i = ", i," and the following 6 lines are conv. to cm-1"
        #print "Li77_mu,Vmlr0(i,zero)", Li77_mu,(ghz2cm*Vmlr0(i,zero))
        #print "m.sqrt(m.fabs(Vmlr0(i,zero)))", m.sqrt(m.fabs(ghz2cm*Vmlr0(i,zero)))
        #print "m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*V_i", m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*V_i
        #print "dV(i,LiLi_r,LiLi_DBOC)", ghz2cm*dV(i,LiLi_r,LiLi_DBOC)
        #print "dV(i,LeRoy_r,LeRoy_DBOC)", ghz2cm*dV(i,LeRoy_r,LeRoy_DBOC)
        #print "dV(i,Coxon_r,Coxon_DBOC)", ghz2cm*dV(i,Coxon_r,Coxon_DBOC)
        #print "dV(i,Hutson_r,Hutson_DBOC)", ghz2cm*dV(i,Hutson_r,Hutson_DBOC)
    #if i>7.599:
      #if i<7.601:
        #print "i = ", i," and the following 6 lines are conv. to cm-1"
        #print "Li77_mu,Vmlr0(i,zero)", Li77_mu,(ghz2cm*Vmlr0(i,zero))
        #print "m.sqrt(m.fabs(Vmlr0(i,zero)))", m.sqrt(m.fabs(ghz2cm*Vmlr0(i,zero)))
        #print "m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*V_i", m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*V_i
        #print "dV(i,LiLi_r,LiLi_DBOC)", ghz2cm*dV(i,LiLi_r,LiLi_DBOC)
        #print "dV(i,LeRoy_r,LeRoy_DBOC)", ghz2cm*dV(i,LeRoy_r,LeRoy_DBOC)
        #print "dV(i,Coxon_r,Coxon_DBOC)", ghz2cm*dV(i,Coxon_r,Coxon_DBOC)
        #print "dV(i,Hutson_r,Hutson_DBOC)", ghz2cm*dV(i,Hutson_r,Hutson_DBOC)
    frac7.append(1/(2*PI)*m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*dV(i,LiLi_r,LiLi_DBOC)/V_i)
    LeRoy7.append(1/(2*PI)*m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*dV(i,LeRoy_r,LeRoy_DBOC)/V_i)
    Coxon7.append(1/(2*PI)*m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*dV(i,Coxon_r,Coxon_DBOC)/V_i)
    Hutson7.append(1/(2*PI)*m.sqrt(amu2au*ghz2hart*2.*Li77_mu)*dV(i,Hutson_r,Hutson_DBOC)/V_i)

    if i>R0:     #  Load arrays with the functions
        x_frac.append(float(i))
        y_frac.append(float(frac7[-1]))
        y_LeRoy.append(float(LeRoy7[-1]))
        y_Coxon.append(float(Coxon7[-1]))
        y_Hutson.append(float(Hutson7[-1]))
        intfrac7.append(-100000*y_frac[-1])
        intLeRoy.append(-100000*y_LeRoy[-1])
        if i>18.5:      # Workaround to avoid weirdness in the Coxon long-range interpolation
          pass
        else:
          x_Coxon.append(float(i))
          intCoxon.append(-100000*y_Coxon[-1])
        intHutson.append(-100000*y_Hutson[-1])
                   # Compute cumulative integrals (this is currently overkill, but I haven't learned a better way)
        cumfrac7=integrate.cumtrapz(y_frac,x_frac,initial=0,dx=tick)
        cumLeRoy=integrate.cumtrapz(y_LeRoy,x_frac,initial=0,dx=tick)
        cumCoxon=integrate.cumtrapz(y_Coxon,x_frac,initial=0,dx=tick)
        cumHutson=integrate.cumtrapz(y_Hutson,x_frac,initial=0,dx=tick)
        print_frac.append(-10000*cumfrac7[-1])
        print_LeRoy.append(-10000*cumLeRoy[-1])
        print_Coxon.append(-10000*cumCoxon[-1])
        print_Hutson.append(-10000*cumHutson[-1])
#    frac_r.append(float(i))
#    frac_fin.append(frac7)
#        print "x_frac = ",x_frac[-1]
#        print "frac7 = ",frac7[-1]
#        print "LeRoy7 = ",LeRoy7[-1]
#        print "Coxon7 = ",Coxon7[-1]
#        print "Hutson7 = ",Hutson7[-1]
        #if i>5.049:
          #if i<5.051:
            #print "intfrac7 = ",intfrac7[-1]
            #print "intLeRoy = ",intLeRoy[-1]
            #print "intCoxon = ",intCoxon[-1]
            #print "intHutson= ",intHutson[-1]
            #print "cumfrac7 = ",print_frac[-1]
            #print "cumLeRoy = ",print_LeRoy[-1]
            #print "cumCoxon = ",print_Coxon[-1]
            #print "cumHutson= ",print_Hutson[-1]
        #if i>7.599:
          #if i<7.601:
	    #print "intfrac7 = ",intfrac7[-1]
            #print "intLeRoy = ",intLeRoy[-1]
            #print "intCoxon = ",intCoxon[-1]
            #print "intHutson= ",intHutson[-1]
            #print "cumfrac7 = ",print_frac[-1]
            #print "cumLeRoy = ",print_LeRoy[-1]
            #print "cumCoxon = ",print_Coxon[-1]
            #print "cumHutson= ",print_Hutson[-1]

fig=plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twinx()

ax2.plot(x_frac,print_frac,color='green',marker='None',ls='--',linewidth=2,label=r"$ab$ $initio$ $\text{(RHF-CCSD)}$")
ax2.plot(x_frac,print_LeRoy,color='blue',marker='None',ls='--',linewidth=2,label=r"$\text{empirical (Le Roy et al.)}$")
ax2.plot(x_frac,print_Coxon,color='red',marker='None',ls='--',linewidth=2,label=r"$\text{empirical (Coxon and Melville)}$")
#ax2.plot(x_frac,intHutson,color='purple',marker='None',ls='-',linewidth=2,label=r"trial (Julienne and Hutson)")
ax1.plot(x_frac,intfrac7,color='green',marker='None',ls='-',linewidth=2)
ax1.plot(x_frac,intLeRoy,color='blue',marker='None',ls='-',linewidth=2)
ax1.plot(x_Coxon,intCoxon,color='red',marker='None',ls='-',linewidth=2)
#ax1.plot(x_frac,print_Hutson,color='purple',marker='None',ls='--',linewidth=2)
#plt.plot((5.05,5.05),(-.35,.35),color='k',ls=':',linewidth=1)
ax2.plot((0,50),(0,0),color='k',ls=":",linewidth=1)
ax2.plot((R0,R0),(-50,50),color='k',ls=':',linewidth=1)
#ax2.plot((7.6,7.6),(-50,50),color='k',ls=':',linewidth=1)

ax2.legend(loc=4)
ax2.set_xlim([2.8,20])
#ax2.set_xticks([4,6,8,10,12,14,16,18,20],
#           ["4.0","6.0", "8.0","10.0","12.0",
#            "14.0","16.0","18.0","20.0"])
#plt.ylim([-300000,150000])
ax2.set_ylim([-3.,5])
#ax2.set_yticks([-20,-15,-10,-5,0,5,10,15,20,25,30],["-20","-15","-10","-5","0","5","10","15","20","25","30"])
#plt.yticks([-.4,-.3,-.2,-.1,0,.1,.2,.3,.4],
#           ["-0.4","","-0.2","","0.0","","0.2","","0.4"])
ax2.set_xlabel(r"$R\;(\mathrm{a}_0)$",size="24.0")
ax2.set_ylabel(r"$\text{Cumulative integral} \times 10^{4}$",size="24.0")# (1/bohr)",size="24.0")
#"mass shift / (|V(R)|$^{1/2}$ $h$) (kHz$^{1/2}$)",size="30.0")
ax2.tick_params(labelsize="20.0")
#ax2=plt.axes()
ax2.set(adjustable='box-forced')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend
frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="20.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

ax1.set_ylabel(r"$\text{Integrand} \times 10^{5}\;(\mathrm{a}_0^{-1}$)",size="24.0")
ax1.set_ylim([-3.,5])
ax1.set_xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
#ax1.set_yticks([-20,-15,-10,-5,0,5,10,15,20,25,30],["-20","-15","-10","-5","0","5","10","15","20","25","30"])
ax1.tick_params(labelsize="20.0")
ax1.set(adjustable='box-forced')

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('LiLi_integrands_literature.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('LiLi_integrands_literature.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


