#/usr/bin/env python

import matplotlib.pyplot as plt
import math as m
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

PI=m.pi
cm2hart=(1.0/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1.0/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1.0/1.889725989)
coulomb=(1.602177E-19*1.602177E-19/4./float(PI)/8.85419E-12)
J2MHz=(1.0E-6/6.62561E-34)
fm2angs=(1.E-5) 
m2angs=(1.E10)

Zyb=70.
dr2yb1=-0.1159
dr2yb2=-0.1810
dr2yb3=-0.2366
dr2yb4=-0.3273
dr2yb5=-0.3845
dr2yb6=-0.5406

ybfactor1=2*(2./3.)*(float(PI)*float(Zyb))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2yb1)
ybfactor2=2*(2./3.)*(float(PI)*float(Zyb))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2yb2)
ybfactor3=2*(2./3.)*(float(PI)*float(Zyb))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2yb3)
ybfactor4=2*(2./3.)*(float(PI)*float(Zyb))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2yb4)
ybfactor5=2*(2./3.)*(float(PI)*float(Zyb))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2yb5)
ybfactor6=2*(2./3.)*(float(PI)*float(Zyb))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2yb6)
#test1=2*(2./3.)*(float(PI)*float(Zyb))*coulomb*m2angs*J2MHz*(angs2bohr**3)*(fm2angs**2)*float(dr2yb6)
#test2 =    2*(2./3.)*(float(PI)*float(Zyb))*34.8206236311*6.74833450351*float(dr2yb6)
print ybfactor6
# Read in potential data in Bohr, Hartree
YbYb=open(str(path)+"/YbYb_EDN_harvested.dat")

YbYb_r=[]
YbYb_V1=[]
YbYb_V2=[]
YbYb_V3=[]
YbYb_V4=[]
YbYb_V5=[]
YbYb_V6=[]

Ybasym=1061555.87902
for line in YbYb:
    line=line.rstrip("\n")
    data=line.split()
    YbYb_r.append(angs2bohr*float(data[0]))
    YbYb_V1.append(ybfactor1*(float(data[1])-Ybasym))
    YbYb_V2.append(ybfactor2*(float(data[1])-Ybasym))
    YbYb_V3.append(ybfactor3*(float(data[1])-Ybasym))
    YbYb_V4.append(ybfactor4*(float(data[1])-Ybasym))
    YbYb_V5.append(ybfactor5*(float(data[1])-Ybasym))
    YbYb_V6.append(ybfactor6*(float(data[1])-Ybasym))

fig=plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twinx()
ax2.plot(YbYb_r,YbYb_V1,color='b',marker='None',ls='-',linewidth=2,label=r"$^{174}\mathrm{Yb}^{174}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
ax2.plot(YbYb_r,YbYb_V2,color='b',marker='None',ls='--',linewidth=2,label=r"$^{173}\mathrm{Yb}^{173}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
ax2.plot(YbYb_r,YbYb_V3,color='b',marker='None',ls='-.',linewidth=2,label=r"$^{172}\mathrm{Yb}^{172}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
ax2.plot(YbYb_r,YbYb_V4,color='c',marker='None',ls='-',linewidth=2,label=r"$^{171}\mathrm{Yb}^{171}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
ax2.plot(YbYb_r,YbYb_V5,color='c',marker='None',ls='--',linewidth=2,label=r"$^{170}\mathrm{Yb}^{170}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
ax2.plot(YbYb_r,YbYb_V6,color='c',marker='None',ls='-.',linewidth=2,label=r"$^{168}\mathrm{Yb}^{168}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
ax1.plot((8.8,8.8),(-250,10),color='b',ls=':',linewidth=1)
itp = "YbYb $R_{\mathrm{e}}$"
ax2.text(8.8,-400,itp,size=24)
ax2.legend(loc=1)
ax2.set_xlim([6,25])
#ax1.set_xticks([10,15,20,25],
#           ["10.0","15.0","20.0","25.0"])
ax2.set_ylim([40,-760])
ax2.set_yticks([-700,-600,-500,-400,-300,-200,-100,0])
ax2.set_yticklabels(["$-7$","$-6$","$-5$","$-4$","$-3$","$-2$","$-1$","$0$"])
#plt.yticks([-150,-100,-50,0],
#           ["-150","-100","-50","0"])
ax2.set_xlabel(r"$R (\mathrm{a}_0$)",size="24.0")
ax2.set_ylabel(r"$\text{Isotopic field shift } \times\;10^2\;/\;h\;(\text{MHz})$",size="24.0")
ax2.tick_params(labelsize="20.0")
ax2.set(adjustable='box-forced')
#ax1.set_aspect('equal')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend
frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

ax1.set_ylabel(r"$\text{Contact density}\;(\mathrm{a}_0^{-3}$)",size="24.0")
ax1.set_ylim(-0.107,2.041)
ax1.set_xlabel("$R\;(\mathrm{a}_0$)",size="24.0")
#vals2=[.5,.1,.15]
#ax2.set_yticks(vals2)#0,.05,.1,.15)#],["0.0","0.05","0.10","0.15"])
ax1.tick_params(labelsize="20.0")

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,7)
fig.savefig('YbYb_FSs.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('YbYb_FSs.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


