#/usr/bin/env python

import matplotlib.pyplot as plt
import math as m
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

Z=19.
dr2=0.1170
PI=m.pi
factor=(2./3.)*(float(PI)*float(Z))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2)
print factor
# Read in potential data in Bohr, Hartree
LiLi=open(str(path)+"/KLi_EDN_harvested.dat")
LiNa=open(str(path)+"/KNa_EDN_harvested.dat")
LiK=open(str(path)+"/KK_EDN_harvested.dat")
LiRb=open(str(path)+"/KRb_EDN_harvested.dat")
LiCs=open(str(path)+"/KCs_EDN_harvested.dat")

LiLi_r=[]
LiLi_V=[]
LiNa_r=[]
LiNa_V=[]
LiK_r=[]
LiK_V=[]
LiRb_r=[]
LiRb_V=[]
LiCs_r=[]
LiCs_V=[]

for line in LiLi:
    line=line.rstrip("\n")
    data=line.split()
    LiLi_r.append(angs2bohr*float(data[0]))
    LiLi_V.append(factor*float(data[1]))
for line in LiNa:
    line=line.rstrip("\n")
    data=line.split()
    LiNa_r.append(angs2bohr*float(data[0]))
    LiNa_V.append(factor*float(data[1]))
for line in LiK:
    line=line.rstrip("\n")
    data=line.split()
    LiK_r.append(angs2bohr*float(data[0]))
    LiK_V.append(factor*float(data[1]))
for line in LiRb:
    line=line.rstrip("\n")
    data=line.split()
    LiRb_r.append(angs2bohr*float(data[0]))
    LiRb_V.append(factor*float(data[1]))
for line in LiCs:
    line=line.rstrip("\n")
    data=line.split()
    LiCs_r.append(angs2bohr*float(data[0]))
    LiCs_V.append(factor*float(data[1]))

fig=plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twinx()
ax2.plot(LiLi_r,LiLi_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^{41}\mathrm{K}^7\mathrm{Li}\leftarrow{}^{39}\mathrm{K}^7\mathrm{Li}$")
ax1.plot((6.273,6.273),(-5,25),color='maroon',ls=':',linewidth=1)
itp = "KLi $R_{\mathrm{e}}$"
ax2.text(6.273,13.0,itp,size=24)
ax2.plot(LiNa_r,LiNa_V,color='g',marker='None',ls='-',linewidth=2,label=r"$^{41}\mathrm{K}^{23}\mathrm{Na}\leftarrow{}^{39}\mathrm{K}^{23}\mathrm{Na}$")
ax1.plot((6.622,6.622),(-5,25),color='g',ls=':',linewidth=1)
itp = "KNa $R_{\mathrm{e}}$"
ax2.text(6.622,11.0,itp,size=24)
ax2.plot(LiK_r,LiK_V,color='r',marker='None',ls='-',linewidth=2,label=r"$^{41}\mathrm{K}^{39}\mathrm{K}\leftarrow{}^{39}\mathrm{K}^{39}\mathrm{K}$")
ax1.plot((7.379,7.379),(-5,25),color='r',ls=':',linewidth=1)
itp = "KK $R_{\mathrm{e}}$"
ax2.text(7.379,8.0,itp,size=24)
ax2.plot(LiRb_r,LiRb_V,color='b',marker='None',ls='-',linewidth=2,label=r"$^{41}\mathrm{K}^{85}\mathrm{Rb}\leftarrow{}^{39}\mathrm{K}^{85}\mathrm{Rb}$")
ax1.plot((7.699,7.699),(-5,25),color='b',ls=':',linewidth=1)
itp = "KRb $R_{\mathrm{e}}$"
ax2.text(7.699,6.0,itp,size=24)
ax2.plot(LiCs_r,LiCs_V,color='k',marker='None',ls='-',linewidth=2,label=r"$^{41}\mathrm{K}^{133}\mathrm{Cs}\leftarrow{}^{39}\mathrm{K}^{133}\mathrm{Cs}$")
ax1.plot((8.111,8.111),(-5,25),color='k',ls=':',linewidth=1)
itp = "KCs $R_{\mathrm{e}}$"
ax2.text(8.111,4.0,itp,size=24)
ax2.legend(loc=1)
ax2.set_xlim([2,15])
xvals=[2,4,6,8,10,12,14]
ax2.set_xticks(xvals)#[2,4,6,8,10,12,14],["2.0","4.0","6.0","8.0","10.0","12.0","14.0"])
ax2.set_ylim([-2.5,17.5])
yvals1=[0,5.0,10.0,15.0]#,["0","0.01","0.02","0.03","0.04","0.05"]
ax2.set_yticks(yvals1)
#plt.yticks([0,.01,.02,.03,.04,.05],
#           ["0","0.01","0.02","0.03","0.04","0.05"]),
ax2.set_xlabel(r"$R (\mathrm{a}_0$)",size="24.0")
ax2.set_ylabel(r"$\text{Isotopic field shift / }h\;\text{(MHz)}$",size="24.0")
ax2.tick_params(labelsize="20.0")
ax2.set(adjustable='box-forced')
#ax1.set_aspect('equal')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend
frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

ax1.set_ylabel(r"$\text{Contact density (a}_0^{-3})$",size="24.0")
ax1.set_ylim(-.228,1.600)
ax1.set_xlabel(r"$R\;(\mathrm{a}_0)$",size="24.0")
yvals2=[0,0.50,1.00,1.50]
ax1.set_yticks(yvals2)#0,.05,.1,.15)#],["0.0","0.05","0.10","0.15"])
ax1.tick_params(labelsize="20.0")

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,7)
fig.savefig('KX_FSs.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('KX_FSs.eps',bbox_inches='tight',dpi=600,format='eps')


plt.show()


