#/usr/bin/env python

import matplotlib.pyplot as plt
import math as m
import numpy as np
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

mhz2ghz=0.001
cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

Z=3.
dr2=0.7310
PI=m.pi
factor=(2./3.)*(float(PI)*float(Z))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2)
print factor
# Read in potential data in Bohr, Hartree
LiLi=open(str(path)+"/LiLi_EDN_harvested.dat")
LiNa=open(str(path)+"/LiNa_EDN_harvested.dat")
LiK=open(str(path)+"/LiK_EDN_harvested.dat")
LiRb=open(str(path)+"/LiRb_EDN_harvested.dat")
LiCs=open(str(path)+"/LiCs_EDN_harvested.dat")

LiLi_r=[]
LiLi_V=[]
LiNa_r=[]
LiNa_V=[]
LiK_r=[]
LiK_V=[]
LiRb_r=[]
LiRb_V=[]
LiCs_r=[]
LiCs_V=[]

for line in LiLi:
    line=line.rstrip("\n")
    data=line.split()
    LiLi_r.append(angs2bohr*float(data[0]))
    LiLi_V.append(factor*float(data[1]))
for line in LiNa:
    line=line.rstrip("\n")
    data=line.split()
    LiNa_r.append(angs2bohr*float(data[0]))
    LiNa_V.append(factor*float(data[1]))
for line in LiK:
    line=line.rstrip("\n")
    data=line.split()
    LiK_r.append(angs2bohr*float(data[0]))
    LiK_V.append(factor*float(data[1]))
for line in LiRb:
    line=line.rstrip("\n")
    data=line.split()
    LiRb_r.append(angs2bohr*float(data[0]))
    LiRb_V.append(factor*float(data[1]))
for line in LiCs:
    line=line.rstrip("\n")
    data=line.split()
    LiCs_r.append(angs2bohr*float(data[0]))
    LiCs_V.append(factor*float(data[1]))
 
fig=plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twinx()
ax2.plot(LiLi_r,LiLi_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^7\mathrm{Li}\leftarrow{}^7\mathrm{Li}^7\mathrm{Li}$")
ax1.plot((5.051,5.051),(-10,10),color='maroon',ls=':',linewidth=1)
itp = "LiLi $R_{\mathrm{e}}$"
ax2.text(5.1,1.5,itp,size=24)
ax2.plot(LiNa_r,LiNa_V,color='g',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{23}\mathrm{Na}\leftarrow{}^7\mathrm{Li}^{23}\mathrm{Na}$")
ax1.plot((5.31,5.31),(-10,10),color='g',ls=':',linewidth=1)
itp = "LiNa $R_{\mathrm{e}}$"
ax2.text(5.4,1.3,itp,size=24)
ax2.plot(LiK_r,LiK_V,color='r',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{39}\mathrm{K}\leftarrow{}^7\mathrm{Li}^{39}\mathrm{K}$")
ax1.plot((6.273,6.273),(-10,10),color='r',ls=':',linewidth=1)
itp = "LiK $R_{\mathrm{e}}$"
ax2.text(6.3,0.9,itp,size=24)
ax2.plot(LiRb_r,LiRb_V,color='b',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{85}\mathrm{Rb}\leftarrow{}^7\mathrm{Li}^{85}\mathrm{Rb}$")
ax1.plot((6.554,6.554),(-10,10),color='b',ls=':',linewidth=1)
itp = "LiRb $R_{\mathrm{e}}$"
ax2.text(6.6,0.7,itp,size=24)
ax2.plot(LiCs_r,LiCs_V,color='k',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{133}\mathrm{Cs}\leftarrow{}^7\mathrm{Li}^{133}\mathrm{Cs}$")
ax1.plot((6.945,6.945),(-10,10),color='k',ls=':',linewidth=1)
itp = "LiCs $R_{\mathrm{e}}$"
ax2.text(7.0,0.5,itp,size=24)
ax2.legend(loc=1)
ax2.set_xlim([2,15])
ax2.set_xticks([2,4,6,8,10,12,14],["2.0","4.0","6.0","8.0","10.0","12.0","14.0"])
ax2.set_ylim([-.2,1.7])
ax2.set_yticks([0,.5,1,1.5],["0.0","0.5","1.0","1.5"])
ax2.set_xlabel(r"$R (\mathrm{a}_0$)",size="24.0")
ax2.set_ylabel(r"$\text{Isotopic field shift / }h\;\text{(MHz)}$",size="24.0")
ax2.tick_params(labelsize="20.0")
ax2.set(adjustable='box-forced')
#ax1.set_aspect('equal')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend
frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

ax1.set_ylabel(r"$\text{Contact density (a}_{0}^{-3}$)",size="24.0")
ax1.set_ylim(-.0185,.157)
ax1.set_xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
vals2=[0,.05,.1,.15]
ax1.set_yticks(vals2)#0,.05,.1,.15)#],["0.0","0.05","0.10","0.15"])
ax1.tick_params(labelsize="20.0")

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,7)
fig.savefig('LiX_FSs.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('LiX_FSs.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()
