#/usr/bin/env python

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
SrSr1=open(str(path)+"/SrSr_DBOC_CCSD_DZP_harvested1.dat")
SrSr2=open(str(path)+"/SrSr_DBOC_CCSD_DZP_harvested2.dat")
SrSr3=open(str(path)+"/SrSr_DBOC_CCSD_DZP_harvested3.dat")
YbYb1=open(str(path)+"/YbYb_DBOC_CCSD_WTBS_harvested1.dat")
YbYb2=open(str(path)+"/YbYb_DBOC_CCSD_WTBS_harvested2.dat")
YbYb3=open(str(path)+"/YbYb_DBOC_CCSD_WTBS_harvested3.dat")
YbYb4=open(str(path)+"/YbYb_DBOC_CCSD_WTBS_harvested4.dat")
YbYb5=open(str(path)+"/YbYb_DBOC_CCSD_WTBS_harvested5.dat")
YbYb6=open(str(path)+"/YbYb_DBOC_CCSD_WTBS_harvested6.dat")

SrSr1_r=[]
SrSr1_V=[]
SrSr2_r=[]
SrSr2_V=[]
SrSr3_r=[]
SrSr3_V=[]
YbYb1_r=[]
YbYb1_V=[]
YbYb2_r=[]
YbYb2_V=[]
YbYb3_r=[]
YbYb3_V=[]
YbYb4_r=[]
YbYb4_V=[]
YbYb5_r=[]
YbYb5_V=[]
YbYb6_r=[]
YbYb6_V=[]

for line in SrSr1:
    line=line.rstrip("\n")
    data=line.split()
    SrSr1_r.append(angs2bohr*float(data[0]))
    SrSr1_V.append(cm2ghz*float(data[1]))
for line in SrSr2:
    line=line.rstrip("\n")
    data=line.split()
    SrSr2_r.append(angs2bohr*float(data[0]))
    SrSr2_V.append(cm2ghz*float(data[1]))
for line in SrSr3:
    line=line.rstrip("\n")
    data=line.split()
    SrSr3_r.append(angs2bohr*float(data[0]))
    SrSr3_V.append(cm2ghz*float(data[1]))
for line in YbYb1:
    line=line.rstrip("\n")
    data=line.split()
    YbYb1_r.append(angs2bohr*float(data[0]))
    YbYb1_V.append(cm2ghz*(float(data[1])-0.000296999998682))
for line in YbYb2:
    line=line.rstrip("\n")
    data=line.split()
    YbYb2_r.append(angs2bohr*float(data[0]))
    YbYb2_V.append(cm2ghz*(float(data[1])-0.000318000000334))
for line in YbYb3:
    line=line.rstrip("\n")
    data=line.split()
    YbYb3_r.append(angs2bohr*float(data[0]))
    YbYb3_V.append(cm2ghz*(float(data[1])-0.000320999999531))
for line in YbYb4:
    line=line.rstrip("\n")
    data=line.split()
    YbYb4_r.append(angs2bohr*float(data[0]))
    YbYb4_V.append(cm2ghz*(float(data[1])-0.000272999999652))
for line in YbYb5:
    line=line.rstrip("\n")
    data=line.split()
    YbYb5_r.append(angs2bohr*float(data[0]))
    YbYb5_V.append(cm2ghz*(float(data[1])-0.000324000000546))
for line in YbYb6:
    line=line.rstrip("\n")
    data=line.split()
    YbYb6_r.append(angs2bohr*float(data[0]))
    YbYb6_V.append(cm2ghz*(float(data[1])-0.00030599999991))


fig=plt.figure()
plt.plot(SrSr1_r,SrSr1_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^{84}\mathrm{Sr}^{84}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
plt.plot(SrSr2_r,SrSr2_V,color='maroon',marker='None',ls='--',linewidth=2,label=r"$^{86}\mathrm{Sr}^{86}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
plt.plot(SrSr3_r,SrSr3_V,color='maroon',marker='None',ls='-.',linewidth=2,label=r"$^{87}\mathrm{Sr}^{87}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
plt.plot((8.83,8.83),(-.1,1),color='maroon',ls=':',linewidth=1)
itp = "SrSr $R_{\mathrm{e}}$"
plt.text(8.83,-.0160,itp,size=24)
plt.plot(YbYb1_r,YbYb1_V,color='b',marker='None',ls='-',linewidth=2,label="$^{168}\mathrm{Yb}^{168}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
plt.plot(YbYb2_r,YbYb2_V,color='b',marker='None',ls='--',linewidth=2,label="$^{170}\mathrm{Yb}^{170}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
plt.plot(YbYb3_r,YbYb3_V,color='b',marker='None',ls='-.',linewidth=2,label="$^{171}\mathrm{Yb}^{171}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
plt.plot(YbYb4_r,YbYb4_V,color='c',marker='None',ls='-',linewidth=2,label="$^{172}\mathrm{Yb}^{172}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
plt.plot(YbYb5_r,YbYb5_V,color='c',marker='None',ls='--',linewidth=2,label="$^{173}\mathrm{Yb}^{173}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
plt.plot(YbYb6_r,YbYb6_V,color='c',marker='None',ls='-.',linewidth=2,label="$^{174}\mathrm{Yb}^{174}\mathrm{Yb}\leftarrow{}^{176}\mathrm{Yb}^{176}\mathrm{Yb}$")
plt.plot((8.8,8.8),(-.1,1),color='b',ls=':',linewidth=1)
itp = "YbYb $R_{\mathrm{e}}$"
plt.text(8.8,-.0185,itp,size=24)
plt.legend(loc=1)
plt.xlim([7,32])
plt.xticks([10,15,20,25,30],
           ["10.0","15.0","20.0","25.0","30.0"])
plt.ylim([-.019,.034])
plt.yticks([-.015,-0.01,-0.005,0,.005,.010,.015,.020,.025,.030],
           ["-15.0","-10.0","-5.0","0","5.0","10.0","15.0","20.0","25.0","30.0"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\text{Isotopic mass shift / }h\;\text{(MHz)}$",size="24.0")
plt.tick_params(labelsize="20.0")

ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()
ax.set(adjustable='box-forced')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('SrSr_YbYb_methods_DBOC.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('SrSr_YbYb_methods_DBOC.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


