#/usr/bin/env python

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
#Kolos=open("/Users/charityvermulm/Desktop/nonBOalk/Li2_Kolos_DBOC.dat")
RDZP=open(str(path)+"/Li2_DBOC_RCCSD_DZP.dat")
UDZP=open(str(path)+"/Li2_DBOC_UCCSD_DZP.dat")
RAVDZ=open(str(path)+"/Li2_DBOC_RCCSD_AVDZ.dat")
UAVDZ=open(str(path)+"/Li2_DBOC_UCCSD_AVDZ.dat")

#Kolos_r=[]
RDZP_r=[]
RDZP_V=[]
UDZP_r=[]
UDZP_V=[]
#Kolos_V=[]
RAVDZ_r=[]
RAVDZ_V=[]
UAVDZ_r=[]
UAVDZ_V=[]

#for line in Kolos:
#    line=line.rstrip("\n")
#    data=line.split()
#    Kolos_r.append(float(data[0]))
#    Kolos_V.append(float(data[1]))
for line in RDZP:
    line=line.rstrip("\n")
    data=line.split()
    RDZP_r.append(float(data[0]))
    RDZP_V.append(float(data[1]))
for line in UDZP:
    line=line.rstrip("\n")
    data=line.split()
    UDZP_r.append(float(data[0]))
    UDZP_V.append(float(data[1]))
for line in RAVDZ:
    line=line.rstrip("\n")
    data=line.split()
    RAVDZ_r.append(float(data[0]))
    RAVDZ_V.append(float(data[1]))
for line in UAVDZ:
    line=line.rstrip("\n")
    data=line.split()
    UAVDZ_r.append(float(data[0]))
    UAVDZ_V.append(float(data[1]))

fig=plt.figure()
#plt.plot(Kolos_r,Kolos_V,color='k',marker='None',ls='-',linewidth=2,label=u"Ko\u0142os")
plt.plot(UDZP_r,UDZP_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$\text{UHF-CCSD/DZP}$")
plt.plot(RDZP_r,RDZP_V,color='g',marker='None',ls='--',linewidth=2,label=r"$\text{RHF-CCSD/DZP}$")
plt.plot(UAVDZ_r,UAVDZ_V,color='r',marker='None',ls='-',linewidth=2,label=r"$\text{UHF-CCSD/aug-cc-pVDZ}$")
plt.plot(RAVDZ_r,RAVDZ_V,color='b',marker='None',ls='--',linewidth=2,label=r"$\text{RHF-CCSD/aug-cc-pVDZ}$")
plt.legend(loc=1)
plt.xlim([2,15])
plt.xticks([4,6,8,10,12,14],
           ["4.0","6.0","8.0","10.0","12.0","14.0"])
#plt.ylim([-.1,.2])
#plt.yticks([-50,0,50,100,150,200],
#           ["-50","0","50","100","150","200"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\Delta V^{\,\mathrm{ad}}(R)\; (\mathrm{cm}^{-1}$)",size="24.0")
#plt.title("Adiabatic corrections for H$_2$ computed with various methods", fontsize=20)
plt.tick_params(labelsize="20.0")
ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('Li2_methods_DBOC.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('Li2_methods_DBOC.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


