#/usr/bin/env python

import matplotlib.pyplot as plt
import math as m
import numpy as np
import scipy as sp
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
abinitio_DBOCs=open(str(path)+"/CCSD_LiK.dat")
empirical_DBOCs=open(str(path)+"/Tiemann_LiK.dat")

ai_r=[]
ai_dboc=[]
emp_r=[]
emp_dboc=[]

for line in abinitio_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    ai_r.append(float(data[0]))
    ai_dboc.append(float(data[1]))

for line in empirical_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    emp_r.append(float(data[0]))
    emp_dboc.append(float(data[1]))

fig=plt.figure()
plt.plot(ai_r,ai_dboc,color='g',marker='None',ls='-',linewidth=2,label=r"$ab$ $initio$ $\text{(RHF-CCSD)}$")
plt.plot(emp_r,emp_dboc,color='b',marker='None',ls='-',linewidth=2,label=r"$\text{empirical (Tiemann et al.)}$")
plt.plot((6.2723,6.2723),(-.15,.35),color='k',ls=':',linewidth=1)
itp = "$R_{\mathrm{e}}$"
plt.text(6.4,.14,itp,size=24)
plt.plot((4.5474,4.5474),(-.15,.35),color='k',ls=':',linewidth=1)
re = "$R_0$"
plt.text(4.6,.21,re,size=24)
plt.plot((8.8,8.8),(-.15,.35),color='k',ls=':',linewidth=1)
hotp = "$R_{1/2}$"
plt.text(8.9,.07,str(hotp),size=24)
plt.plot((4,21),(0,0),color='k',ls=':',linewidth=1)
plt.legend(loc=1)
plt.xlim([4.1,10.1])
plt.xticks([5,6,7,8,9,10],
           ["5.0","6.0","7.0","8.0","9.0","10.0"])
plt.ylim([-0.15,0.24])
plt.yticks([-0.15,-0.1,-0.05,0,0.05,0.10,0.15,0.20],
           ["-0.15","-0.10","-0.05","0","0.05","0.10","0.15","0.20"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\text{Isotopic mass shift (cm}^{-1})$",size="24.0")
#plt.title("Differences between RCCSD DBOCs for H$_2$ and \n 
#           adiabatic corrections of Ko$\l$os and Rychlewski", fontsize=20)
plt.tick_params(labelsize="20.0")
ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('LiK_RCCSD_Tiemann.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('LiK_RCCSD_Tiemann.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


