#/usr/bin/env python

import matplotlib.pyplot as plt
import math as m
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

Zsr=38.
dr2sr1=0.007
dr2sr2=0.051
PI=m.pi
srfactor1=2*(2./3.)*(float(PI)*float(Zsr))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2sr1)
srfactor2=2*(2./3.)*(float(PI)*float(Zsr))/6.626069E-34/1.0E+06*2.307077E-13*(52917.725)**(-3)*float(dr2sr2)
print srfactor1,srfactor2
# Read in potential data in Bohr, Hartree
SrSr_D=open(str(path)+"/SrSr_EDN_harvested.dat")
SrSr_A=open(str(path)+"/SrSr_ADF_harvested.dat")

SrSr_r=[]
SrSr_V1=[]
SrSr_V2=[]
SrSr_ra=[]
SrSr_V1a=[]
SrSr_V2a=[]

Srasym=0.0142075600015
#Srasym=0.01475600015

for line in SrSr_D:
    line=line.rstrip("\n")
    data=line.split()
    SrSr_r.append(angs2bohr*float(data[0]))
    SrSr_V1.append(srfactor1*(float(data[1])-Srasym))
    SrSr_V2.append(srfactor2*(float(data[1])-Srasym))

for line in SrSr_A:
    line=line.rstrip("\n")
    data=line.split()
    SrSr_ra.append(float(data[0]))
    SrSr_V1a.append(srfactor1*float(data[1]))
    SrSr_V2a.append(srfactor2*float(data[1]))


fig=plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twinx()
ax2.plot(SrSr_r,SrSr_V1,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Sr}^{87}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
ax2.plot(SrSr_r,SrSr_V2,color='maroon',marker='None',ls='--',linewidth=2,label=r"$^{86}\mathrm{Sr}^{86}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
ax2.plot(SrSr_ra,SrSr_V1a,color='blue',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Sr}^{87}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
ax2.plot(SrSr_ra,SrSr_V2a,color='blue',marker='None',ls='--',linewidth=2,label=r"$^{86}\mathrm{Sr}^{86}\mathrm{Sr}\leftarrow{}^{88}\mathrm{Sr}^{88}\mathrm{Sr}$")
ax1.plot((8.83,8.83),(-250,10),color='k',ls=':',linewidth=1)
itp = "SrSr $R_{\mathrm{e}}$"
ax2.text(8.83,2.1,itp,size=24)
ax2.legend(loc=4)
ax2.set_xlim([6,25])
xvals=[10.0,15.0,20.0,25.0]
xmark=["10.0","15.0","20.0","25.0"]
ax2.set_xticks(xvals,xmark)#[10,15,20,25],["10.0","15.0","20.0","25.0"])
ax2.set_ylim([-6.8667,4.1963])
#yvals1=[-.75,-.5,-.25,0,.25,.5]
#ax2.set_yticks(yvals1)#[-.75,-.5,-.25,0,.25,.5,.75],["-0.75","-0.50","-0.25","0","0.25","0.50","0.75"])
ax2.set_xlabel(r"$R (\mathrm{a}_0$)",size="24.0")
ax2.set_ylabel(r"$\text{Isotopic field shift / }h\;\text{(MHz)}$",size="24.0")
ax2.tick_params(labelsize="20.0")
ax2.set(adjustable='box-forced')
#ax1.set_aspect('equal')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend
frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

ax1.set_ylabel(r"$\text{Contact density (a}_0^{-3}$)",size="24.0")
#ax1.set_ylim(-0.04194,0.02883)
ax1.set_ylim(-0.36,0.22)
ax1.set_xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
#yvals2=[-0.04,-0.02,0,0.02]
#ax1.set_yticks(yvals2)
ax1.tick_params(labelsize="20.0")

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,7)
fig.savefig('SrSr_FSs.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('SrSr_FSs.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


