#/usr/bin/env python

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
RbLi=open(str(path)+"/RbLi_DBOC_CCSD_DZP_harvested.dat")
RbNa=open(str(path)+"/RbNa_DBOC_CCSD_DZP_harvested.dat")
RbK=open(str(path)+"/RbK_DBOC_CCSD_DZP_harvested.dat")
RbRb=open(str(path)+"/RbRb_DBOC_CCSD_DZP_harvested.dat")
RbCs=open(str(path)+"/RbCs_DBOC_CCSD_DZP_harvested.dat")

RbLi_r=[]
RbLi_V=[]
RbNa_r=[]
RbNa_V=[]
RbK_r=[]
RbK_V=[]
RbRb_r=[]
RbRb_V=[]
RbCs_r=[]
RbCs_V=[]

for line in RbLi:
    line=line.rstrip("\n")
    data=line.split()
    RbLi_r.append(float(data[0]))
    RbLi_V.append(cm2ghz*float(data[1]))
for line in RbNa:
    line=line.rstrip("\n")
    data=line.split()
    RbNa_r.append(float(data[0]))
    RbNa_V.append(cm2ghz*float(data[1]))
for line in RbK:
    line=line.rstrip("\n")
    data=line.split()
    RbK_r.append(float(data[0]))
    RbK_V.append(cm2ghz*float(data[1]))
for line in RbRb:
    line=line.rstrip("\n")
    data=line.split()
    RbRb_r.append(float(data[0]))
    RbRb_V.append(cm2ghz*float(data[1]))
for line in RbCs:
    line=line.rstrip("\n")
    data=line.split()
    RbCs_r.append(float(data[0]))
    RbCs_V.append(cm2ghz*float(data[1]))

fig=plt.figure()
plt.plot(RbLi_r,RbLi_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Rb}^7\mathrm{Li}\leftarrow{}^{85}\mathrm{Rb}^7\mathrm{Li}$")
plt.plot((6.554,6.554),(-100,100),color='maroon',ls=':',linewidth=1)
itp = "RbLi $R_{\mathrm{e}}$"
plt.text(6.56,-.110,itp,size=24)
plt.plot(RbNa_r,RbNa_V,color='g',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Rb}^{23}\mathrm{Na}\leftarrow{}^{85}\mathrm{Rb}^{23}\mathrm{Na}$")
plt.plot((6.903,6.903),(-100,100),color='g',ls=':',linewidth=1)
itp = "RbNa $R_{\mathrm{e}}$"
plt.text(6.91,-.095,itp,size=24)
plt.plot(RbK_r,RbK_V,color='r',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Rb}^{39}\mathrm{K}\leftarrow{}^{85}\mathrm{Rb}^{39}\mathrm{K}$")
plt.plot((7.379,7.379),(-100,100),color='r',ls=':',linewidth=1)
itp = "RbK $R_{\mathrm{e}}$"
plt.text(7.4,-.080,itp,size=24)
plt.plot(RbRb_r,RbRb_V,color='b',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Rb}^{85}\mathrm{Rb}\leftarrow{}^{85}\mathrm{Rb}^{85}\mathrm{Rb}$")
plt.plot((7.956,7.956),(-100,100),color='b',ls=':',linewidth=1)
itp = "RbRb $R_{\mathrm{e}}$"
plt.text(8.0,-.065,itp,size=24)
plt.plot(RbCs_r,RbCs_V,color='k',marker='None',ls='-',linewidth=2,label=r"$^{87}\mathrm{Rb}^{133}\mathrm{Cs}\leftarrow{}^{85}\mathrm{Rb}^{133}\mathrm{Cs}$")
plt.plot((8.380,8.380),(-100,100),color='k',ls=':',linewidth=1)
itp = "RbCs $R_{\mathrm{e}}$"
plt.text(8.4,-.05,itp,size=24)
plt.legend(loc=4)
plt.xlim([2,15])
plt.xticks([2,4,6,8,10,12,14],
           ["2.0","4.0","6.0","8.0","10.0","12.0","14.0"])
plt.ylim([-.18,.065])
plt.yticks([-.15,-.12,-.09,-.06,-.03,0,.03,.06],
           ["-150","-120","-90","-60","-30","0","30","60"])
plt.xlabel(r"$R\;(\mathrm{a}_0)$",size="24.0")
plt.ylabel(r"$\text{Isotopic mass shift / }h\;\text{(MHz)}$",size="24.0")
#plt.title("Adiabatic corrections for H$_2$ computed with various methods", fontsize=20)
plt.tick_params(labelsize="20.0")

ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()
ax.set(adjustable='box-forced')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('RbX_methods_DBOC.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('RbX_methods_DBOC.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


