#/usr/bin/env python

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
KLi1=open(str(path)+"/KLi_DBOC_CCSD_DZP_harvested_1.dat")
KNa1=open(str(path)+"/KNa_DBOC_CCSD_DZP_harvested_1.dat")
KK1=open(str(path)+"/KK_DBOC_CCSD_DZP_harvested_1.dat")
KRb1=open(str(path)+"/KRb_DBOC_CCSD_DZP_harvested_1.dat")
#KCs1=open("/Users/charityvermulm/Desktop/nonBOalk/KCs_DBOC_CCSD_DZP_harvested_1.dat")
KLi2=open(str(path)+"/KLi_DBOC_CCSD_DZP_harvested_2.dat")
KNa2=open(str(path)+"/KNa_DBOC_CCSD_DZP_harvested_2.dat")
KK2=open(str(path)+"/KK_DBOC_CCSD_DZP_harvested_2.dat")
KRb2=open(str(path)+"/KRb_DBOC_CCSD_DZP_harvested_2.dat")
#KCs2=open("/Users/charityvermulm/Desktop/nonBOalk/KCs_DBOC_CCSD_DZP_harvested_2.dat")

KLi1_r=[]
KLi1_V=[]
KNa1_r=[]
KNa1_V=[]
KK1_r=[]
KK1_V=[]
KRb1_r=[]
KRb1_V=[]
#KCs1_r=[]
#KCs1_V=[]
KLi2_r=[]
KLi2_V=[]
KNa2_r=[]
KNa2_V=[]
KK2_r=[]
KK2_V=[]
KRb2_r=[]
KRb2_V=[]
#KCs2_r=[]
#KCs2_V=[]

for line in KLi1:
    line=line.rstrip("\n")
    data=line.split()
    KLi1_r.append(float(data[0]))
    KLi1_V.append(cm2ghz*float(data[1]))
for line in KNa1:
    line=line.rstrip("\n")
    data=line.split()
    KNa1_r.append(float(data[0]))
    KNa1_V.append(cm2ghz*float(data[1]))
for line in KK1:
    line=line.rstrip("\n")
    data=line.split()
    KK1_r.append(float(data[0]))
    KK1_V.append(cm2ghz*float(data[1]))
for line in KRb1:
    line=line.rstrip("\n")
    data=line.split()
    KRb1_r.append(float(data[0]))
    KRb1_V.append(cm2ghz*float(data[1]))
#for line in KCs1:
#    line=line.rstrip("\n")
#    data=line.split()
#    KCs1_r.append(float(data[0]))
#    KCs1_V.append(float(data[1]))
for line in KLi2:
    line=line.rstrip("\n")
    data=line.split()
    KLi2_r.append(float(data[0]))
    KLi2_V.append(cm2ghz*float(data[1]))
for line in KNa2:
    line=line.rstrip("\n")
    data=line.split()
    KNa2_r.append(float(data[0]))
    KNa2_V.append(cm2ghz*float(data[1]))
for line in KK2:
    line=line.rstrip("\n")
    data=line.split()
    KK2_r.append(float(data[0]))
    KK2_V.append(cm2ghz*float(data[1]))
for line in KRb2:
    line=line.rstrip("\n")
    data=line.split()
    KRb2_r.append(float(data[0]))
    KRb2_V.append(cm2ghz*float(data[1]))
#for line in KCs2:
#    line=line.rstrip("\n")
#    data=line.split()
#    KCs2_r.append(float(data[0]))
#    KCs2_V.append(float(data[1]))

fig=plt.figure()
plt.plot(KLi1_r,KLi1_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^{40}\mathrm{K}^7\mathrm{Li}\leftarrow{}^{39}\!$K$^7\mathrm{Li}$")
plt.plot(KLi2_r,KLi2_V,color='maroon',marker='None',ls='--',linewidth=2,label=r"$^{41}\mathrm{K}^7\mathrm{Li}\leftarrow{}^{39}\!$K$^7\mathrm{Li}$")
plt.plot((6.273,6.273),(-10,10),color='maroon',ls=':',linewidth=1)
itp = "KLi $R_{\mathrm{e}}$"
plt.text(6.3,-.35,itp,size=24)
plt.plot(KNa1_r,KNa1_V,color='g',marker='None',ls='-',linewidth=2,label=r"$^{40}\mathrm{K}^{23}\mathrm{Na}\leftarrow{}^{39}\mathrm{K}^{23}\mathrm{Na}$")
plt.plot(KNa2_r,KNa2_V,color='g',marker='None',ls='--',linewidth=2,label=r"$^{41}\mathrm{K}^{23}\mathrm{Na}\leftarrow{}^{39}\mathrm{K}^{23}\mathrm{Na}$")
plt.plot((6.622,6.622),(-10,10),color='g',ls=':',linewidth=1)
itp = "KNa $R_{\mathrm{e}}$"
plt.text(6.65,-.275,itp,size=24)
plt.plot(KK1_r,KK1_V,color='r',marker='None',ls='-',linewidth=2,label=r"$^{40}\mathrm{K}^{39}\mathrm{K}\leftarrow{}^{39}\mathrm{K}^{39}\mathrm{K}$")
plt.plot(KK2_r,KK2_V,color='r',marker='None',ls='--',linewidth=2,label=r"$^{41}\mathrm{K}^{39}\mathrm{K}\leftarrow{}^{39}\mathrm{K}^{39}\mathrm{K}$")
plt.plot((7.379,7.379),(-10,10),color='r',ls=':',linewidth=1)
itp = "KK $R_{\mathrm{e}}$"
plt.text(7.4,-.2,itp,size=24)
plt.plot(KRb1_r,KRb1_V,color='b',marker='None',ls='-',linewidth=2,label=r"$^{40}\mathrm{K}^{85}\mathrm{Rb}\leftarrow{}^{39}\mathrm{K}^{85}\mathrm{Rb}$")
plt.plot(KRb2_r,KRb2_V,color='b',marker='None',ls='--',linewidth=2,label=r"$^{41}\mathrm{K}^{85}\mathrm{Rb}\leftarrow{}^{39}\mathrm{K}^{85}\mathrm{Rb}$")
plt.plot((7.699,7.699),(-10,10),color='b',ls=':',linewidth=1)
itp = "KRb $R_{\mathrm{e}}$"
plt.text(7.71,-.125,itp,size=24)
#plt.plot(KCs1_r,KCs1_V,color='k',marker='None',ls='-',linewidth=2,label="KCs1")
#plt.plot(KCs2_r,KCs2_V,color='k',marker='None',ls=':',linewidth=2,label="KCs2")
#plt.plot((6.945,6.945),(-.1,1),color='k',ls=':',linewidth=1)
#itp = "LiCs V(R$_{\mathrm{e}}$)"
#plt.text(7.0,.2,itp,size=20)
plt.legend(loc=4)
plt.xlim([2,15])
plt.xticks([2,4,6,8,10,12,14],
           ["2.0","4.0","6.0","8.0","10.0","12.0","14.0"])
plt.ylim([-0.4,0.15])
plt.yticks([-0.3,-0.2,-0.1,0,.1],
           ["-300","-200","-100","0","100"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\text{Isotopic mass shift / }h\;\text{(MHz)}$",size="24.0")
#plt.title("Adiabatic corrections for H$_2$ computed with various methods", fontsize=20)
plt.tick_params(labelsize="20.0")

ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()
ax.set(adjustable='box-forced')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('KX_methods_DBOC.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('KX_methods_DBOC.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


