#/usr/bin/env python

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
LiLi=open(str(path)+"/Li2_DBOC_RCCSD_DZP.dat")
LiNa=open(str(path)+"/LiNa_DBOC_RCCSD_DZP.dat")
LiK=open(str(path)+"/LiK_DBOC_RCCSD_DZP.dat")
LiRb=open(str(path)+"/LiRb_DBOC_RCCSD_DZP.dat")
LiCs=open(str(path)+"/LiCs_DBOC_RCCSD_DZP.dat")

LiLi_r=[]
LiLi_V=[]
LiNa_r=[]
LiNa_V=[]
LiK_r=[]
LiK_V=[]
LiRb_r=[]
LiRb_V=[]
LiCs_r=[]
LiCs_V=[]

for line in LiLi:
    line=line.rstrip("\n")
    data=line.split()
    LiLi_r.append(float(data[0]))
    LiLi_V.append(cm2ghz*float(data[1]))
for line in LiNa:
    line=line.rstrip("\n")
    data=line.split()
    LiNa_r.append(float(data[0]))
    LiNa_V.append(cm2ghz*float(data[1]))
for line in LiK:
    line=line.rstrip("\n")
    data=line.split()
    LiK_r.append(float(data[0]))
    LiK_V.append(cm2ghz*float(data[1]))
for line in LiRb:
    line=line.rstrip("\n")
    data=line.split()
    LiRb_r.append(float(data[0]))
    LiRb_V.append(cm2ghz*float(data[1]))
for line in LiCs:
    line=line.rstrip("\n")
    data=line.split()
    LiCs_r.append(float(data[0]))
    LiCs_V.append(cm2ghz*float(data[1]))

fig=plt.figure()
plt.plot(LiLi_r,LiLi_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^7\mathrm{Li}\leftarrow{}^7\mathrm{Li}^7\mathrm{Li}$")
plt.plot((5.051,5.051),(-100,100),color='maroon',ls=':',linewidth=1)
itp = "LiLi $R_{\mathrm{e}}$"
plt.text(5.1,10.5,itp,size=24)
plt.plot(LiNa_r,LiNa_V,color='g',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{23}\mathrm{Na}\leftarrow{}^7\mathrm{Li}^{23}\mathrm{Na}$")
plt.plot((5.31,5.31),(-100,100),color='g',ls=':',linewidth=1)
itp = "LiNa $R_{\mathrm{e}}$"
plt.text(5.4,9,itp,size=24)
plt.plot(LiK_r,LiK_V,color='r',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{39}\mathrm{K}\leftarrow{}^7\mathrm{Li}^{39}\mathrm{K}$")
plt.plot((6.273,6.273),(-100,100),color='r',ls=':',linewidth=1)
itp = "LiK $R_{\mathrm{e}}$"
plt.text(6.3,7.5,itp,size=24)
plt.plot(LiRb_r,LiRb_V,color='b',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{85}\mathrm{Rb}\leftarrow{}^7\mathrm{Li}^{85}\mathrm{Rb}$")
plt.plot((6.554,6.554),(-100,100),color='b',ls=':',linewidth=1)
itp = "LiRb $R_{\mathrm{e}}$"
plt.text(6.6,6,itp,size=24)
plt.plot(LiCs_r,LiCs_V,color='k',marker='None',ls='-',linewidth=2,label=r"$^6\mathrm{Li}^{133}\mathrm{Cs}\leftarrow{}^7\mathrm{Li}^{133}\mathrm{Cs}$")
plt.plot((6.945,6.945),(-100,100),color='k',ls=':',linewidth=1)
itp = "LiCs $R_{\mathrm{e}}$"
plt.text(7.0,4.5,itp,size=24)
plt.legend(loc=1)
plt.xlim([2,15])
plt.xticks([2,4,6,8,10,12,14],
           ["2.0","4.0","6.0","8.0","10.0","12.0","14.0"])
plt.ylim([-2,12.5])
plt.yticks([0,2,4,6,8,10,12],
           ["0","2.0","4.0","6.0","8.0","10.0","12.0"])
#plt.ylim([-.1,.8])
#plt.yticks([-50,0,50,100,150,200],
#           ["-50","0","50","100","150","200"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\text{Isotopic mass shift / }h\;\text{(GHz)}$",size="24.0")
#plt.title("Adiabatic corrections for H$_2$ computed with various methods", fontsize=20)
plt.tick_params(labelsize="20.0")

ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()
ax.set(adjustable='box-forced')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('LiX_methods_DBOC.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('LiX_methods_DBOC.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


