#/usr/bin/env python

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
#Kolos=open("/Users/charityvermulm/Desktop/nonBOalk/H2_Kolos_V.dat")
RHF=open(str(path)+"/LiLi_CCSD_AVDZ_harvested.dat")
UHF=open(str(path)+"/LiLi_UCCSD_AVDZ_harvested.dat")
RCCSD=open(str(path)+"/LiLi_CCSD_DZP_harvested.dat")
UCCSD=open(str(path)+"/LiLi_UCCSD_DZP_harvested.dat")

#Kolos_r=[]
RHF_r=[]
RHF_V=[]
UHF_r=[]
UHF_V=[]
#Kolos_V=[]
RCCSD_r=[]
RCCSD_V=[]
UCCSD_r=[]
UCCSD_V=[]
#for line in Kolos:
#    line=line.rstrip("\n")
#    data=line.split()
#    Kolos_r.append(float(data[0]))
#    Kolos_V.append(float(data[1]))
for line in RHF:
    line=line.rstrip("\n")
    data=line.split()
    RHF_r.append(float(data[0]))
    RHF_V.append(float(data[1]))
for line in UHF:
    line=line.rstrip("\n")
    data=line.split()
    UHF_r.append(float(data[0]))
    UHF_V.append(float(data[1]))
for line in RCCSD:
    line=line.rstrip("\n")
    data=line.split()
    RCCSD_r.append(float(data[0]))
    RCCSD_V.append(float(data[1]))
for line in UCCSD:
    line=line.rstrip("\n")
    data=line.split()
    UCCSD_r.append(float(data[0]))
    UCCSD_V.append(float(data[1]))

fig=plt.figure()
#plt.plot(Kolos_r,Kolos_V,color='k',marker='None',ls='-',linewidth=2,label=u"Ko\u0142os")
plt.plot(UCCSD_r,UCCSD_V,color='maroon',marker='None',ls='-',linewidth=2,label=r"$\text{UHF-CCSD/DZP}$")
plt.plot(RCCSD_r,RCCSD_V,color='g',marker='None',ls='--',linewidth=2,label=r"$\text{RHF-CCSD/DZP}$")
plt.plot(UHF_r,UHF_V,color='r',marker='None',ls='-',linewidth=2,label=r"$\text{UHF-CCSD/aug-cc-pVDZ}$")
plt.plot(RHF_r,RHF_V,color='b',marker='None',ls='--',linewidth=2,label=r"$\text{RHF-CCSD/aug-cc-pVDZ}$")
plt.legend(loc=1)
plt.xlim([2,15])
plt.xticks([4,6,8,10,12,14],
           ["4.0","6.0","8.0","10.0","12.0","14.0"])
plt.ylim([0,0.3])
plt.yticks([0,0.1,0.2,0.3],
           ["0.0","0.1","0.2","0.3"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$V(R)\;(\text{hartree})$",size="24.0")
#plt.title("Adiabatic corrections for H$_2$ computed with various methods", fontsize=20)
plt.tick_params(labelsize="20.0")
ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('Li2_methods_V.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('Li2_methods_V.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


