#/usr/bin/env python

import matplotlib.pyplot as plt
import math as m
import numpy as np
import scipy as sp
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
ANORCC_DBOCs=open(str(path)+"/ANORCC_err.dat")
ANORCCmb_DBOCs=open(str(path)+"/ANORCCmb_err.dat")
AV5Z_DBOCs=open(str(path)+"/AV5Z_err.dat")
AV5Zmb_DBOCs=open(str(path)+"/AV5Zmb_err.dat")
AV6Z_DBOCs=open(str(path)+"/AV6Z_err.dat")

ANORCC_r=[]
ANORCC_err=[]
ANORCCmb_r=[]
ANORCCmb_err=[]
AV5Z_r=[]
AV5Z_err=[]
AV5Zmb_r=[]
AV5Zmb_err=[]
AV6Z_r=[]
AV6Z_err=[]

for line in ANORCC_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    ANORCC_r.append(float(data[0]))
    ANORCC_err.append(float(data[1]))

for line in ANORCCmb_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    ANORCCmb_r.append(float(data[0]))
    ANORCCmb_err.append(float(data[1]))

for line in AV5Z_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    AV5Z_r.append(float(data[0]))
    AV5Z_err.append(float(data[1]))

for line in AV5Zmb_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    AV5Zmb_r.append(float(data[0]))
    AV5Zmb_err.append(float(data[1]))

for line in AV6Z_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    AV6Z_r.append(float(data[0]))
    AV6Z_err.append(float(data[1]))

fig=plt.figure()
plt.plot(ANORCC_r,ANORCC_err,color='r',marker='None',ls='-',linewidth=2,label=r"$\text{ANO-RCC}$")
#plt.plot(ANORCCmb_r,ANORCCmb_err,color='maroon',marker='None',ls='-',label="ANO-RCC+mb")
plt.plot(AV5Z_r,AV5Z_err,color='blueviolet',marker='None',ls='-',linewidth=2,label=r"$\text{aug-cc-pV5Z}$")
plt.plot(AV5Zmb_r,AV5Zmb_err,color='g',marker='None',ls='-',linewidth=2,label=r"$\text{aug-cc-pV5Z+mb}$")
plt.plot(AV6Z_r,AV6Z_err,color='blue',marker='None',ls='-',linewidth=2,label=r"$\text{aug-cc-pV6Z}$")
plt.plot((0,100),(0,0),color='k',ls=':',linewidth=1)
plt.legend(loc=4)
plt.xlim([0,6])
plt.xticks([1,2,3,4,5,6],
           ["1","2","3","4","5","6"])
plt.ylim([-0.15,0.15])
plt.yticks([-0.15,-0.1,-0.05,0,0.05,0.1,0.15],
           ["-0.15","-0.10","-0.05","0","0.05","0.10","0.15"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\text{Error in }\Delta V^{\,\mathrm{ad}}(R)\;(\mathrm{cm}^{-1}$)",size="24.0")
#plt.title("Differences between RCCSD DBOCs for H$_2$ and 
#           adiabatic corrections of Kou"Ko\u0142os"os and Rychlewski", fontsize=20)
plt.tick_params(labelsize="20.0")
ax=plt.axes()
#ax.yaxis.grid()
#ax.xaxis.grid()

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('H2_basis_rel.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('H2_basis_rel.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


