#/usr/bin/env python

import matplotlib.pylab as plt
import math as m
import numpy as np
import scipy as sp
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}
import os
path = os.getcwd()

cm2hart=(1/219474.63067)
cm2ghz=29.9702547
ghz2cm=(1/29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1/1.889725989)

# Read in potential data in Bohr, Hartree
kolos_DBOCs=open(str(path)+"/kolos_DBOC.dat")
DZP_DBOCs=open(str(path)+"/DZP_DBOC.dat")
AVDZ_DBOCs=open(str(path)+"/AVDZ_DBOC.dat")
AVTZ_DBOCs=open(str(path)+"/AVTZ_DBOC.dat")
AVQZ_DBOCs=open(str(path)+"/AVQZ_DBOC.dat")
ANORCC_DBOCs=open(str(path)+"/ANORCC_DBOC.dat")
AV5Zmb_DBOCs=open(str(path)+"/AV5Zmb_DBOC.dat")

kolos_r=[]
kolos_DBOC=[]
DZP_r=[]
DZP_DBOC=[]
AVDZ_r=[]
AVDZ_DBOC=[]
AVTZ_r=[]
AVTZ_DBOC=[]
AVQZ_r=[]
AVQZ_DBOC=[]
ANORCC_r=[]
ANORCC_DBOC=[]
AV5Z_r=[]
AV5Z_DBOC=[]
AV5Zmb_r=[]
AV5Zmb_DBOC=[]
AV6Z_r=[]
AV6Z_DBOC=[]

for line in kolos_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    kolos_r.append(float(data[0]))
    kolos_DBOC.append(float(data[1]))

for line in DZP_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    DZP_r.append(float(data[0]))
    DZP_DBOC.append(float(data[1]))

for line in ANORCC_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    ANORCC_r.append(float(data[0]))
    ANORCC_DBOC.append(float(data[1]))

for line in AVDZ_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    AVDZ_r.append(float(data[0]))
    AVDZ_DBOC.append(float(data[1]))

for line in AVTZ_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    AVTZ_r.append(float(data[0]))
    AVTZ_DBOC.append(float(data[1]))

for line in AVQZ_DBOCs:
    line=line.rstrip("\n")
    data=line.split()
    AVQZ_r.append(float(data[0]))
    AVQZ_DBOC.append(float(data[1]))

plt.plot(kolos_r,kolos_DBOC,color='k',marker='x',ls='None',linewidth=2,label=r"$\text{Ko}$\l{}$\text{os}$")
plt.plot(DZP_r,DZP_DBOC,color='c',marker='None',ls='-',linewidth=2,label=r"$\text{DZP}$")
plt.plot(AVDZ_r,AVDZ_DBOC,color='b',marker='None',ls='-',linewidth=2,label=r"$\text{aug-cc-pVDZ}$")
plt.plot(AVTZ_r,AVTZ_DBOC,color='darkgreen',marker='None',ls='-',linewidth=2,label=r"$\text{aug-cc-pVTZ}$")
plt.plot(AVQZ_r,AVQZ_DBOC,color='violet',marker='None',ls='-',linewidth=2,label=r"$\text{aug-cc-pVQZ}$")
plt.plot(ANORCC_r,ANORCC_DBOC,color='r',marker='None',ls='-',linewidth=2,label=r"$\text{ANO-RCC}$")
plt.legend(loc=1)
plt.xlim([0.5,5.5])
plt.xticks([1,2,3,4,5],
           ["1","2","3","4","5"])
plt.ylim([-20,30])
plt.yticks([-20,-15,-10,-5,0,5,10,15,20,25,30],
           ["-20","-15","-10","-5","0","5","10","15","20","25","30"])
plt.xlabel(r"$R\;(\mathrm{a}_0$)",size="24.0")
plt.ylabel(r"$\Delta V^{\,\mathrm{ad}}(R)\;(\mathrm{cm}^{-1}$)",size="24.0")
#plt.title("CCSD DBOCs for H$_2$ using various basis sets \n comared with adiabatic corrections of Ko$\l$os", fontsize=20)
plt.plot((1.4,1.4),(-20,50),color='k',ls=':',linewidth=1)
itp = "$R_{\mathrm{e}}$"
plt.text(1.5,15,itp,size=24)
plt.plot((0.8,0.8),(-20,50),color='k',ls=':',linewidth=1)
re = "$R_0$"
plt.text(0.9,25,re,size=24)
plt.plot((3.0,3.0),(-20,50),color='k',ls=':',linewidth=1)
hotp = "$R_{1/2}$"
plt.text(3.1,5,str(hotp),size="24.0")
plt.plot((0,7),(0,0),color='k',ls=':',linewidth=1)
plt.tick_params(labelsize="20.0")
ax=plt.axes()

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend

frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="24.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('H2_basis_abs.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('H2_basis_abs.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()
