#/usr/bin/env python 
import sys,os
import matplotlib.pyplot as plt
import math as m
import numpy as np
#import scipy as sp
from scipy.integrate import quad
from scipy import interpolate
from scipy import integrate
import scipy.optimize
from matplotlib import pyplot as plt
import matplotlib as mpl
mpl.rcParams['text.usetex'] = True
mpl.rcParams['text.latex.preamble'] = [r'\usepackage{amsmath}'] #for \text command
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = 'Times New Roman'
tnr = {'fontname':'Times New Roman'}

CWD = os.getcwd()

#User-definied width of the trapezoid for integration 
tick = 0.1

#Conversion factors and constants
cm2hart=(1./219474.63067)
cm2ghz=29.9702547
ghz2cm=(1./29.9702547)
hart2cm=219474.63067
angs2bohr=1.889725989
bohr2angs=(1./1.889725989)
infnty = 100000 
zero = 0.0E0
PI = m.pi
ghz2hart = 1.5198285E-7
amu2au = 1822.88839
Li6_mass = 6.015122795e0
Li7_mass = 7.01600455e0
K39_mass = 38.96370668e0
Li7_mu = Li7_mass*K39_mass/(Li7_mass+K39_mass)
Li6_mu = Li6_mass*K39_mass/(Li6_mass+K39_mass)

b_const = -0.140
Rref_angst = 3.31915094
a_0 = -6216.885781
a_1 =  0.334917429
a_2 =  0.323011297e5
a_3 =  0.860795379e4
a_4 = -0.282433630e5
a_5 = -0.308683063e5
a_6 = -0.161513488e5
a_7 = -0.137002015e6
a_8 = -0.347458261e6
a_9 =  0.708580513e6
a_10=  0.254996749e7
a_11=  0.498407877e7
a_12= -0.852878862e7
a_13= -0.161176610e9
a_14=  0.114921288e8
a_15=  0.159815395e10
a_16= -0.274957351e9
a_17= -0.841507227e10
a_18=  0.381237693e10
a_19=  0.251064334e11
a_20= -0.199254108e11
a_21= -0.382991547e11
a_22=  0.470917590e11
a_23=  0.161747462e11
a_24= -0.427310532e11
a_25=  0.160268221e11
U_inf= 0.0E0
C_6  = 0.1119028E8
C_8  = 0.2631649E9
C_10 = 0.9997962E10
A_ex = 0.2118698E4
gamma= 4.88068
beta = 2.25698

#Routine for sampling Tiemann et al's potential function
def Vmlr(rbohr):
  rangst = rbohr*bohr2angs
#  prefactor = ((Li6_mass-Li7_mass)/Li6_mass)*(2*Rref_angst/(rangst+Rref_angst))**6
  yref = (rangst-Rref_angst)/(rangst+b_const*Rref_angst)
  if rangst<11.101:
    Vcm = m.fsum([a_0*yref**0, a_1*yref**1, a_2*yref**2, a_3*yref**3, a_4*yref**4, a_5*yref**5,
                               a_6*yref**6, a_7*yref**7, a_8*yref**8, a_9*yref**9, a_10*yref**10,
       	                       a_11*yref**11, a_12*yref**12, a_13*yref**13, a_14*yref**14, a_15*yref**15,
		               a_16*yref**16, a_17*yref**17, a_18*yref**18, a_19*yref**19, a_20*yref**20,
		               a_21*yref**21, a_22*yref**22, a_23*yref**23, a_24*yref**24, a_25*yref**25])
  else:
    Vcm = U_inf - C_6/rangst**6 - C_8/rangst**8 - C_10/rangst**10 - A_ex*rangst**gamma*m.exp(-1*beta*rangst)
  #print rbohr,Vcm
  Vghz = Vcm*cm2ghz
  return Vghz

#This routine is similar to Vmlr, except it sets the asymptote to zero
#and has ability to add a correction 
asymp_mlr = Vmlr(infnty)
#print "asymp_mlr= ",asymp_mlr
def Vmlr0(rbohr,dV):
  Vghz = Vmlr(rbohr) - asymp_mlr + dV
  return Vghz

#Here R0 is determined numerically
R0 = 2.360*angs2bohr

#This routine interpolates DBOC functions without adding a potential value
def dV(rbohr,r,DBOC):
    f = interpolate.interp1d(r,DBOC,kind='cubic')
    val = f(rbohr)
    return val

# Read in DBOC data (file units are bohr, cm-1)
LiK=open(CWD+"/CCSD_LiK.dat")
Tfile=open(CWD+"/Tiemann_LiK.dat")

Tiem_r=[]
Tiem_DBOC=[]
LiK_r=[]
LiK_DBOC=[]

#All energies read in are immediately converted to GHz
for line in LiK:
    line=line.rstrip("\n")
    data=line.split()
    LiK_r.append(float(data[0]))
    LiK_DBOC.append(cm2ghz*float(data[1]))
for line in Tfile:
    line=line.rstrip("\n")
    data=line.split()
    Tiem_r.append(float(data[0]))
    Tiem_DBOC.append(cm2ghz*float(data[1]))

frac7 = []
Tiem7 = []
x_frac = []
y_frac = []
y_Tiem = []
intfrac7 = []
intTiem = []
print_frac = []
print_Tiem = []
frac_r = []
frac_fin = []
for i in np.arange(4.5, 19.95, tick):
    V_i = m.sqrt(m.fabs(Vmlr0(i,zero)))
    frac7.append(1/(2*PI)*m.sqrt(amu2au*ghz2hart*2.*Li7_mu)*dV(i,LiK_r,LiK_DBOC)/V_i)
    Tiem7.append(1/(2*PI)*m.sqrt(amu2au*ghz2hart*2.*Li7_mu)*dV(i,Tiem_r,Tiem_DBOC)/V_i)
#   print "Li7_mu, dV, V_i, frac7", Li7_mu, dV(i,LiK_r,LiK_DBOC), V_i, frac7[-1]

    if i>R0:     #  Load arrays with the functions
        x_frac.append(float(i))
        y_frac.append(float(frac7[-1]))
        y_Tiem.append(float(Tiem7[-1]))
        intfrac7.append(-10000*y_frac[-1])
        intTiem.append(-10000*y_Tiem[-1])
        cumfrac7=integrate.cumtrapz(y_frac,x_frac,initial=0,dx=tick)
        cumTiem=integrate.cumtrapz(y_Tiem,x_frac,initial=0,dx=tick)
        print_frac.append(-10000*cumfrac7[-1])
        print_Tiem.append(-10000*cumTiem[-1])

fig=plt.figure()
ax1 = fig.add_subplot(111)
ax2 = ax1.twinx()

ax2.plot(x_frac,print_frac,color='green',marker='None',ls='--',linewidth=2,label=r"$ab$ $initio$ $\text{(RHF-CCSD)}$")
ax2.plot(x_frac,print_Tiem,color='blue',marker='None',ls='--',linewidth=2,label=r"$\text{empirical (Tiemann et al.)}$")
ax1.plot(x_frac,intfrac7,color='green',marker='None',ls='-',linewidth=2)
ax1.plot(x_frac,intTiem,color='blue',marker='None',ls='-',linewidth=2)
ax2.plot((0,50),(0,0),color='k',ls=":",linewidth=1)
ax2.plot((R0,R0),(-100,100),color='k',ls=':',linewidth=1)

ax2.legend(loc=4)
ax2.set_xlim([4,20])
#ax2.set_xticks([4,6,8,10,12,14,16,18,20],
#           ["4.0","6.0", "8.0","10.0","12.0",
#            "14.0","16.0","18.0","20.0"])
ax2.set_ylim([-2.5,1])
ax2.set_yticks([-2,-1.5,-1,-0.5,0,0.5,1])
ax2.set_yticklabels([r"$-2.0$","$-1.5$","$-1.0$","$-0.5$","$0.0$","$0.5$","$1.0$"])
#plt.yticks([-.4,-.3,-.2,-.1,0,.1,.2,.3,.4],
#           ["-0.4","","-0.2","","0.0","","0.2","","0.4"])
ax2.set_xlabel(r"$R\;(\mathrm{a}_0)$",size="24.0",**tnr)
ax2.set_ylabel(r"$\text{Cumulative integral} \times 10^{4}$",size="24.0",**tnr)# (1/bohr)",size="24.0")
#"mass shift / (|V(R)|$^{1/2}$ $h$) (kHz$^{1/2}$)",size="30.0")
ax2.tick_params(labelsize="20.0")
#ax2=plt.axes()
ax2.set(adjustable='box-forced')

leg = plt.gca().get_legend()
ltext  = leg.get_texts()  # all the text.Text instance in the legend
llines = leg.get_lines()  # all the lines.Line2D instance in the legend
frame  = leg.get_frame()  # the patch.Rectangle instance surrounding the legend
frame.set_facecolor('1.00')      # set the frame face color to light gray
plt.setp(ltext, fontsize="20.0")    # the legend text fontsize
plt.setp(llines, linewidth=2.0)      # the legend linewidth

ax1.set_ylabel(r"$\text{Integrand} \times 10^{4}\;(\mathrm{a}_0^{-1})$",size="24.0",**tnr)
ax1.set_ylim([-1.25,0.5])
ax1.set_xlabel(r"$R\;(\mathrm{a}_0)$",size="24.0",**tnr)
#ax1.set_yticks([-20,-15,-10,-5,0,5,10,15,20,25,30],["-20","-15","-10","-5","0","5","10","15","20","25","30"])
ax1.tick_params(labelsize="20.0")
ax1.set(adjustable='box-forced')

plt.tight_layout()

fig = plt.gcf()
fig.set_size_inches(10,8)
fig.savefig('LiK_integrands_literature.pdf',bbox_inches='tight',dpi=600,format='pdf')
fig.savefig('LiK_integrands_literature.eps',bbox_inches='tight',dpi=600,format='eps')

plt.show()


