(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    198368,       4677]
NotebookOptionsPosition[    196302,       4621]
NotebookOutlinePosition[    196657,       4637]
CellTagsIndexPosition[    196614,       4634]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.640081563786171*^9, 3.640081574144381*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"stringa", "=", "\"\<../InitialTesselations\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "stringa", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"filesin", "=", 
    RowBox[{"FileNames", "[", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"stringa", ",", "\"\<triang_lmax0.01.dat\>\""}], "]"}], "]"}]}],
    ";", 
   RowBox[{"(*", 
    RowBox[{
    "this", " ", "0.01", " ", "I", " ", "have", " ", "used", " ", "for", " ", 
     "the", " ", "phase", " ", "diagram", " ", "and", " ", "0.04", " ", "for",
      " ", "the", " ", "images", " ", "and", " ", "bridges"}], "*)"}], "\n", 
   RowBox[{"nfiles", "=", 
    RowBox[{"Length", "[", "filesin", "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"file", "=", 
   RowBox[{"filesin", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"str", "=", 
    RowBox[{"OpenRead", "[", "file", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"nvert", "=", 
  RowBox[{"Read", "[", 
   RowBox[{"str", ",", "Number"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"nedge", "=", 
  RowBox[{"Read", "[", 
   RowBox[{"str", ",", "Number"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nfacet", "=", 
   RowBox[{"Read", "[", 
    RowBox[{"str", ",", "Number"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"datavert", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"vv", "[", 
       RowBox[{"n", ",", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "nvert"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataedge", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ee", "[", 
      RowBox[{"n", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "nedge"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"datafacet", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ff", "[", 
       RowBox[{"n", ",", "i"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "nfacet"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "9"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "\[LessEqual]", "nvert"}], ",", " ", 
     RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"vv", "[", 
        RowBox[{"n", ",", "1"}], "]"}], "=", 
       RowBox[{"Read", "[", 
        RowBox[{"str", ",", "Number"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vv", "[", 
        RowBox[{"n", ",", "2"}], "]"}], "=", 
       RowBox[{"Read", "[", 
        RowBox[{"str", ",", "Number"}], "]"}]}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "\[LessEqual]", "nedge"}], ",", " ", 
     RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", "4"}], ",", " ", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"ee", "[", 
           RowBox[{"n", ",", "i"}], "]"}], "=", 
          RowBox[{"Read", "[", 
           RowBox[{"str", ",", "Number"}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";"}]}], "\n", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "\[LessEqual]", "nfacet"}], ",", " ", 
     RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", "9"}], ",", " ", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"ff", "[", 
           RowBox[{"n", ",", "i"}], "]"}], "=", 
          RowBox[{"Read", "[", 
           RowBox[{"str", ",", "Number"}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Yellow", ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "1"}], "]"}], ",", "1"}], "]"}], ",", 
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "1"}], "]"}], ",", "2"}], "]"}]}], "}"}], 
           "  ", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "2"}], "]"}], ",", "1"}], "]"}], ",", 
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "2"}], "]"}], ",", "2"}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "3"}], "]"}], ",", "1"}], "]"}], ",", 
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "3"}], "]"}], ",", "2"}], "]"}]}], "}"}]}], 
          " ", "}"}], " ", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "nfacet"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", "p"}], "}"}], ",", " ", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontSize", " ", "\[Rule]", " ", "17"}], "}"}]}]}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.640081670050551*^9, 3.640081778828629*^9}, 
   3.640082122651922*^9, 3.640082439163292*^9, 3.640684171942515*^9, 
   3.640928951669964*^9, {3.641111457138102*^9, 3.641111458357168*^9}, {
   3.641112415164249*^9, 3.641112415704164*^9}, 3.641117549801156*^9, {
   3.641309538725741*^9, 3.6413095404340763`*^9}, {3.6414899023908033`*^9, 
   3.641489902548152*^9}, {3.641556878922017*^9, 3.6415568790494957`*^9}, {
   3.641637007983575*^9, 3.641637016820776*^9}, {3.641637103143918*^9, 
   3.641637107937318*^9}, {3.641637150893651*^9, 3.641637154404502*^9}, {
   3.6416372233980722`*^9, 3.6416372314098263`*^9}, {3.641927040476334*^9, 
   3.641927041811804*^9}, {3.6421401256844177`*^9, 3.6421401261816673`*^9}, {
   3.642160463192452*^9, 3.642160463903919*^9}, {3.644216238317341*^9, 
   3.644216239662966*^9}, {3.6442164375452137`*^9, 3.6442164378193502`*^9}, {
   3.64421648826232*^9, 3.6442164996028748`*^9}, {3.646644669948039*^9, 
   3.646644693709591*^9}, {3.6466551102084293`*^9, 3.646655111560699*^9}, {
   3.6470649011866093`*^9, 3.647064901467061*^9}, {3.6470773748548717`*^9, 
   3.6470773749298983`*^9}, {3.647679623782599*^9, 3.647679624300386*^9}, {
   3.647768948219119*^9, 3.64776903022066*^9}, {3.647769118378942*^9, 
   3.647769164199872*^9}, {3.647769298481193*^9, 3.6477693765223722`*^9}, {
   3.6477694870747147`*^9, 3.6477695022947397`*^9}, {3.647769655085415*^9, 
   3.6477696554961977`*^9}, {3.6727591718106823`*^9, 3.67275917816693*^9}, {
   3.6727593687778807`*^9, 3.672759368848156*^9}, {3.676628757803769*^9, 
   3.6766287584860153`*^9}, {3.676629041256983*^9, 3.676629041414188*^9}, {
   3.676631640995614*^9, 3.676631658144267*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%1974", ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datavert3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"vv3", "[", 
        RowBox[{"n", ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "nvert"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "3"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rr", "[", "z_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "^", "8"}], "-", 
        RowBox[{"14", "*", 
         RowBox[{"z", "^", "4"}]}], "+", "1"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"a", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi", "=", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eta", "=", 
     RowBox[{"a", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"w", " ", "=", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "3", "]"}], "-", "1"}], ")"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Re", "[", 
      RowBox[{"I", "*", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rr", "[", "tau", "]"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"tau", "^", "2"}]}], ")"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"tau", ",", "0", ",", "w"}], "}"}]}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y", " ", "=", " ", 
     RowBox[{"Re", "[", 
      RowBox[{"I", "*", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"I", "*", 
          RowBox[{"rr", "[", "tau", "]"}], 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"tau", "^", "2"}]}], ")"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"tau", ",", "0", ",", "w"}], "}"}]}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z", " ", "=", " ", 
     RowBox[{"Re", "[", 
      RowBox[{"I", "*", 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"2", 
          RowBox[{"rr", "[", "tau", "]"}], "tau"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"tau", ",", "0", ",", "w"}], "}"}]}], "]"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "z", "\[IndentingNewLine]", "x", 
   "\[IndentingNewLine]", "y", "\[IndentingNewLine]", 
   RowBox[{"r", " ", "=", " ", 
    RowBox[{
     RowBox[{"-", "a"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", "0.5", "]"}], "/", "y"}]}]}], "\n", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["3"]}], 
    SqrtBox["2"]], "\n", "0.`", "\n", "0.`", "\n", 
   RowBox[{"-", "0.7624434082076192`"}], "\n", 
   "0.9274219877496757`"}]}]], "Input",
 CellChangeTimes->{{3.64008189301167*^9, 3.640081945343031*^9}, {
   3.640082188246151*^9, 3.640082192746481*^9}, {3.640082295640999*^9, 
   3.640082314936935*^9}, {3.640082425296077*^9, 3.640082426750515*^9}, {
   3.640083303350299*^9, 3.640083312107136*^9}, {3.6400835423798447`*^9, 
   3.640083552412322*^9}, 3.640084118148033*^9, {3.64033819334695*^9, 
   3.640338199320581*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"n", "=", "1"}], ",", 
      RowBox[{"n", "\[LessEqual]", "nvert"}], ",", " ", 
      RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ww", " ", "=", " ", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{"n", ",", "1"}], "]"}], "+", 
         RowBox[{
          RowBox[{"vv", "[", 
           RowBox[{"n", ",", "2"}], "]"}], "*", " ", "I"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vv3", "[", 
         RowBox[{"n", ",", "1"}], "]"}], "=", 
        RowBox[{"r", "*", 
         RowBox[{"Re", "[", 
          RowBox[{"I", "*", 
           RowBox[{"NIntegrate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"rr", "[", "z", "]"}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vv3", "[", 
         RowBox[{"n", ",", "2"}], "]"}], "=", 
        RowBox[{"r", "*", 
         RowBox[{"Re", "[", 
          RowBox[{"I", "*", 
           RowBox[{"NIntegrate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"rr", "[", "z", "]"}], "*", "I", "*", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"vv3", "[", 
         RowBox[{"n", ",", "3"}], "]"}], "=", 
        RowBox[{"r", "*", 
         RowBox[{"Re", "[", 
          RowBox[{"I", "*", 
           RowBox[{"NIntegrate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"rr", "[", "z", "]"}], "*", "2", "*", "z"}], ",", 
             RowBox[{"{", 
              RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}],
        ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.64008189301167*^9, 3.640081945343031*^9}, {
  3.640082188246151*^9, 3.640082192746481*^9}, {3.640082295640999*^9, 
  3.640082314936935*^9}, {3.640082425296077*^9, 3.640082426750515*^9}, {
  3.640083303350299*^9, 3.640083312107136*^9}, {3.6400835423798447`*^9, 
  3.640083552412322*^9}, {3.6400837319540443`*^9, 3.640083741686138*^9}, {
  3.6400838884071293`*^9, 3.6400838901545887`*^9}, {3.640084042421163*^9, 
  3.640084077532202*^9}, {3.640085135347542*^9, 3.640085140718326*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"datavert3a", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"vv3a", "[", 
      RowBox[{"n", ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "nvert"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"n", "=", "1"}], ",", 
     RowBox[{"n", "\[LessEqual]", "nvert"}], ",", " ", 
     RowBox[{"n", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"vv3a", "[", 
        RowBox[{"n", ",", "1"}], "]"}], "=", 
       RowBox[{
        RowBox[{"-", "xi"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"vv3", "[", 
           RowBox[{"n", ",", "1"}], "]"}], "+", 
          RowBox[{"vv3", "[", 
           RowBox[{"n", ",", "2"}], "]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vv3a", "[", 
        RowBox[{"n", ",", "2"}], "]"}], "=", 
       RowBox[{
        RowBox[{"vv3", "[", 
         RowBox[{"n", ",", "3"}], "]"}], "+", "eta"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"vv3a", "[", 
        RowBox[{"n", ",", "3"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "xi"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"vv3", "[", 
            RowBox[{"n", ",", "1"}], "]"}], "-", 
           RowBox[{"vv3", "[", 
            RowBox[{"n", ",", "2"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"2", "*", "eta"}]}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "READING", " ", "OFF", " ", "THE", " ", "NEIGHBOURS", " ", "FOR", " ", "A",
     " ", "SINGLE", " ", "PATCH"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NeighSet", " ", "=", " ", 
   RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Neigh", " ", "=", " ", 
      RowBox[{"List", "[", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "=", " ", 
         RowBox[{"3", "+", "k"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"q1", " ", "=", " ", 
         RowBox[{
          RowBox[{"vv3a", "[", 
           RowBox[{
            RowBox[{"ee", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               RowBox[{"n", ",", "j"}], "]"}], ",", "1"}], "]"}], ",", "1"}], 
           "]"}], "-", 
          RowBox[{"vv3a", "[", 
           RowBox[{
            RowBox[{"ee", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               RowBox[{"n", ",", "j"}], "]"}], ",", "2"}], "]"}], ",", "1"}], 
           "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"q2", " ", "=", " ", 
         RowBox[{
          RowBox[{"vv3a", "[", 
           RowBox[{
            RowBox[{"ee", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               RowBox[{"n", ",", "j"}], "]"}], ",", "1"}], "]"}], ",", "2"}], 
           "]"}], "-", 
          RowBox[{"vv3a", "[", 
           RowBox[{
            RowBox[{"ee", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               RowBox[{"n", ",", "j"}], "]"}], ",", "2"}], "]"}], ",", "2"}], 
           "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"q3", " ", "=", " ", 
         RowBox[{
          RowBox[{"vv3a", "[", 
           RowBox[{
            RowBox[{"ee", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               RowBox[{"n", ",", "j"}], "]"}], ",", "1"}], "]"}], ",", "3"}], 
           "]"}], "-", 
          RowBox[{"vv3a", "[", 
           RowBox[{
            RowBox[{"ee", "[", 
             RowBox[{
              RowBox[{"ff", "[", 
               RowBox[{"n", ",", "j"}], "]"}], ",", "2"}], "]"}], ",", "3"}], 
           "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"length", " ", "=", " ", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"q1", "*", "q1"}], "+", 
           RowBox[{"q2", "*", "q2"}], "+", 
           RowBox[{"q3", "*", "q3"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"l", " ", "=", " ", 
         RowBox[{"6", "+", "k"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Neigh", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Neigh", ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ff", "[", 
              RowBox[{"n", ",", "l"}], "]"}], ",", " ", "length"}], "}"}]}], 
          "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"NeighSet", " ", "=", " ", 
      RowBox[{"Append", "[", 
       RowBox[{"NeighSet", ",", " ", "Neigh"}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "nfacet", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"CURVATURE", " ", "AND", " ", "AREA", " ", "FIELDS"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TileAreas", " ", "=", " ", 
   RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"area", " ", "=", " ", 
      RowBox[{"Abs", "[", 
       RowBox[{"0.5", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"vv", "[", 
            RowBox[{
             RowBox[{"ff", "[", 
              RowBox[{"n", ",", "1"}], "]"}], ",", "1"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "2"}], "]"}], ",", "2"}], "]"}], "-", 
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "3"}], "]"}], ",", "2"}], "]"}]}], ")"}]}], 
          "+", 
          RowBox[{
           RowBox[{"vv", "[", 
            RowBox[{
             RowBox[{"ff", "[", 
              RowBox[{"n", ",", "2"}], "]"}], ",", "1"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "3"}], "]"}], ",", "2"}], "]"}], "-", 
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "1"}], "]"}], ",", "2"}], "]"}]}], ")"}]}], 
          "+", " ", 
          RowBox[{
           RowBox[{"vv", "[", 
            RowBox[{
             RowBox[{"ff", "[", 
              RowBox[{"n", ",", "3"}], "]"}], ",", "1"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "1"}], "]"}], ",", "2"}], "]"}], "-", 
             RowBox[{"vv", "[", 
              RowBox[{
               RowBox[{"ff", "[", 
                RowBox[{"n", ",", "2"}], "]"}], ",", "2"}], "]"}]}], 
            ")"}]}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TileAreas", " ", "=", " ", 
      RowBox[{"Append", "[", 
       RowBox[{"TileAreas", ",", " ", "area"}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "nfacet"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"List", "[", "]"}]}], " ", 
  RowBox[{"(*", 
   RowBox[{"Gaussian", " ", "curvature"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", " ", "=", " ", 
   RowBox[{"List", "[", "]"}]}], 
  RowBox[{"(*", 
   RowBox[{"surface", " ", "area"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], " ", ":=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"z", "^", "8"}], " ", "-", 
      RowBox[{"14", 
       RowBox[{"z", "^", "4"}]}], "+", "1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "z_", "]"}], " ", ":=", " ", "z"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"c", "[", "z_", "]"}], " ", ":=", " ", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"g", "'"}], "[", "z", "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"f", "[", "z", "]"}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"g", "[", "z", "]"}], "]"}], "^", "2"}]}], ")"}], "^", 
           "2"}]}], ")"}]}]}], ")"}], "^", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "[", "z_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.5", 
     RowBox[{"Abs", "[", 
      RowBox[{"f", "[", "z", "]"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"g", "[", "z", "]"}], "]"}], "^", "2"}]}], ")"}]}], ")"}], 
   "^", "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cm1", " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n", ",", "1"}], "]"}], ",", "1"}], "]"}], "+", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n", ",", "2"}], "]"}], ",", "1"}], "]"}], "+", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n", ",", "3"}], "]"}], ",", "1"}], "]"}]}], ")"}], "/", 
       "3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cm2", " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n", ",", "1"}], "]"}], ",", "2"}], "]"}], "+", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n", ",", "2"}], "]"}], ",", "2"}], "]"}], "+", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n", ",", "3"}], "]"}], ",", "2"}], "]"}]}], ")"}], "/", 
       "3"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"z", " ", "=", " ", 
      RowBox[{"cm1", " ", "+", " ", 
       RowBox[{"I", "*", "cm2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"G", " ", "=", " ", 
      RowBox[{"Append", "[", 
       RowBox[{"G", ",", " ", 
        RowBox[{"N", "[", 
         RowBox[{"c", "[", "z", "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"A", " ", "=", " ", 
      RowBox[{"Append", "[", 
       RowBox[{"A", ",", " ", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"b", "[", "z", "]"}], "]"}], "*", 
         RowBox[{"TileAreas", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "nfacet"}], "}"}]}], "]"}], "\n"}], "\n", 
 RowBox[{"G", ";"}], "\n", 
 RowBox[{
  RowBox[{"A", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "POLYSET", " ", "WITH", " ", "ALL", " ", "THE", " ", "PLOTING", " ", 
    "INFORMATION"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet", " ", "=", " ", 
   RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"G", "[", 
           RowBox[{"[", "n", "]"}], "]"}], "]"}], " ", "<=", " ", 
         RowBox[{"-", "2"}]}], ",", " ", 
        RowBox[{"FieldPoly", " ", "=", " ", "Green"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"G", "[", 
           RowBox[{"[", "n", "]"}], "]"}], "]"}], " ", ">", " ", "2"}], ",", 
        " ", 
        RowBox[{"FieldPoly", " ", "=", " ", "Pink"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"FieldPoly", " ", "=", " ", 
       RowBox[{"Hue", "[", 
        RowBox[{
         RowBox[{"G", "[", 
          RowBox[{"[", "n", "]"}], "]"}], "/", 
         RowBox[{"Min", "[", "G", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2", ",", "1"}], "]"}], "]"}], "==", " ", 
           RowBox[{"-", "2"}]}], ",", " ", 
          RowBox[{"FieldPoly", " ", "=", " ", "Blue"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2", ",", "1"}], "]"}], "]"}], "==", " ", 
           RowBox[{"-", "1"}]}], ",", " ", 
          RowBox[{"FieldPoly", " ", "=", " ", "Purple"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2", ",", "1"}], "]"}], "]"}], "==", " ", 
           RowBox[{"-", "3"}]}], ",", " ", 
          RowBox[{"FieldPoly", " ", "=", " ", "Red"}]}], "]"}], ";"}], "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{"PolySet", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"PolySet", ",", " ", 
         RowBox[{"{", " ", 
          RowBox[{"FieldPoly", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "1"}], "]"}], ",", "1"}], "]"}], ",", 
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "1"}], "]"}], ",", "2"}], "]"}], ",", 
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "1"}], "]"}], ",", "3"}], "]"}]}], "}"}], 
             " ", "\[IndentingNewLine]", " ", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "2"}], "]"}], ",", "1"}], "]"}], ",", 
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "2"}], "]"}], ",", "2"}], "]"}], ",", 
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "2"}], "]"}], ",", "3"}], "]"}]}], "}"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "3"}], "]"}], ",", "1"}], "]"}], ",", 
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "3"}], "]"}], ",", "2"}], "]"}], ",", 
               RowBox[{"vv3a", "[", 
                RowBox[{
                 RowBox[{"ff", "[", 
                  RowBox[{"n", ",", "3"}], "]"}], ",", "3"}], "]"}]}], 
              "}"}]}], "}"}]}], " ", "}"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "nfacet", ",", "1"}], "}"}]}], "]"}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet2", " ", "=", " ", "PolySet"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}], " ", "=", 
   " ", 
   RowBox[{"PolySet", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}], " ", "=", 
   " ", 
   RowBox[{"PolySet", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet2", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"PolySet", ",", " ", "PolySet2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G", ",", "G"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"A", ",", "A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet3", " ", "=", " ", "PolySet2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet3", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}], " ", "=", 
   " ", 
   RowBox[{"PolySet2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet3", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}], " ", "=", 
   " ", 
   RowBox[{"PolySet2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet3", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"PolySet2", ",", " ", "PolySet3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G2", ",", "G2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"A2", ",", "A2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet4", " ", "=", " ", "PolySet2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet4", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}], " ", "=", 
   " ", 
   RowBox[{"PolySet2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet4", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}], " ", "=", 
   " ", 
   RowBox[{"PolySet2", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet4", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"PolySet3", ",", " ", "PolySet4"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G", ",", "G2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"A", ",", "A2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet5", " ", "=", " ", "PolySet4"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet5", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"PolySet4", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], "-", 
    RowBox[{"a", "/", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySet5", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"PolySet5", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}]}], "+", 
    RowBox[{"a", "/", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PolySet5", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"PolySet4", ",", " ", "PolySet5"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G", ",", "G"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"A", ",", "A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"PolySet6", " ", "=", " ", "PolySet5"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PolySet6", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}], " ", 
     "=", " ", 
     RowBox[{"-", 
      RowBox[{"PolySet5", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"PolySet6", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"PolySet5", ",", "PolySet6"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"G", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"G", ",", "G"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"A", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"A", ",", "A"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"PolySet7", " ", "=", " ", "PolySet6"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PolySet7", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}], " ", 
     "=", " ", 
     RowBox[{"-", 
      RowBox[{"PolySet6", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"PolySet7", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"PolySet6", ",", " ", "PolySet7"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"G", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"G", ",", "G"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"A", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"A", ",", "A"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"PolySet8", " ", "=", " ", "PolySet7"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PolySet8", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}], " ", 
     "=", " ", 
     RowBox[{"-", 
      RowBox[{"PolySet7", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"PolySet8", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"PolySet7", ",", "PolySet8"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"G", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"G", ",", "G"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"A", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"A", ",", "A"}], "]"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolySetComplete", " ", "=", " ", "PolySet5"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"PolySetComplete", " ", "=", " ", "PolySet5"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "PolySetComplete", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "G", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "A", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.64008189301167*^9, 3.640081945343031*^9}, {
   3.640082188246151*^9, 3.640082198096136*^9}, {3.6400836994189177`*^9, 
   3.640083702496554*^9}, {3.640160686189563*^9, 3.640160720432047*^9}, {
   3.640171432642161*^9, 3.640171479072459*^9}, {3.640171509421653*^9, 
   3.640171559634334*^9}, {3.640171915668717*^9, 3.640171928825082*^9}, {
   3.640171988667498*^9, 3.64017204066578*^9}, 3.6403271164941*^9, {
   3.640327593962962*^9, 3.640327594288794*^9}, {3.640327895267617*^9, 
   3.640327970499614*^9}, {3.64032804639719*^9, 3.640328077509972*^9}, {
   3.6403281168999863`*^9, 3.6403281616480503`*^9}, {3.64032842290585*^9, 
   3.640328426021278*^9}, {3.640328462584132*^9, 3.640328521556531*^9}, {
   3.640328599723157*^9, 3.640328599885933*^9}, {3.6403286405662413`*^9, 
   3.640328643507515*^9}, {3.640329105525152*^9, 3.640329123980027*^9}, {
   3.640329159187109*^9, 3.6403291617056303`*^9}, {3.6403293881654463`*^9, 
   3.640329700535366*^9}, {3.6403299169991426`*^9, 3.6403299193403387`*^9}, {
   3.640329995341056*^9, 3.6403300557590017`*^9}, {3.640330171852685*^9, 
   3.6403301720583773`*^9}, {3.6403302329823017`*^9, 
   3.6403302851133327`*^9}, {3.640330347233839*^9, 3.640330351675418*^9}, {
   3.6403304051098948`*^9, 3.640330539052376*^9}, {3.640330676877674*^9, 
   3.640330806314831*^9}, {3.640330839515415*^9, 3.6403308772026367`*^9}, {
   3.6403309088464727`*^9, 3.640330944947649*^9}, {3.640330982253137*^9, 
   3.640331002965879*^9}, {3.640331235522747*^9, 3.6403313429268703`*^9}, {
   3.640331375755619*^9, 3.640331543754575*^9}, {3.640331624997266*^9, 
   3.640331643290797*^9}, {3.640331710421294*^9, 3.6403318468613873`*^9}, {
   3.6403319217829657`*^9, 3.640331984100555*^9}, {3.64033209408574*^9, 
   3.640332095342506*^9}, {3.640332135015616*^9, 3.640332154508122*^9}, {
   3.64033219892999*^9, 3.640332201088306*^9}, {3.6403325665840187`*^9, 
   3.640332568760642*^9}, {3.640334632234096*^9, 3.6403346494564133`*^9}, {
   3.640335327719907*^9, 3.640335331262422*^9}, {3.6403353769493856`*^9, 
   3.6403354290520973`*^9}, {3.640335465167259*^9, 3.6403354733401546`*^9}, {
   3.640335523292674*^9, 3.640335527935814*^9}, {3.64033561579062*^9, 
   3.6403356336298943`*^9}, {3.640335709411974*^9, 3.640335817021278*^9}, {
   3.640336020749633*^9, 3.640336021856451*^9}, {3.64033610643039*^9, 
   3.64033610862267*^9}, {3.6403362033408737`*^9, 3.6403362187452393`*^9}, {
   3.6403364210394697`*^9, 3.640336439056773*^9}, {3.640336616089488*^9, 
   3.640336616730085*^9}, {3.640336908453722*^9, 3.640336943231682*^9}, 
   3.640337257190814*^9, {3.640337450216381*^9, 3.640337463215802*^9}, {
   3.6403375604086103`*^9, 3.640337571142334*^9}, {3.64033764502008*^9, 
   3.6403377299586897`*^9}, 3.6403377667608023`*^9, {3.640338209905892*^9, 
   3.640338263133081*^9}, {3.6403384877788057`*^9, 3.640338495241682*^9}, {
   3.640339163269104*^9, 3.64033923536455*^9}, {3.640339461319077*^9, 
   3.6403395798440313`*^9}, {3.640339969421351*^9, 3.640340074590467*^9}, {
   3.640340402391251*^9, 3.640340471504364*^9}, {3.640340937064575*^9, 
   3.640340942792444*^9}, {3.640341000255905*^9, 3.6403410244923153`*^9}, {
   3.640341070548237*^9, 3.640341098896462*^9}, {3.6403412514366417`*^9, 
   3.6403412667509117`*^9}, {3.640341505981687*^9, 3.64034154722462*^9}, {
   3.640341919612866*^9, 3.640341922059842*^9}, {3.640342676789209*^9, 
   3.640342679954462*^9}, {3.640342725406843*^9, 3.640342728173617*^9}, {
   3.6403428405393753`*^9, 3.640342852724922*^9}, {3.640415578533313*^9, 
   3.64041572054468*^9}, {3.640416304869495*^9, 3.640416307944232*^9}, {
   3.64041717045513*^9, 3.6404171796532583`*^9}, {3.64041721683785*^9, 
   3.640417246124641*^9}, {3.6404173316288567`*^9, 3.640417331955385*^9}, {
   3.6404174744035997`*^9, 3.640417479189086*^9}, {3.6404175186335983`*^9, 
   3.6404175437986107`*^9}, {3.640417618729685*^9, 3.640417654482532*^9}, {
   3.6404234553535*^9, 3.640423459571059*^9}, {3.6404238584824266`*^9, 
   3.64042385942768*^9}, {3.6404239059982843`*^9, 3.640423937278399*^9}, {
   3.640428359179101*^9, 3.64042842923735*^9}, {3.640589354405253*^9, 
   3.640589420435288*^9}, {3.640595501022053*^9, 3.640595562311428*^9}, 
   3.640607688573691*^9, {3.6409290149548903`*^9, 3.640929028375359*^9}, {
   3.640929583863142*^9, 3.640929622476663*^9}, {3.640929784356884*^9, 
   3.640929791427676*^9}, {3.640929874458706*^9, 3.640929988629573*^9}, {
   3.64110320730544*^9, 3.641103275666293*^9}, {3.641309576700437*^9, 
   3.641309585835531*^9}, {3.641539301761142*^9, 3.6415393051140747`*^9}, {
   3.64155879168769*^9, 3.641558794931201*^9}, {3.642140203769682*^9, 
   3.642140232815361*^9}, {3.642160491442059*^9, 3.6421605529492188`*^9}, {
   3.6421613192180033`*^9, 3.6421613282266197`*^9}, {3.642163018416521*^9, 
   3.6421630334315968`*^9}, {3.6428734093523197`*^9, 3.642873417862762*^9}, {
   3.643623590145043*^9, 3.643623604264185*^9}, {3.643623644324562*^9, 
   3.643623645302096*^9}, {3.6436248283228493`*^9, 3.643624828413787*^9}, {
   3.644216282140295*^9, 3.6442163027330427`*^9}, {3.646644805367676*^9, 
   3.646644822656118*^9}, {3.6466513968905783`*^9, 3.6466513974362307`*^9}, {
   3.6466514482999487`*^9, 3.646651463174515*^9}, {3.647064973963171*^9, 
   3.6470649819012823`*^9}, {3.647077411168172*^9, 3.647077419543124*^9}, {
   3.647079030895866*^9, 3.647079031899907*^9}, {3.647681052729951*^9, 
   3.647681084742756*^9}, {3.6476811198930607`*^9, 3.647681142785796*^9}, {
   3.647682284514346*^9, 3.6476823141232224`*^9}, {3.647682356359741*^9, 
   3.647682366281949*^9}, {3.6476829887496443`*^9, 3.647683000660327*^9}, {
   3.647683072703865*^9, 3.647683084371664*^9}, {3.647769869839897*^9, 
   3.647769884308564*^9}, {3.647769921844715*^9, 3.647769931676478*^9}, {
   3.64784888773929*^9, 3.647848887799554*^9}, {3.672758575875328*^9, 
   3.6727586127177267`*^9}, 3.67275865637996*^9, {3.672758839159769*^9, 
   3.67275884046439*^9}, {3.672758908998373*^9, 3.672758912229019*^9}, {
   3.67275899952459*^9, 3.672759096755361*^9}, {3.672760969371215*^9, 
   3.67276097354666*^9}, {3.6727612208389463`*^9, 3.672761222141213*^9}, {
   3.672761549577908*^9, 3.672761553772149*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyGraphics", " ", "=", " ", 
    RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.64008189301167*^9, 3.640081945343031*^9}, {
   3.640082188246151*^9, 3.640082198096136*^9}, {3.6400836994189177`*^9, 
   3.640083702496554*^9}, {3.640160686189563*^9, 3.640160720432047*^9}, {
   3.640171432642161*^9, 3.640171479072459*^9}, {3.640171509421653*^9, 
   3.640171559634334*^9}, {3.640171915668717*^9, 3.640171928825082*^9}, {
   3.640171988667498*^9, 3.64017204066578*^9}, 3.6403271164941*^9, {
   3.640327593962962*^9, 3.640327594288794*^9}, {3.640327895267617*^9, 
   3.640327970499614*^9}, {3.64032804639719*^9, 3.640328077509972*^9}, {
   3.6403281168999863`*^9, 3.6403281616480503`*^9}, {3.64032842290585*^9, 
   3.640328426021278*^9}, {3.640328462584132*^9, 3.640328521556531*^9}, {
   3.640328599723157*^9, 3.640328599885933*^9}, {3.6403286405662413`*^9, 
   3.640328643507515*^9}, {3.640329105525152*^9, 3.640329123980027*^9}, {
   3.640329159187109*^9, 3.6403291617056303`*^9}, {3.6403293881654463`*^9, 
   3.640329700535366*^9}, {3.6403299169991426`*^9, 3.6403299193403387`*^9}, {
   3.640329995341056*^9, 3.6403300557590017`*^9}, {3.640330171852685*^9, 
   3.6403301720583773`*^9}, {3.6403302329823017`*^9, 
   3.6403302851133327`*^9}, {3.640330347233839*^9, 3.640330351675418*^9}, {
   3.6403304051098948`*^9, 3.640330539052376*^9}, {3.640330676877674*^9, 
   3.640330806314831*^9}, {3.640330839515415*^9, 3.6403308772026367`*^9}, {
   3.6403309088464727`*^9, 3.640330944947649*^9}, {3.640330982253137*^9, 
   3.640331002965879*^9}, {3.640331235522747*^9, 3.6403313429268703`*^9}, {
   3.640331375755619*^9, 3.640331543754575*^9}, {3.640331624997266*^9, 
   3.640331643290797*^9}, {3.640331710421294*^9, 3.6403318468613873`*^9}, {
   3.6403319217829657`*^9, 3.640331984100555*^9}, {3.64033209408574*^9, 
   3.640332095342506*^9}, {3.640332135015616*^9, 3.640332154508122*^9}, {
   3.64033219892999*^9, 3.640332201088306*^9}, {3.6403325665840187`*^9, 
   3.640332568760642*^9}, {3.640334632234096*^9, 3.6403346494564133`*^9}, {
   3.640335327719907*^9, 3.640335331262422*^9}, {3.6403353769493856`*^9, 
   3.6403354290520973`*^9}, {3.640335465167259*^9, 3.6403354733401546`*^9}, {
   3.640335523292674*^9, 3.640335527935814*^9}, {3.64033561579062*^9, 
   3.6403356336298943`*^9}, {3.640335709411974*^9, 3.640335817021278*^9}, {
   3.640336020749633*^9, 3.640336021856451*^9}, {3.64033610643039*^9, 
   3.64033610862267*^9}, {3.6403362033408737`*^9, 3.6403362187452393`*^9}, {
   3.6403364210394697`*^9, 3.640336439056773*^9}, {3.640336616089488*^9, 
   3.640336616730085*^9}, {3.640336908453722*^9, 3.640336943231682*^9}, 
   3.640337257190814*^9, {3.640337450216381*^9, 3.640337463215802*^9}, {
   3.6403375604086103`*^9, 3.640337571142334*^9}, {3.64033764502008*^9, 
   3.6403377299586897`*^9}, 3.6403377667608023`*^9, {3.640338209905892*^9, 
   3.640338263133081*^9}, {3.6403384877788057`*^9, 3.640338495241682*^9}, {
   3.640339163269104*^9, 3.64033923536455*^9}, {3.640339461319077*^9, 
   3.6403395798440313`*^9}, {3.640339969421351*^9, 3.640340074590467*^9}, {
   3.640340402391251*^9, 3.640340471504364*^9}, {3.640340937064575*^9, 
   3.640340942792444*^9}, {3.640341000255905*^9, 3.6403410244923153`*^9}, {
   3.640341070548237*^9, 3.640341098896462*^9}, {3.6403412514366417`*^9, 
   3.6403412667509117`*^9}, {3.640341505981687*^9, 3.64034154722462*^9}, {
   3.640341919612866*^9, 3.640341922059842*^9}, {3.640342676789209*^9, 
   3.640342679954462*^9}, {3.640342725406843*^9, 3.640342728173617*^9}, {
   3.6403428405393753`*^9, 3.640342852724922*^9}, {3.640415578533313*^9, 
   3.64041572054468*^9}, {3.640416304869495*^9, 3.640416307944232*^9}, {
   3.64041717045513*^9, 3.6404171796532583`*^9}, {3.64041721683785*^9, 
   3.640417246124641*^9}, {3.6404173316288567`*^9, 3.640417331955385*^9}, {
   3.6404174744035997`*^9, 3.640417479189086*^9}, {3.6404175186335983`*^9, 
   3.6404175437986107`*^9}, {3.640417618729685*^9, 3.640417654482532*^9}, {
   3.6404234553535*^9, 3.640423459571059*^9}, {3.6404238584824266`*^9, 
   3.64042385942768*^9}, {3.6404239059982843`*^9, 3.640423937278399*^9}, {
   3.640428359179101*^9, 3.64042842923735*^9}, {3.640589354405253*^9, 
   3.640589420435288*^9}, {3.640595501022053*^9, 3.640595562311428*^9}, {
   3.640607688573691*^9, 3.640607695378786*^9}, {3.640607737890378*^9, 
   3.640607740377945*^9}, {3.640608006208631*^9, 3.6406080119798594`*^9}, 
   3.640608050138302*^9, 3.6406120193205023`*^9, {3.640612107734849*^9, 
   3.640612109421142*^9}, {3.640623524978076*^9, 3.640623531867955*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "1"}], ",", " ", 
        RowBox[{
         RowBox[{"PolySetComplete", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "=", " ", "Green"}]}], 
       "]"}], ";", 
      RowBox[{"(*", 
       RowBox[{
       "comment", " ", "these", " ", "two", " ", "lines", " ", "if", " ", 
        "the", " ", "simulation", " ", "is", " ", "done", " ", "only", " ", 
        "on", " ", "the", " ", "fundamental", " ", "patch"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "0"}], ",", " ", 
        RowBox[{
         RowBox[{"PolySetComplete", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", " ", "Pink"}]}], "]"}],
       ";"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PolyGraphics", " ", "=", " ", 
      RowBox[{"Append", "[", 
       RowBox[{"PolyGraphics", ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"EdgeForm", "[", 
           RowBox[{"(*", 
            RowBox[{"{", 
             RowBox[{"Thin", ",", "Black"}], "}"}], "*)"}], " ", "]"}], ",", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", " ", 
          RowBox[{"Polygon", "[", 
           RowBox[{"PolySetComplete", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}],
      ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", " ", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "//", "AbsoluteTiming"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{" "}]}], "Input",
 CellChangeTimes->{{3.64008189301167*^9, 3.640081945343031*^9}, {
   3.640082188246151*^9, 3.640082198096136*^9}, {3.6400836994189177`*^9, 
   3.640083702496554*^9}, {3.640160686189563*^9, 3.640160720432047*^9}, {
   3.640171432642161*^9, 3.640171479072459*^9}, {3.640171509421653*^9, 
   3.640171559634334*^9}, {3.640171915668717*^9, 3.640171928825082*^9}, {
   3.640171988667498*^9, 3.64017204066578*^9}, 3.6403271164941*^9, {
   3.640327593962962*^9, 3.640327594288794*^9}, {3.640327895267617*^9, 
   3.640327970499614*^9}, {3.64032804639719*^9, 3.640328077509972*^9}, {
   3.6403281168999863`*^9, 3.6403281616480503`*^9}, {3.64032842290585*^9, 
   3.640328426021278*^9}, {3.640328462584132*^9, 3.640328521556531*^9}, {
   3.640328599723157*^9, 3.640328599885933*^9}, {3.6403286405662413`*^9, 
   3.640328643507515*^9}, {3.640329105525152*^9, 3.640329123980027*^9}, {
   3.640329159187109*^9, 3.6403291617056303`*^9}, {3.6403293881654463`*^9, 
   3.640329700535366*^9}, {3.6403299169991426`*^9, 3.6403299193403387`*^9}, {
   3.640329995341056*^9, 3.6403300557590017`*^9}, {3.640330171852685*^9, 
   3.6403301720583773`*^9}, {3.6403302329823017`*^9, 
   3.6403302851133327`*^9}, {3.640330347233839*^9, 3.640330351675418*^9}, {
   3.6403304051098948`*^9, 3.640330539052376*^9}, {3.640330676877674*^9, 
   3.640330806314831*^9}, {3.640330839515415*^9, 3.6403308772026367`*^9}, {
   3.6403309088464727`*^9, 3.640330944947649*^9}, {3.640330982253137*^9, 
   3.640331002965879*^9}, {3.640331235522747*^9, 3.6403313429268703`*^9}, {
   3.640331375755619*^9, 3.640331543754575*^9}, {3.640331624997266*^9, 
   3.640331643290797*^9}, {3.640331710421294*^9, 3.6403318468613873`*^9}, {
   3.6403319217829657`*^9, 3.640331984100555*^9}, {3.64033209408574*^9, 
   3.640332095342506*^9}, {3.640332135015616*^9, 3.640332154508122*^9}, {
   3.64033219892999*^9, 3.640332201088306*^9}, {3.6403325665840187`*^9, 
   3.640332568760642*^9}, {3.640334632234096*^9, 3.6403346494564133`*^9}, {
   3.640335327719907*^9, 3.640335331262422*^9}, {3.6403353769493856`*^9, 
   3.6403354290520973`*^9}, {3.640335465167259*^9, 3.6403354733401546`*^9}, {
   3.640335523292674*^9, 3.640335527935814*^9}, {3.64033561579062*^9, 
   3.6403356336298943`*^9}, {3.640335709411974*^9, 3.640335817021278*^9}, {
   3.640336020749633*^9, 3.640336021856451*^9}, {3.64033610643039*^9, 
   3.64033610862267*^9}, {3.6403362033408737`*^9, 3.6403362187452393`*^9}, {
   3.6403364210394697`*^9, 3.640336439056773*^9}, {3.640336616089488*^9, 
   3.640336616730085*^9}, {3.640336908453722*^9, 3.640336943231682*^9}, 
   3.640337257190814*^9, {3.640337450216381*^9, 3.640337463215802*^9}, {
   3.6403375604086103`*^9, 3.640337571142334*^9}, {3.64033764502008*^9, 
   3.6403377299586897`*^9}, 3.6403377667608023`*^9, {3.640338209905892*^9, 
   3.640338263133081*^9}, {3.6403384877788057`*^9, 3.640338495241682*^9}, {
   3.640339163269104*^9, 3.64033923536455*^9}, {3.640339461319077*^9, 
   3.6403395798440313`*^9}, {3.640339969421351*^9, 3.640340074590467*^9}, {
   3.640340402391251*^9, 3.640340471504364*^9}, {3.640340937064575*^9, 
   3.640340942792444*^9}, {3.640341000255905*^9, 3.6403410244923153`*^9}, {
   3.640341070548237*^9, 3.640341098896462*^9}, {3.6403412514366417`*^9, 
   3.6403412667509117`*^9}, {3.640341505981687*^9, 3.64034154722462*^9}, {
   3.640341919612866*^9, 3.640341922059842*^9}, {3.640342676789209*^9, 
   3.640342679954462*^9}, {3.640342725406843*^9, 3.640342728173617*^9}, {
   3.6403428405393753`*^9, 3.640342852724922*^9}, {3.640415578533313*^9, 
   3.64041572054468*^9}, {3.640416304869495*^9, 3.640416307944232*^9}, {
   3.64041717045513*^9, 3.6404171796532583`*^9}, {3.64041721683785*^9, 
   3.640417246124641*^9}, {3.6404173316288567`*^9, 3.640417331955385*^9}, {
   3.6404174744035997`*^9, 3.640417479189086*^9}, {3.6404175186335983`*^9, 
   3.6404175437986107`*^9}, {3.640417618729685*^9, 3.640417654482532*^9}, {
   3.6404234553535*^9, 3.640423459571059*^9}, {3.6404238584824266`*^9, 
   3.64042385942768*^9}, {3.6404239059982843`*^9, 3.640423937278399*^9}, {
   3.640428359179101*^9, 3.64042842923735*^9}, {3.640589354405253*^9, 
   3.640589420435288*^9}, {3.640595501022053*^9, 3.640595562311428*^9}, {
   3.640607688573691*^9, 3.640607695378786*^9}, {3.640607737890378*^9, 
   3.640607740377945*^9}, {3.640608006208631*^9, 3.6406080119798594`*^9}, 
   3.640608050138302*^9, 3.6406120193205023`*^9, {3.640612107734849*^9, 
   3.640612109421142*^9}, {3.640623524978076*^9, 3.640623568685964*^9}, {
   3.6406679056517973`*^9, 3.640667918354615*^9}, {3.6406683720084343`*^9, 
   3.6406683768041773`*^9}, {3.640668490385933*^9, 3.6406685018323517`*^9}, {
   3.640684219844387*^9, 3.640684220623746*^9}, {3.6413096368740683`*^9, 
   3.641309640127997*^9}, {3.641503785703059*^9, 3.6415037899135723`*^9}, {
   3.642140249061789*^9, 3.642140253405946*^9}, {3.642160564618875*^9, 
   3.6421605694998083`*^9}, {3.6476809583208303`*^9, 3.647680961629273*^9}, {
   3.6727606913412933`*^9, 3.6727606961902037`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Graphics3D", "[", 
   RowBox[{"PolyGraphics", ",", " ", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"BoxRatios", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}]}], ","}], "*)"}], 
    " ", 
    RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
    RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"FontSize", "\[Rule]", "17"}], "}"}]}]}], "]"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"BarLegend", "[", 
  RowBox[{"{", 
   RowBox[{"Hue", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Min", "[", "G", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Max", "[", "G", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.64008189301167*^9, 3.640081945343031*^9}, {
   3.640082188246151*^9, 3.640082198096136*^9}, {3.6400836994189177`*^9, 
   3.640083702496554*^9}, {3.640160686189563*^9, 3.640160720432047*^9}, {
   3.640171432642161*^9, 3.640171479072459*^9}, {3.640171509421653*^9, 
   3.640171559634334*^9}, {3.640171915668717*^9, 3.640171928825082*^9}, {
   3.640171988667498*^9, 3.64017204066578*^9}, 3.6403271164941*^9, {
   3.640327593962962*^9, 3.640327594288794*^9}, {3.640327895267617*^9, 
   3.640327970499614*^9}, {3.64032804639719*^9, 3.640328077509972*^9}, {
   3.6403281168999863`*^9, 3.6403281616480503`*^9}, {3.64032842290585*^9, 
   3.640328426021278*^9}, {3.640328462584132*^9, 3.640328521556531*^9}, {
   3.640328599723157*^9, 3.640328599885933*^9}, {3.6403286405662413`*^9, 
   3.640328643507515*^9}, {3.640329105525152*^9, 3.640329123980027*^9}, {
   3.640329159187109*^9, 3.6403291617056303`*^9}, {3.6403293881654463`*^9, 
   3.640329700535366*^9}, {3.6403299169991426`*^9, 3.6403299193403387`*^9}, {
   3.640329995341056*^9, 3.6403300557590017`*^9}, {3.640330171852685*^9, 
   3.6403301720583773`*^9}, {3.6403302329823017`*^9, 
   3.6403302851133327`*^9}, {3.640330347233839*^9, 3.640330351675418*^9}, {
   3.6403304051098948`*^9, 3.640330539052376*^9}, {3.640330676877674*^9, 
   3.640330806314831*^9}, {3.640330839515415*^9, 3.6403308772026367`*^9}, {
   3.6403309088464727`*^9, 3.640330944947649*^9}, {3.640330982253137*^9, 
   3.640331002965879*^9}, {3.640331235522747*^9, 3.6403313429268703`*^9}, {
   3.640331375755619*^9, 3.640331543754575*^9}, {3.640331624997266*^9, 
   3.640331643290797*^9}, {3.640331710421294*^9, 3.6403318468613873`*^9}, {
   3.6403319217829657`*^9, 3.640331984100555*^9}, {3.64033209408574*^9, 
   3.640332095342506*^9}, {3.640332135015616*^9, 3.640332154508122*^9}, {
   3.64033219892999*^9, 3.640332201088306*^9}, {3.6403325665840187`*^9, 
   3.640332568760642*^9}, {3.640334632234096*^9, 3.6403346494564133`*^9}, {
   3.640335327719907*^9, 3.640335331262422*^9}, {3.6403353769493856`*^9, 
   3.6403354290520973`*^9}, {3.640335465167259*^9, 3.6403354733401546`*^9}, {
   3.640335523292674*^9, 3.640335527935814*^9}, {3.64033561579062*^9, 
   3.6403356336298943`*^9}, {3.640335709411974*^9, 3.640335817021278*^9}, {
   3.640336020749633*^9, 3.640336021856451*^9}, {3.64033610643039*^9, 
   3.64033610862267*^9}, {3.6403362033408737`*^9, 3.6403362187452393`*^9}, {
   3.6403364210394697`*^9, 3.640336439056773*^9}, {3.640336616089488*^9, 
   3.640336616730085*^9}, {3.640336908453722*^9, 3.640336943231682*^9}, 
   3.640337257190814*^9, {3.640337450216381*^9, 3.640337463215802*^9}, {
   3.6403375604086103`*^9, 3.640337571142334*^9}, {3.64033764502008*^9, 
   3.6403377299586897`*^9}, 3.6403377667608023`*^9, {3.640338209905892*^9, 
   3.640338263133081*^9}, {3.6403384877788057`*^9, 3.640338495241682*^9}, {
   3.640339163269104*^9, 3.64033923536455*^9}, {3.640339461319077*^9, 
   3.6403395798440313`*^9}, {3.640339969421351*^9, 3.640340074590467*^9}, {
   3.640340402391251*^9, 3.640340471504364*^9}, {3.640340937064575*^9, 
   3.640340942792444*^9}, {3.640341000255905*^9, 3.6403410244923153`*^9}, {
   3.640341070548237*^9, 3.640341098896462*^9}, {3.6403412514366417`*^9, 
   3.6403412667509117`*^9}, {3.640341505981687*^9, 3.64034154722462*^9}, {
   3.640341919612866*^9, 3.640341922059842*^9}, {3.640342676789209*^9, 
   3.640342679954462*^9}, {3.640342725406843*^9, 3.640342728173617*^9}, {
   3.6403428405393753`*^9, 3.640342852724922*^9}, {3.640415578533313*^9, 
   3.64041572054468*^9}, {3.640416304869495*^9, 3.640416307944232*^9}, {
   3.64041717045513*^9, 3.6404171796532583`*^9}, {3.64041721683785*^9, 
   3.640417246124641*^9}, {3.6404173316288567`*^9, 3.640417331955385*^9}, {
   3.6404174744035997`*^9, 3.640417479189086*^9}, {3.6404175186335983`*^9, 
   3.6404175437986107`*^9}, {3.640417618729685*^9, 3.640417654482532*^9}, {
   3.6404234553535*^9, 3.640423459571059*^9}, {3.6404238584824266`*^9, 
   3.64042385942768*^9}, {3.6404239059982843`*^9, 3.640423937278399*^9}, {
   3.640428359179101*^9, 3.64042842923735*^9}, {3.640589354405253*^9, 
   3.640589420435288*^9}, {3.640595501022053*^9, 3.640595562311428*^9}, {
   3.640607688573691*^9, 3.640607695378786*^9}, {3.642141284649291*^9, 
   3.642141305412209*^9}, {3.642160629985407*^9, 3.642160632329528*^9}, {
   3.647681213914287*^9, 3.647681234704205*^9}, {3.647681269275284*^9, 
   3.647681297229212*^9}, {3.6476814734636106`*^9, 3.647681496958578*^9}, {
   3.6476821968990726`*^9, 3.6476822302606773`*^9}, {3.647769730478208*^9, 
   3.64776974698342*^9}, {3.672759128292739*^9, 3.6727591437173986`*^9}, {
   3.672759795294785*^9, 3.6727598194069443`*^9}, {3.672760244550992*^9, 
   3.672760245642144*^9}, {3.672760279245841*^9, 3.672760281609846*^9}, {
   3.672760400783101*^9, 3.672760437633408*^9}, {3.6727605788442087`*^9, 
   3.672760587273712*^9}, {3.672760928722672*^9, 3.6727609301173477`*^9}, {
   3.672760998643729*^9, 3.672761005886175*^9}, {3.672761341340474*^9, 
   3.672761392481998*^9}, {3.6727614402898617`*^9, 3.672761444078017*^9}, {
   3.672761648246708*^9, 3.672761653358769*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.640668480484963*^9, 3.64066848240733*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Fast", " ", "visualisations", " ", "once", " ", "PolyGraphics", " ", 
    "has", " ", "been", " ", "calculated", " ", "once"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Here", " ", "visualisation", " ", "of", " ", "a", " ", "domain", " ", 
    "with", " ", "its", " ", "interface"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "imported", " ", "files", " ", "below", " ", "only", " ", 
    "work", " ", "properly", " ", "with", " ", 
    "\"\<triang_lmax0.01.dat\>\""}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\<S_Field_line_tensionbis.txt\>\"", ",", " ", "\"\<List\>\""}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\<Best_S_Field_line_tension.txt\>\"", ",", " ", "\"\<List\>\""}], 
      "]"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "Domain", " ", "shape", " ", "with", " ", "high", " ", "line", " ", 
     "tension"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\<S_Field_line_tensionCurv.txt\>\"", ",", " ", "\"\<List\>\""}], 
      "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "Domain", " ", "shape", " ", "with", " ", "zero", " ", "line", " ", 
     "tension"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Int", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Int", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<InterfaceCurv.txt\>\"", ",", " ", "\"\<List\>\""}], 
      "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "Domain", " ", "interface", " ", "with", " ", "zero", " ", "line", " ", 
     "tension"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"[", 
       RowBox[{"Int", "[", 
        RowBox[{"[", "All", "]"}], "]"}], "]"}], "]"}], " ", "=", " ", "2"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S2", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"S", ",", "S"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "if", " ", "the", " ", "simulation", " ", "is", " ", "done", " ", "on", 
     " ", "one", " ", "half", " ", "of", " ", "the", " ", "patch"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"S2", ",", "S2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"S", ",", "S2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"S", ",", "S"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "1"}], ",", " ", 
         RowBox[{
          RowBox[{"PolyGraphics", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "=", " ", "Green"}]}],
         "]"}], ";", 
       RowBox[{"(*", 
        RowBox[{
        "comment", " ", "these", " ", "two", " ", "lines", " ", "if", " ", 
         "the", " ", "simulation", " ", "is", " ", "done", " ", "only", " ", 
         "on", " ", "the", " ", "fundamental", " ", "patch"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "0"}], ",", " ", 
         RowBox[{
          RowBox[{"PolyGraphics", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", " ", "Pink"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "2"}], ",", " ", 
         RowBox[{
          RowBox[{"PolyGraphics", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", " ", "Blue"}]}], 
        "]"}], ";"}], "\[IndentingNewLine]", ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"gr", " ", "=", " ", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"PolyGraphics", ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}]}], ","}], "*)"}],
       " ", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}]}], "]"}]}], " ", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6409334245265636`*^9, 3.640933490796402*^9}, {
   3.641309597476467*^9, 3.641309626739645*^9}, {3.641551181410392*^9, 
   3.641551185717483*^9}, {3.6415610574950457`*^9, 3.6415610607451487`*^9}, {
   3.641714043564027*^9, 3.641714074170219*^9}, {3.64172214940591*^9, 
   3.641722240342586*^9}, {3.642161960287537*^9, 3.6421619936028023`*^9}, {
   3.642162028568643*^9, 3.64216208307623*^9}, {3.6421622818437366`*^9, 
   3.6421622973787327`*^9}, {3.642163254378355*^9, 3.6421632572094193`*^9}, {
   3.642311082595138*^9, 3.642311108951272*^9}, {3.642316397584845*^9, 
   3.642316402140465*^9}, {3.6423181842105217`*^9, 3.642318208794897*^9}, {
   3.6423199383332033`*^9, 3.6423199570117407`*^9}, {3.6423213816056547`*^9, 
   3.6423214038996677`*^9}, {3.6423243622351723`*^9, 
   3.6423243849271812`*^9}, {3.642324563649001*^9, 3.6423245811709337`*^9}, {
   3.642326273449448*^9, 3.6423262762049017`*^9}, {3.642328055054914*^9, 
   3.642328061229743*^9}, {3.642329500423876*^9, 3.642329503317189*^9}, {
   3.6423390426683693`*^9, 3.64233904466374*^9}, {3.64233909305306*^9, 
   3.642339101043503*^9}, {3.64234199789227*^9, 3.64234202005532*^9}, {
   3.642343050882949*^9, 3.642343076630329*^9}, {3.642386610814782*^9, 
   3.6423866148128347`*^9}, {3.642495083679744*^9, 3.6424951116674767`*^9}, {
   3.642495191129525*^9, 3.6424951946905947`*^9}, {3.642495261285248*^9, 
   3.6424952632922707`*^9}, {3.642495298795573*^9, 3.6424953325334682`*^9}, {
   3.6424968196924677`*^9, 3.642496826716996*^9}, {3.642498037486211*^9, 
   3.642498060616591*^9}, {3.642498115191325*^9, 3.642498116433227*^9}, {
   3.642498918706962*^9, 3.6424989406027517`*^9}, {3.6425045514098377`*^9, 
   3.642504555674975*^9}, {3.64250679935163*^9, 3.642506802401503*^9}, {
   3.64251132071109*^9, 3.642511327684057*^9}, {3.642747207827924*^9, 
   3.642747213011305*^9}, {3.6427484348478117`*^9, 3.6427484375705214`*^9}, {
   3.642759770668082*^9, 3.6427597936123734`*^9}, {3.642775809200879*^9, 
   3.6427758289769573`*^9}, {3.64278245773665*^9, 3.642782476889331*^9}, {
   3.642788132984963*^9, 3.6427881601526957`*^9}, {3.6428172646407967`*^9, 
   3.6428172709072323`*^9}, {3.642852353445051*^9, 3.64285236181535*^9}, {
   3.6428582169394712`*^9, 3.642858219819085*^9}, {3.642865412290172*^9, 
   3.642865441948103*^9}, {3.6428734460897417`*^9, 3.6428734563064127`*^9}, {
   3.64287662204978*^9, 3.642876639100006*^9}, {3.642876954578898*^9, 
   3.642876960686399*^9}, {3.642877092679618*^9, 3.642877097615679*^9}, {
   3.642878305598686*^9, 3.642878313713911*^9}, {3.643085217918435*^9, 
   3.643085254554833*^9}, {3.6432649309048367`*^9, 3.643264942344078*^9}, {
   3.6432649907903767`*^9, 3.643264999029972*^9}, {3.643359922199045*^9, 
   3.6433599350449667`*^9}, {3.643361841961788*^9, 3.64336184449445*^9}, {
   3.643362336273685*^9, 3.643362343809389*^9}, {3.643438374930254*^9, 
   3.643438388400776*^9}, {3.6434509219292192`*^9, 3.643450933241747*^9}, {
   3.643473754258523*^9, 3.643473760159843*^9}, {3.643473799776104*^9, 
   3.6434738020324497`*^9}, {3.647237003839447*^9, 3.647237043379218*^9}, {
   3.647237196568779*^9, 3.647237199391591*^9}, {3.647237326369041*^9, 
   3.647237330080881*^9}, {3.647238745372303*^9, 3.647238755685609*^9}, {
   3.647271712581716*^9, 3.647271737687142*^9}, {3.647271800000188*^9, 
   3.647271803542766*^9}, {3.647271861820692*^9, 3.6472718953523197`*^9}, {
   3.647343094808919*^9, 3.647343112209981*^9}, {3.676629701984324*^9, 
   3.676629751363121*^9}, {3.67662978826469*^9, 3.676629848373414*^9}, 
   3.676629896687768*^9, {3.67663001260928*^9, 3.676630026798712*^9}, {
   3.676630189899472*^9, 3.676630220446974*^9}, {3.676630267802827*^9, 
   3.676630269144628*^9}, {3.676630312581155*^9, 3.676630314577239*^9}, {
   3.676630393757884*^9, 3.676630396055108*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Fast", " ", "visualisation", " ", "once", " ", "PolyGraphics", " ", "has",
     " ", "been", " ", "calculated", " ", "once"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "data", " ", "imported", " ", "below", " ", "only", " ", 
    "works", " ", "properly", " ", "with", " ", 
    "\"\<triang_lmax0.04.dat\>\""}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<4-patch.txt\>\"", ",", " ", "\"\<List\>\""}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"S2", " ", "=", " ", 
      RowBox[{"Join", "[", 
       RowBox[{"S", ",", "S"}], "]"}]}], ";", " ", 
     RowBox[{"(*", 
      RowBox[{
      "if", " ", "the", " ", "simulation", " ", "is", " ", "done", " ", "on", 
       " ", "one", " ", "half", " ", "of", " ", "the", " ", "patch"}], "*)"}],
      "\[IndentingNewLine]", 
     RowBox[{"S", " ", "=", " ", 
      RowBox[{"Join", "[", 
       RowBox[{"S2", ",", "S2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"S", " ", "=", " ", 
      RowBox[{"Join", "[", 
       RowBox[{"S", ",", "S2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"S", " ", "=", " ", 
      RowBox[{"Join", "[", 
       RowBox[{"S", ",", "S"}], "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "1"}], ",", " ", 
         RowBox[{
          RowBox[{"PolyGraphics", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "=", " ", "Green"}]}],
         "]"}], ";", 
       RowBox[{"(*", 
        RowBox[{
        "comment", " ", "these", " ", "two", " ", "lines", " ", "if", " ", 
         "the", " ", "simulation", " ", "is", " ", "done", " ", "only", " ", 
         "on", " ", "the", " ", "fundamental", " ", "patch"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "0"}], ",", " ", 
         RowBox[{
          RowBox[{"PolyGraphics", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", " ", "Pink"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"[", "i", "]"}], "]"}], " ", "==", " ", "2"}], ",", " ", 
         RowBox[{
          RowBox[{"PolyGraphics", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", " ", "Blue"}]}], 
        "]"}], ";"}], "\[IndentingNewLine]", ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"gr", " ", "=", " ", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"PolyGraphics", ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}]}], ","}], "*)"}],
       " ", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}]}], "]"}], 
    " "}]}]}]], "Input",
 CellChangeTimes->{{3.643369623430111*^9, 3.643369643080542*^9}, {
  3.643615813712479*^9, 3.643615820570333*^9}, {3.6470684559016447`*^9, 
  3.6470684586810923`*^9}, {3.647068506825605*^9, 3.6470685508560534`*^9}, {
  3.647068587918511*^9, 3.647068588223959*^9}, {3.6470686213898573`*^9, 
  3.647068621964944*^9}, {3.6470686599334297`*^9, 3.647068660448257*^9}, {
  3.6470687061573763`*^9, 3.647068715781229*^9}, {3.647068803460531*^9, 
  3.647068804787261*^9}, {3.647068841652054*^9, 3.6470688419301863`*^9}, {
  3.6470688885424757`*^9, 3.647068888909988*^9}, {3.6766288235559797`*^9, 
  3.676628833038045*^9}, {3.67663035724603*^9, 3.6766304111721354`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.647067237009557*^9, 3.647068498206764*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Visualization", " ", "in", " ", "the", " ", "complex", " ", "plane"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pfast", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Yellow", ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", " ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"vv", "[", 
               RowBox[{
                RowBox[{"ff", "[", 
                 RowBox[{"n", ",", "1"}], "]"}], ",", "1"}], "]"}], ",", 
              RowBox[{"vv", "[", 
               RowBox[{
                RowBox[{"ff", "[", 
                 RowBox[{"n", ",", "1"}], "]"}], ",", "2"}], "]"}]}], "}"}], 
            "  ", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"vv", "[", 
               RowBox[{
                RowBox[{"ff", "[", 
                 RowBox[{"n", ",", "2"}], "]"}], ",", "1"}], "]"}], ",", 
              RowBox[{"vv", "[", 
               RowBox[{
                RowBox[{"ff", "[", 
                 RowBox[{"n", ",", "2"}], "]"}], ",", "2"}], "]"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"vv", "[", 
               RowBox[{
                RowBox[{"ff", "[", 
                 RowBox[{"n", ",", "3"}], "]"}], ",", "1"}], "]"}], ",", 
              RowBox[{"vv", "[", 
               RowBox[{
                RowBox[{"ff", "[", 
                 RowBox[{"n", ",", "3"}], "]"}], ",", "2"}], "]"}]}], "}"}]}],
            " ", "}"}], " ", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "nfacet"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pfast", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{"[", "All", "]"}], "]"}], ",", "1"}], "]"}], "]"}], " ", "=",
      " ", "Blue"}], ";"}], "\[IndentingNewLine]", "Int", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pfast", "[", 
      RowBox[{"[", 
       RowBox[{"2461", ",", "1"}], "]"}], "]"}], " ", "=", " ", "Red"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pfast", "[", 
      RowBox[{"[", 
       RowBox[{"396", ",", "1"}], "]"}], "]"}], " ", "=", " ", "Red"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cm1", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cm2", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n1", " ", "=", " ", "5022"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n2", " ", "=", " ", "396"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"cm1coord", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"n1", ",", "1"}], "]"}], ",", "i"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"n1", ",", "2"}], "]"}], ",", "i"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"n1", ",", "3"}], "]"}], ",", "i"}], "]"}]}], ")"}], "/",
         "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cm2coord", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"n2", ",", "1"}], "]"}], ",", "i"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"n2", ",", "2"}], "]"}], ",", "i"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"n2", ",", "3"}], "]"}], ",", "i"}], "]"}]}], ")"}], "/",
         "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cm1", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"cm1", ",", "cm1coord"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cm2", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"cm2", ",", "cm2coord"}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "2", ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "cm1", "\[IndentingNewLine]", "cm2", 
   "\[IndentingNewLine]", 
   RowBox[{"diffx", " ", "=", " ", 
    RowBox[{
     RowBox[{"cm2", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", 
     RowBox[{"cm1", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"length", " ", "=", " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cm2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "-", 
         RowBox[{"cm1", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}], " ", "+", " ", 
      
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cm2", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{"cm1", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"CosAlpha", " ", "=", " ", 
    RowBox[{"diffx", "/", "length"}]}], "\[IndentingNewLine]", 
   RowBox[{"gamma", " ", "=", " ", 
    RowBox[{"Pi", "-", 
     RowBox[{"2", "*", 
      RowBox[{"ArcCos", "[", "CosAlpha", "]"}]}]}]}], "\[IndentingNewLine]", 
   RowBox[{"gamma", " ", "-", 
    RowBox[{"Pi", "/", "3"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6418092020928793`*^9, 3.641809225294499*^9}, {
   3.641809317277411*^9, 3.641809318310194*^9}, {3.641809435328862*^9, 
   3.641809440240181*^9}, {3.641809584849842*^9, 3.641809589401688*^9}, {
   3.64180962395866*^9, 3.64180962649326*^9}, {3.6418096592560673`*^9, 
   3.641809688060218*^9}, {3.6470898649785233`*^9, 3.647089867299614*^9}, {
   3.647104452556875*^9, 3.647104520561537*^9}, {3.647148491445663*^9, 
   3.647148493532868*^9}, {3.647148528563902*^9, 3.647148562486247*^9}, {
   3.647148690108279*^9, 3.647148766055462*^9}, {3.6471488484748583`*^9, 
   3.647149051157099*^9}, {3.647149147360924*^9, 3.647149202635613*^9}, {
   3.647149339976521*^9, 3.647149543175856*^9}, {3.647149639246291*^9, 
   3.647149642108376*^9}, {3.647149706740683*^9, 3.647149716445767*^9}, {
   3.647149808580021*^9, 3.6471498350469646`*^9}, {3.647149953863882*^9, 
   3.647149958130937*^9}, {3.647150088507575*^9, 3.647150127250049*^9}, {
   3.6471502114803467`*^9, 3.647150229936201*^9}, {3.647150275031108*^9, 
   3.6471503080122013`*^9}, {3.64715500600176*^9, 3.647155047622114*^9}, {
   3.647155100159849*^9, 3.647155148420885*^9}, {3.647156308138115*^9, 
   3.647156311023369*^9}, {3.647156436366001*^9, 3.647156478235745*^9}, {
   3.647156645570528*^9, 3.647156712710627*^9}, {3.647156804870111*^9, 
   3.647156861214282*^9}, {3.647156938706448*^9, 3.6471569659520273`*^9}, {
   3.647157036339016*^9, 3.647157094455405*^9}, {3.64719290131781*^9, 
   3.64719290432292*^9}, {3.647192938346685*^9, 3.647193195076528*^9}, {
   3.647193247885454*^9, 3.647193262093164*^9}, {3.647193327930582*^9, 
   3.647193354337476*^9}, {3.647193387813321*^9, 3.647193414923408*^9}, {
   3.647193540716679*^9, 3.6471935631892233`*^9}, {3.647193649153481*^9, 
   3.64719364963484*^9}, 3.647193711016872*^9, {3.647193759281947*^9, 
   3.647193826374775*^9}, {3.647193857832206*^9, 3.647193961689649*^9}, {
   3.647194014266523*^9, 3.6471940197711973`*^9}, {3.647194067795886*^9, 
   3.647194097782159*^9}, {3.647194330477174*^9, 3.647194364107978*^9}, {
   3.647237120213406*^9, 3.647237186964189*^9}, {3.647237287834711*^9, 
   3.647237313278015*^9}, {3.647237361909153*^9, 3.6472373644966793`*^9}, {
   3.6472374281782722`*^9, 3.64723745410655*^9}, {3.647237504396865*^9, 
   3.647237506891879*^9}, {3.647237537589158*^9, 3.64723755846502*^9}, {
   3.6472375908029613`*^9, 3.647237603733418*^9}, {3.647237642031076*^9, 
   3.6472378098732023`*^9}, {3.647238661820114*^9, 3.647238663858283*^9}, {
   3.6472388004034767`*^9, 3.647238815420877*^9}, {3.6472395094021482`*^9, 
   3.647239559671556*^9}, {3.64723961129655*^9, 3.6472396813484993`*^9}, {
   3.647239757091524*^9, 3.647239810633304*^9}, 3.647274049695716*^9, {
   3.6472740839125032`*^9, 3.647274086155479*^9}, {3.647277391310783*^9, 
   3.6472774975951567`*^9}, {3.6472775456293907`*^9, 3.647277706491205*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Outputing", " ", "data", " ", "points", " ", "of", " ", "the", " ", 
    "interface", " ", "in", " ", "the", " ", "complex", " ", "plane", " ", 
    "to", " ", "be", " ", "fitted", " ", "with", " ", "whatever", " ", 
    "software"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"IntCM", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"nint", " ", "=", " ", 
       RowBox[{"Int", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cmx", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"nint", ",", "1"}], "]"}], ",", "1"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"nint", ",", "2"}], "]"}], ",", "1"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"nint", ",", "3"}], "]"}], ",", "1"}], "]"}]}], ")"}], 
        "/", "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cmy", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"nint", ",", "1"}], "]"}], ",", "2"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"nint", ",", "2"}], "]"}], ",", "2"}], "]"}], " ", "+", 
          " ", 
          RowBox[{"vv", "[", 
           RowBox[{
            RowBox[{"ff", "[", 
             RowBox[{"nint", ",", "3"}], "]"}], ",", "2"}], "]"}]}], ")"}], 
        "/", "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"IntCM", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"IntCM", ",", " ", 
         RowBox[{"{", 
          RowBox[{"cmx", ",", "cmy"}], "}"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "Int", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "IntCM", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", "pfast"}], "}"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6418092020928793`*^9, 3.641809225294499*^9}, {
   3.641809317277411*^9, 3.641809318310194*^9}, {3.641809435328862*^9, 
   3.641809440240181*^9}, {3.641809584849842*^9, 3.641809589401688*^9}, {
   3.64180962395866*^9, 3.64180962649326*^9}, {3.6418096592560673`*^9, 
   3.641809688060218*^9}, {3.6470898649785233`*^9, 3.647089867299614*^9}, {
   3.647104452556875*^9, 3.647104520561537*^9}, {3.647148491445663*^9, 
   3.647148493532868*^9}, {3.647148528563902*^9, 3.647148562486247*^9}, {
   3.647148690108279*^9, 3.647148766055462*^9}, {3.6471488484748583`*^9, 
   3.647149051157099*^9}, {3.647149147360924*^9, 3.647149202635613*^9}, {
   3.647149339976521*^9, 3.647149543175856*^9}, {3.647149639246291*^9, 
   3.647149642108376*^9}, {3.647149706740683*^9, 3.647149716445767*^9}, {
   3.647149808580021*^9, 3.6471498350469646`*^9}, {3.647149953863882*^9, 
   3.647149958130937*^9}, {3.647150088507575*^9, 3.647150127250049*^9}, {
   3.6471502114803467`*^9, 3.647150229936201*^9}, {3.647150275031108*^9, 
   3.6471503080122013`*^9}, {3.64715500600176*^9, 3.647155047622114*^9}, {
   3.647155100159849*^9, 3.647155148420885*^9}, {3.647156308138115*^9, 
   3.647156311023369*^9}, {3.647156436366001*^9, 3.647156478235745*^9}, {
   3.647156645570528*^9, 3.647156712710627*^9}, {3.647156804870111*^9, 
   3.647156861214282*^9}, {3.647156938706448*^9, 3.6471569659520273`*^9}, {
   3.647157036339016*^9, 3.647157094455405*^9}, {3.64719290131781*^9, 
   3.64719290432292*^9}, {3.647192938346685*^9, 3.647193195076528*^9}, {
   3.647193247885454*^9, 3.647193262093164*^9}, {3.647193327930582*^9, 
   3.647193354337476*^9}, {3.647193387813321*^9, 3.647193414923408*^9}, {
   3.647193540716679*^9, 3.6471935631892233`*^9}, {3.647193649153481*^9, 
   3.64719364963484*^9}, 3.647193711016872*^9, {3.647193759281947*^9, 
   3.647193826374775*^9}, {3.647193857832206*^9, 3.647193961689649*^9}, {
   3.647194014266523*^9, 3.6471940197711973`*^9}, {3.647194067795886*^9, 
   3.647194097782159*^9}, {3.647194330477174*^9, 3.647194364107978*^9}, {
   3.647237120213406*^9, 3.647237186964189*^9}, {3.647237287834711*^9, 
   3.647237313278015*^9}, {3.647237361909153*^9, 3.6472373644966793`*^9}, {
   3.6472374281782722`*^9, 3.64723745410655*^9}, {3.647237504396865*^9, 
   3.647237506891879*^9}, {3.647237537589158*^9, 3.64723755846502*^9}, {
   3.6472375908029613`*^9, 3.647237603733418*^9}, {3.647237642031076*^9, 
   3.6472378098732023`*^9}, {3.647238661820114*^9, 3.647238663858283*^9}, {
   3.6472388004034767`*^9, 3.647238815420877*^9}, {3.6472395094021482`*^9, 
   3.647239559671556*^9}, {3.64723961129655*^9, 3.6472396813484993`*^9}, {
   3.647239757091524*^9, 3.647239810633304*^9}, 3.647274049695716*^9, {
   3.6472740839125032`*^9, 3.647274086155479*^9}, {3.647277391310783*^9, 
   3.6472774975951567`*^9}, {3.6472775456293907`*^9, 3.647277706491205*^9}, {
   3.647322289336091*^9, 3.6473222935573*^9}, 3.647322380226922*^9, {
   3.647322422208894*^9, 3.6473224315029*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"print", " ", "IntCM", " ", "to", " ", "file"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"title", " ", "=", 
     RowBox[{"FileNameJoin", "@", 
      RowBox[{"{", "\"\<InterfaceCMCurv.txt\>\"", "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", " ", "=", " ", 
     RowBox[{"OpenAppend", "[", "title", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dummyx", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"IntCM", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dummyy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"IntCM", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "str", ",", "dummyx", ",", "\"\< \>\"", ",", "dummyy", ",", " ", 
        "\"\<\\n\>\""}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "IntCM", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "str", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6473224370310373`*^9, 3.647322452210534*^9}, {
  3.647322699863202*^9, 3.647322798181307*^9}, {3.6473229220434923`*^9, 
  3.647322922392646*^9}, {3.647322958521872*^9, 3.647322959458507*^9}, {
  3.647323126720751*^9, 3.647323127651018*^9}, {3.647344471452693*^9, 
  3.6473444720511*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Discretizing", " ", "the", " ", "curve", " ", "obtained", " ", "from", 
    " ", 
    RowBox[{"gnuplot", ":", " ", 
     RowBox[{
     "expresses", " ", "u", " ", "as", " ", "a", " ", "function", " ", "of", 
      " ", "v", " ", "for", " ", "v", " ", 
      RowBox[{"in", " ", "[", 
       RowBox[{"0", ":", "0.165"}], "]"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fit", "[", "x_", "]"}], ":=", " ", 
    RowBox[{"0.295", "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"8.5", "*", 
       RowBox[{"x", "^", "1.8"}]}], "]"}]}]}], 
   RowBox[{"(*", 
    RowBox[{"with", " ", "facetting"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"fit", "[", "x_", "]"}], ":=", " ", 
     RowBox[{"0.312", "*", 
      RowBox[{"Exp", "[", 
       RowBox[{"9.35", "*", 
        RowBox[{"x", "^", "2.1"}]}], "]"}]}]}], "*)"}], 
   RowBox[{"(*", 
    RowBox[{"with", " ", "curvature", " ", "only"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FittedInterface", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.001", ",", "0."}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.", ",", "0.001"}], "}"}]}], ";", 
    RowBox[{"(*", 
     RowBox[{
     "these", " ", "are", " ", "the", " ", "2", "D", " ", "vectors", " ", 
      "to", " ", "add", " ", "to", " ", "Intp", " ", "to", " ", "give", " ", 
      "the", " ", "position", " ", "of", " ", "two", " ", "points", " ", "in",
       " ", "C", " ", "which", " ", "will", " ", "be", " ", "used", " ", "to",
       " ", "get", " ", "the", " ", "normal", " ", "to", " ", "the", " ", 
      "surface"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"v", " ", "=", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], "*", 
         RowBox[{"0.165", "/", "501"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"u", " ", "=", " ", 
        RowBox[{"fit", "[", "v", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Intp", " ", "=", " ", 
        RowBox[{"{", 
         RowBox[{"u", ",", "v"}], "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"IntpNeigh1", " ", "=", " ", 
        RowBox[{"Intp", "+", "d1"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"IntpNeigh2", " ", "=", " ", 
        RowBox[{"Intp", " ", "+", "d2"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "The", " ", "actual", " ", "list", " ", "will", " ", "consist", " ", 
          "of", " ", "500", " ", "sublists", " ", "associated", " ", "to", 
          " ", "each", " ", "point", " ", "of", " ", "the", " ", "interface", 
          " ", "whereby", " ", "the", " ", "first", " ", "element", " ", "of",
           " ", "the", " ", "sublist", " ", "is", " ", "Intp"}], ",", " ", 
         RowBox[{
         "and", " ", "the", " ", "second", " ", "and", " ", "third", " ", 
          "are", " ", "the", " ", "neighbouring", " ", "points", " ", "of", 
          " ", "Intp"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"FittedInterface", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"FittedInterface", ",", " ", 
          RowBox[{"{", 
           RowBox[{"Intp", ",", " ", "IntpNeigh1", ",", " ", "IntpNeigh2"}], 
           "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "501", ",", "1"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"FittedInterface", ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.647324370443152*^9, 3.647324477719701*^9}, {
   3.6473248665757732`*^9, 3.647324973798671*^9}, {3.647325152970503*^9, 
   3.647325230355665*^9}, {3.647325266925913*^9, 3.647325383956585*^9}, 
   3.6473254446111603`*^9, {3.647325963436261*^9, 3.647325988817389*^9}, {
   3.64732604114196*^9, 3.647326328749366*^9}, {3.647326399576232*^9, 
   3.647326426471184*^9}, 3.647327314009617*^9, 3.647327346231514*^9, {
   3.647327480818125*^9, 3.647327485570788*^9}, {3.647344611504697*^9, 
   3.647344673509646*^9}, {3.647345068759637*^9, 3.647345079659754*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "We", " ", "know", " ", "have", " ", "to", " ", "map", " ", "these", " ", 
    "2", "d", " ", "points", " ", "onto", " ", "the", " ", "P", " ", 
    "surface", " ", "via", " ", "the", " ", "Weierstrass", " ", "map"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ThreeDFittedInt", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"uu", " ", "=", " ", 
       RowBox[{"FittedInterface", "[", 
        RowBox[{"[", 
         RowBox[{"s", ",", "1", ",", "1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vvv", " ", "=", " ", 
       RowBox[{"FittedInterface", "[", 
        RowBox[{"[", 
         RowBox[{"s", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ww", " ", "=", " ", 
       RowBox[{"uu", "+", 
        RowBox[{"vvv", "*", " ", "I"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xp", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"yp", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", "I", "*", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"zp", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", "2", "*", "z"}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"uu", " ", "=", " ", 
       RowBox[{"FittedInterface", "[", 
        RowBox[{"[", 
         RowBox[{"s", ",", "2", ",", "1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vvv", " ", "=", " ", 
       RowBox[{"FittedInterface", "[", 
        RowBox[{"[", 
         RowBox[{"s", ",", "2", ",", "2"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ww", " ", "=", " ", 
       RowBox[{"uu", "+", 
        RowBox[{"vvv", "*", " ", "I"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xp1", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"yp1", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", "I", "*", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"zp1", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", "2", "*", "z"}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"uu", " ", "=", " ", 
       RowBox[{"FittedInterface", "[", 
        RowBox[{"[", 
         RowBox[{"s", ",", "3", ",", "1"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vvv", " ", "=", " ", 
       RowBox[{"FittedInterface", "[", 
        RowBox[{"[", 
         RowBox[{"s", ",", "3", ",", "2"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ww", " ", "=", " ", 
       RowBox[{"uu", "+", 
        RowBox[{"vvv", "*", " ", "I"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xp2", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"yp2", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", "I", "*", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"zp2", "=", 
       RowBox[{"r", "*", 
        RowBox[{"Re", "[", 
         RowBox[{"I", "*", 
          RowBox[{"NIntegrate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"rr", "[", "z", "]"}], "*", "2", "*", "z"}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", "ww"}], "}"}]}], "]"}]}], "]"}]}]}], 
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ThreeDFittedInt", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"ThreeDFittedInt", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xp", ",", "yp", ",", "zp"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"xp1", ",", "yp1", ",", "zp1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"xp2", ",", "yp2", ",", "zp2"}], "}"}]}], "}"}]}], 
        "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "FittedInterface", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"ThreeDFittedInt", ";"}]}]}]], "Input",
 CellChangeTimes->{{3.647327372844749*^9, 3.6473274222650013`*^9}, 
   3.6473276816155148`*^9, {3.647327797339645*^9, 3.6473278370704203`*^9}, {
   3.647328550149342*^9, 3.647328583308556*^9}, {3.647328626758836*^9, 
   3.647328756663069*^9}, {3.647328934009119*^9, 3.647329062066972*^9}, 
   3.64732913683801*^9, {3.647344695756507*^9, 3.6473447110429983`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Output", " ", 
    RowBox[{"{", 
     RowBox[{"xp", ",", "yp", ",", "zp"}], "}"}], " ", "to", " ", "file", " ",
     "to", " ", "be", " ", "plotted", " ", "to", " ", "see", " ", "if", " ", 
    "the", " ", "curve", " ", "looks", " ", "ok"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"title", " ", "=", 
     RowBox[{"FileNameJoin", "@", 
      RowBox[{"{", "\"\<FittedInterface3D.txt\>\"", "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", " ", "=", " ", 
     RowBox[{"OpenAppend", "[", "title", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dummyx", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"ThreeDFittedInt", "[", 
         RowBox[{"[", 
          RowBox[{"s", ",", "1", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dummyy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"ThreeDFittedInt", "[", 
         RowBox[{"[", 
          RowBox[{"s", ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dummyz", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"ThreeDFittedInt", "[", 
         RowBox[{"[", 
          RowBox[{"s", ",", "1", ",", "3"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "str", ",", "dummyx", ",", "\"\< \>\"", ",", "dummyy", ",", 
        "\"\< \>\"", ",", "dummyz", ",", " ", "\"\<\\n\>\""}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "ThreeDFittedInt", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "str", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.647322280036787*^9, {3.647329161874745*^9, 3.647329192848954*^9}, {
   3.647329371920906*^9, 3.6473294926210823`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Tangent", " ", "vector"}], ",", " ", 
    RowBox[{
    "its", " ", "derivative", " ", "and", " ", "the", " ", "normal", " ", 
     "to", " ", "the", " ", "surface"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"First", " ", "the", " ", "tangent", " ", "vector", " ", "field"}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"T", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NormT", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dr", " ", "=", " ", 
       RowBox[{
        RowBox[{"ThreeDFittedInt", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"s", "+", "1"}], ",", "1"}], "]"}], "]"}], "-", 
        RowBox[{"ThreeDFittedInt", "[", 
         RowBox[{"[", 
          RowBox[{"s", ",", "1"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"T", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"T", ",", " ", 
         RowBox[{"dr", "/", 
          RowBox[{"Norm", "[", "dr", "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"NormT", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"NormT", ",", " ", 
         RowBox[{"Norm", "[", "dr", "]"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{
        RowBox[{"Length", "[", "ThreeDFittedInt", "]"}], "-", "1"}], ",", 
       "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"T", ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Derivative", " ", "of", " ", "the", " ", "tangent", " ", "vector"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Nt", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kappa", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dT", " ", "=", " ", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"[", 
          RowBox[{"s", "+", "1"}], "]"}], "]"}], "-", 
        RowBox[{"T", "[", 
         RowBox[{"[", "s", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"kappa", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"kappa", ",", " ", 
         RowBox[{"Norm", "[", "dT", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Nt", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"Nt", ",", " ", 
         RowBox[{"dT", "/", 
          RowBox[{"Norm", "[", "dT", "]"}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{
        RowBox[{"Length", "[", "T", "]"}], "-", "1"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"kappa", ";"}], "\[IndentingNewLine]", 
   RowBox[{"Nt", ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Normal", " ", "vector", " ", "to", " ", "the", " ", "surface"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nt", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"cross", " ", "=", " ", 
       RowBox[{"CrossProduct", "[", 
        RowBox[{
         RowBox[{"ThreeDFittedInt", "[", 
          RowBox[{"[", 
           RowBox[{"s", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"ThreeDFittedInt", "[", 
          RowBox[{"[", 
           RowBox[{"s", ",", "3"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nt", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"nt", ",", " ", 
         RowBox[{"cross", "/", 
          RowBox[{"Norm", "[", "cross", "]"}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "Nt", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"nt", ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.647335791086413*^9, 3.647335931696856*^9}, {
   3.6473359683579893`*^9, 3.647336141445036*^9}, {3.647336195558056*^9, 
   3.647336226893371*^9}, {3.647336262553545*^9, 3.647336268867538*^9}, {
   3.647336316198635*^9, 3.647336548456471*^9}, {3.647336581079144*^9, 
   3.647336616294153*^9}, {3.64733665733703*^9, 3.6473366852736807`*^9}, {
   3.647336739297275*^9, 3.647336763259033*^9}, {3.6473382286559143`*^9, 
   3.6473382635339317`*^9}, {3.6473383001285343`*^9, 3.647338303108914*^9}, {
   3.6473383756998796`*^9, 3.647338491113155*^9}, {3.647338541014964*^9, 
   3.647338575367487*^9}, {3.64733863626509*^9, 3.647338640551766*^9}, 
   3.647338762518153*^9, {3.647341499251511*^9, 3.6473415259400454`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Computing", " ", "the", " ", "geodesic", " ", "curvature", " ", "along", 
    " ", "the", " ", "curve"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"kappag", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"kg", " ", "=", " ", 
       RowBox[{
        RowBox[{"kappa", "[", 
         RowBox[{"[", "s", "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"DotProduct", "[", 
             RowBox[{
              RowBox[{"Nt", "[", 
               RowBox[{"[", "s", "]"}], "]"}], ",", 
              RowBox[{"nt", "[", 
               RowBox[{"[", "s", "]"}], "]"}]}], "]"}], ")"}], "^", "2"}]}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"kappag", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"kappag", ",", " ", "kg"}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "nt", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"kappag", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "print", " ", "geodesic", " ", "curvature", " ", "to", " ", "file"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"title", " ", "=", 
     RowBox[{"FileNameJoin", "@", 
      RowBox[{"{", "\"\<GeodesicCurv.txt\>\"", "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", " ", "=", " ", 
     RowBox[{"OpenAppend", "[", "title", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dummy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"kappag", "[", 
         RowBox[{"[", "s", "]"}], "]"}], 
        RowBox[{"(*", 
         RowBox[{"/", 
          RowBox[{"kappag", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "*)"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "str", ",", "s", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
        "\"\<\\n\>\""}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "kappag", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "str", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.647338801914217*^9, 3.647338853998177*^9}, {
   3.647338886682733*^9, 3.6473389470994453`*^9}, {3.6473390021518097`*^9, 
   3.647339041819808*^9}, {3.647339084899951*^9, 3.647339094931185*^9}, {
   3.6473391315958548`*^9, 3.647339185751247*^9}, 3.647339222004342*^9, {
   3.647339278717523*^9, 3.647339398839374*^9}, {3.64734018592724*^9, 
   3.647340190881537*^9}, {3.6473447741525927`*^9, 3.647344776219939*^9}, {
   3.647345026502531*^9, 3.647345030005741*^9}, {3.647345119125246*^9, 
   3.647345120278953*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Computing", " ", "the", " ", 
    RowBox[{"integral", "/", "cumulative"}], " ", "of", " ", "the", " ", 
    "geodesic", " ", "curvature"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"cumul", " ", "=", " ", "0."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"angle", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"cumul", " ", "=", " ", 
       RowBox[{"cumul", " ", "+", " ", 
        RowBox[{"kappag", "[", 
         RowBox[{"[", "s", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"angle", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"angle", ",", " ", "cumul"}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "kappag", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "print", " ", "the", " ", "normalized", " ", "cumulative", " ", "to", " ",
      "file"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"title", " ", "=", 
     RowBox[{"FileNameJoin", "@", 
      RowBox[{"{", "\"\<GeodesicCumulNoFacet.txt\>\"", "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", " ", "=", " ", 
     RowBox[{"OpenAppend", "[", "title", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dummy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"angle", "[", 
         RowBox[{"[", "s", "]"}], "]"}], 
        RowBox[{"(*", 
         RowBox[{"/", 
          RowBox[{"angle", "[", 
           RowBox[{"[", 
            RowBox[{"Length", "[", "angle", "]"}], "]"}], "]"}]}], "*)"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "str", ",", "s", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
        "\"\<\\n\>\""}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", 
       RowBox[{"Length", "[", "angle", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "str", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.647340193362688*^9, 3.6473402065030413`*^9}, {
   3.647340470370277*^9, 3.647340633597571*^9}, {3.647340678783678*^9, 
   3.647340727459484*^9}, {3.6473413365773*^9, 3.6473413406185713`*^9}, {
   3.6473415507380323`*^9, 3.647341560360553*^9}, {3.647341620670148*^9, 
   3.647341623837853*^9}, 3.647341715131155*^9, {3.6473447813010883`*^9, 
   3.647344782994956*^9}, {3.647345699164988*^9, 3.6473457081223497`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"curv", " ", "=", " ", 
    RowBox[{"List", "[", "]"}]}], ";", " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "failed", " ", "attemps", " ", "at", " ", "measuring", " ", "the", " ", 
      "angle", " ", "by", " ", "taking", " ", "an", " ", "average", " ", "of",
       " ", "the", " ", "angle", " ", "between", " ", "local", " ", "tangent",
       " ", "vectors", " ", "along", " ", "the", " ", "2", "d", " ", "curve", 
      " ", "and", " ", "the", " ", "x"}], "-", "axis"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"n1", " ", "=", " ", 
        RowBox[{"Int", "[", 
         RowBox[{"[", 
          RowBox[{"j", "+", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"n2", " ", "=", " ", 
        RowBox[{"Int", "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"cm1x", " ", "=", " ", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n1", ",", "1"}], "]"}], ",", "1"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n1", ",", "2"}], "]"}], ",", "1"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n1", ",", "3"}], "]"}], ",", "1"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cm2x", " ", "=", " ", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n2", ",", "1"}], "]"}], ",", "1"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n2", ",", "2"}], "]"}], ",", "1"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n2", ",", "3"}], "]"}], ",", "1"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cm1y", " ", "=", " ", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n1", ",", "1"}], "]"}], ",", "2"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n1", ",", "2"}], "]"}], ",", "2"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n1", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cm2y", " ", "=", " ", 
        RowBox[{
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n2", ",", "1"}], "]"}], ",", "2"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n2", ",", "2"}], "]"}], ",", "2"}], "]"}], " ", "+", " ", 
         RowBox[{"vv", "[", 
          RowBox[{
           RowBox[{"ff", "[", 
            RowBox[{"n2", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cm1", " ", "=", " ", 
        RowBox[{"{", 
         RowBox[{"cm1x", ",", "cm1y"}], "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"cm2", " ", "=", " ", 
        RowBox[{"{", 
         RowBox[{"cm2x", ",", "cm2y"}], "}"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"diffx", " ", "=", " ", 
        RowBox[{
         RowBox[{"cm2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "-", 
         RowBox[{"cm1", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"length", " ", "=", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"cm2", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{"cm1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}], " ", "+", 
          " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"cm2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", 
             RowBox[{"cm1", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"CosAlpha", " ", "=", " ", 
        RowBox[{"diffx", "/", "length"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"gamma", " ", "=", " ", 
        RowBox[{"Pi", "-", 
         RowBox[{"2", "*", 
          RowBox[{"ArcCos", "[", "CosAlpha", "]"}]}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"curv", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"curv", " ", ",", " ", 
          RowBox[{"gamma", " ", "-", 
           RowBox[{"Pi", "/", "3"}]}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{
         RowBox[{"Length", "[", "Int", "]"}], "-", "1"}], ",", "1"}], "}"}]}],
      "]"}], "\[IndentingNewLine]", "curv", "\[IndentingNewLine]", 
    RowBox[{"total", " ", "=", " ", "0"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"total", " ", "=", " ", 
        RowBox[{"total", " ", "+", " ", 
         RowBox[{"curv", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "curv", "]"}], ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"total", "/", 
     RowBox[{"(", 
      RowBox[{"Length", "[", "curv", "]"}], ")"}]}], "\[IndentingNewLine]", 
    RowBox[{"Mean", "[", "curv", "]"}], "\[IndentingNewLine]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Variance", "[", "curv", "]"}], "]"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.6418092020928793`*^9, 3.641809225294499*^9}, {
   3.641809317277411*^9, 3.641809318310194*^9}, {3.641809435328862*^9, 
   3.641809440240181*^9}, {3.641809584849842*^9, 3.641809589401688*^9}, {
   3.64180962395866*^9, 3.64180962649326*^9}, {3.6418096592560673`*^9, 
   3.641809688060218*^9}, {3.6470898649785233`*^9, 3.647089867299614*^9}, {
   3.647104452556875*^9, 3.647104520561537*^9}, {3.647148491445663*^9, 
   3.647148493532868*^9}, {3.647148528563902*^9, 3.647148562486247*^9}, {
   3.647148690108279*^9, 3.647148766055462*^9}, {3.6471488484748583`*^9, 
   3.647149051157099*^9}, {3.647149147360924*^9, 3.647149202635613*^9}, {
   3.647149339976521*^9, 3.647149543175856*^9}, {3.647149639246291*^9, 
   3.647149642108376*^9}, {3.647149706740683*^9, 3.647149716445767*^9}, {
   3.647149808580021*^9, 3.6471498350469646`*^9}, {3.647149953863882*^9, 
   3.647149958130937*^9}, {3.647150088507575*^9, 3.647150127250049*^9}, {
   3.6471502114803467`*^9, 3.647150229936201*^9}, {3.647150275031108*^9, 
   3.6471503080122013`*^9}, {3.64715500600176*^9, 3.647155047622114*^9}, {
   3.647155100159849*^9, 3.647155148420885*^9}, {3.647156308138115*^9, 
   3.647156311023369*^9}, {3.647156436366001*^9, 3.647156478235745*^9}, {
   3.647156645570528*^9, 3.647156712710627*^9}, {3.647156804870111*^9, 
   3.647156861214282*^9}, {3.647156938706448*^9, 3.6471569659520273`*^9}, {
   3.647157036339016*^9, 3.647157094455405*^9}, {3.64719290131781*^9, 
   3.64719290432292*^9}, {3.647192938346685*^9, 3.647193195076528*^9}, {
   3.647193247885454*^9, 3.647193262093164*^9}, {3.647193327930582*^9, 
   3.647193354337476*^9}, {3.647193387813321*^9, 3.647193414923408*^9}, {
   3.647193540716679*^9, 3.6471935631892233`*^9}, {3.647193649153481*^9, 
   3.64719364963484*^9}, 3.647193711016872*^9, {3.647193759281947*^9, 
   3.647193826374775*^9}, {3.647193857832206*^9, 3.647193961689649*^9}, {
   3.647194014266523*^9, 3.6471940197711973`*^9}, {3.647194067795886*^9, 
   3.647194097782159*^9}, {3.647194330477174*^9, 3.647194364107978*^9}, {
   3.647237120213406*^9, 3.647237186964189*^9}, {3.647237287834711*^9, 
   3.647237313278015*^9}, {3.647237361909153*^9, 3.6472373644966793`*^9}, {
   3.6472374281782722`*^9, 3.64723745410655*^9}, {3.647237504396865*^9, 
   3.647237506891879*^9}, {3.647237537589158*^9, 3.64723755846502*^9}, {
   3.6472375908029613`*^9, 3.647237603733418*^9}, {3.647237642031076*^9, 
   3.6472378098732023`*^9}, {3.647238661820114*^9, 3.647238663858283*^9}, {
   3.6472388004034767`*^9, 3.647238815420877*^9}, {3.6472395094021482`*^9, 
   3.647239559671556*^9}, {3.64723961129655*^9, 3.6472396813484993`*^9}, {
   3.647239757091524*^9, 3.647239810633304*^9}, {3.647274049695716*^9, 
   3.647274079799058*^9}, {3.6473292270971603`*^9, 3.6473292873119497`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Getting", " ", "a", " ", "list", " ", "of", " ", "Neighbours", " ", 
    "between", " ", "adjacent", " ", "patches"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"NeighSet2", " ", "=", " ", "NeighSet"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
           "0"}], ",", " ", 
          RowBox[{
           RowBox[{"NeighSet2", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
           RowBox[{
            RowBox[{"NeighSet", "[", 
             RowBox[{"[", 
              RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
            RowBox[{"Length", "[", "PolySet", "]"}]}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySet", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NeighSet2", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"NeighSet", ",", "NeighSet2"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.640332077995884*^9, 3.640332078620488*^9}, {
   3.640332456924811*^9, 3.640332463634551*^9}, {3.640340316032682*^9, 
   3.640340320243867*^9}, {3.6404229583398323`*^9, 3.6404230888279676`*^9}, 
   3.6404231475913467`*^9, {3.640423261948812*^9, 3.6404232935722733`*^9}, {
   3.6404233889074163`*^9, 3.640423397817692*^9}, {3.640423863896435*^9, 
   3.640423941527401*^9}, {3.640424172550838*^9, 3.640424177581193*^9}, 
   3.640424209020905*^9, {3.640424301981052*^9, 3.6404243185712557`*^9}, {
   3.640424446169828*^9, 3.6404244834961443`*^9}, {3.640424768410573*^9, 
   3.640424818012805*^9}, {3.640424860927931*^9, 3.640425065044519*^9}, {
   3.640425281243373*^9, 3.640425304860812*^9}, {3.640425398058661*^9, 
   3.640425412203158*^9}, {3.640425491999591*^9, 3.6404254950301247`*^9}, {
   3.64042646975826*^9, 3.640426528260635*^9}, {3.6404266584560966`*^9, 
   3.640426663049917*^9}, {3.640426770901443*^9, 3.6404267725662193`*^9}, {
   3.640426813652265*^9, 3.640426836647118*^9}, {3.640427552119269*^9, 
   3.640427553949781*^9}, {3.6404276515227003`*^9, 3.640427658423184*^9}, {
   3.6404277119884443`*^9, 3.640427712346403*^9}, {3.640427787599843*^9, 
   3.6404277881231527`*^9}, {3.6404278328555107`*^9, 3.640427877443561*^9}, {
   3.640427976385783*^9, 3.6404279783929577`*^9}, {3.640428008702923*^9, 
   3.640428034560586*^9}, {3.64042817039966*^9, 3.640428177070702*^9}, {
   3.6406844386954803`*^9, 3.640684575985716*^9}, {3.64068478354797*^9, 
   3.640684858907405*^9}, {3.640684902442089*^9, 3.640685081379978*^9}, {
   3.6406853316128807`*^9, 3.640685399979621*^9}, {3.640933512681658*^9, 
   3.6409335299856863`*^9}, {3.6409358433600073`*^9, 
   3.6409358472515173`*^9}, {3.6410168957575617`*^9, 3.641016897639586*^9}, {
   3.641017007132401*^9, 3.641017008156745*^9}, {3.647274468159368*^9, 
   3.647274468646652*^9}, {3.67663049132407*^9, 3.676630515250112*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "finding", " ", "neighbours", " ", "at", " ", "the", " ", "diagonal", " ", 
    "boundary", " ", "between", " ", "the", " ", "two", " ", "first", " ", 
    "fondamental", " ", "patches"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet2", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "\[Equal]", 
          " ", 
          RowBox[{"-", "2"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Do", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"NeighSet2", "[", 
                  RowBox[{"[", 
                   RowBox[{"m", ",", "j", ",", "1"}], "]"}], "]"}], " ", 
                 "\[Equal]", " ", 
                 RowBox[{"-", "2"}]}], " ", "&&", " ", 
                RowBox[{
                 RowBox[{"NeighSet2", "[", 
                  RowBox[{"[", 
                   RowBox[{"m", ",", "j", ",", "2"}], "]"}], "]"}], 
                 "\[Equal]", " ", 
                 RowBox[{"NeighSet2", "[", 
                  RowBox[{"[", 
                   RowBox[{"n", ",", "i", ",", "2"}], "]"}], "]"}]}]}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{"intersection", " ", "=", " ", 
                  RowBox[{"Intersection", "[", 
                   RowBox[{
                    RowBox[{"PolySetComplete", "[", 
                    RowBox[{"[", 
                    RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"PolySetComplete", "[", 
                    RowBox[{"[", 
                    RowBox[{"m", ",", "2"}], "]"}], "]"}]}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"Length", "[", 
                    RowBox[{"intersection", " ", ">=", " ", "1"}], "]"}], 
                   ","}]}]}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"NeighSet2", "[", 
                  RowBox[{"[", 
                   RowBox[{"m", ",", "j", ",", "1"}], "]"}], "]"}], " ", "=", 
                 " ", "n"}], ";", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"NeighSet2", "[", 
                  RowBox[{"[", 
                   RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "=", 
                 " ", "m"}], ";"}]}], "\[IndentingNewLine]", 
              RowBox[{"(*", "]", "*)"}], "\[IndentingNewLine]", "]"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "i", ",", 
             RowBox[{"Length", "[", "NeighSet2", "]"}], ",", "1"}], "}"}]}], 
          "]"}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet2", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet2", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "\[Equal]", 
          " ", 
          RowBox[{"-", "3"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet2", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"n", "+", "nfacet"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"NeighSet2", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"n", "+", "nfacet"}], ",", "i", ",", "1"}], "]"}], 
            "]"}], " ", "=", " ", "n"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet", "]"}], ",", "1"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.640332077995884*^9, 3.640332078620488*^9}, {
   3.640332456924811*^9, 3.640332463634551*^9}, {3.640340316032682*^9, 
   3.640340320243867*^9}, {3.6404229583398323`*^9, 3.6404230888279676`*^9}, 
   3.6404231475913467`*^9, {3.640423261948812*^9, 3.6404232935722733`*^9}, {
   3.6404233889074163`*^9, 3.640423397817692*^9}, {3.640423863896435*^9, 
   3.640423941527401*^9}, {3.640424172550838*^9, 3.640424177581193*^9}, 
   3.640424209020905*^9, {3.640424301981052*^9, 3.6404243185712557`*^9}, {
   3.640424446169828*^9, 3.6404244834961443`*^9}, {3.640424768410573*^9, 
   3.640424818012805*^9}, {3.640424860927931*^9, 3.640425065044519*^9}, {
   3.640425281243373*^9, 3.640425304860812*^9}, {3.640425398058661*^9, 
   3.640425412203158*^9}, {3.640425491999591*^9, 3.6404254950301247`*^9}, {
   3.64042646975826*^9, 3.640426528260635*^9}, {3.6404266584560966`*^9, 
   3.640426663049917*^9}, {3.640426770901443*^9, 3.6404267725662193`*^9}, {
   3.640426813652265*^9, 3.640426836647118*^9}, {3.640427552119269*^9, 
   3.640427553949781*^9}, {3.6404276515227003`*^9, 3.640427658423184*^9}, {
   3.6404277119884443`*^9, 3.640427712346403*^9}, {3.640427787599843*^9, 
   3.6404277881231527`*^9}, {3.6404278328555107`*^9, 3.640427877443561*^9}, {
   3.640427976385783*^9, 3.6404279783929577`*^9}, {3.640428008702923*^9, 
   3.640428034560586*^9}, {3.64042817039966*^9, 3.640428177070702*^9}, {
   3.6406844386954803`*^9, 3.640684575985716*^9}, {3.64068478354797*^9, 
   3.640684858907405*^9}, {3.640684902442089*^9, 3.640685081379978*^9}, {
   3.6406853316128807`*^9, 3.640685417280644*^9}, {3.640685526923223*^9, 
   3.640685528409811*^9}, {3.6406858776726093`*^9, 3.640685993668397*^9}, {
   3.640686037700878*^9, 3.6406861078382263`*^9}, {3.640687131537373*^9, 
   3.640687137146652*^9}, {3.640687220116601*^9, 3.6406872259270353`*^9}, {
   3.640687451034046*^9, 3.640687463494814*^9}, {3.6406878192044897`*^9, 
   3.6406878288336678`*^9}, {3.641014318724269*^9, 3.641014339902055*^9}, {
   3.6410144211446323`*^9, 3.6410145236107817`*^9}, {3.6410146794665823`*^9, 
   3.641014695946385*^9}, {3.641103185152458*^9, 3.641103185302967*^9}, {
   3.676630528822513*^9, 3.676630552555531*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"diagbound", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet2", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], "\[Equal]", " ", 
           RowBox[{"-", "3"}]}], ",", " ", 
          RowBox[{"diagbound", " ", "=", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"diagbound", ",", " ", 
             RowBox[{"{", 
              RowBox[{"n", ",", "i"}], "}"}]}], "]"}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet2", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "diagbound", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.640686139375304*^9, {3.64068696497954*^9, 3.640686967058509*^9}, {
   3.640686999500372*^9, 3.640687002279961*^9}, {3.640687152233717*^9, 
   3.640687153080432*^9}, 3.6406876119610443`*^9, {3.64084025687087*^9, 
   3.6408402890706673`*^9}, {3.641016498203494*^9, 3.641016542380108*^9}, 
   3.641016590558382*^9, {3.641016637823511*^9, 3.64101666568904*^9}, {
   3.641016698125762*^9, 3.641016707600469*^9}, {3.6410169684691257`*^9, 
   3.641016974740045*^9}, {3.641103187570426*^9, 3.6411031877029343`*^9}, 
   3.6411115719041557`*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"NeighSet3", " ", "=", " ", "NeighSet2"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet2", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
           "0"}], ",", " ", 
          RowBox[{
           RowBox[{"NeighSet3", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
           RowBox[{
            RowBox[{"NeighSet2", "[", 
             RowBox[{"[", 
              RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
            RowBox[{"Length", "[", "NeighSet2", "]"}]}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet2", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NeighSet3", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"NeighSet2", ",", " ", "NeighSet3"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NeighSet4", " ", "=", " ", "NeighSet2"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet2", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
           "0"}], ",", " ", 
          RowBox[{
           RowBox[{"NeighSet4", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
           RowBox[{
            RowBox[{"NeighSet2", "[", 
             RowBox[{"[", 
              RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
            RowBox[{"2", 
             RowBox[{"Length", "[", "NeighSet2", "]"}]}]}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet2", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NeighSet4", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"NeighSet3", ",", "NeighSet4"}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"NeighSet5", " ", "=", " ", "NeighSet4"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet4", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
           "0"}], ",", " ", 
          RowBox[{
           RowBox[{"NeighSet5", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
           RowBox[{
            RowBox[{"NeighSet4", "[", 
             RowBox[{"[", 
              RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
            RowBox[{"Length", "[", "NeighSet4", "]"}]}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet4", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NeighSet5", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"NeighSet4", ",", "NeighSet5"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.640332077995884*^9, 3.640332078620488*^9}, {
   3.640332456924811*^9, 3.640332463634551*^9}, {3.640340316032682*^9, 
   3.640340320243867*^9}, {3.6404229583398323`*^9, 3.6404230888279676`*^9}, 
   3.6404231475913467`*^9, {3.640423261948812*^9, 3.6404232935722733`*^9}, {
   3.6404233889074163`*^9, 3.640423397817692*^9}, {3.640423863896435*^9, 
   3.640423941527401*^9}, {3.640424172550838*^9, 3.640424177581193*^9}, 
   3.640424209020905*^9, {3.640424301981052*^9, 3.6404243185712557`*^9}, {
   3.640424446169828*^9, 3.6404244834961443`*^9}, {3.640424768410573*^9, 
   3.640424818012805*^9}, {3.640424860927931*^9, 3.640425065044519*^9}, {
   3.640425281243373*^9, 3.640425304860812*^9}, {3.640425398058661*^9, 
   3.640425412203158*^9}, {3.640425491999591*^9, 3.6404254950301247`*^9}, {
   3.64042646975826*^9, 3.640426528260635*^9}, {3.6404266584560966`*^9, 
   3.640426663049917*^9}, {3.640426770901443*^9, 3.6404267725662193`*^9}, {
   3.640426813652265*^9, 3.640426836647118*^9}, {3.640427552119269*^9, 
   3.640427553949781*^9}, {3.6404276515227003`*^9, 3.640427658423184*^9}, {
   3.6404277119884443`*^9, 3.640427712346403*^9}, {3.640427787599843*^9, 
   3.6404277881231527`*^9}, {3.6404278328555107`*^9, 3.640427877443561*^9}, {
   3.640427976385783*^9, 3.6404279783929577`*^9}, {3.640428008702923*^9, 
   3.640428034560586*^9}, {3.64042817039966*^9, 3.640428177070702*^9}, {
   3.6406844386954803`*^9, 3.640684575985716*^9}, {3.64068478354797*^9, 
   3.640684858907405*^9}, {3.640684902442089*^9, 3.640685081379978*^9}, {
   3.6406853316128807`*^9, 3.640685417280644*^9}, {3.640687844700342*^9, 
   3.640687849704887*^9}, 3.6406879433152933`*^9, {3.640935863934738*^9, 
   3.6409358835192432`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"finding", " ", "neighbours", " ", "at", " ", "the", " ", "x"}], 
    "-", 
    RowBox[{
    "axis", " ", "boundary", " ", "between", " ", "the", " ", "16", " ", 
     "first", " ", "fondamental", " ", "patches"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet5", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "\[Equal]", 
          " ", 
          RowBox[{"-", "1"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", 
               RowBox[{"Intersection", "[", 
                RowBox[{
                 RowBox[{"Floor", "[", 
                  RowBox[{
                   RowBox[{"PolySetComplete", "[", 
                    RowBox[{"[", 
                    RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
                   RowBox[{"10.", "^", 
                    RowBox[{"-", "5"}]}]}], "]"}], ",", 
                 RowBox[{"Floor", "[", 
                  RowBox[{
                   RowBox[{"PolySetComplete", "[", 
                    RowBox[{"[", 
                    RowBox[{"m", ",", "2"}], "]"}], "]"}], ",", 
                   RowBox[{"10.", "^", 
                    RowBox[{"-", "5"}]}]}], "]"}]}], "]"}], "]"}], " ", ">", 
              " ", "1"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"NeighSet5", "[", 
                RowBox[{"[", 
                 RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "=", 
               " ", "m"}], ";", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"NeighSet5", "[", 
                RowBox[{"[", 
                 RowBox[{"m", ",", "i", ",", "1"}], "]"}], "]"}], " ", "=", 
               " ", "n"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", 
             RowBox[{"n", "+", "nfacet"}], ",", 
             RowBox[{"Length", "[", "NeighSet5", "]"}], ",", "nfacet"}], 
            "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet5", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.640687945822262*^9, 3.6406879818388653`*^9}, {
  3.64068806120009*^9, 3.6406881038569393`*^9}, {3.6406908951713333`*^9, 
  3.6406909234190702`*^9}, {3.6406909917523203`*^9, 3.640691193135043*^9}, {
  3.640691266613345*^9, 3.640691323468849*^9}, {3.6408799274001713`*^9, 
  3.6408799521684513`*^9}, {3.640879998917338*^9, 3.640880001961788*^9}, {
  3.641111603321965*^9, 3.6411116034476643`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "check", " ", "that", " ", "all", " ", "neighbours", " ", "have", " ", 
    "been", " ", "found"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"xbound", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NeighSet5", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], "\[Equal]", " ", 
           RowBox[{"-", "1"}]}], ",", " ", 
          RowBox[{"xbound", " ", "=", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"xbound", ",", " ", 
             RowBox[{"{", 
              RowBox[{"n", ",", "i"}], "}"}]}], "]"}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet5", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "xbound", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"PolySetComplete", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"xbound", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"PolySetComplete", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"xbound", "[", 
         RowBox[{"[", 
          RowBox[{"73", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Intersection", "[", 
      RowBox[{
       RowBox[{"Floor", "[", 
        RowBox[{
         RowBox[{"PolySetComplete", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"xbound", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}],
          ",", 
         RowBox[{"10.", "^", 
          RowBox[{"-", "5"}]}]}], "]"}], ",", 
       RowBox[{"Floor", "[", 
        RowBox[{
         RowBox[{"PolySetComplete", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"xbound", "[", 
             RowBox[{"[", 
              RowBox[{"73", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], 
          "]"}], ",", 
         RowBox[{"10.", "^", 
          RowBox[{"-", "5"}]}]}], "]"}]}], "]"}], "\[IndentingNewLine]", 
     RowBox[{"PolySetComplete", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"xbound", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", "2"}], "]"}], "]"}]}],
     "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.640688127197997*^9, 3.6406881322333393`*^9}, {
  3.640840002323217*^9, 3.640840113422427*^9}, {3.640840157264138*^9, 
  3.640840200616824*^9}, {3.640842751330616*^9, 3.640842803769395*^9}, {
  3.640849017434677*^9, 3.640849050485177*^9}, {3.640853273645331*^9, 
  3.640853478590393*^9}, {3.640879850032454*^9, 3.640879894920781*^9}, {
  3.6409294866275167`*^9, 3.640929489886845*^9}, {3.6766305744169817`*^9, 
  3.676630584566256*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NeighSet6", " ", "=", " ", "NeighSet5"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet5", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
          "0"}], ",", " ", 
         RowBox[{
          RowBox[{"NeighSet6", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
          RowBox[{
           RowBox[{"NeighSet5", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
           RowBox[{"Length", "[", "NeighSet5", "]"}]}]}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", 
      RowBox[{"Length", "[", "NeighSet5", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NeighSet6", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"NeighSet5", ",", "NeighSet6"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NeighSet7", " ", "=", " ", "NeighSet6"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet6", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
          "0"}], ",", " ", 
         RowBox[{
          RowBox[{"NeighSet7", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
          RowBox[{
           RowBox[{"NeighSet6", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
           RowBox[{"Length", "[", "NeighSet6", "]"}]}]}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", 
      RowBox[{"Length", "[", "NeighSet6", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NeighSet7", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"NeighSet6", ",", "NeighSet7"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NeighSet8", " ", "=", " ", "NeighSet7"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet7", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
          "0"}], ",", " ", 
         RowBox[{
          RowBox[{"NeighSet8", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "=", " ", 
          RowBox[{
           RowBox[{"NeighSet7", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "k", ",", "1"}], "]"}], "]"}], "+", " ", 
           RowBox[{"Length", "[", "NeighSet7", "]"}]}]}]}], "]"}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", 
      RowBox[{"Length", "[", "NeighSet7", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NeighSet8", " ", "=", " ", 
    RowBox[{"Join", "[", 
     RowBox[{"NeighSet7", ",", "NeighSet8"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"NeighSet8", " ", "=", " ", "NeighSet6"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "NeighSet8", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.640332077995884*^9, 3.640332078620488*^9}, {
   3.640332456924811*^9, 3.640332463634551*^9}, {3.640340316032682*^9, 
   3.640340320243867*^9}, {3.6404229583398323`*^9, 3.6404230888279676`*^9}, 
   3.6404231475913467`*^9, {3.640423261948812*^9, 3.6404232935722733`*^9}, {
   3.6404233889074163`*^9, 3.640423397817692*^9}, {3.640423863896435*^9, 
   3.640423886802383*^9}, {3.640424219003456*^9, 3.640424279164687*^9}, {
   3.640424502728818*^9, 3.640424547074739*^9}, {3.640424822848504*^9, 
   3.640424824309338*^9}, {3.6404250777117577`*^9, 3.6404250960038757`*^9}, {
   3.640425129854185*^9, 3.640425158671431*^9}, {3.64042520340695*^9, 
   3.640425212235572*^9}, {3.640425251506681*^9, 3.640425255598895*^9}, {
   3.640425437748254*^9, 3.6404254479192533`*^9}, {3.6404265642282*^9, 
   3.64042661188011*^9}, {3.64042666766238*^9, 3.640426740356492*^9}, {
   3.640426783433247*^9, 3.640426783520843*^9}, {3.640427519035925*^9, 
   3.640427519138008*^9}, {3.6404275711609077`*^9, 3.640427609540833*^9}, {
   3.6404276794680233`*^9, 3.640427700830583*^9}, {3.6404277943127613`*^9, 
   3.6404277945782013`*^9}, {3.64042786189898*^9, 3.64042789385915*^9}, {
   3.640427988740315*^9, 3.640427989849402*^9}, {3.640428043722912*^9, 
   3.640428056246602*^9}, {3.6404281845686703`*^9, 3.640428196664426*^9}, {
   3.6406903281863623`*^9, 3.6406904413031054`*^9}, {3.64069057830147*^9, 
   3.640690578735074*^9}, {3.6406907614789133`*^9, 3.6406907648418493`*^9}, {
   3.640691340410615*^9, 3.640691344963374*^9}, {3.640748818596933*^9, 
   3.6407488773852386`*^9}, {3.640748921022789*^9, 3.6407489637895947`*^9}, {
   3.640748997482149*^9, 3.640749089932219*^9}, {3.640929354443137*^9, 
   3.640929368596179*^9}, {3.640934144901545*^9, 3.6409341532920218`*^9}, 
   3.641309662582796*^9, 3.641540289274613*^9, 3.641560329631329*^9, 
   3.643613812267024*^9, {3.643624896510806*^9, 3.643624907446886*^9}, {
   3.643631075925161*^9, 3.643631081514958*^9}, {3.64422788524687*^9, 
   3.644227905550384*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Finding", " ", "boundary", " ", "neighbours", " ", "attached", " ", "via",
     " ", "the", " ", "circular", " ", "part", " ", "of", " ", "the", " ", 
    "patch", " ", "in", " ", "the", " ", "bulk", " ", "of", " ", "the", " ", 
    "cubic", " ", "cell"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NeighSet8", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "\[Equal]", 
          " ", 
          RowBox[{"-", "2"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", 
               RowBox[{"Intersection", "[", 
                RowBox[{
                 RowBox[{"Floor", "[", 
                  RowBox[{
                   RowBox[{"PolySetComplete", "[", 
                    RowBox[{"[", 
                    RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
                   RowBox[{"10.", "^", 
                    RowBox[{"-", "5"}]}]}], "]"}], ",", 
                 RowBox[{"Floor", "[", 
                  RowBox[{
                   RowBox[{"PolySetComplete", "[", 
                    RowBox[{"[", 
                    RowBox[{"m", ",", "2"}], "]"}], "]"}], ",", 
                   RowBox[{"10.", "^", 
                    RowBox[{"-", "5"}]}]}], "]"}]}], "]"}], "]"}], " ", ">", 
              " ", "0"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"NeighSet8", "[", 
                RowBox[{"[", 
                 RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", "=", 
               " ", "m"}], ";", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"NeighSet8", "[", 
                RowBox[{"[", 
                 RowBox[{"m", ",", "i", ",", "1"}], "]"}], "]"}], " ", "=", 
               " ", "n"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
           "\[IndentingNewLine]", ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", 
             RowBox[{"n", "+", "nfacet"}], ",", 
             RowBox[{"Length", "[", "NeighSet8", "]"}], ",", "nfacet"}], 
            "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "NeighSet8", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.640749095196342*^9, 3.640749167889029*^9}, {
  3.640749234189843*^9, 3.640749234671527*^9}, {3.640749347315041*^9, 
  3.640749389391238*^9}, {3.640880040438416*^9, 3.640880067248782*^9}, {
  3.641103167586399*^9, 3.64110316767977*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Print", " ", "the", " ", "Neighbours", " ", "to", " ", "file", " ", "to", 
    " ", "be", " ", "read", " ", "by", " ", "the", " ", "MC", " ", "code"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"title", " ", "=", 
      RowBox[{"FileNameJoin", "@", 
       RowBox[{"{", 
        RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
         RowBox[{"ToString", "[", "n", "]"}], "<>", "\"\<.txt\>\""}], 
        "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"str", " ", "=", " ", 
      RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"k", " ", "=", " ", 
          RowBox[{"NeighSet8", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"dummy", " ", "=", " ", 
          RowBox[{"FortranForm", "[", 
           RowBox[{"NeighSet8", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "i", ",", "2"}], "]"}], "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"NeighSet8", "[", 
             RowBox[{"[", 
              RowBox[{"n", ",", "i", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
            "0"}], ",", 
           RowBox[{
            RowBox[{"WriteString", "[", 
             RowBox[{
             "str", ",", "k", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
              "\"\<\\n\>\""}], "]"}], ";"}]}], "]"}]}], "\[IndentingNewLine]",
         ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "str", "]"}]}], ";"}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", 
      RowBox[{"Length", "[", "NeighSet8", "]"}], ",", "1"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.640749729726288*^9, 3.640749761572908*^9}, {
  3.640750109832562*^9, 3.640750176511042*^9}, {3.640750208366499*^9, 
  3.6407502929538918`*^9}, {3.640750347249185*^9, 3.6407504077203617`*^9}, {
  3.640750740567417*^9, 3.640750796558908*^9}, {3.6407510954474583`*^9, 
  3.640751130302135*^9}, {3.64075145622586*^9, 3.640751465685112*^9}, {
  3.640934164074696*^9, 3.640934168760851*^9}, {3.64093523943381*^9, 
  3.6409352450625277`*^9}, {3.6413096687999268`*^9, 3.6413096694277983`*^9}, {
  3.641927198281437*^9, 3.641927198998897*^9}, {3.643613873821144*^9, 
  3.643613876206912*^9}, {3.643624936127198*^9, 3.643624937817369*^9}, {
  3.6442279410054827`*^9, 3.644227942702915*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "print", " ", "area", " ", "and", " ", "curvature", " ", "fields"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"str", " ", "=", " ", 
     RowBox[{"OpenWrite", "[", "\"\<toto1.txt\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str1", " ", "=", " ", 
     RowBox[{"OpenWrite", "[", "\"\<titi1.txt\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"dummy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"G", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
       "ensures", " ", "that", " ", "the", " ", "output", " ", "is", " ", 
        "in", " ", "a", " ", "readable", " ", "format", " ", "for", " ", 
        "the", " ", "C", " ", "or", " ", "Fortran", " ", "code"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Write", "[", 
       RowBox[{"str", ",", " ", "dummy"}], "]"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"dummy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"A", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
       "ensures", " ", "that", " ", "the", " ", "output", " ", "is", " ", 
        "in", " ", "a", " ", "readable", " ", "format", " ", "for", " ", 
        "the", " ", "C", " ", "or", " ", "Fortran", " ", "code"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Write", "[", 
       RowBox[{"str1", ",", " ", "dummy"}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "G", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "str", "]"}], ";", " ", 
    RowBox[{"Close", "[", "str1", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6409305375454617`*^9, 3.64093056762844*^9}, {
  3.641111678384635*^9, 3.6411116830458727`*^9}, {3.641309677113879*^9, 
  3.6413096812905893`*^9}, {3.641540403788557*^9, 3.641540408746331*^9}, {
  3.641560438611361*^9, 3.641560443750486*^9}, {3.6436139477939997`*^9, 
  3.64361395044913*^9}, {3.643626182790848*^9, 3.6436261886737127`*^9}, {
  3.646646853987583*^9, 3.646646857171891*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Let", "'"}], "s", " ", "look", " ", "for", " ", "neighbours", 
    " ", "due", " ", "to", " ", "periodic", " ", "boundary", " ", 
    "conditions"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Boundaryxplus", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "List", " ", "of", " ", "cell", " ", "numbers", " ", "belonging", " ", 
     "to", " ", "the", " ", "boundary"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}], 
          "]"}], " ", "==", " ", "1."}], ",", " ", 
        RowBox[{"Boundaryxplus", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Boundaryxplus", ",", " ", "i"}], "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Boundaryxminus", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "List", " ", "of", " ", "cell", " ", "numbers", " ", "belonging", " ", 
     "to", " ", "the", " ", "boundary"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2", ",", "All", ",", "1"}], "]"}], "]"}], 
          "]"}], " ", "==", " ", 
         RowBox[{"-", "1."}]}], ",", " ", 
        RowBox[{"Boundaryxminus", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Boundaryxminus", ",", " ", "i"}], "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Boundaryyplus", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "List", " ", "of", " ", "cell", " ", "numbers", " ", "belonging", " ", 
     "to", " ", "the", " ", "boundary"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}], 
          "]"}], " ", "==", " ", "1."}], ",", " ", 
        RowBox[{"Boundaryyplus", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Boundaryyplus", ",", " ", "i"}], "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Boundaryyminus", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "List", " ", "of", " ", "cell", " ", "numbers", " ", "belonging", " ", 
     "to", " ", "the", " ", "boundary"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2", ",", "All", ",", "2"}], "]"}], "]"}], 
          "]"}], " ", "==", " ", 
         RowBox[{"-", "1."}]}], ",", " ", 
        RowBox[{"Boundaryyminus", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Boundaryyminus", ",", " ", "i"}], "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Boundaryzplus", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "List", " ", "of", " ", "cell", " ", "numbers", " ", "belonging", " ", 
     "to", " ", "the", " ", "boundary"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}], 
          "]"}], " ", "==", " ", "1."}], ",", " ", 
        RowBox[{"Boundaryzplus", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Boundaryzplus", ",", " ", "i"}], "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Boundaryzminus", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "List", " ", "of", " ", "cell", " ", "numbers", " ", "belonging", " ", 
     "to", " ", "the", " ", "boundary"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2", ",", "All", ",", "3"}], "]"}], "]"}], 
          "]"}], " ", "==", " ", 
         RowBox[{"-", "1."}]}], ",", " ", 
        RowBox[{"Boundaryzminus", " ", "=", " ", 
         RowBox[{"Append", "[", 
          RowBox[{"Boundaryzminus", ",", " ", "i"}], "]"}]}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySetComplete", "]"}], ",", "1"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{3.6407504160877247`*^9, 3.640750454107871*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
  "Boundaryxplus", "\[IndentingNewLine]", "Boundaryxminus", 
   "\[IndentingNewLine]", "Boundaryyplus", "\[IndentingNewLine]", 
   "Boundaryyminus", "\[IndentingNewLine]", "Boundaryzplus", 
   "\[IndentingNewLine]", "Boundaryzminus", "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "Boundaryxplus", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "Boundaryxminus", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "Boundaryyplus", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "Boundaryyminus", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "Boundaryzplus", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "Boundaryzminus", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.640750491158749*^9, 3.640750492609819*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"Let", "'"}], "s", " ", "now", " ", "append", " ", "the", " ", 
     "neighbour", " ", "files", " ", "for", " ", "those", " ", "cells", " ", 
     "which", " ", "lie", " ", "at", " ", "the", " ", 
     RowBox[{"boundary", ".", " ", "By"}], " ", "default"}], ",", " ", 
    RowBox[{
    "the", " ", "following", " ", "code", " ", "updates", " ", "neighbour", 
     "\[IndentingNewLine]", "files", " ", "located", " ", "in", " ", "the", 
     " ", "folder", " ", "NeighbourFiles", " ", "but", " ", "for", " ", 
     "safety", " ", "a", " ", "backup", " ", "of", " ", "the", " ", "bulk", 
     " ", "neighbours", " ", "files", " ", "is", " ", "kept", " ", "in", " ", 
     "folder", " ", "NeighbourFilesOld"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Do", "[", " ", 
    RowBox[{"(*", 
     RowBox[{
     "Append", " ", "the", " ", "files", " ", "of", " ", "the", " ", "cells", 
      " ", "belonging", " ", "to", " ", "the", " ", "x", " ", "boundaries", 
      " ", "by", " ", "adding", " ", "their", " ", "missing", " ", 
      "neighbour", " ", "owing", " ", "to", " ", "periodic", " ", "boundary", 
      " ", "conditions"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"kmin", " ", "=", " ", 
       RowBox[{"Boundaryxminus", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"kmax", " ", "=", " ", 
       RowBox[{"Boundaryxplus", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"t", " ", "=", " ", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"PolySetComplete", "[", 
          RowBox[{"[", 
           RowBox[{"kmin", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{"Min", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"kmin", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
       "returns", " ", "the", " ", "label", " ", "of", " ", "the", " ", 
        "points", " ", "of", " ", "cell", " ", "kmin", " ", "which", " ", 
        "contain", " ", "the", " ", "minimum", " ", "number", " ", "in", " ", 
        
        RowBox[{"PolySetComplete", "[", 
         RowBox[{"[", 
          RowBox[{"kmin", ",", "2"}], "]"}], "]"}], " ", 
        RowBox[{"i", ".", "e", ".", " ", 
         RowBox[{"-", "1."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "t", "]"}], " ", "\[Equal]", " ", "2"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"norm", " ", "=", " ", 
          RowBox[{"Norm", "[", 
           RowBox[{
            RowBox[{"PolySetComplete", "[", 
             RowBox[{"[", 
              RowBox[{"kmin", ",", "2", ",", 
               RowBox[{"t", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], "-", 
            RowBox[{"PolySetComplete", "[", 
             RowBox[{"[", 
              RowBox[{"kmin", ",", "2", ",", 
               RowBox[{"t", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"dummy", " ", "=", " ", 
          RowBox[{"FortranForm", "[", "norm", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"title", " ", "=", 
          RowBox[{"FileNameJoin", "@", 
           RowBox[{"{", 
            RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
             RowBox[{"ToString", "[", "kmin", "]"}], "<>", "\"\<.txt\>\""}], 
            "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"str", " ", "=", " ", 
          RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"WriteString", "[", 
          RowBox[{
          "str", ",", "kmax", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
           "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "str", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"title", " ", "=", 
          RowBox[{"FileNameJoin", "@", 
           RowBox[{"{", 
            RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
             RowBox[{"ToString", "[", "kmax", "]"}], "<>", "\"\<.txt\>\""}], 
            "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"str", " ", "=", " ", 
          RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"WriteString", "[", 
          RowBox[{
          "str", ",", "kmin", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
           "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "str", "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}]}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "Boundaryxminus", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Do", "[", " ", 
    RowBox[{"(*", 
     RowBox[{
     "Append", " ", "the", " ", "files", " ", "of", " ", "the", " ", "cells", 
      " ", "belonging", " ", "to", " ", "the", " ", "y", " ", "boundaries", 
      " ", "by", " ", "adding", " ", "their", " ", "missing", " ", 
      "neighbour", " ", "owing", " ", "to", " ", "periodic", " ", "boundary", 
      " ", "conditions"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"kmin", " ", "=", " ", 
       RowBox[{"Boundaryyminus", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"kmax", " ", "=", " ", 
       RowBox[{"Boundaryyplus", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"t", " ", "=", " ", 
       RowBox[{"Position", "[", 
        RowBox[{
         RowBox[{"PolySetComplete", "[", 
          RowBox[{"[", 
           RowBox[{"kmin", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{"Min", "[", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"kmin", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "t", "]"}], " ", "\[Equal]", " ", "2"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"norm", " ", "=", " ", 
          RowBox[{"Norm", "[", 
           RowBox[{
            RowBox[{"PolySetComplete", "[", 
             RowBox[{"[", 
              RowBox[{"kmin", ",", "2", ",", 
               RowBox[{"t", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], "-", 
            RowBox[{"PolySetComplete", "[", 
             RowBox[{"[", 
              RowBox[{"kmin", ",", "2", ",", 
               RowBox[{"t", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"dummy", " ", "=", " ", 
          RowBox[{"FortranForm", "[", "norm", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"title", " ", "=", 
          RowBox[{"FileNameJoin", "@", 
           RowBox[{"{", 
            RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
             RowBox[{"ToString", "[", "kmin", "]"}], "<>", "\"\<.txt\>\""}], 
            "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"str", " ", "=", " ", 
          RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"WriteString", "[", 
          RowBox[{
          "str", ",", "kmax", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
           "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "str", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"title", " ", "=", 
          RowBox[{"FileNameJoin", "@", 
           RowBox[{"{", 
            RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
             RowBox[{"ToString", "[", "kmax", "]"}], "<>", "\"\<.txt\>\""}], 
            "}"}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"str", " ", "=", " ", 
          RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"WriteString", "[", 
          RowBox[{
          "str", ",", "kmin", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
           "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "str", "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}]}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "Boundaryxminus", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", " ", 
     RowBox[{"(*", 
      RowBox[{
      "Append", " ", "the", " ", "files", " ", "of", " ", "the", " ", "cells",
        " ", "belonging", " ", "to", " ", "the", " ", "z", " ", "boundaries", 
       " ", "by", " ", "adding", " ", "their", " ", "missing", " ", 
       "neighbour", " ", "owing", " ", "to", " ", "periodic", " ", "boundary",
        " ", "conditions"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"kmin", " ", "=", " ", 
        RowBox[{"Boundaryzminus", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"kmax", " ", "=", " ", 
        RowBox[{"Boundaryzplus", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"t", " ", "=", " ", 
        RowBox[{"Position", "[", 
         RowBox[{
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"kmin", ",", "2"}], "]"}], "]"}], ",", " ", 
          RowBox[{"Min", "[", 
           RowBox[{"PolySetComplete", "[", 
            RowBox[{"[", 
             RowBox[{"kmin", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "t", "]"}], " ", "\[Equal]", " ", "2"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"norm", " ", "=", " ", 
           RowBox[{"Norm", "[", 
            RowBox[{
             RowBox[{"PolySetComplete", "[", 
              RowBox[{"[", 
               RowBox[{"kmin", ",", "2", ",", 
                RowBox[{"t", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}], "-", 
             
             RowBox[{"PolySetComplete", "[", 
              RowBox[{"[", 
               RowBox[{"kmin", ",", "2", ",", 
                RowBox[{"t", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "]"}], "]"}]}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"dummy", " ", "=", " ", 
           RowBox[{"FortranForm", "[", "norm", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"title", " ", "=", 
           RowBox[{"FileNameJoin", "@", 
            RowBox[{"{", 
             RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
              RowBox[{"ToString", "[", "kmin", "]"}], "<>", "\"\<.txt\>\""}], 
             "}"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"str", " ", "=", " ", 
           RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{
           "str", ",", "kmax", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
            "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Close", "[", "str", "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"title", " ", "=", 
           RowBox[{"FileNameJoin", "@", 
            RowBox[{"{", 
             RowBox[{"\"\<NeighboursFilesNewNew96-patch/\>\"", "<>", 
              RowBox[{"ToString", "[", "kmax", "]"}], "<>", "\"\<.txt\>\""}], 
             "}"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"str", " ", "=", " ", 
           RowBox[{"OpenAppend", "[", "title", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{
           "str", ",", "kmin", ",", "\"\< \>\"", ",", "dummy", ",", " ", 
            "\"\<\\n\>\""}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Close", "[", "str", "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}]}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "Boundaryxminus", "]"}], ",", "1"}], "}"}]}], 
     "]"}], "//", "AbsoluteTiming"}]}]}]], "Input",
 CellChangeTimes->{{3.640750496101651*^9, 3.6407505115222483`*^9}, {
  3.640750628263688*^9, 3.640750662632125*^9}, {3.6442279952503967`*^9, 
  3.644228017474636*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.6404252474774427`*^9, 3.640425249994318*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"NeighSet8", "[", 
   RowBox[{"[", "7403", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.641492509815218*^9, 3.641492549190878*^9}, {
  3.641492671259431*^9, 3.641492671383157*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CMList", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"cm", " ", "=", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "2", ",", "1"}], "]"}], "]"}], "+", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "2", ",", "2"}], "]"}], "]"}], "+", 
          RowBox[{"PolySetComplete", "[", 
           RowBox[{"[", 
            RowBox[{"n", ",", "2", ",", "3"}], "]"}], "]"}]}], ")"}], "/", 
        "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"CMList", " ", "=", " ", 
       RowBox[{"Append", "[", 
        RowBox[{"CMList", ",", " ", "cm"}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySet", "]"}], ",", "1"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.6416428559809923`*^9, {3.641642889435236*^9, 3.641642927031143*^9}, {
   3.6416429694617167`*^9, 3.641643010299532*^9}, {3.641643047743079*^9, 
   3.641643060995775*^9}, {3.641643094073227*^9, 3.641643133439559*^9}, {
   3.641643227855994*^9, 3.64164325421251*^9}, {3.641645357476544*^9, 
   3.6416454091853857`*^9}, {3.641646453239788*^9, 3.641646458799185*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"print", " ", "CMList", " ", "to", " ", "file"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"str", " ", "=", " ", 
     RowBox[{"OpenWrite", "[", "\"\<CMListNewNew.txt\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"dummyx", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"CMList", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dummyy", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"CMList", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dummyz", " ", "=", " ", 
       RowBox[{"FortranForm", "[", 
        RowBox[{"CMList", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "3"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{
       "str", ",", "dummyx", ",", "\"\< \>\"", ",", "dummyy", ",", 
        "\"\< \>\"", ",", "dummyz", ",", " ", "\"\<\\n\>\""}], "]"}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "PolySet", "]"}], ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Close", "[", "str", "]"}], ";"}], " "}]}]], "Input",
 CellChangeTimes->{{3.6416463837427187`*^9, 3.6416464421333437`*^9}, {
  3.64164647283506*^9, 3.641646597620516*^9}, {3.6419274123059196`*^9, 
  3.641927414995882*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Finding", " ", "a", " ", "LefttoRight", " ", "vector", " ", "to", " ", 
    "sort", " ", "the", " ", "cells", " ", "found", " ", "at", " ", "the", 
    " ", "interface", " ", "in", " ", "the", " ", "MC", " ", "code"}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CMList", "[", 
    RowBox[{"[", "1718", "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LeftBorder", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NeighSet", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "k", ",", "1"}], "]"}], "]"}], " ", 
             "\[Equal]", " ", 
             RowBox[{"-", "3"}]}], " ", ",", " ", 
            RowBox[{"a", "=", " ", "1"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"a", " ", "\[Equal]", " ", "1"}], ",", " ", 
         RowBox[{"LeftBorder", " ", "=", " ", 
          RowBox[{"Append", "[", 
           RowBox[{"LeftBorder", ",", " ", "i"}], "]"}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "nfacet", ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "LeftBorder", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RightBorder", " ", "=", " ", 
     RowBox[{"List", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NeighSet", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "k", ",", "1"}], "]"}], "]"}], " ", 
             "\[Equal]", " ", 
             RowBox[{"-", "1"}]}], " ", ",", " ", 
            RowBox[{"a", "=", " ", "1"}]}], "]"}], ";"}], 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "3", ",", "1"}], "}"}]}], "]"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"a", " ", "\[Equal]", " ", "1"}], ",", " ", 
         RowBox[{"RightBorder", " ", "=", " ", 
          RowBox[{"Append", "[", 
           RowBox[{"RightBorder", ",", " ", "i"}], "]"}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "nfacet", ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "RightBorder", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "the", " ", "cell", " ", "1718", " ", "for", " ", "density", " ", "0.05", 
     " ", "seems", " ", "doing", " ", "the", " ", "job", " ", "fine"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dist", " ", "=", " ", "3000"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"diff", " ", "=", " ", 
       RowBox[{
        RowBox[{"CMList", "[", 
         RowBox[{"[", "1718", "]"}], "]"}], "-", 
        RowBox[{"CMList", "[", 
         RowBox[{"[", 
          RowBox[{"RightBorder", "[", 
           RowBox[{"[", "n", "]"}], "]"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"d", " ", "=", " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"diff", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
         RowBox[{
          RowBox[{"diff", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], "+", 
         RowBox[{
          RowBox[{"diff", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"d", " ", "<", " ", "dist"}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"nmin", " ", "=", " ", 
          RowBox[{"RightBorder", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"dist", " ", "=", " ", "d"}], ";"}]}], "\[IndentingNewLine]",
        "]"}], ";"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       RowBox[{"Length", "[", "RightBorder", "]"}], ",", "1"}], "}"}]}], 
    "]"}], "\[IndentingNewLine]", "nmin", "\[IndentingNewLine]"}]}]], "Input",\

 CellChangeTimes->{{3.642326522510921*^9, 3.642326578748178*^9}, {
  3.6423266304476423`*^9, 3.642326827220118*^9}, {3.642327018483255*^9, 
  3.6423270392816*^9}, {3.642327082789673*^9, 3.642327168993751*^9}, {
  3.6423272006393547`*^9, 3.6423273236921473`*^9}, {3.6423273912090483`*^9, 
  3.642327391318536*^9}, {3.6423274451158237`*^9, 3.6423274616326303`*^9}, {
  3.6423275918784103`*^9, 3.6423276506522007`*^9}, {3.642328096315003*^9, 
  3.642328167426403*^9}, {3.642495422609756*^9, 3.6424954759796953`*^9}, {
  3.642496968212385*^9, 3.6424969919522343`*^9}, {3.6424977309465113`*^9, 
  3.642497804364645*^9}, {3.6424978374767857`*^9, 3.642497943161358*^9}, {
  3.642497985284574*^9, 3.642497993132831*^9}, {3.642498097647718*^9, 
  3.6424981036341953`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"d1", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0.5", ",", "0.5"}], "}"}]}], "\[IndentingNewLine]", 
   
   RowBox[{"d2", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0.", ",", "0.5", ",", "0."}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{"d1", "+", "d2"}], "\[IndentingNewLine]", 
   RowBox[{"Norm", "[", "d1", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.647325464950242*^9, 3.647325486329561*^9}, {
  3.647336149844693*^9, 3.647336172260145*^9}}],

Cell[BoxData[{
 RowBox[{"Histogram", "[", "A", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"StandardDeviation", "[", "A", "]"}], "/", 
  RowBox[{"Mean", "[", "A", "]"}]}]}], "Input",
 CellChangeTimes->{{3.647687745852249*^9, 3.647687835054945*^9}, {
  3.647699131434209*^9, 3.647699135291657*^9}}]
},
WindowSize->{1174, 715},
WindowMargins->{{Automatic, 32}, {Automatic, 0}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 11, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 178, 3, 46, "Input"],
Cell[739, 25, 8350, 216, 726, "Input"],
Cell[9092, 243, 141, 4, 28, "Input"],
Cell[9236, 249, 3456, 99, 404, "Input"],
Cell[12695, 350, 2793, 70, 182, "Input"],
Cell[15491, 422, 30095, 768, 1916, "Input"],
Cell[45589, 1192, 4640, 65, 46, "Input"],
Cell[50232, 1259, 7035, 123, 148, "Input"],
Cell[57270, 1384, 6054, 95, 114, "Input"],
Cell[63327, 1481, 91, 1, 28, "Input"],
Cell[63421, 1484, 9106, 195, 454, "Input"],
Cell[72530, 1681, 4363, 105, 318, "Input"],
Cell[76896, 1788, 90, 1, 28, "Input"],
Cell[76989, 1791, 8714, 206, 454, "Input"],
Cell[85706, 1999, 5553, 112, 199, "Input"],
Cell[91262, 2113, 1751, 44, 199, "Input"],
Cell[93016, 2159, 4403, 97, 352, "Input"],
Cell[97422, 2258, 7437, 192, 471, "Input"],
Cell[104862, 2452, 2068, 53, 182, "Input"],
Cell[106933, 2507, 5038, 125, 505, "Input"],
Cell[111974, 2634, 3152, 79, 301, "Input"],
Cell[115129, 2715, 2835, 68, 301, "Input"],
Cell[117967, 2785, 8789, 192, 471, "Input"],
Cell[126759, 2979, 3509, 69, 176, "Input"],
Cell[130271, 3050, 7065, 147, 454, "Input"],
Cell[137339, 3199, 1724, 39, 165, "Input"],
Cell[139066, 3240, 5923, 137, 437, "Input"],
Cell[144992, 3379, 3209, 76, 250, "Input"],
Cell[148204, 3457, 3288, 88, 216, "Input"],
Cell[151495, 3547, 6308, 148, 471, "Input"],
Cell[157806, 3697, 3078, 72, 250, "Input"],
Cell[160887, 3771, 2819, 63, 216, "Input"],
Cell[163709, 3836, 2356, 56, 199, "Input"],
Cell[166068, 3894, 6347, 167, 386, "Input"],
Cell[172418, 4063, 818, 13, 233, "Input"],
Cell[173239, 4078, 13021, 287, 1066, "Input"],
Cell[186263, 4367, 94, 1, 28, "Input"],
Cell[186360, 4370, 240, 5, 46, "Input"],
Cell[186603, 4377, 1501, 36, 114, "Input"],
Cell[188107, 4415, 1704, 44, 182, "Input"],
Cell[189814, 4461, 5635, 135, 556, "Input"],
Cell[195452, 4598, 539, 13, 97, "Input"],
Cell[195994, 4613, 304, 6, 46, "Input"]
}
]
*)

