#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>

double a1;
double lambda;
double beta; //= 10000;//inverse temperature as usual
double k[2];//species preference for curvature
double Area;
double A1;
int N1;
int *Sint;//an array of size N where the first m elements are the labels of the cells at the red-green interface
int IntSize;//number of points in the "chain" delimiting the interface
double ***J;//Ising-like parameter //J[i][j][0] is the site number of the jth neighbour of site i and J[i][j][1] is the interaction between sites i and site J[i][j][0]
double **CM;
int N;//N is the number of voronoi cells on the surface for one cubic cell
double *G;//gaussian curvature field to be imported from mathematica
double *A;//tile area field to be imported from mathematica too
int *SortedArray;//Array in which the numbers of the 1s are written first and that the 0s after; the MC move consists then in swapping a 0 and a 1
double E;//total energy
double Eline; //line tension energy
double Ecurv; //curvature energy
int *S;//scpecies type represented by an Ising 0 or 1 variable
int *Neighcard;//Cardinality field of the set of neighbours
int count; //counts the MC successes for the rejection criterion
int totcount;//counts the number of times an actual MC move has be tried
long int nstep;
double length;
int LeftCell;
int RightCell;
double *VecDirector;

/************************
 **       XOR
 **  xor returns 1 iff
 **  only one of its
 **  arguments is 1
 ************************/
int xor(int a, int b)
{
    int c;
    c = (a==0 && b==1)||(a==1 && b==0);
    return c;
}

/*********************************************
 **                ALEA
 **    generates a real random number between a
 **                    and b
 *********************************************/
double alea(double a, double b)
{
    double x;
    x = (double)(((double)rand())/RAND_MAX);
    x = a + x*(b-a);
    return x;
}

/*********************************************
 **                   DOT
 **  calculate the scalar product between
 **             two vectors
 *********************************************/
double dot(double *p1, double *p2)
{
    double scalar = 0.;
    int i;
    for (i = 0; i < 3; i++)
    {
        scalar += p1[i]*p2[i];
    }
    return scalar;
}


/*********************************************
 **                   D
 **  calculate the eucidean distance between
 **             two vectors
 *********************************************/
double d(double *p1, double *p2)
{
    double dist = 0.;
    int i;
    for (i = 0; i < 3; i++)
    {
        dist += (p2[i]-p1[i])*(p2[i]-p1[i]);
    }
    return sqrt(dist);
}


/**************************************************
 **                     GETN
 ** return the number of lines in the file in
 ** argument
 **************************************************/
int getn (char* filename)
{
    FILE *fp;
    fp = fopen (filename, "r");
    float g;
    int returnvalue;
    int count = 0;
    while(!(feof (fp)))
    {
        returnvalue = fscanf (fp, "%f ", &g);
        count++;
    }
    fclose (fp);
    return count;
}

/**************************************************
 **                     GETG
 ** Get the gaussian cruvature field values from 
 ** the first file
 **************************************************/
void getg (char* filename)
{
    FILE *fp;
    fp = fopen (filename, "r");
    int i = 0;
    int returnvalue;
    while(!(feof (fp)))
    {
        returnvalue = fscanf (fp, "%lf ", &G[i]);
        i++;
    }
        fclose (fp);
}

/**************************************************
 **                     GETA
 ** Get the 3D Voronoi area field values from the
 ** second file
 **************************************************/
void geta (char* filename)
{
    FILE *fp;
    fp = fopen (filename, "r");
    int i = 0;
    int returnvalue;
    while(!(feof (fp)))
    {
        returnvalue = fscanf (fp, "%lf ", &A[i]);
        i++;
    }
    fclose (fp);
}

/**************************************************
 **                     GETS
 ** Get the S field values from the third file
 **************************************************/
void getS (void)
{
    FILE *fs;
    int p = 0;
    int returnvalue;
    int dummy;
    int n;
    //char filename[50] = "S_Field_min.txt";
    char filename[50] = "S_Field_line_tensionbis.txt";
    //char filename[50] = "Best_S_Field_line_tension3.txt";
    fs = fopen (filename, "r");
    while(!(feof(fs)))
    {
        returnvalue = fscanf (fs, "%d ", &dummy);
        S[p] = dummy;
        p++;
    }
    fclose (fs);
}

/**************************************************
 **                     GETCM
 ** Get the center of mass coordinates for each
 **                    cell
 **************************************************/
void getCM (void)
{
    FILE *fs;
    int p = 0;
    int returnvalue;
    double dummyx,dummyy,dummyz;
    int n;
    char filename[50] = "CMListNewNew.txt";
    fs = fopen (filename, "r");
    while(!(feof(fs)))
    {
        returnvalue = fscanf (fs, "%lf %lf %lf ", &dummyx, &dummyy, &dummyz);
        CM[p][0] = dummyx;
        CM[p][1] = dummyy;
        CM[p][2] = dummyz;
        p++;
    }
    fclose (fs);
}


/**************************************************
 **                     GETJ
 ** Get the J field values from the dedicated folder
 **************************************************/
void getj ()
{
    FILE *fl;
    int size;
    int i;
    int j;
    int n;
    int returnvalue;
    int neigh;
    double coupling;
    char filename[50];
    for (i = 0; i < N; i++)
    { //the neighbour files in the Folder NeighboursFiles start at number 1
        n = sprintf(filename,"NeighboursFilesNewNew/%d.txt",i+1);
        //printf("%s \n",filename);
        size = getn(filename)/2;//the reason for dividing by 2 is because getn() is written to look for one element at a time; since there are 2 elements per lign, it counts twice the number of lines in the file
        Neighcard[i] = size;
        J[i] = (double **)malloc(size*sizeof(double *));
        for (j = 0; j < size; j++)
        {
            J[i][j] = (double *)malloc(2*sizeof(double));
        }
        fl = fopen(filename,"r");
        j = 0;
        while(!(feof (fl)))
        {
            returnvalue = fscanf (fl, "%d %lf ", &neigh, &coupling);
            J[i][j][0] = (double)(neigh-1);
            J[i][j][1] = coupling;
            if(J[i][j][1] < 0) printf("bou \n");
            j++;
        }
        /*double contour = 0.;
        for (j = 0; j < Neighcard[i]; j++)
        {
            contour += J[i][j][1];
        }
        for (j = 0; j < Neighcard[i]; j++)
        {
            J[i][j][1] = J[i][j][1]/contour;
        }*/
        fclose(fl);
    }
}

/**************************************************
 **               ELINESITE
 ** returns the energy of a site i due to the 
 **        line tension term
 **************************************************/
double Elinesite (int s)
{
    double linetension = 0.;
    int i,l,j;
    for (j = 0; j < Neighcard[s]; j++)
    {
        l = (int)(J[s][j][0]); //label of jth neighbour of site i
        linetension += J[s][j][1]*xor(S[s],S[l]);
    }
    return linetension;
}

/**************************************************
 **               LINETENSIONENERGY
 ** returns the energy due to the line tension term
 **************************************************/
double linetensionenergy ()
{
    double linetension = 0.;
    int i;
    for (i = 0; i < N; i++)
    {
        linetension += Elinesite(i);
    }
    return linetension*0.5;
}

/**************************************************
 **                     ENERGY
 **              calculate the energy
 **************************************************/
void energy ()
{
    int i;
    E = 0.;
    Ecurv = 0.;
    Eline = 0;
    A1 = 0;
    Area = 0;
    printf("calculating the area \n");
    for (i = 0; i < N; i++) {
        if(A[i] > 1) A[i] = A[0]; //this is because the zero curvature point seems to have a huge area
        if(S[i] == 1) A1 += A[i];
        Area += A[i];
    }
    printf("finished with the area \n");
    for (i = 0; i < N; i++)
    {
        Ecurv += G[i]*k[S[i]]*A[i];
    }
    printf("finished with the curvature \n");
    Eline = lambda*linetensionenergy();
    printf("finished with line tension \n");
    E = Ecurv + Eline;
}

/**************************************************
 **                     GAUSSBONNET
 **     calculate the area curvature part of the
 **          l.h.s. of the G-B theorem
 **************************************************/
double gaussbonnet()
{
    int i;
    double gb = 0.;
    for (i = 0; i < N; i++)
    {
        if (S[i] == 1)
        {
            gb += fabs(G[i])*A[i];
        }
    }
    return gb;
}

/**************************************************
 **                     SORTARRAY
 **          put N1 numbers first and N0 zeros
 **************************************************/
void sortarray ()
{
    int i, iarray;
    iarray = 0;
    for (i = 0; i < N; i++)
    {
        if (S[i] == 1)
        {
            SortedArray[iarray] = i;
            iarray++;
        }
    }
    N1 = iarray;
    for (i = 0; i < N; i++) {
        if (S[i] == 0)
        {
            SortedArray[iarray] = i;
            iarray++;
        }
    }
}


/**************************************************
 **                     INIT
 ** Reads the files and allocates
 ** memory for the arrays G, A and S and generates
 ** a random field S on the surface
 **************************************************/
void init(char* filename1, char* filename2)
{
    N = getn(filename1);
    printf("N = %d ok \n", N);
    G = malloc(N*sizeof(double));
    getg(filename1);
    printf("G ok \n");
    A = malloc(N*sizeof(double));
    geta(filename2);
    printf("A ok \n");
    S = malloc(N*sizeof(int));
    Sint = malloc(N*sizeof(int));
    Neighcard = malloc(N*sizeof(int));
    CM = (double **)malloc(N*sizeof(double*));
    VecDirector = malloc(3*sizeof(double));
    int i,j;
    for (i = 0; i < N; i++)
    {
        CM[i] = (double *)malloc(3*sizeof(double));
    }
    float a;
    double r;
    for (i = 0; i < N; i++)
    {
        r = alea(0.,1.);
        if (r < a1)
        {
            S[i] = 1;
        }
        else S[i] = 0;
    }
    //getS();
    SortedArray = malloc(N*sizeof(int));
    sortarray();
    J = (double ***)malloc(N*sizeof(double **));
    getj();
    printf("J ok \n");
    getCM();
    printf("CM ok \n");
    for (i = 0; i < 3; i++)
    {
        VecDirector[i] = CM[RightCell-1][i]-CM[LeftCell-1][i];
    }
    printf("VecDirector = (%lf, %lf, %lf) \n", VecDirector[0], VecDirector[1], VecDirector[2]);
    energy();
}

/**************************************************
 **                     MCSTEP
 **              Performs an MC step
 **************************************************/

void mcstep()
{
    int iArrayGreen, iArrayRed, iGreen, iRed;
    iArrayGreen = round(alea(0.,(double)(N1-1)));//pick one green randomly
    iArrayRed = round(alea((double)(N1), (double)(N-1)));//pick one red randomly
    iGreen = SortedArray[iArrayGreen];//discover to which cell they correspond to
    iRed = SortedArray[iArrayRed];
    //printf("iArrayGreen = %d, iGreen = %d, S[iGreen] = %d and iArrayRed = %d, iRed = %d, S[iRed] = %d \n", iArrayGreen, iGreen, S[iGreen], iArrayRed, iRed, S[iRed]);
    int SGreen = S[iGreen];//saving the value of their spins and energies
    int SRed = S[iRed];
    double ElineGreenOld = Elinesite(iGreen);
    double ElineRedOld = Elinesite(iRed);
    //mow we propose the swap
    S[iGreen] = 0;
    S[iRed] = 1;
    double DEline, DEcurve, DE;
    //now calculate the energy change
    DEline = lambda*(-ElineGreenOld + Elinesite(iGreen)-ElineRedOld + Elinesite(iRed));
    DEcurve = -G[iGreen]*(k[SGreen]-k[S[iGreen]])-G[iRed]*(k[SRed]-k[S[iRed]]);//normally I should put A[] but then it is not only the curvature energy that contributes but we start comparing very different tile areas which biases A LOT the outcome
    DE = DEline + DEcurve;
    double r = alea(0.,1.);
    //printf("DE = %lf , proba = %lf\n", DEcurve,exp(-beta*DE) );
    if (r < exp(-beta*DE))
    {
        Eline = Eline + DEline;
        E = E + DE;
        Ecurv = Ecurv + DEcurve;
        SortedArray[iArrayGreen] = iRed;
        SortedArray[iArrayRed] = iGreen;
        count++;
    }
    if(r > exp(-beta*DE))
    {
        S[iGreen] = 1;
        S[iRed] = 0;
    }
    
}

/**************************************************
 **                     MCSTEP2
 **              Performs an MC step
 **************************************************/

void mcstep2()
{
    int i = 0;
    int j = 0;
    int k1,l;
    int iArrayGreen, iArrayRed, iGreen, iRed;
    while(i == 0)
    {
        iArrayGreen = round(alea(0.,(double)(N1-1)));//pick one green randomly
        iGreen = SortedArray[iArrayGreen];//discover to which cell they correspond to
        for (k1 = 0; k1 < Neighcard[iGreen]; k1++)
        {
            l = J[iGreen][k1][0];
            if (l > 0 )
            {
                if(S[l] == 0) i = 1;
            }
        }
    }
    while(j == 0)
    {
        iArrayRed = round(alea((double)(N1), (double)(N-1)));//pick one red randomly
        iRed = SortedArray[iArrayRed];
        for (k1 = 0; k1 < Neighcard[iRed]; k1++)
        {
            l = J[iRed][k1][0];
            if (l > 0 )
            {
                if(S[l] == 1) j = 1;
            }
        }
    }
    
    //printf("iArrayGreen = %d, iGreen = %d, S[iGreen] = %d and iArrayRed = %d, iRed = %d, S[iRed] = %d \n", iArrayGreen, iGreen, S[iGreen], iArrayRed, iRed, S[iRed]);
    int SGreen = S[iGreen];//saving the value of their spins and energies
    int SRed = S[iRed];
    double ElineGreenOld = Elinesite(iGreen);
    double ElineRedOld = Elinesite(iRed);
    //mow we propose the swap
    S[iGreen] = 0;
    S[iRed] = 1;
    double DEline, DEcurve, DE;
    //now calculate the energy change
    DEline = lambda*(-ElineGreenOld + Elinesite(iGreen)-ElineRedOld + Elinesite(iRed));
    DEcurve = -G[iGreen]*(k[SGreen]-k[S[iGreen]])-G[iRed]*(k[SRed]-k[S[iRed]]);//normally I should put A[] but then it is not only the curvature energy that contributes but we start comparing very different tile areas which biases A LOT the outcome
    DE = DEline + DEcurve;
    double r = alea(0.,1.);
    //printf("DE = %lf , proba = %lf\n", DEcurve,exp(-beta*DE) );
    if (r < exp(-beta*DE))
    {
        Eline = Eline + DEline;
        E = E + DE;
        Ecurv = Ecurv + DEcurve;
        SortedArray[iArrayGreen] = iRed;
        SortedArray[iArrayRed] = iGreen;
        count++;
    }
    if(r > exp(-beta*DE))
    {
        S[iGreen] = 1;
        S[iRed] = 0;
    }
    
}

/**************************************************
 **                     PRINTSTUFF
 **   Print Field configurations in a folder to
 **               make a movie
 **************************************************/
void printstuff(int j)
{
    FILE *fs;
    char filename[50];
    int n,l;
    n = sprintf(filename,"S_FieldFiles/%d.txt",j);
    fs = fopen(filename, "w");
    for (l = 0; l < N; l++)
    {
        fprintf(fs, "%d \n ", S[l]);
    }
    fclose(fs);
    
}

/**************************************************
 **                     TEST
 **   test with a given configuration that
 **            everything is fine
 **************************************************/
void test ()
{
    int i,j,l;
    for (i = 0; i < N; i++)
    {
        S[i] = 0;
    }
    i = round(alea(0,N-1));
    S[i] = 1;
    for (j = 0; j < Neighcard[i]; j++)
    {
        l = J[i][j][0];
        S[l] = 1;
    }
    printf("line energy of cell 1 is %lf \n", linetensionenergy());
}

/**************************************************
 **                INITGEODESIC
 **  find cells at the green interface and 
 **  selects a certain fraction of them
 **************************************************/
void initgeodesic(int period)
{
    int n;
    int i,j;
    int countint = 0;//count the number of cells at the interface
    int interface;
    Sint = malloc(N*sizeof(int));
    for (n = 0; n < N; n++)
    {
        Sint[n] = 0;
    }
    int count = 0;
    for (n = 0; n < N; n++)
    {
        interface = 0;
        switch (S[n])
        {
            case 1:
                for (i = 0; i < Neighcard[n]; i++)
                {
                    j = J[n][i][0];
                    if(S[j] == 0) interface = 1;
                }
                if(interface == 1 && countint%period == 0)
                {
                    Sint[count] = n;
                    count++;
                }
                countint++;

                break;
                
            case 0:
                for (i = 0; i < Neighcard[n]; i++)
                {
                    j = J[n][i][0];
                    if(S[j] == 1) interface = 1;
                }
                if(interface == 1 && Neighcard[n] < 3)
                {
                    Sint[count] = n;
                    count++;
                }
                countint++;
                
                break;
        }
    }
    //will try to sort the interface cells into an ordered chain that will remain so afterwards
    int SortedInt[count];
    printf("count = %d \n", count);
    //find first one of the two ends
    for (i = 0; i < count; i++)
    {
        if(Neighcard[Sint[i]] < 3) break;
    }
    SortedInt[0] = Sint[i];
    printf("ok1 \n");
    Sint[i] = 0;//removes the cell from the original list to be put it temporarilly in the sorted list
    //then build an ordered list (by distance) from there
    double *p1, *p2, dbuffer,dist;
    int jbuffer;
    for (n = 1; n < count; n++)
    {
        p1 = CM[SortedInt[n-1]];
        dbuffer = 3000.;//normally much much bigger than any distance in the problem
        for (j = 0; j < count; j++)
        {
            if(Sint[j] != 0)//recall that Sint[j] is the label of a cell at the inteface and so is SortedInt[n-1]
            {
                p2 = CM[Sint[j]];
                dist = d(p1,p2);
                if(dist < dbuffer)
                {
                    dbuffer = dist;
                    SortedInt[n] = Sint[j];
                    jbuffer = j;
                }
            }
        }
        Sint[jbuffer] = 0;
        
    }
    for (n = 1; n < count; n++)
    {
        printf("\t cell %d \n dist \t \t %lf \n ", SortedInt[n-1], d(CM[n-1],CM[n]));
    }
    IntSize = count;
    for (i = 0; i < IntSize; i++)
    {
        Sint[i] = SortedInt[i];
    }
}

/**************************************************
 **                FINDINTERFACE
 **  find cells at the green interface and
 **  selects a certain fraction of them
 **************************************************/
void FindInterface()
{
    //Sint already exists and has already N values that we reset to zero just in case
    int i,j,k;
    int interface;//boolean variable to asses whether a cell is at the interface or not
    int IntCount = 0;//total number of cells at the interface
    int cell;
    for (i = 0; i < N; i++)
    {
        Sint[i] = 0;
    }
    for (i = 0; i < N1; i++)
    {
        interface = 0;
        cell = SortedArray[i];
        for (j = 0; j < Neighcard[cell]; j++)
        {
            k = J[cell][j][0];
            if(S[k] == 0) interface = 1;
        }
        if(interface == 1)
        {
            Sint[IntCount] = cell;
            IntCount++;
        }
    }
    IntSize = IntCount;
}

/**************************************************
 **                SORTINTERFACE
 **  given the vector Sint as implicit input, sorts it to
 **  make an ordered chain out of it
 **************************************************/
void SortInterface(int period)
{
    int j, isorted,imin;
    //first count the number of non zero element i.e. the cardinality of the interface
    int i = 0;
    int size = 0;
    int mostleft;
    double scalarmin;
    double scalar;
    double *v1;
    int *buffer;
    buffer = malloc(IntSize*sizeof(int));
    for(isorted = 0; isorted < IntSize; isorted++)
    {
    i = 0;
    scalarmin = 3000.;
    while(Sint[i] != 0)
    {
        v1 = CM[Sint[i]];
        scalar = dot(v1,VecDirector);
        if (scalar < scalarmin)
        {
            scalarmin = scalar;
            mostleft = Sint[i];
            imin = i;
        }
        i++;
    }
    buffer[isorted] = mostleft;//putting the isorted-th element in the sorted buffer vector
    //need to make the previous mostleft disapear from Sint by shifting every element on its right by one cell to the left
    for (j = imin; j < IntSize; j++)
    {
        Sint[j] = Sint[j+1];
    }
    }
    for (j = 0; j < N; j++)
    {
        Sint[j] = 0;
    }
    for (j = 0; j < IntSize; j++)
    {
        if(j%period == 0)
        {
            Sint[size] = buffer[j];
            size++;
        }
    }
    IntSize = size;
    free(buffer);
    
}


/**************************************************
 **                CHAINLENGTH
 **   calculate the lenth of an ordered chain
 **************************************************/
void chainlength()
{
    int i;
    length = 0;
    for (i = 0; i < IntSize-1; i++)
    {
        length += d(CM[Sint[i]], CM[Sint[i+1]]);
    }
}

/**************************************************
 **                 MCSTEP3
 ** MC step that uses the chain length to 
 ** estimate the line tension energy
 **************************************************/
void mcstep3(int period)
{
    FILE *fm;
    int i = 0;
    int j = 0;
    int k1,l;
    int iArrayGreen, iArrayRed, iGreen, iRed;
    while(i == 0)
    {
        iArrayGreen = round(alea(0.,(double)(N1-1)));//pick one green randomly
        iGreen = SortedArray[iArrayGreen];//discover to which cell they correspond to
        for (k1 = 0; k1 < Neighcard[iGreen]; k1++)
        {
            l = J[iGreen][k1][0];
            if (l > 0 )
            {
                if(S[l] == 0) i = 1;
            }
        }
    }
    while(j == 0)
    {
        iArrayRed = round(alea((double)(N1), (double)(N-1)));//pick one red randomly
        iRed = SortedArray[iArrayRed];
        for (k1 = 0; k1 < Neighcard[iRed]; k1++)
        {
            l = J[iRed][k1][0];
            if (l > 0 )
            {
                if(S[l] == 1) j = 1;
            }
        }
    }
    
    //printf("iArrayGreen = %d, iGreen = %d, S[iGreen] = %d and iArrayRed = %d, iRed = %d, S[iRed] = %d \n", iArrayGreen, iGreen, S[iGreen], iArrayRed, iRed, S[iRed]);
    int SGreen = S[iGreen];//saving the value of their spins and energies
    int SRed = S[iRed];
    //mow we propose the swap
    S[iGreen] = 0;
    S[iRed] = 1;
    double oldlength;
    double dlength;
    oldlength = length;
    FindInterface();
    SortInterface(period);
    chainlength();
    dlength = length-oldlength;
    double r = alea(0.,1.);
    //printf("DE = %lf , proba = %lf\n", DEcurve,exp(-beta*DE) );
    if (r < exp(-beta*dlength*lambda*19))
    {
        printf("accepted: beta*delength*lambda*19 = %lf, length = %lf \n",beta*dlength*lambda*19,length);
        SortedArray[iArrayGreen] = iRed;
        SortedArray[iArrayRed] = iGreen;
        fm = fopen("S_Field_line_tension_best_so_far.txt", "w");
        for (i = 0; i < N; i++)
        {
            fprintf(fm, "%d \n", S[i]);
        }
        fclose(fm);
        fm = fopen("Interface_best_so_far.txt", "w");
        for (i = 0; i < IntSize; i++)
        {
            fprintf(fm, "%d \n", Sint[i]+1);
        }
        fclose(fm);
        count++;
    }
    if(r > exp(-beta*lambda*dlength*19))
    {
        S[iGreen] = 1;
        S[iRed] = 0;
        length = oldlength;
    }
}
/**************************************************
 **                 MCLENGTH
 ** MC step to change the length of the interface
 **                   chain
 **************************************************/
void mclength(double kappa)
{
    int i,j,n,k,m,o;
    double dlength,r;
    i = round(alea(1.,(double)(IntSize-2)));
    n = Sint[i]; //label of the interface cell "chain"
    m = Sint[i-1];//label of the i-1 neighbour on the chain
    o = Sint[i+1]; //label of the i+1 neighbour on the chain
    j = round(alea(1.,(double)(Neighcard[n]-1))); //pick randomly a neighbour of cell n
    k = J[n][j][0];
    dlength = -(d(CM[n],CM[m]) + d(CM[n],CM[o])) + (d(CM[k],CM[m]) + d(CM[k],CM[o]));
    r = alea(0.,1.);
    if (r < exp(-kappa*dlength))
    {
        length += dlength;
        Sint[i] = k;
    }
}

/**************************************************
 **                     FREESTUFF
 **   free the memory allocated by the fields
 **************************************************/
void freestuff ()
{
    int i,j;
    free(A);
    printf("free A ok\n");
    free(G);
    printf("free G ok\n");
    free(S);
    printf("free S ok\n");
    free(Neighcard);
    printf("free Neighcard ok\n");
    free(SortedArray);
    printf("free SortedArray ok\n");
    for (i = 0; i < N; i++) {
        for (j = 0; j < Neighcard[i]; j++)
        {
            free(J[i][j]);
        }
        free(J[i]);
    }
    free(J);
    printf("free J ok\n");
}

int main(int argc, char* argv[])
{
    srand(time(NULL));
    FILE *fp, *fs, *fl,*fm;
    fp = fopen("MC_evolution_line_tensionbis.txt", "w");
    k[0] = 0., k[1] = -10.;
    a1 = 0.45;
    lambda = 10.;
    count = 0;
    LeftCell = 1718;
    RightCell = 210;
    init(argv[1],argv[2]);
    energy();
    FindInterface();
    SortInterface(2);
    chainlength();
    int i,j,l,n,m;
    double E0;
    E0 = E;
    printf("best energy so far = %lf \n", E0);
    j = 1;
    long int Nstep = 1000000;
    beta = 60.0;
    while(length > 20.1475)
    {
    for (nstep = 0; nstep < Nstep; nstep++)
    {
        mcstep();
    }
    FindInterface();
    SortInterface(1);
    chainlength();
    printf("initial chain length = %lf \n", length);
    }
    //while(length > 0.165)
    for (nstep = 0; nstep < 300000; nstep++)
    {
        mcstep3(1);
    }
    fp = fopen("InterfaceCurv.txt","w");
    FindInterface();
    SortInterface(1);
    for (i = 0; i < IntSize; i++)
    {
        fprintf(fp," %d \n", Sint[i]+1);
    }
    chainlength();
    printf("final chain length = %lf \n", length);
    fclose(fp);
    fl = fopen("S_Field_line_tensionCurv.txt", "w");
    for (i = 0; i < N; i++)
    {
        fprintf(fl, "%d \n", S[i]);
    }
    fclose(fl);
    energy();
    printf("a1 = %lf, \t Etot = %lf, \t Eline = %lf, Ecurv = %lf, gauss bonnet = %lf \n", A1/Area, E, Eline, Ecurv, gaussbonnet());
    freestuff();
    return 0;
}











