import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
import os


# Define RGB values for each color
color_list= [
    "#03045E",  # Dark Slate Blue
    "#007786",  # Steel Blue
    "#00B4D8",  # Light Blue

    "#F86E51",  # Tomato
    "#D1193E",  # Indian Red
    "#8B0000",   # Dark Red

    # Add more colors as needed
]
fig, (ax_left, ax_right) = plt.subplots(1, 2, figsize=(5.5, 3.5), sharex=True)
# Normalize RGB values to be in the range [0, 1]
SMALL_SIZE=10
n = 7
colors = plt.cm.rainbow(np.linspace(0, 1, n))
fitted_slope = []
fitted_intercept = []
# Define RGB values for each color
color_list= [
    "#03045E",  # Dark Slate Blue
    "#007786",  # Steel Blue
    "#00B4D8",  # Light Blue

    "#F86E51",  # Tomato
    "#D1193E",  # Indian Red
    "#8B0000",   # Dark Red
]


k=0
def see_force (path, stepsize, k, name, annotate, fit_or_not, sp_fit, sp_fit_cut,line_fit_data_cut, shift_by_final, ax):
    # path = "/Users/thornbird/Documents/surface_evolver/size_test/cone_hight_0.1_pool_width_0.2_pore_depth_0.1_cone_angle_30_ca_10/output_cone_hight_0.1_pool_width_0.2_pore_depth_0.1_cone_angle_30_ca_10_sim4ke.txt"
    f=open(path, "r")
    lines=f.readlines()
    energy=[]
    extra = []
    position=[]
    for x in lines:
        energy.append(x.split('\t')[1])
        position.append(x.split('\t')[0])

    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip())))
    for j in energy:
        energy_corrected.append(float((j.strip())))

    print(position_corrected)
    print(energy_corrected)

    print('position', len(position))
    print('energy', len(energy))

    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 3)::])
    array_position = np.array(position_corrected)+0.0075
    chopped_position = array_position[0:-1]
    diff=np.diff(array_energy)/-stepsize
    print("lendiff", len(diff))
    print("lenchopped_position", len(chopped_position))
    print(array_position)
    print(array_energy)

    # plt.xlabel('Position',fontsize = MEDIUM_SIZE)
    # plt.ylabel('Force',fontsize = MEDIUM_SIZE)
    plt.xticks(fontsize=SMALL_SIZE)
    plt.yticks(fontsize=SMALL_SIZE)
    if sp_fit == 'TRUE':
        print('hi')
        s = 1
        tck = interpolate.splrep(array_position[:sp_fit_cut], shifted_energy[:sp_fit_cut], s=s)
        # plt.plot(position_corrected[:sp_fit_cut],shifted_energy[:sp_fit_cut],color='black')
        print("here",array_position[sp_fit_cut])
        xnew = np.arange(array_position[0], array_position[sp_fit_cut], 0.0001)
        # plt.plot(xnew + 0.0075, -BSpline(*tck)(xnew, 0), '-', color='black', label = name+'fit energy then get gradient')
        simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(30) / 2))
        print('simulation_blunt_length', simulation_blunt_length)
        ax.plot(xnew / simulation_blunt_length, -BSpline(*tck)(xnew, 1) / simulation_blunt_length, '-',
                 color=color_list[k], label=name,
                 linewidth=1)


        x_flat = [xnew[-1], array_position[sp_fit_cut], array_position[-1], 1]
        y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
        # Plot a vertical line at x=2

        ax.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-',
                 color=color_list[k], zorder=5,
                 linewidth=1, alpha=0.8)


    if annotate == 'TRUE':

        print('')

    if fit_or_not == 'TRUE':
        to_fit_chopped_position = chopped_position[0:line_fit_data_cut]+0.0075
        to_fit_force = diff[0:line_fit_data_cut]
        a, b = np.polyfit(to_fit_chopped_position, to_fit_force, 1)
        m, n = np.polyfit(xnew+0.0075, -BSpline(*tck)(xnew, 1), 1)
        # plt.plot(xnew+0.0075, m * (xnew+0.0075) + n, color=colors[k], linestyle='--', linewidth=1, alpha = 0.4)
        fitted_slope.append(m)



os.chdir('/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Data_nanoparticle_adhesion/Sqone_normalisation_SI')
see_force('sqone_shape_0_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE',
          ax=ax_left)

k=k+1
see_force('sqone_shape_0.5_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.5', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE',
          ax=ax_left)
k=k+1
see_force('sqone_shape_0.7_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.7', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE',
          ax=ax_left)
k=k+1

see_force('sqone_shape_0.95_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.95', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE',
          ax=ax_left)
k=k+1
see_force('sqone_shape_0.99_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.99', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE',
          ax=ax_left)
#

ax_right.set_xticks(np.arange(-2,8,2),fontsize=SMALL_SIZE)
ax_right.set_yticks([-30,-20,-10,0],fontsize=SMALL_SIZE)


ax_right.legend(fontsize=SMALL_SIZE, loc ="lower right",frameon=False)
ax_right.set_xlim(-2,7)

import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
import os
SMALL_SIZE = 10
MEDIUM_SIZE = 10
BIGGER_SIZE = 10
n = 7
colors = plt.cm.rainbow(np.linspace(0, 1, n))
fitted_slope = []
fitted_intercept = []
# Define RGB values for each color
color_list= [
    "#03045E",  # Dark Slate Blue
    "#007786",  # Steel Blue
    "#00B4D8",  # Light Blue

    "#F86E51",  # Tomato
    "#D1193E",  # Indian Red
    "#8B0000",   # Dark Red
]


k=0
def see_force (path, stepsize, k, name, annotate, fit_or_not, sp_fit, sp_fit_cut,line_fit_data_cut, shift_by_final, effective_radius, ax):

    f=open(path, "r")
    lines=f.readlines()
    energy=[]
    extra = []
    position=[]
    for x in lines:
        energy.append(x.split('\t')[1])
        position.append(x.split('\t')[0])

    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip())))
    for j in energy:
        energy_corrected.append(float((j.strip())))

    print(position_corrected)
    print(energy_corrected)

    print('position', len(position))
    print('energy', len(energy))

    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 3)::])
    array_position = np.array(position_corrected)+0.0075
    chopped_position = array_position[0:-1]
    diff=np.diff(array_energy)/-stepsize
    print("lendiff", len(diff))
    print("lenchopped_position", len(chopped_position))
    print(array_position)
    print(array_energy)

    plt.xticks(fontsize=SMALL_SIZE)
    plt.yticks(fontsize=SMALL_SIZE)
    if sp_fit == 'TRUE':
        print('hi')
        s = 1
        tck = interpolate.splrep(array_position[:sp_fit_cut], shifted_energy[:sp_fit_cut], s=s)

        print("here",array_position[sp_fit_cut])
        xnew = np.arange(array_position[0], array_position[sp_fit_cut], 0.0001)

        simulation_blunt_length = effective_radius
        print('simulation_blunt_length', simulation_blunt_length)
        ax.plot(xnew / simulation_blunt_length, -BSpline(*tck)(xnew, 1) / simulation_blunt_length, '-',
                 color=color_list[k], label=name,
                 linewidth=1)


        x_flat = [xnew[-1], array_position[sp_fit_cut], array_position[-1], 1]
        y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
        # Plot a vertical line at x=2
        x_flat = np.array(x_flat)
        y_flat = np.array(y_flat)
        ax.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-',
                 color=color_list[k], zorder=5,
                 linewidth=1, alpha=0.8)


    if annotate == 'TRUE':

        print('')
    # plt.legend(fontsize=SMALL_SIZE,loc ="lower right")
    if fit_or_not == 'TRUE':
        to_fit_chopped_position = chopped_position[0:line_fit_data_cut]+0.0075
        to_fit_force = diff[0:line_fit_data_cut]
        a, b = np.polyfit(to_fit_chopped_position, to_fit_force, 1)
        m, n = np.polyfit(xnew+0.0075, -BSpline(*tck)(xnew, 1), 1)

        fitted_slope.append(m)


os.chdir('/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Data_nanoparticle_adhesion/Sqone_normalisation_SI')

see_force('sqone_shape_0_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE', effective_radius=0.00201,ax=ax_right)

k=k+1
see_force('sqone_shape_0.5_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.5', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE', effective_radius=0.00205,ax=ax_right)
k=k+1
see_force('sqone_shape_0.7_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.7', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE', effective_radius=0.00210,ax=ax_right)
k=k+1

see_force('sqone_shape_0.95_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.95', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE', effective_radius=0.00230,ax=ax_right)
k=k+1
see_force('sqone_shape_0.99_condition_0.001_conea_30_ca_30.txt',
0.0005, k,name='0.99', annotate='TURE',fit_or_not='TRUE',sp_fit='TRUE',line_fit_data_cut=21,sp_fit_cut=21,shift_by_final = 'NONE', effective_radius=0.00242, ax=ax_right)

ax_right.set_xlim(-2,7)

plt.tight_layout()

ax_left.set_xlabel('$\dfrac{Position}{R}$', fontsize=10)
ax_right.set_xlabel('$\dfrac{Position}{R\'}$', fontsize=10)
ax_left.set_xticks(np.arange(-2,8,2),fontsize=10)
ax_left.set_yticks([-30,-20,-10,0],fontsize=10)
ax_left.set_ylabel('$\dfrac{F}{R\, \\times \, \gamma_{LG}}$', fontsize=10)
ax_right.set_ylabel('$\dfrac{F}{R\' \, \\times \, \gamma_{LG}}$', fontsize=10)
ax_right.legend(fontsize=10, loc='lower right', frameon=False)
ax_left.set_ylim(-27,2)
ax_right.set_ylim(-27,2)


plt.tight_layout()
# Save the figure with a full path
save_name = 'sqone_norm.eps'
save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/'
# plt.savefig(save_path+save_name, format='eps', bbox_inches='tight',dpi=1200)
# plt.legend()
plt.show()
