import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import os
import re
from matplotlib.cm import get_cmap
from matplotlib.cm import ScalarMappable
SMALL_SIZE = 8
MEDIUM_SIZE = 8
BIGGER_SIZE = 8

plot_color = ['blue','red']
plot_label = ['Wide Tip','Narrow Tip']
blunt_length = 56
ylg=0.02
set_linewidth=1.0


blue_color = "#c1121f"
orange_color = "#219ebc"


def extract_number_from_curve_name(curve_name):
    match = re.search(r'(\d+)', curve_name)
    if match:
        return int(match.group())
    return float('inf')  # Use a large number for names without numbers

def process_input_file(input_file, Spring_constant):

    # Get the name of the input file as a string
    file_name = input_file
    # curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        first_x = float(info_line.split(',')[0].split(' ')[3])
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
        print('first_x', first_x)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True


    # put into an array in Force
    deflection_data_array = np.array(deflection_data) * Spring_constant

    position_array = np.arange(first_x, (len(deflection_data_array) + 2) * position_interval, position_interval).astype(
            float)
    position_array = position_array[:len(deflection_data_array)]+deflection_data_array / Spring_constant
    position_array = position_array*1e9/(blunt_length/2)
    deflection_data_array = deflection_data_array*1e9/(blunt_length/2*ylg)

    print('x_len', len(position_array))
    print('y_len', len(deflection_data_array))

    # Return deflection data array and position array
    return deflection_data_array, position_array
def process_error(input_file, Spring_constant):

    # Get the name of the input file as a string
    file_name = input_file
    # curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        first_x = float(info_line.split(',')[0].split(' ')[3])
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
        print('first_x', first_x)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    error_deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                error_deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True


    # put into an array in Force
    error_data_array = np.array(error_deflection_data) * Spring_constant

    error_position_array = np.arange(first_x, (len(error_data_array) + 2) * position_interval, position_interval).astype(
            float)
    error_position_array = error_position_array[:len(error_data_array)]+error_data_array / Spring_constant


    print('x_len', len(error_position_array))
    print('error_len', len(error_data_array))

    error_position_array = error_position_array * 1e9 / (blunt_length / 2)
    error_data_array = error_data_array * 1e9 / (blunt_length / 2 * ylg)

    return error_data_array, error_position_array


import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
import os

color_list_new=['#023047',"#219ebc","#8ecae6","#e76f51","#c1121f","#780000"]


SMALL_SIZE = 10
MEDIUM_SIZE = 10
BIGGER_SIZE = 10
n = 6
fitted_slope = []
fitted_intercept = []



def see_force (ax,input_file, k, shift_by_final,q_fit):

    # Get the name of the input file as a string
    curve_full_name = str(input_file)
    curve_name = str(curve_full_name.split('_')[-4])
    cone_angle.append(float(curve_name))
    print('strat processing', curve_full_name)

    f=open(input_file, "r")
    lines=f.readlines()
    energy=[]
    extra = []
    position=[]
    for x in lines:
        energy.append(x.split('\t')[1])
        position.append(x.split('\t')[0])

    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip())))
    for j in energy:
        energy_corrected.append(float((j.strip())))


    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 4)::])
    array_position = np.array(position_corrected)+0.0075

    target_file_name = curve_full_name

    # Open the data file for reading
    with open("sp_fit_source.txt", "r") as file_source:
        for line in file_source:
            parts = line.split()
            if len(parts) == 2:
                curve_full_name, sp_fit_cut = parts
                if curve_full_name == target_file_name:
                    sp_fit_cut = int(sp_fit_cut)  # Convert to integer
                    print(f"The number associated with '{target_file_name}' is: {sp_fit_cut}")
                    print('the type is',type(sp_fit_cut))
                    break
        else:
            print(f"No entry found for '{target_file_name}'")

    simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(curve_name) / 2))
    if q_fit == 'TRUE':
        s = 1
        tck = interpolate.splrep(array_position[:sp_fit_cut], shifted_energy[:sp_fit_cut], s=s)

        # Get the coefficients of the fitted spline
        coeffs = tck[1]
        a = coeffs[2]
        quadratic_constants.append(a)
        sp_fit_cut = int(sp_fit_cut)
        xnew = np.arange(array_position[0], array_position[sp_fit_cut], 0.0001)
        print('simulation_blunt_length', simulation_blunt_length)
        ax.plot(xnew/simulation_blunt_length, -BSpline(*tck)(xnew, 1)/simulation_blunt_length, '-', color = color_list_new[k], label = r'$\alpha$'+ '='+curve_name+u'\N{DEGREE SIGN}',linewidth=set_linewidth,alpha=0.9)
        adhesion_force.append(-(-BSpline(*tck)(xnew, 1)[0]))
        x_flat = [xnew[-1],array_position[sp_fit_cut], array_position[-1], 1]
        y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
        # Plot a vertical line at x=2

        ax.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-', color=color_list_new[k], zorder=5,
                 linewidth=set_linewidth, alpha=0.9)

    else:
        s = 5
        tck = interpolate.splrep(array_position[:sp_fit_cut], shifted_energy[:sp_fit_cut], k=2, s=s)
        xnew = np.linspace(array_position[0], array_position[sp_fit_cut], 1000)
        ynew_prime = interpolate.splev(xnew, tck, der=1)
        ax.plot(xnew/simulation_blunt_length, -ynew_prime/simulation_blunt_length, '-',label = r'$\alpha$'+ '='+curve_name+u'\N{DEGREE SIGN}' ,  color=color_list_new[k], linewidth=set_linewidth,zorder=3,alpha=0.9)
        x_flat = [xnew[-1], array_position[sp_fit_cut], array_position[-1], 1]

        y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
        ax.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-',
                          color=color_list_new[k], zorder=3,
                          linewidth=set_linewidth, alpha=0.9)



# Create a figure and subplots grid
fig, axs = plt.subplots(nrows=1, ncols=2, figsize=(3.5, 2), gridspec_kw={'width_ratios': [1, 1]})

# Specify the folder containing the .txt files
folder_path = '/Cone_angle_AFM_simulation (Fig_4)/AFM'
n=1
os.chdir(folder_path)
Sensitivity = 80.48 # nm/V, input
Spring_constant = 1.81 # nN/nm
# Process input file
deflection_data, position_array = process_input_file('B1T8_100_avg_Defl.txt', Spring_constant = Spring_constant)
axs[0].plot(position_array, deflection_data, label='Deflection', linewidth=set_linewidth, alpha=0.7, color=orange_color,zorder=3)

# Process error file
error_data, error_position = process_error('B1T8_100_avgSDV_Defl.txt',Spring_constant = Spring_constant)


# Calculate upper and lower bounds for shaded area
upper_bound = (deflection_data + error_data)
lower_bound = (deflection_data - error_data)

# Shade the area between the curves
axs[0].fill_between(position_array, lower_bound, upper_bound, color="#90e0ef", alpha=0.7, label='Deflection ± Error', zorder=1)

# B2T6
show_from=55
Sensitivity = 80 # nm/V, input
Spring_constant = 1.97 # nN/nm
# Specify the folder containing the .txt files

# List all the .txt files in the folder
deflection_data, position_array = process_input_file('B2T6_100_avg_Defl.txt', Spring_constant = Spring_constant)
axs[0].scatter(position_array[show_from:], deflection_data[show_from:], label='Deflection', s=0.2, alpha=0.7, color=blue_color, zorder=3)
# Process error file
error_data, error_position = process_error('B2T6_100_avgSDV_Defl.txt', Spring_constant = Spring_constant)

# Calculate upper and lower bounds for shaded area
upper_bound = (deflection_data + error_data)
lower_bound = (deflection_data - error_data)

# Shade the area between the curves
axs[0].fill_between(position_array[show_from:], lower_bound[show_from:], upper_bound[show_from:], color="#ffb5a7", alpha=0.7, label='Deflection ± Error', zorder=1)

def myFunc(file_name):
  return float(str(file_name.split('_')[-3]))

folder_path = '/Cone_angle_AFM_simulation (Fig_4)/Simulation'
os.chdir(folder_path)
# List all the .txt files in the folder
txt_files = [f for f in os.listdir(folder_path) if f.endswith('.txt') and f.startswith('1108')]

def myFunc(file_name):
  return float(str(file_name.split('_')[-4]))

# Sort the files based on the numeric part of curve_name
txt_files.sort(key=myFunc)

print('file_list', txt_files)

quadratic_constants = []  # Array to store quadratic constants
cone_angle = []
adhesion_force = []
 # Process each .txt file and create a subplot for each

k = 0
for i, txt_file in enumerate(txt_files):
    position_value = float(str(txt_file.split('_')[-4]))
    print(f"Processing file {i + 1}/{len(txt_files)}: {txt_file}, Position Value: {position_value}")
    if position_value in range(12, 18,2):  # Check if the value is in the range 14, 16, 18, ..., 32
        input_file = txt_file
        see_force(ax=axs[1], input_file=input_file, k=k, shift_by_final='TRUE', q_fit='none')
        print('k', k)
        k += 1
    elif position_value in range(22, 46, 8):  # Check if the value is in the range 14, 16, 18, ..., 32
        input_file = txt_file
        see_force(ax=axs[1], input_file=input_file, k=k, shift_by_final='TRUE', q_fit='TRUE')
        print('k', k)
        k += 1
    else:
        print('not_selected')


# Set tick parameters for both subplots
for ax in axs:
    ax.tick_params(axis='both', which='both', labelsize=SMALL_SIZE)

for ax in axs:
    axs[0].set_xlim(-1, 6)
    axs[0].set_ylim(-45, 5)
    axs[1].set_xlim(-1,6)
    axs[1].set_ylim(-45,5)
    ax.set_yticks(np.arange(-40, 10, 10), fontsize=10)
    ax.set_xticks(np.arange(0, 8, 2),fontsize=10)
    axs[0].set_xlabel('$\dfrac{Position}{R}$', fontsize=10)
    axs[0].set_ylabel('$\dfrac{F}{R\, \\times \, \gamma_{LG}}$', fontsize=10)
    axs[1].set_xlabel('$\dfrac{Position}{R}$', fontsize=10)
    axs[1].axvspan(-1, 0, facecolor='gray', alpha=0.15, edgecolor='none')


plt.tight_layout()

save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/'
save_name = 'present_vary_conagle.svg'

# plt.savefig(save_path+save_name, format='svg', bbox_inches='tight',dpi=1200)

plt.show()


