import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import os
import re
from matplotlib.cm import get_cmap
from matplotlib.cm import ScalarMappable
from BaselineRemoval import BaselineRemoval
# Set font to Helvetica
plt.rc('font', family='Helvetica')

Sensitivity = 76.26 # nm/V
Spring_constant = 1.58 # nN/nm

adhesion_force_array = []
bridge_length_array = []
speed_array = []

# Create a colormap
cmap = get_cmap("viridis")  # You can choose any colormap you prefer

def extract_number_from_curve_name(curve_name):
    match = re.search(r'(\d+)', curve_name)
    if match:
        return int(match.group())
    return float('inf')  # Use a large number for names without numbers

def process_input_file(input_file, k):

    # Get the name of the input file as a string
    file_name = input_file
    curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True

    # put into an array
    deflection_data_array = np.array(deflection_data) / 100 / 1 * Sensitivity * Spring_constant

    position_array = np.arange(0, (len(deflection_data_array) + 2) * position_interval, position_interval).astype(
            float)
    position_array = position_array[:len(deflection_data_array)]

    # if we correct the bending
    position_array = position_array[:len(deflection_data_array)] + deflection_data_array / Spring_constant

    # baseline removal
    baseObj_retr_minus_ext_base_on_height = BaselineRemoval(deflection_data_array)
    Imodpoly_output_for_ext_minus_retr_base_on_height = baseObj_retr_minus_ext_base_on_height.IModPoly(
        3)

    start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height = Imodpoly_output_for_ext_minus_retr_base_on_height[
                                                                        0:round(
                                                                            len(Imodpoly_output_for_ext_minus_retr_base_on_height) / 3)]
    shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height = start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height[
                                                                           np.argmin(
                                                                               start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height):]

    index_of_zero_x_base_on_height_on_interpad_measured_height = np.argmin(
        start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height) + np.argmax(
        shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height)
    zero_x_base_on_height = position_array[index_of_zero_x_base_on_height_on_interpad_measured_height]
    zero_y_base_on_height = deflection_data_array[
        index_of_zero_x_base_on_height_on_interpad_measured_height]
    shifted_array_retr_minus_ext_base_on_height = deflection_data_array - zero_y_base_on_height

    y_manual = np.average(shifted_array_retr_minus_ext_base_on_height[
                          int(0.2 * len(shifted_array_retr_minus_ext_base_on_height)):
                          int(0.9 * len(shifted_array_retr_minus_ext_base_on_height))])


    # measure
    F_ad = abs(min(deflection_data_array)*1e9) #adhesion force in nN
    bridge_length = abs(zero_x_base_on_height*1e9) #bridge length in nm
    speed = float(curve_name)
    adhesion_force_array.append(F_ad)
    bridge_length_array.append(bridge_length)
    speed_array.append(speed)

    # plot together afte shift
    plt.plot((position_array-zero_x_base_on_height) * 1e9+50, (deflection_data_array-y_manual) * 1e9, label=curve_name, linewidth=1.0, alpha=0.7,
             color=cmap(k * (1 / 7)))


# Specify the folder containing the .txt files
folder_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Data_nanoparticle_adhesion/Velocity_test_SI'
os.chdir(folder_path)



# List all the .txt files in the folder
txt_files = [f for f in os.listdir(folder_path) if f.endswith('.txt')]

def myFunc(file_name):
  return float(str(file_name.split('_')[-4]))

# Sort the files based on the numeric part of curve_name
txt_files.sort(key=myFunc)

print('file_list', txt_files)

# Create a single figure
fig, ax = plt.subplots(figsize=(3.5, 3))  # Adjust figsize as needed

# Process each .txt file and create a subplot for each
k = 0
for i, txt_file in enumerate(txt_files):
    input_file = txt_file
    process_input_file(input_file,k)
    k += 1
# Adjust the spacing between figures (increase top and bottom space)
plt.subplots_adjust(top=0.95, bottom=0.05)

# Enlarge axis number size
plt.xlim(-25,100)
plt.xticks([-25,0,25,50, 75, 100], fontsize=10)
plt.yticks([-14,-7,0], fontsize=10)
plt.ylim(-15,1)
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)



plt.xlabel("Position (nm)", fontsize = 10)
plt.ylabel('$\it{F}$'+' (nN)', fontsize = 10)
plt.tight_layout()

# Add a colorbar to the side with the scale from 0 to 30
sm = ScalarMappable(cmap=cmap, norm=plt.Normalize(vmin=0.1, vmax=10))
sm.set_array([])  # Dummy array

plt.tight_layout()
save_name = 'velocity.eps'
save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/'
# plt.savefig(save_path+save_name, format='eps', bbox_inches='tight',dpi=1200)
plt.show()





