import matplotlib.pyplot as plt
import numpy as np
import os
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
from matplotlib.cm import get_cmap
from matplotlib.cm import ScalarMappable
SMALL_SIZE = 12
MEDIUM_SIZE = 15
BIGGER_SIZE = 16
markersize=1
# Set font to Helvetica
plt.rcParams["font.family"] = "Helvetica"
plt.rcParams["pdf.fonttype"] = 42  # Embed the font in the PDF file
n = 9
simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(30) / 2))
# Create a colormap
coloe_list = [

    "#03045E",  # Dark Slate Blue
    "#007786",  # Steel Blue
    "#00B4D8",  # Light Blue

    "#90E0EF",# Light Coral
    "#BCD2E8",  # Coral
    "#f2c85b",
    "#F86E51",  # Tomato
    "#EE3E38",  # Cinnabar
    "#D1193E",  # Indian Red
    "#8B0000",   # Dark Red
    # "#802300",
]# Crimson
fitted_slope = []
fitted_intercept = []
length=[]
a = []
F = []
k=0
# Define RGB values for each color

plt.figure(figsize=(4,3))

folder_path ='/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/surface_evolver/sphere'
def see_force (input_file, k, shift_by_final, data_from_correct):
    # Get the name of the input file as a string
    curve_full_name = str(input_file)
    curve_name = str(str(curve_full_name.split('_')[9])).split('.')[-2]

    print('strat processing', curve_full_name)

    f = open(input_file, "r")
    lines=f.readlines()
    energy=[]
    extra = []
    position=[]
    for x in lines:
        energy.append(x.split('\t')[1])
        position.append(x.split('\t')[0])

    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip()))+data_from_correct)
    for j in energy:
        energy_corrected.append(float((j.strip())))

    print(position_corrected)
    print(energy_corrected)

    print('position', len(position))
    print('energy', len(energy))

    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 3)::])
    array_position = np.array(position_corrected)
    chopped_position = array_position[0:-1]
    # diff=np.diff(array_energy)/-stepsize
    # print("lendiff", len(diff))
    print("lenchopped_position", len(chopped_position))
    print(array_position)
    print(array_energy)
    sp_fit_cut = array_energy.argmax()
    # plt.scatter(array_position[sp_fit_cut], array_energy[sp_fit_cut], s=100, marker='o', color='r')
    print('connect point', array_position[sp_fit_cut], array_energy[sp_fit_cut])




    print('hi')
    s_fit = 1
    tck = interpolate.splrep(array_position[:sp_fit_cut+1], shifted_energy[:sp_fit_cut+1], s=s_fit)

    print("here",array_position[sp_fit_cut])

    xnew = np.linspace(array_position[0], array_position[sp_fit_cut], 100)

    print('black', array_position[sp_fit_cut])
    print('red',xnew[-1])
    simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(30) / 2))
    # energy
    shift_x = 0.001542
    plt.plot(array_position/simulation_blunt_length, array_energy/(simulation_blunt_length*simulation_blunt_length),'o-',markersize=markersize,
             color='black', label=r'$\theta$' + '=' + curve_name + u'\N{DEGREE SIGN}',zorder=2)
    plt.plot((array_position[:sp_fit_cut]-shift_x)/simulation_blunt_length, array_energy[:sp_fit_cut]/(simulation_blunt_length*simulation_blunt_length),'o-',markersize=markersize,
             color='blue', label=r'$\theta$' + '=' + curve_name + u'\N{DEGREE SIGN}',zorder=2)
    # plt.plot(xnew, -BSpline(*tck)(xnew, 0), '-',
    #          color=color_list_normalized[k], label=r'$\theta$' + '=' + curve_name + u'\N{DEGREE SIGN}', linewidth=3.0)

    simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(30) / 2))

    print('simulation_blunt_length', simulation_blunt_length)
    # plt.plot(xnew / simulation_blunt_length, -BSpline(*tck)(xnew, 1) / simulation_blunt_length, '-',
    #          color=coloe_list[k], label=curve_name + u'\N{DEGREE SIGN}', linewidth=1.5)
    # x_flat = [xnew[-1], array_position[sp_fit_cut], array_position[-1], 1]
    # y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
    # Plot a vertical line at x=2

    # plt.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-', color=coloe_list[k],
    #         zorder=5,
    #         linewidth=1.5, alpha=0.8)
    print('end point',xnew[-1] / simulation_blunt_length, -BSpline(*tck)(xnew[-1], 1))

    a.append(-BSpline(*tck)(xnew, 3))
    length.append(array_position[sp_fit_cut]+0.0025)
    F.append(BSpline(*tck)(xnew[0], 1))

    k=k+1

 # List all the .txt files in the folder
txt_files = [f for f in os.listdir(folder_path) if f.endswith('.txt') and f.startswith('2007_nongra')]

def myFunc(file_name):

  return float(str(str(file_name.split('_')[9])).split('.')[-2])

# Sort the files based on the numeric part of curve_name
txt_files.sort(key=myFunc)


see_force('2007_nongra_condition_0.0002_cone_angle_30_contact_angle_20.txt', k, shift_by_final='TRUE', data_from_correct=0.0075)
# plt.axhline(y=0, color='grey', linestyle='--', zorder=0)



# plt.xlabel('$\dfrac{Position}{R}$', fontsize=12)
# plt.ylabel('$\dfrac{F}{R\, \\times \, \gamma_{LG}}$', fontsize=12)
# plt.ylim(-0.1,0.1)
# Display cone angle as text on top of the legend
# plt.legend(fontsize=SMALL_SIZE, loc='upper left', bbox_to_anchor=(0, 0.9))
connect_point_x=0.0086
connect_point_y=0.013431

import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
import os
from matplotlib.cm import get_cmap

folder_path ='/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/surface_evolver/sphere'
os.chdir(folder_path)

SMALL_SIZE = 12
MEDIUM_SIZE = 15
BIGGER_SIZE = 16
n = 6
cmap = get_cmap("gist_rainbow")
fitted_slope = []
fitted_intercept = []

def see_energy(path, shift_by_final, sp_fit_cut, data_available_from):
    f = open(path, "r")

    # Get the name of the input file as a string
    curve_full_name = str(path)
    curve_name = str(curve_full_name.split('_')[-1])
    print('start processing', curve_full_name)

    lines = f.readlines()
    energy = []
    extra = []
    position = []
    for x in lines:
        energy.append(x.split('\t')[2])
        position.append(x.split('\t')[1])

    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip())))
    for j in energy:
        energy_corrected.append(float((j.strip())))

    print(position_corrected)
    print(energy_corrected)

    print('position', len(position))
    print('energy', len(energy))

    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 4)::])
    array_position = np.array(position_corrected)

    array_position = array_position
    shifted_energy =shifted_energy

    # Perform a linear fit
    slope, intercept = np.polyfit(array_position[data_available_from:(data_available_from+sp_fit_cut)], shifted_energy[data_available_from:(data_available_from+sp_fit_cut)], 1)

    # Generate points along the fitted line
    y_fit = slope * array_position[data_available_from:(data_available_from+sp_fit_cut)] + intercept
    force_length = (array_position[data_available_from:(data_available_from+sp_fit_cut)][-1]-array_position[data_available_from:(data_available_from+sp_fit_cut)][0])
    print('force length', force_length)

    # Plot the fitted line
    # plt.plot(array_position[data_available_from:(data_available_from+sp_fit_cut)], y_fit, color='blue', label=f'Linear Fit: y={slope:.4f}x + {intercept:.4f}',zorder=3, linewidth=1.5)
    # array_position = array_position[data_available_from::]
    s = 1
    s_fit = 1
    tck = interpolate.splrep(array_position[:data_available_from+sp_fit_cut+1], shifted_energy[:data_available_from+sp_fit_cut+1], s=s_fit)
    # plt.scatter(array_position, shifted_energy, s=60, marker= 'o', color='black', label='data', alpha=0.3)
    connect_paramater_x=array_position[data_available_from]-connect_point_x
    connect_paramater_y = shifted_energy[data_available_from] - connect_point_y
    shift_x = 0.001542
    plt.plot((array_position[data_available_from:]-shift_x-connect_paramater_x)/simulation_blunt_length, (shifted_energy[data_available_from:]-connect_paramater_y)/(simulation_blunt_length*simulation_blunt_length), 'o-', markersize=markersize,color='blue', zorder=2, alpha=1)
    # xnew = np.linspace(array_position[0], array_position[sp_fit_cut+data_available_from], 100)
    #
    # plt.plot(xnew, BSpline(*tck)(xnew, 0), '-',
    #                   color='green', zorder = 4, label = 'bspline fit', linewidth =1.5)
    # plt.plot(xnew, BSpline(*tck)(xnew, 1), '-',
    #          color='green')
    print(array_position[-1])
    f.close()


see_energy('tagent_sphere_condition_0.0002_cone_angle_30_contact_angle_20.txt',
           shift_by_final='TRUE', sp_fit_cut=23, data_available_from=27)

plt.xlabel('$\dfrac{Position}{R}$', fontsize=10)
plt.ylabel('$\dfrac{E}{R^2\, \\times \, \gamma_{LG}}$', fontsize=10)
plt.yticks([3240, 3280, 3320], fontsize=10)
plt.xticks([-2.5,0,2.5,5], fontsize=10)
plt.xlim(-3,5.6)
plt.tight_layout()
plt.axvspan(-3,0,facecolor='gray',alpha=0.15,edgecolor='none',zorder=0)
save_name = 'sphere_data_shifted.eps'
save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/'
plt.savefig(save_path+save_name, format='eps', bbox_inches='tight',dpi=1200)

# plt.legend()

plt.show()




