import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import os
import re
from matplotlib.cm import get_cmap
from matplotlib.cm import ScalarMappable
# fig, (ax_left, ax_right) = plt.subplots(1, 2, figsize=(5.5, 3.5), sharex=True)
Sensitivity = 73.95 # nm/V
Spring_constant = 1.53 #
fig, (ax_left, ax_right) = plt.subplots(1, 2, figsize=(3.5, 2))


def extract_number_from_curve_name(curve_name):
    match = re.search(r'(\d+)', curve_name)
    if match:
        return int(match.group())
    return float('inf')  # Use a large number for names without numbers

def process_input_file(input_file, k, ax):

    # Get the name of the input file as a string
    file_name = input_file
    curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True

    # put into an array
    deflection_data_array = np.array(deflection_data) / 100 / 1 * Sensitivity * Spring_constant

    position_array = np.arange(0, (len(deflection_data_array) + 2) * position_interval, position_interval).astype(
            float)
    position_array = position_array[:len(deflection_data_array)]

    # if we correct the bending
    position_array = position_array[:len(deflection_data_array)] + deflection_data_array / Spring_constant

    # plot together
    show_from=20
    ax.plot(position_array[show_from:]*1e9,deflection_data_array[show_from:]*1e9, label = curve_name +' μm/s', linewidth = 1.0, alpha = 1.0, color = 'black')


    # plot individual
    # fig, ax = plt.subplots()  # Create a new figure for each curve
    # ax.plot(position_array, deflection_data_array, label=curve_name, linewidth=0.5, alpha=0.7, color=cmap(0.5))
    # ax.set_title(str(file_name).split('_')[1:3])

    # plot stack
    # ax.plot(position_array, deflection_data_array, label=curve_name, linewidth=0.5, alpha=0.7, color=cmap(k*(1/7)))
    # ax.set_title(str(file_name).split('_')[1:3])
    # ax.legend()

# Specify the folder containing the .txt files
folder_path = '/Imperfect_particle (Fig_7)'
os.chdir(folder_path)



# List all the .txt files in the folder
txt_files = [f for f in os.listdir(folder_path) if f.endswith('B4T1_0.5_u_avg_Defl.txt')]

def myFunc(file_name):
  return float(str(file_name.split('_')[-4]))

# Sort the files based on the numeric part of curve_name
txt_files.sort(key=myFunc)

print('file_list', txt_files)

# Create a single figure with subplots
# num_files = len(txt_files)
# fig, axs = plt.subplots(num_files, 1, figsize=(8, 2 * num_files))
# fig.subplots_adjust(hspace=0.4)  # Adjust hspace as needed# Adjust the figsize as needed


# ax_left.set_xlabel('Position (nm)', fontsize=10)
# ax_left.set_ylabel('F (nN)', fontsize=10)
# Process each .txt file and create a subplot for each
k = 0
for i, txt_file in enumerate(txt_files):
    input_file = txt_file
    process_input_file(input_file,k, ax=ax_left)
    k += 1
plt.rc('xtick')
plt.rc('ytick')
SMALL_SIZE = 12
MEDIUM_SIZE = 12
BIGGER_SIZE = 12


ax_left.set_xlim(-6,40)




import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import scipy
from scipy.interpolate import interp1d
from scipy.integrate import simps
from BaselineRemoval import BaselineRemoval
import glob, os

# grab txt file
files_path = '/Imperfect_particle (Fig_7)'
Spring_cons = 0.392
polynomial_degree_for_ext_minus_retr = 3
plot_line_width = 0.85
os.chdir(files_path)



# Setting the x-axis ticks
ax_right.set_xticks([0,  50,100], fontsize=10)
ax_right.set_yticks([-10, -5, 0], fontsize=10)
ax_left.set_yticks([-5, -2.5, 0], fontsize=10)
for filename in os.listdir(files_path):
    if filename.endswith(".660.txt"):
        print('filename', filename)
        path_of_file = os.path.abspath(filename)
        # read the file to pandas data frame by splitting by space
        with open(path_of_file) as f:
            df = pd.DataFrame([line.strip().split() for line in f.readlines()])

        # extracting column(vertical tip position) and column(vertical reflection)
        col_measured_smoothed_height = df[0].values.tolist()
        col_measured_height = df[7].values.tolist()
        # print('len(col_measured_height)', len(col_measured_height))
        col_vertical_reflection = df[13].values.tolist()

        list_of_measured_smoothed_height = []
        list_of_vertical_reflection = []
        list_of_measured_height = []
        list_of_NaN_position_index = []
        length_range_of_measured_smoothed_height = range(0, len(col_measured_smoothed_height))
        for i in length_range_of_measured_smoothed_height:
            try:
                list_of_measured_smoothed_height.append(float(col_measured_smoothed_height[i]))
                list_of_measured_height.append(float(col_measured_height[i]))
                list_of_vertical_reflection.append(float(col_vertical_reflection[i]))
            except:
                list_of_NaN_position_index.append(i)

        n = 0
        for f in length_range_of_measured_smoothed_height:
            if f == list_of_NaN_position_index[n]:
                n = n + 1
            else:
                n = n + 1
                break

        minus = list_of_NaN_position_index[n] - n
        print('minus',minus)
        array_extension_measured_height = np.asarray(list_of_measured_height[0:minus])
        array_retraction_measured_height = np.asarray(list_of_measured_height[minus::])
        array_extension_vertical_reflection = np.asarray(list_of_vertical_reflection[0:minus])
        array_retraction_vertical_reflection = np.asarray(list_of_vertical_reflection[minus::])


        # define interpolation range as the overlap measured_height position data area of extension and retraction
        min_extenstion_measured_height = min(array_extension_measured_height)
        min_retraction_measured_height = min(array_retraction_measured_height)
        max_extenstion_measured_height = max(array_extension_measured_height)
        max_retraction_measured_height = max(array_retraction_measured_height)
        lower_interp1d_band_base_on_measured_height = max(min_extenstion_measured_height, min_retraction_measured_height)
        upper_interp1d_band__base_on_measured_height = min(max_extenstion_measured_height, max_retraction_measured_height)
        print('band',lower_interp1d_band_base_on_measured_height, 'to', upper_interp1d_band__base_on_measured_height )


        # interpolation using measured_height-
        interp1d_measured_height = np.linspace(lower_interp1d_band_base_on_measured_height, upper_interp1d_band__base_on_measured_height, 4000)
        function_extension_base_on_height = scipy.interpolate.interp1d(array_extension_measured_height,
                                                        array_extension_vertical_reflection, fill_value="extrapolate")
        function_retraction_base_on_height = scipy.interpolate.interp1d(array_retraction_measured_height,

                                                         array_retraction_vertical_reflection, fill_value="extrapolate")
        #plt.plot(array_extension_measured_height,function_extension_base_on_height(array_extension_measured_height), color = 'b', lw = 3.0, label ='function_extension_base_on_height')
        array_retr_minus_ext_base_on_height = function_retraction_base_on_height(interp1d_measured_height) - function_extension_base_on_height(
            interp1d_measured_height)
        #function_retr_minus_ext_base_on_height = scipy.interpolate.interp1d(interp1d_measured_height, array_retr_minus_ext_base_on_height,
                                                             #fill_value="extrapolate")


        # find the dipping
        reversed_ext = array_extension_vertical_reflection[::-1]
        ext_point_index = 0
        for ext_point_index in range(0, len(reversed_ext)-1):
            if reversed_ext[ext_point_index + 1] < reversed_ext[ext_point_index]:
                # print('h', ext_point_index)
                measure_height_for_ext_turn_point = array_extension_measured_height[
                    len(reversed_ext) - 1 - ext_point_index]

                break
            else:
                ext_point_index = ext_point_index + 1


        # plot a line at y = 0
        # plt.axhline(y=0, color='black', linewidth=0.5, linestyle='-')


        baseObj_retr_minus_ext_base_on_height = BaselineRemoval(array_retr_minus_ext_base_on_height)
        Imodpoly_output_for_ext_minus_retr_base_on_height = baseObj_retr_minus_ext_base_on_height.IModPoly(polynomial_degree_for_ext_minus_retr)


        start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height = Imodpoly_output_for_ext_minus_retr_base_on_height[
                                                                        0:round(len(Imodpoly_output_for_ext_minus_retr_base_on_height)*0.33)]
        shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height = start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height[np.argmin(start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height):]

        index_of_zero_x_base_on_height_on_interpad_measured_height = np.argmin(start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height) + np.argmax(shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height)
        zero_x_base_on_height = interp1d_measured_height[index_of_zero_x_base_on_height_on_interpad_measured_height]
        zero_y_base_on_height = array_retr_minus_ext_base_on_height[index_of_zero_x_base_on_height_on_interpad_measured_height]
        shifted_array_retr_minus_ext_base_on_height_method_1 = array_retr_minus_ext_base_on_height - zero_y_base_on_height

        # plt.scatter(zero_x_base_on_height,zero_y_base_on_height, s = 15.0, color = 'purple', label = 'method1: zero_point_based_on_height' )

        print('zero_x_base_on_height',zero_x_base_on_height)
        # print('zero_y_base_on_height',zero_y_base_on_height)

        interp1d_separation = interp1d_measured_height + array_retr_minus_ext_base_on_height / Spring_cons

        function_retr_minus_ext_base_on_height_vs_separation = scipy.interpolate.interp1d(interp1d_separation, array_retr_minus_ext_base_on_height,
                                                             fill_value="extrapolate")

        x_to_plot=(interp1d_separation-zero_x_base_on_height)*1e9+80
        y_to_plot=(shifted_array_retr_minus_ext_base_on_height_method_1)*1e9
        show_from=6
        ax_right.plot(x_to_plot[show_from:], y_to_plot[show_from:],
                 color='black',
                 linewidth=1.0, label='see')
        # find adhesion point as it is not the minimum
        k = 0
        for k in range(0,len(shifted_array_retr_minus_ext_base_on_height_method_1)):
            if shifted_array_retr_minus_ext_base_on_height_method_1[k+1] > shifted_array_retr_minus_ext_base_on_height_method_1[k]:
                index_for_ad_force = k
                break
                print('index_for_ad_force', index_for_ad_force)
            else:
                k = k+1


        separation_for_Ad_force_method1 = interp1d_separation[index_for_ad_force]


        plt.rc('xtick')
        plt.rc('ytick')
        SMALL_SIZE = 10
        MEDIUM_SIZE = 10
        BIGGER_SIZE = 10


        plt.rc('font', size=SMALL_SIZE)  # controls default text sizes
        plt.rc('axes', titlesize=BIGGER_SIZE)  # fontsize of the axes title
        plt.rc('axes', labelsize=MEDIUM_SIZE)  # fontsize of the x and y labels
        plt.rc('xtick', labelsize=SMALL_SIZE)  # fontsize of the tick labels
        plt.rc('ytick', labelsize=SMALL_SIZE)  # fontsize of the tick labels
        plt.rc('legend', fontsize=SMALL_SIZE)  # legend fontsize
        plt.rc('figure', titlesize=BIGGER_SIZE)  # fontsize of the figure title
        plt.tight_layout()


        # use ori
        baseObj_retr_base_on_height = BaselineRemoval(array_retraction_vertical_reflection)
        Imodpoly_retraction_base_on_height = baseObj_retr_base_on_height.IModPoly(polynomial_degree_for_ext_minus_retr)

        yshift = array_retraction_vertical_reflection[np.argmax(Imodpoly_retraction_base_on_height)]



        extension_separation_based_on_ori = array_extension_measured_height + array_extension_vertical_reflection/Spring_cons-yshift/Spring_cons
        retraction_separation_based_on_ori = array_retraction_measured_height + array_retraction_vertical_reflection / Spring_cons - yshift/Spring_cons
        function_ext_base_on_height_ori = scipy.interpolate.interp1d(extension_separation_based_on_ori,
                                                                                          array_extension_vertical_reflection-yshift,
                                                                                          fill_value="extrapolate")
        function_retr_base_on_height_ori = scipy.interpolate.interp1d(retraction_separation_based_on_ori,
                                                                                          array_retraction_vertical_reflection-yshift,
                                                                                          fill_value="extrapolate")

        Ad_force_method2 = min(array_retraction_vertical_reflection)-yshift
        separation_Ad_force_method2 = retraction_separation_based_on_ori[np.argmin(array_retraction_vertical_reflection)]

        # find extension turn point
        re_array_extension_vertical_reflection = array_extension_vertical_reflection[::-1]
        ele_ext_separation = 0
        for ele_ext_separation in range(0,len(array_extension_vertical_reflection)):
            if re_array_extension_vertical_reflection[ele_ext_separation+1] < re_array_extension_vertical_reflection[ele_ext_separation]:
                separation_method2_ext_turn_point = extension_separation_based_on_ori[len(array_extension_vertical_reflection)-ele_ext_separation]
                break
            else:
                ele_ext_separation = ele_ext_separation+1
        ax_right.set_xlim(-15, 120)
        print("Data appended successfully for", filename)



ax_left.set_xlabel('Position (nm)', fontsize=10)
ax_right.set_xlabel('Position (nm)', fontsize=10)
ax_left.set_ylabel('$\it{F}$'+' (nN)', fontsize=10)


plt.tight_layout()
save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/imprefect_tips.svg'
# plt.savefig(save_path, format='svg', bbox_inches='tight', dpi=1200)
plt.show()





