import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import scipy
from scipy.signal import savgol_filter
from scipy.interpolate import interp1d
from scipy.integrate import simps
from BaselineRemoval import BaselineRemoval
from scipy.fft import rfft, rfftfreq
import glob, os
from scipy.fft import irfft
import math

# grab txt file
# files_path = '/Users/thornbird/OneDrive - Durham University/Tip geometry/2022_09_01_glaco_10cstsoil_scout70_tip5_ampl6.0_abssp4.0/speed_50_processed-2022.09.01-17.55.00/processed_curves-2022.09.01-17.55.00'
files_path ='/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Data_nanoparticle_adhesion/AFM_data_processing_SI'
file_path_split = files_path.split('/')[6]

Spring_cons = 2.0 # in N/m
Sensitivity = 35.0 # in nm/V
polynomial_degree_for_ext_minus_retr = 3
os.chdir(files_path)
# for file in glob.glob("*.txt"):
#     print('list of file',file)
rgb_red = (171/255,58/255,41/255)
rgb_blue= (19/255,103/255,158/255)
rgb_lightred= (212/255,97/255,83/255)
rgb_lightblue= (145/255,197/255,158/218)
rgb_green = (27/255,124/255,61/255)
small_size = 10

for filename in os.listdir(files_path):
    if filename.endswith(".195.txt"):
        print('filename', filename)
        path_of_file = os.path.abspath(filename)
        # read the file to pandas data frame by splitting by space
        with open(path_of_file) as f:
            df = pd.DataFrame([line.strip().split() for line in f.readlines()])

        # extracting column(vertical tip position) and column(vertical reflection)
        col_measured_smoothed_height = df[0].values.tolist()
        col_measured_height = df[4].values.tolist()
        # print('len(col_measured_height)', len(col_measured_height))
        col_vertical_reflection = df[9].values.tolist()
        # print('len(col_vertical_reflection)', len(col_vertical_reflection))

        # list of veritical tip position and vertical reflection value, convert string to float, realise there is '#' i the info as NaN
        list_of_measured_smoothed_height = []
        list_of_vertical_reflection = []
        list_of_measured_height = []
        list_of_NaN_position_index = []
        length_range_of_measured_smoothed_height = range(0, len(col_measured_smoothed_height))
        for i in length_range_of_measured_smoothed_height:
            try:
                list_of_measured_smoothed_height.append(float(col_measured_smoothed_height[i]))
                list_of_measured_height.append(float(col_measured_height[i]))
                list_of_vertical_reflection.append(float(col_vertical_reflection[i]))
            except:
                list_of_NaN_position_index.append(i)

        cutting = 0
        for f in length_range_of_measured_smoothed_height:
            if f == list_of_NaN_position_index[cutting]:
                cutting = cutting + 1
            else:
                cutting = cutting + 1
                break

        minus = list_of_NaN_position_index[cutting] - cutting
        print('minus',minus)
        array_extension_measured_height = np.asarray(list_of_measured_height[0:minus])
        array_retraction_measured_height = np.asarray(list_of_measured_height[minus::])
        array_extension_vertical_reflection = np.asarray(list_of_vertical_reflection[0:minus])
        array_retraction_vertical_reflection = np.asarray(list_of_vertical_reflection[minus::])




        def cutting_odd_ext(array_ext):
            if len(array_ext) % 2 == 0:
                return array_ext
            else:
                return array_ext[1:]

        array_extension_measured_height = cutting_odd_ext(array_extension_measured_height)
        array_extension_vertical_reflection = cutting_odd_ext(array_extension_vertical_reflection)

        def cutting_odd_retr(array_retr):
            if len(array_retr) % 2 == 0:
                return array_retr
            else:
                return array_retr[:-1]


        array_retraction_measured_height = cutting_odd_retr(array_retraction_measured_height)
        array_retraction_vertical_reflection = cutting_odd_retr(array_retraction_vertical_reflection)

        # print('len(array_extension_measured_height)', len(array_extension_measured_height))
        # print('len(array_extension_vertical_reflection)',len(array_extension_vertical_reflection))
        # print('len(array_retraction_measured_height)',len(array_retraction_measured_height))
        # print('len(array_retraction_vertical_reflection)', len(array_retraction_vertical_reflection))



        # correcting bending for raw data
        bend_corrected_array_extension_measured_height = array_extension_measured_height + array_extension_vertical_reflection / Spring_cons
        bend_corrected_array_retraction_measured_height = array_retraction_measured_height + array_retraction_vertical_reflection / Spring_cons


        # define interpolation range as the overlap measured_height position data area of extension and retraction
        min_extenstion_measured_height = min(array_extension_measured_height)
        min_retraction_measured_height = min(array_retraction_measured_height)
        max_extenstion_measured_height = max(array_extension_measured_height)
        max_retraction_measured_height = max(array_retraction_measured_height)
        lower_interp1d_band_base_on_measured_height = max(min_extenstion_measured_height, min_retraction_measured_height)
        upper_interp1d_band__base_on_measured_height = min(max_extenstion_measured_height, max_retraction_measured_height)
        print('band',lower_interp1d_band_base_on_measured_height, 'to', upper_interp1d_band__base_on_measured_height )

        ## RFFT


        len_of_retr = len(bend_corrected_array_retraction_measured_height)
        # print('len_of_retr',len_of_retr)
        rfft_of_retr = rfft(array_retraction_vertical_reflection, len_of_retr)
        # print('rfft_of_retr',len(rfft_of_retr))# computes the fft
        sample_rate_retr = (max(bend_corrected_array_retraction_measured_height) - min(bend_corrected_array_retraction_measured_height)) / len_of_retr

        print('sample rate', sample_rate_retr)
        rfftfreq_of_retr = rfftfreq(len_of_retr, sample_rate_retr)
        # print('rfftfreq_of_retr', len(rfftfreq_of_retr))
        irfft_retr = irfft(rfft_of_retr)
        # print('irfft_retr', len(irfft_retr))

        len_of_ext = len(bend_corrected_array_extension_measured_height)
        # print('len_of_ext', len_of_ext)
        rfft_of_ext = rfft(array_extension_vertical_reflection, len_of_ext)
        # print('rfft_of_ext',len(rfft_of_ext))
        sample_rate_ext = (max(bend_corrected_array_extension_measured_height) - min(
            bend_corrected_array_extension_measured_height)) / len_of_ext
        rfftfreq_of_ext = rfftfreq(len_of_ext, sample_rate_ext)
        # print('rfftfreq_of_ext', len(rfftfreq_of_ext))
        irfft_ext = irfft(rfft_of_ext)


        ## sigmoid for retr
        def sigmoid(rate, xmidp, input):
            return 1 / (1 + np.exp(-grow_rate_of_sigmoid * (xmidp - input)))

        x_sigmoid_midpoint = 2e8 # the x value of the sigmoid's midpoint;
        grow_rate_of_sigmoid = 5e-8 # the logistic growth rate or steepness of the curve
        y_sig_midpoint = 0.5

        x_sig_retr = np.linspace(min(rfftfreq_of_retr), max(rfftfreq_of_retr), len(rfftfreq_of_retr))
        y_sig_retr = sigmoid(rate = grow_rate_of_sigmoid, xmidp = x_sigmoid_midpoint, input = x_sig_retr)

        x_sig_ext = np.linspace(min(rfftfreq_of_ext), max(rfftfreq_of_ext), len(rfftfreq_of_ext))
        y_sig_ext = sigmoid(rate = grow_rate_of_sigmoid, xmidp = x_sigmoid_midpoint, input = x_sig_ext)



        # filter by sigmoid
        sig_filtered_retr = np.multiply(y_sig_retr, np.abs(np.real(rfft_of_retr)))
        irfft_sig_filtered_retr = irfft(np.multiply(y_sig_retr, rfft_of_retr))

        sig_filtered_ext = np.multiply(y_sig_ext, np.abs(np.real(rfft_of_ext)))
        irfft_sig_filtered_ext = irfft(np.multiply(y_sig_ext, rfft_of_ext))





        fig1 = plt.figure(1)
        fig1.set_size_inches(16, 9)
        Original_ext_and_retr = fig1.add_subplot(231)
        log_sigmoid_filtereted_rfft_retr = fig1.add_subplot(236)
        sigmoid_filter = fig1.add_subplot(233)
        log_sigmoid_filtereted_rfft_ext = fig1.add_subplot(235)
        rfftfiltered_result = fig1.add_subplot(234)
        sigmoid_filter_ext = fig1.add_subplot(232)

        # for measured height, plot the original ext and retr data
        Original_ext_and_retr.title.set_text('Original extention & retraction')
        Original_ext_and_retr.plot(bend_corrected_array_extension_measured_height, array_extension_vertical_reflection,
                    'o-', color ='gold',
                                   markerfacecolor='darkorange', markeredgecolor='darkorange', markersize=1.0, lw = 0.8,
                                   label = 'raw_extension_bending_corrected',
                                   alpha=0.9)
        Original_ext_and_retr.plot(bend_corrected_array_retraction_measured_height, array_retraction_vertical_reflection,
                    'o-', color ='plum',
                                   markerfacecolor='purple', markeredgecolor='purple', markersize=1.0, lw = 0.8,
                                   label = 'raw_retraction_bending_corrected',
                                   alpha=0.7)
        Original_ext_and_retr. legend(loc='best')
        Original_ext_and_retr.set(xlabel='Separation (m)', ylabel='Vertical Deflection (N)')



        # plot rfft vs. freq


        # plot rfft vs. freq for original and sigmoid filtered
        log_sigmoid_filtereted_rfft_retr.title.set_text('Sigmoid filtereted rfft retr (log)')
        log_sigmoid_filtereted_rfft_retr.plot(rfftfreq_of_retr/1e6, np.abs(np.real(rfft_of_retr)), color='purple', label ='Original rfft retr')
        log_sigmoid_filtereted_rfft_retr.plot(rfftfreq_of_retr/1e6, sig_filtered_retr, color ='red', label ='Sigmoid filtereted rfft retr')
        log_sigmoid_filtereted_rfft_retr.plot(x_sig_retr/1e6, y_sig_retr, color='green', label ='sigmoid_filter')
        log_sigmoid_filtereted_rfft_retr.set_yscale('log')
        log_sigmoid_filtereted_rfft_retr.scatter(x_sigmoid_midpoint/1e6, y_sig_midpoint, color='red', s=45.0)
        log_sigmoid_filtereted_rfft_retr. legend(loc='best')
        log_sigmoid_filtereted_rfft_retr.set(xlabel='Frequency (MHz)', ylabel='RFFT Magnitude')


        log_sigmoid_filtereted_rfft_ext.title.set_text('Sigmoid filtereted rfft ext (log)')
        log_sigmoid_filtereted_rfft_ext.plot(rfftfreq_of_ext, np.abs(np.real(rfft_of_ext)), color='orange', label ='Original rfft ext')
        log_sigmoid_filtereted_rfft_ext.plot(rfftfreq_of_ext, sig_filtered_ext, color ='red', label ='Sigmoid filtereted rfft ext')
        log_sigmoid_filtereted_rfft_ext.plot(x_sig_ext, y_sig_ext, color='m', label ='sigmoid_filter')
        log_sigmoid_filtereted_rfft_ext.scatter(x_sigmoid_midpoint, y_sig_midpoint, color='red', s=45.0, label = 'midpoint')
        log_sigmoid_filtereted_rfft_ext.set_yscale('log')
        log_sigmoid_filtereted_rfft_ext. legend(loc='best')
        log_sigmoid_filtereted_rfft_ext.set(xlabel='Separation (m)', ylabel='RFFT Magnitude')

        sigmoid_filter_ext.title.set_text('Sigmoid filter ext')
        sigmoid_filter_ext.plot(x_sig_ext, y_sig_ext, color='m', label='sigmoid')
        sigmoid_filter_ext.scatter(x_sigmoid_midpoint, y_sig_midpoint, color='red', s=45.0, label = 'midpoint')
        sigmoid_filter_ext.legend(loc='best')
        sigmoid_filter_ext.set(xlabel='Separation (m)', ylabel='Sigmoid')




        # plot sigmoid filter
        sigmoid_filter.title.set_text('Sigmoid filter retr')
        sigmoid_filter.plot(x_sig_retr, y_sig_retr, color='green', label ='sigmoid filter retr')
        sigmoid_filter.scatter(x_sigmoid_midpoint, y_sig_midpoint, color = 'red', s=45.0, label = 'midpoint')
        sigmoid_filter.legend(loc='best')
        sigmoid_filter.set(xlabel='Separation (m)', ylabel='Sigmoid')

        # plot retraction result
        rfftfiltered_result.title.set_text('RFFT filtered Result')
        rfftfiltered_result.plot(bend_corrected_array_extension_measured_height, irfft_sig_filtered_ext,
                                 color='gold', label = 'filtered ext')
        rfftfiltered_result.plot(bend_corrected_array_retraction_measured_height, irfft_sig_filtered_retr,
                                 color ='purple', label = 'filtered retr')
        rfftfiltered_result.legend(loc='best')
        rfftfiltered_result.set(xlabel='Separation (m)', ylabel='Vertical Deflection (N)')

        plt.rcParams.update({'font.size': 15})
        plt.subplots_adjust(hspace=0.4, wspace= 0.3)
        # plt.show()

        # define interpolation range as the overlap measured_height position data area of extension and retraction

        lower_interp1d_band_base_on_measured_height = max(
            min(bend_corrected_array_extension_measured_height),
            min(bend_corrected_array_retraction_measured_height))
        upper_interp1d_band_base_on_measured_height = min(
            max(bend_corrected_array_extension_measured_height),
            max(bend_corrected_array_retraction_measured_height))

        print('band',lower_interp1d_band_base_on_measured_height, 'to', upper_interp1d_band__base_on_measured_height )

        fig2 = plt.figure(2)
        fig2.set_size_inches(6, 6)

        # Interpolation

        Interpolation_number = 4000
        interp1d_measured_height = np.linspace(lower_interp1d_band_base_on_measured_height, upper_interp1d_band_base_on_measured_height, Interpolation_number)
        function_extension_base_on_height = scipy.interpolate.interp1d(bend_corrected_array_extension_measured_height,
                                                         irfft_sig_filtered_ext,
                                                         fill_value="extrapolate")
        function_retraction_base_on_height = scipy.interpolate.interp1d(bend_corrected_array_retraction_measured_height,
                                                          irfft_sig_filtered_retr,
                                                          fill_value="extrapolate")
        # #plt.plot(array_extension_measured_height,function_extension_base_on_height(array_extension_measured_height), color = 'b', lw = 3.0, label ='function_extension_base_on_height')
        array_retr_minus_ext_base_on_height = function_retraction_base_on_height(interp1d_measured_height) - function_extension_base_on_height(
             interp1d_measured_height)
        function_retr_minus_ext_base_on_height = scipy.interpolate.interp1d(interp1d_measured_height, array_retr_minus_ext_base_on_height,
                                             fill_value="extrapolate")
        rfftfiltered_result.plot(interp1d_measured_height, array_retr_minus_ext_base_on_height ,
                                 color = 'b', linewidth = '1', label = 'retr - ext')

        # find and assign zero point
        baseObj_retr_minus_ext_base_on_height = BaselineRemoval(array_retr_minus_ext_base_on_height)
        Imodpoly_output_for_ext_minus_retr_base_on_height = baseObj_retr_minus_ext_base_on_height.IModPoly(polynomial_degree_for_ext_minus_retr)
        # rfftfiltered_result.plot(interp1d_measured_height, Imodpoly_output_for_ext_minus_retr_base_on_height, color='gold',
        # linewidth = 0.8,label='Imodpoly_for_ext_minus_retr_base_on_height')

        start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height = Imodpoly_output_for_ext_minus_retr_base_on_height[
                                                                         0:round(len(Imodpoly_output_for_ext_minus_retr_base_on_height)/3)]
        shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height = start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height[np.argmin(start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height):]
        # print('len(Imodpoly_output_for_ext_minus_retr_base_on_height)',len(Imodpoly_output_for_ext_minus_retr_base_on_height))
        # print('len(start_half_Imodpoly_output_for_ext_minus_retr_base_on_height)', len(start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height))
        # print('len(shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height)',len(shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height))
        index_of_zero_x_base_on_height_on_interpad_measured_height = np.argmin(start_one_third_Imodpoly_output_for_ext_minus_retr_base_on_height) + np.argmax(shorter_start_half_Imodpoly_output_for_ext_minus_retr_base_on_height)
        zero_x_base_on_height = interp1d_measured_height[index_of_zero_x_base_on_height_on_interpad_measured_height]
        zero_y_base_on_height = array_retr_minus_ext_base_on_height[index_of_zero_x_base_on_height_on_interpad_measured_height]
        shifted_array_retr_minus_ext_base_on_height = array_retr_minus_ext_base_on_height - zero_y_base_on_height

        # plotting after interpolation
        rfftfiltered_result.scatter(zero_x_base_on_height,zero_y_base_on_height, s = 15.0, color = 'purple', label = 'method1: zero_point_based_on_height' )
        # rfftfiltered_result.plot(interp1d_measured_height, shifted_array_retr_minus_ext_base_on_height,
        #                          color='red',
        #                          linewidth=0.8, label='shifted_array_retr_minus_ext_base_on_height')
        # print('zero_x_base_on_height',zero_x_base_on_height)

        plt.plot(interp1d_measured_height, array_retr_minus_ext_base_on_height,
                                 color='b', linewidth='2', label='retr - ext')
        # plt.plot(interp1d_measured_height, Imodpoly_output_for_ext_minus_retr_base_on_height, color='gold',
        # linewidth = 2,label='Imodpoly_for_ext_minus_retr_base_on_height')
        # plt.scatter(zero_x_base_on_height,zero_y_base_on_height, s = 15.0, color = 'purple', label = 'method1: zero_point_based_on_height' )
        # plt.plot(interp1d_measured_height, shifted_array_retr_minus_ext_base_on_height,
        #                          color='red',
        #                          linewidth=2, label='shifted_array_retr_minus_ext_base_on_height')
        plt.show()

        fig3 = plt.figure(3)



        fig3.set_size_inches(8, 5)
        plt.rc('font', family='Helvetica')
        font_size_tick = 10
        font_szie_xy_label=10
        show_Original_ext_and_retr = fig3.add_subplot(231)
        show_fft= fig3.add_subplot(232)
        sigmoid_filter_ext=fig3.add_subplot(233)
        show_rfft = fig3.add_subplot(234)
        show_result = fig3.add_subplot(235)
        set_linewidth = 1


        # for measured height, plot the original ext and retr data
        # show_Original_ext_and_retr.title.set_text('Original extention & retraction')
        shift_x_for_presnet = bend_corrected_array_extension_measured_height[-2]
        # print('shift_x_for_presnet',
        #       bend_corrected_array_extension_measured_height[-2]*1e9
        #       )
        show_Original_ext_and_retr.plot((bend_corrected_array_extension_measured_height-shift_x_for_presnet)*1e9, array_extension_vertical_reflection*1e9,
                                   'o-',
                                   color=rgb_lightred,
                                   markerfacecolor=rgb_red, markeredgecolor=rgb_red, markersize=0.6,
                                   lw=set_linewidth,
                                   label='Extension',
                                   alpha=0.9)
        show_Original_ext_and_retr.plot((bend_corrected_array_retraction_measured_height-shift_x_for_presnet)*1e9,
                                   array_retraction_vertical_reflection*1e9,
                                   'o-',
                                   color=rgb_lightblue,
                                   markerfacecolor=rgb_blue, markeredgecolor=rgb_blue, markersize=0.6,
                                   lw=set_linewidth,
                                   label='Retraction',
                                   alpha=0.9)
        show_Original_ext_and_retr.legend(loc='best',fontsize = 10, frameon=False)
        show_Original_ext_and_retr.set_xticks(np.arange(0, 1600, 400),fontsize=font_size_tick)
        show_Original_ext_and_retr.set_yticks(np.arange(30, 50, 5),fontsize=font_size_tick)
        show_Original_ext_and_retr.set_xlabel('Position (nm)',fontsize=font_szie_xy_label)
        show_Original_ext_and_retr.set_ylabel('$\it{F}$'+' (nN)',fontsize=font_szie_xy_label)


        sigmoid_filter_ext.plot(x_sig_ext/1e6, y_sig_ext, color='black', label='Sigmoid Filter')
        sigmoid_filter_ext.legend(loc='best', fontsize=small_size, frameon=False)
        sigmoid_filter_ext.scatter(x_sigmoid_midpoint/1e6, y_sig_midpoint, color='black', s=45.0, label='Midpoint')
        sigmoid_filter_ext.set_xticks(np.arange(0, 600, 150), fontsize=10)
        sigmoid_filter_ext.set_yticks(np.arange(0, 2, 1), fontsize=10)
        sigmoid_filter_ext.set_xlabel('Frequency (1/nm)', fontsize=font_szie_xy_label)
        sigmoid_filter_ext.set_ylabel('Filter', fontsize=font_szie_xy_label)
        sigmoid_filter_ext.tick_params(axis='both', labelsize=10)



        # show_fft.title.set_text('Sigmoid filtereted rfft ext (log)')
        show_fft.plot(rfftfreq_of_ext/1e6, np.abs(np.real(rfft_of_ext)), color='orange',
                                             label='FFT extention',
                                             lw=set_linewidth)
        show_fft.plot(rfftfreq_of_ext/1e6, sig_filtered_ext, color='red',
                                             label='Sigmoid filtereted FFT extension',
                                            lw=set_linewidth)
        # show_fft.plot(x_sig_ext/1e6, y_sig_ext, color='m', label='sigmoid_filter')
        # show_fft.scatter(x_sigmoid_midpoint/1e6, y_sig_midpoint, color='red', s=45.0)
        show_fft.set_yscale('log')
        show_fft.legend(loc='best',fontsize = small_size, frameon=False)

        # plot sigmoid filter
        # show_fft.title.set_text('Sigmoid filter retr')
        # show_fft.plot(x_sig_retr/1e6, y_sig_retr, color='black', label='Sigmoid filter', lw=set_linewidth)
        # show_fft.scatter(x_sigmoid_midpoint/1e6, y_sig_midpoint, color='black', s=30.0)
        show_fft.legend(loc='best',fontsize = small_size,frameon=False)
        show_fft.set_xticks(np.arange(0, 600, 150), fontsize=font_size_tick)
        show_fft.set_yticks([1e-16,1e-12,1e-8,1e-4,1e0], fontsize=10)
        show_fft.set_xlabel('Frequency (1/nm)',fontsize=font_szie_xy_label)
        show_fft.set_ylabel('Magnitude (nN)', fontsize=font_szie_xy_label)

        # plot retraction result
        # show_rfft.title.set_text('RFFT filtered Result')
        show_rfft.plot((bend_corrected_array_extension_measured_height-shift_x_for_presnet)*1e9, irfft_sig_filtered_ext*1e9,lw=set_linewidth,
                                 color=rgb_red, label='RFFT Extention')
        show_rfft.plot((bend_corrected_array_retraction_measured_height-shift_x_for_presnet)*1e9, irfft_sig_filtered_retr*1e9,lw=set_linewidth,
                                 color=rgb_blue, label='RFFT Retraction')
        show_rfft.legend(loc='best',fontsize = small_size)
        show_rfft.set_xticks(np.arange(0, 1600, 400), fontsize=font_size_tick)
        show_rfft.set_yticks(np.arange(30, 50, 5), fontsize=font_size_tick)
        show_rfft.set_xlabel('Position (nm)',fontsize=font_szie_xy_label)
        show_rfft.set_ylabel('$\it{F}$'+' (nN)', fontsize=font_szie_xy_label)



        show_result.plot((interp1d_measured_height-shift_x_for_presnet)*1e9, array_retr_minus_ext_base_on_height*1e9 , lw=set_linewidth,
                                 color = rgb_green, label = 'Retraction-Extension')
        # show_result.axvline(x=0, color='grey', linestyle='--', zorder=0)
        show_result.axhline(y=0, color='grey', linestyle='--', zorder=0)
        show_result.set_xticks(np.arange(0, 1600, 400), fontsize=font_size_tick)
        show_result.set_yticks(np.arange(-12, 2, 4), fontsize=font_size_tick)
        show_result.set_xlabel('Position (nm)',fontsize=font_szie_xy_label)
        show_result.set_ylabel('$\it{F}$'+' (nN)', fontsize=font_szie_xy_label)
        show_result.legend(loc='best',fontsize = small_size, frameon=False)
        plt.rcParams.update({'font.size': small_size})
        # plt.subplots_adjust(hspace=0.1, wspace= 0.1)
        # Adjust label and tick font sizes
        # Adjust tick font sizes
        for ax in [show_Original_ext_and_retr, show_fft, show_rfft, show_result]:
            ax.tick_params(axis='both', labelsize=10)  # Adjust tick label font size

        # Adjust the title font size of each subplot
        # for ax in [show_Original_ext_and_retr, show_fft, show_rfft, show_result]:
        #     ax.title.set_fontsize(10)
        # Adjust layout to prevent clipping of titles
        # plt.subplots_adjust(wspace=0.1)
        plt.tight_layout()
        # plt.subplots_adjust(left=0.1, right=0.95, top=0.95, bottom=0.05, wspace=0.32, hspace=0.3)
        save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/data_process.eps'
        # plt.savefig(save_path, format='eps', bbox_inches='tight', dpi=1200)
        plt.show()

