% Data for E=1e6 and v=0, rho=80, 20 loadsteps
nels =  [2^2        2^3         2^4         2^5         2^6         2^7         2^8];
nmp  =  [2^1        2^2         2^3         2^4         2^5         2^6         2^7         2^8         2^9];

eMPM1 = [6.250E-02	3.129E-02   2.994E-02	3.226E-02	3.465E-02	3.611E-02	3.597E-02];  %   2MPs/element
eMPM2 = [6.250E-02	3.827E-02   3.025E-02	2.819E-02	2.977E-02	3.098E-02	3.111E-02];  %   4MPs/element
eMPM3 = [6.364E-02	3.436E-02   2.450E-02	2.304E-02	2.284E-02	2.313E-02	2.489E-02];  %   8MPs/element
eMPM4 = [6.000E-02	3.084E-02   1.848E-02	1.515E-02	1.451E-02	1.540E-02	1.715E-02];  %  16MPs/element
eMPM5 = [5.952E-02	2.864E-02   1.349E-02	7.734E-03	5.809E-03	6.796E-03	8.172E-03];  %  32MPs/element
eMPM6 = [5.999E-02	2.843E-02   1.276E-02	5.469E-03	3.268E-03	3.522E-03	3.939E-03];  %  64MPs/element
eMPM7 = [5.991E-02	2.840E-02   1.263E-02	4.833E-03	2.062E-03	1.843E-03	2.075E-03];  % 128MPs/element
eMPM8 = [5.999E-02	2.835E-02   1.257E-02	4.735E-03	1.435E-03	1.010E-03	1.032E-03];  % 256MPs/element
eMPM9 = [5.995E-02	2.835E-02   1.257E-02	4.687E-03	1.269E-03	6.592E-04   5.276E-04];  % 512MPs/element


h    = 50./nels;

figure; 
loglog(1./h,eMPM1,'k-o','MarkerFaceColor','w','MarkerSize', 6); hold on;
loglog(1./h,eMPM2,'k-o','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./h,eMPM3,'k-s','MarkerFaceColor','w','MarkerSize', 6);
loglog(1./h,eMPM4,'k-s','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./h,eMPM5,'k-d','MarkerFaceColor','w','MarkerSize', 6);
loglog(1./h,eMPM6,'k-d','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./h,eMPM7,'k-^','MarkerFaceColor','w','MarkerSize', 6);
loglog(1./h,eMPM8,'k-^','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./h,eMPM9,'k-v','MarkerFaceColor','w','MarkerSize', 6);
set(gca,'FontSize',16);
xlabel('$1/h_z$','Interpreter','latex');
ylabel('normalised stress error','Interpreter','latex');
legend('2^1 MPs','2^2 MPs','2^3 MPs','2^4 MPs','2^5 MPs','2^6 MPs','2^7 MPs','2^8 MPs','2^9 MPs','Location','southwest')


tnmp = nmp.'*nels;
hmp  = 50./tnmp;

eMPMs=[eMPM1; eMPM2; eMPM3; eMPM4; eMPM5; eMPM6; eMPM7; eMPM8; eMPM9];

figure; 
for i=1:size(nels,2)
  loglog(1./hmp(:,i),eMPMs(:,i),'k-'); hold on;
end
loglog(1./hmp(1,:),eMPM1,'ko','MarkerFaceColor','w','MarkerSize', 6); hold on;
loglog(1./hmp(2,:),eMPM2,'ko','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./hmp(3,:),eMPM3,'ks','MarkerFaceColor','w','MarkerSize', 6);
loglog(1./hmp(4,:),eMPM4,'ks','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./hmp(5,:),eMPM5,'kd','MarkerFaceColor','w','MarkerSize', 6);
loglog(1./hmp(6,:),eMPM6,'kd','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./hmp(7,:),eMPM7,'k^','MarkerFaceColor','w','MarkerSize', 6);
loglog(1./hmp(8,:),eMPM8,'k^','MarkerFaceColor','k','MarkerSize', 6);
loglog(1./hmp(9,:),eMPM9,'kv','MarkerFaceColor','w','MarkerSize', 6);
set(gca,'FontSize',16);
xlabel('$1/l_p^0$','Interpreter','latex');
ylabel('normalised stress error','Interpreter','latex');
