
nels     = [2^2       2^3       2^4       2^5       2^6       2^7       2^8       2^9       2^10    ];  % number of elements

eGIMP    = [5.73E-02  2.54E-02  9.48E-03  2.37E-03  7.94E-04  2.32E-04  6.35E-05  1.91E-05  7.17E-06];  % update via U or F
eGIMPdet = [5.76E-02  2.56E-02  9.58E-03  2.47E-03  9.24E-04  4.26E-04  3.52E-04  3.86E-04  4.45e-04];  % volume update, det(J)
eGIMPnon = [5.82E-02  2.60E-02  1.35E-02  1.20E-02  1.21E-02  1.21E-02  1.21E-02  1.21e-02  1.21e-02];  % no update

eCPDI    = [5.752E-02	2.560E-02	9.681E-03	2.354E-03	7.607E-04	2.299E-04	6.061E-05	1.740E-05	6.548E-06];  % CPDI2

h    = 50./nels;    % element size

figure; clf;
loglog(1./h,eCPDI   ,'k-d','MarkerFaceColor','k','MarkerSize', 9); hold on;
loglog(1./h,eGIMPnon,'k-o','MarkerFaceColor','k','MarkerSize', 7); hold on;
loglog(1./h,eGIMPdet,'k-v','MarkerFaceColor','w','MarkerSize', 7);
loglog(1./h,eGIMP   ,'k-s','MarkerFaceColor','w','MarkerSize', 7);

set(gca,'FontSize',16);
xlabel('$1/h_z$','Interpreter','latex');
ylabel('normalised stress error')
legend('CPDI2','no update','det(F_i_j)','U_i_j or F_i_j','Location','southwest');