      SUBROUTINE  VINIT(II,RM,RESULT)
      USE physical_constants
      USE potential, only: LAMBDA
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXPAR=4)
      SAVE
      logical :: inolls=.false.
      DOUBLE PRECISION, ALLOCATABLE::  BETA0(:)
      DOUBLE PRECISION, ALLOCATABLE::  ALPHAS0(:)
      DOUBLE PRECISION, ALLOCATABLE:: RPT(:), VPT(:), R2PT(:)
      DOUBLE PRECISION, DIMENSION(MAXPAR):: DELAA,DELAB,SDOTN,EQQA,EQQB
      DOUBLE PRECISION, DIMENSION(MAXPAR):: STENIA,STENIB,EFFLG
      DOUBLE PRECISION, ALLOCATABLE:: CPLPAR(:)
      INTEGER, ALLOCATABLE:: ICPFOR(:)
      COMMON /PES_DATA/ LMAX
      CHARACTER(LEN=80) :: POTFNAME
      DIMENSION LAM(1)
      character(2) ordnl

      NAMELIST / POTFILE / POTFNAME,XLAM,IPOTL,A,B,C6,C8,C10,
     1 IDELAA,IDELAB,ISDOTN,IEQQA,IEQQB,ISTENIA,ISTENIB,IEFFLG,
     2 DELAA,DELAB,SDOTN,EQQA,EQQB,STENIA,STENIB,EFFLG
C
C  include common block for data received via pvm
C
cINOLLS include 'all/pvmdat1.f'
cINOLLS include 'all/pvmdat.f'
C
      IF (II.NE.1) GOTO 15
      AUtocm=hartree_in_inv_cm
      XMHZTOCM = MHz_in_inv_cm
      XDBVMTOCM = Debye_Volt_metre_in_inv_cm
C
C  FIELD IN V/M  DIPOLE MOMENT IN D
C

      POTFNAME='potl.tab'
      XLAM=1.0
      A=0.0
      B=0.0
      C6=0.0
      C8=0.0
      C10=0.0
      IPOTL=-1
      IDELAA =0
      IDELAB =0
      ISDOTN =0
      IEQQA  =0
      IEQQB  =0
      ISTENIA=0
      ISTENIB=0
      IEFFLG =0
      DO I =1,MAXPAR
        DELAA (I) =0.0
        DELAB (I) =0.0
        SDOTN (I) =0.0
        EQQA  (I) =0.0
        EQQB  (I) =0.0
        STENIA(I) =0.0
        STENIB(I) =0.0
        EFFLG (I) =0.0
      ENDDO
      WRITE(6,*) ' IN VSTAR-ALK_1S_NEW. INITIALISING. '
      IF (.NOT. ALLOCATED(ICPFOR)) THEN
        MXLAM=1
c       ALLOCATE(LAMBDA(MXLAM))
        ALLOCATE(ICPFOR(MXLAM))
        ALLOCATE(CPLPAR(MAXPAR*MXLAM))
        LAMBDA(1)=1
        WRITE(6,*)"LAMBDA ARRAY NOT PASSED IN FROM EXTERNAL ROUTINE, SO"
     1           ," ASSUMING ONLY ELECTRONIC POTENTIAL IS REQUIRED AND "
     2           , "SETTING LAMBDA=1."
        WRITE(6,*)"(NB. THIS LAMBDA IS INTERNAL TO VSTAR AND MAY DIFFER"
     1           ," FROM LAMBDA USED ELSEWHERE IN THE PROGRAM FOR "
     2           ,"ITYPE=1)"
      ENDIF
      IF (.NOT.INOLLS) READ(5,POTFILE)

      IF (IPOTL.EQ.1 .OR. IPOTL.EQ.-1) THEN
        WRITE(6,25)IPOTL,POTFNAME
   25   FORMAT('  IPOTL = ',I1,' REQUESTS POTENTIAL FROM AB INITIO DATA'
     1       ' POINTS IN EXTERNAL FILE: ',A,' PLUS ANALYTIC LONG RANGE')
        OPEN(9,FILE=POTFNAME,FORM="FORMATTED",STATUS="OLD",err=1000)
        READ(9,*)  ! LINE WITH COMMENT, TITLE ETC..
C  NUMBER OF POINTS BELOW/SCALING FACTOR/ TYPE OF ASYMPTOTIC BEHAVIOR
        READ(9,*) NPOINTS, FAC
C
C  OVERWRITE FAC FROM DATA FILE WITH VALUE FROM PVM MESSAGE
C  NOT WORTH AN INCLUDE STATEMENT FOR 1 LINE
cINOLLS if (inolls) fac=parm0(1)
C
        WRITE(6,*)' NPOINTS = ',NPOINTS
        WRITE(6,*)' POTENTIAL SCALING FACTOR = ',FAC
        WRITE(6,*)' INPUT XLAM SCALING FACTOR = ',XLAM
        write(6,*)' TOTAL SCALING FACTOR = ',FAC*XLAM
        ALLOCATE(RPT(NPOINTS))
        ALLOCATE(R2PT(NPOINTS))
        ALLOCATE(VPT(NPOINTS))
        NP0 = 3
        MP0 = 2
        LP0 = 1
        NFIX = 0
        ASYM = 0.0D0
        BETA1= 3.D0/10.D0
        BETA2=-3.D0/10.D0
        BETA3= 3.D0/35.D0
        if (ipotl.EQ.-1) then
          MP0 = 5
          BETA1= 3.D0/56.D0
          BETA2=-4.D0*BETA1/3.D0
          BETA3= 7.D0*BETA1/15.D0
        endif
        ALLOCATE(BETA0(NP0))
        BETA0(1) =  BETA1
        BETA0(2) =  BETA2
        BETA0(3) =  BETA3

        ALLOCATE(ALPHAS0(npoints))

        CALL FLUSH(6)
        DO 70 IA=1,NPOINTS
          READ(9,*) RPT(IA), VXPT
          VPT(IA) = VXPT*FAC*XLAM
          R2PT(IA) = RPT(IA)**2
   70   CONTINUE

        if (ipotl.eq.1) then
        CALL RK_INIT(NPOINTS, R2PT, VPT, ALPHAS0, BETA0,
     1               NP0, MP0, LP0, NFIX, ASYM )
        elseif (ipotl.eq.-1) then
        CALL RK_INIT(NPOINTS, RPT, VPT, ALPHAS0, BETA0,
     1               NP0, MP0, LP0, NFIX, ASYM )
        endif

        C6_REF=0.0
        C8_REF=0.0
        C10_REF=0.0
        DO IA=0,NPOINTS
          C6_REF=C6_REF+ALPHAS0(IA)
          C8_REF=C8_REF+ALPHAS0(IA)*R2PT(IA)
          C10_REF=C10_REF+ALPHAS0(IA)*R2PT(IA)**2
        ENDDO
        C6_REF=C6_REF*BETA0(1)
        C8_REF=C8_REF*BETA0(2)
        C10_REF=C10_REF*BETA0(3)
C  PARAMETERS FOR ASYMPTOTIC BEHAVIOR
C  IASYMP=1 MEANS WE INCLUDE ONLY C6
C  IASYMP>1 INCLUDE C8 AND C10
C  B IS THE EXPONENT FOR THE TANG-TOENNIES DAMPING FUNCTION IN
C  BOHR^-1
C  C6, C8, C10 ARE IN ATOMIC UNITS.
        IF (IPOTL.EQ.1) THEN
        READ(9,*) IASYMP,B,C6,C8,C10
        ELSEIF (IPOTL.EQ.-1) THEN
        READ(9,*) IASYMP,FSW1,FSW2,C6,C8
        C10=0D0
        ENDIF
cINOLLS if (inolls) then
cINOLLS   c6=parm0(2)
cINOLLS   c8=c6*parm0(3)
cINOLLS   if (iasymp.ge.3) c10=c8*parm0(3)
cINOLLS   if (parm0(4).gt.1.d0) fsw1=parm0(4)
cINOLLS   if (parm0(5).gt.1.d0) fsw2=parm0(5)
cINOLLS endif
   20   FORMAT('  C',I1,'  = ',G12.5,' AU = ',G12.5,' CM-1 ANGSTROM**'
     1          ,I1)
   21   FORMAT('  C',I2,' = ',G12.5,' AU = ',G12.5,' CM-1 ANGSTROM**'
     1          ,I2)
        WRITE(6,20) 6,C6,C6*AUTOCM*(bohr_to_Angstrom**6),6
        WRITE(6,20) 8,C8,C8*AUTOCM*(bohr_to_Angstrom**8),8
        WRITE(6,21) 10,C10,C10*AUTOCM*(bohr_to_Angstrom**10),10
        C6=C6*AUTOCM*(bohr_to_Angstrom**6)
        C8=C8*AUTOCM*(bohr_to_Angstrom**8)
        C10=C10*AUTOCM*(bohr_to_Angstrom**10)
   22   FORMAT('  TANG-TOENNIES DAMPING RANGE, B = ',G12.5,
     1         ' AU (BOHR**-1) = ',G12.5,' ANGSTROM**-1')
        WRITE(6,22) B,B/bohr_to_Angstrom
        B=B/BOHR_TO_ANGSTROM

CCC REMOVED INPUTTING COUPLING TERMS THROUGH POTENTIAL FILE. WILL NOW BE
CCC INPUT THROUGH INPUT FILE.

C  PARAMETERS FOR R-DEPENDENCE OF FERMI CONTACT   [ MHZ, 1/ANG, ANG ]
c      READ(9,*) FA1,FA2,FA3
C  PARAMETERS FOR R-DEPENDENCE OF SPIN-ROTATION
c      READ(9,*) GA1,GA2,GA3
C  PARAMETERS FOR R-DEPENDENCE OF EQQ
c      READ(9,*) HA1,HA2,HA3
C     READ(9,*) DA1,DA2,DA3,EFLD !             E FLD DATA
C     IF (FA4.LT.0) THEN
C       DREF=226.0 ! ENERGY AT 7 ANG
C       XMAXFC=7.0    ! DELTA HFC AT 7 ANG
C       FA4 = ((XMAXFC*XMHZTOCM)/DREF )*C6/XMHZTOCM
C       WRITE(*,*) XMAXFC*XMHZTOCM ,DE, FA4/C6
C     ELSE
C       FA4=0D0
C     ENDIF
C     RRX= 2.0
C     DO I=1,100
C       VXX = V_RKHS(RRX, NP0, MP0, LP0, NPOINTS, BETA0, RPT, ALPHAS0)
C       WRITE(*,*) RRX, FA4*(RRX/0.529177)**(-6)*XMHZTOCM
C       RRX=RRX+0.5
C     ENDDO
C     WRITE(*,*) ' ASYMPTOTIC COEFFICIENT FOR I.S TERM: ',FA4,' MHZ '
        CLOSE(9)
      ELSE IF (IPOTL.EQ.2) THEN
C CODE FOR ANALYTIC POTENTIAL WITH DAMPED DISPERSION PLUS REPULSIVE
C EXPONENTIAL. CONTROLLED ENTIRELY THROUGH NAMELIST INPUT. MOSTLY JUST
C ECHOING INPUT AND UNIT CONVERSIONS HERE.
        WRITE(6,26)IPOTL
   26   FORMAT('  IPOTL = ',I1,' REQUESTS POTENTIAL WITH DAMPED',
     1         ' DISPERSION PLUS REPULSIVE EXPONENTIAL')
        WRITE(6,20) 6,C6,C6*AUTOCM*(bohr_to_Angstrom**6),6
        WRITE(6,20) 8,C8,C8*AUTOCM*(bohr_to_Angstrom**8),8
        WRITE(6,21) 10,C10,C10*AUTOCM*(bohr_to_Angstrom**6),10
        C6=C6*AUTOCM*(bohr_to_Angstrom**6)
        C8=C8*AUTOCM*(bohr_to_Angstrom**8)
        C10=C10*AUTOCM*(bohr_to_Angstrom**10)
   27   FORMAT('  EXPONENT OF REPULSIVE EXPONENTIAL B = ',G12.5,
     1         ' AU (BOHR**-1) = ',G12.5,' ANGSTROM**-1'/
     2         ' ALSO USED AS RANGE OF TANG-TOENNIES DAMPING FUNCTIONS')
        WRITE(6,27) B,B/bohr_to_Angstrom
        B=B/BOHR_TO_ANGSTROM
        WRITE(6,28) A,A*AUTOCM
        A=A*AUTOCM
   28   FORMAT('  PREFACTOR OF REPULSIVE EXPONENTIAL A = ',G12.5,
     1         ' AU (HARTREE) = ',G12.5,' CM-1')
      ELSE
        WRITE(6,24)IPOTL
   24   FORMAT(/'  IPOTL = ',I2,' UNRECOGNISED. STOPPING.')
        STOP
      ENDIF
   15 CONTINUE
C LIST POTENTIAL TERM
      LAMB=LAMBDA(II)
      WRITE(6,10) II, ordnl(ii),LAMB
   10 FORMAT(/'  ',I2'-',a2,' POTENTIAL TERM IS LAMBDA = ',I2)
C GET COUPLING TERM FORM AND PARAMETERS INTO JOINT ARRAY
      IF (LAMB.EQ.1) THEN
        ICPFOR(II)=0
        WRITE(6,*) "  WHICH IS ELECTRONIC POTENTIAL"
      ELSEIF (LAMB.EQ.2) THEN
        WRITE(6,*) "  WHICH IS R-DEPENDENT COMPONENT OF SCALAR "//
     1            "(ISOTROPIC) HYPERFINE COUPLING ON ATOM A"
        ICPFOR(II)=IDELAA
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=DELAA(I)
        ENDDO
      ELSEIF (LAMB.EQ.3) THEN
        WRITE(6,*) "  WHICH IS R-DEPENDENT COMPONENT OF SCALAR "//
     1            "(ISOTROPIC) HYPERFINE COUPLING ON ATOM B"
        ICPFOR(II)=IDELAB
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=DELAB(I)
        ENDDO
      ELSEIF (LAMB.EQ.4) THEN
        WRITE(6,*) "  WHICH IS TENSORAL "//
     1            "(ANISOTROPIC) HYPERFINE COUPLING ON ATOM A"
        ICPFOR(II)=ISTENIA
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=STENIA(I)
        ENDDO
      ELSEIF (LAMB.EQ.5) THEN
        WRITE(6,*) "  WHICH IS TENSORAL "//
     1            "(ANISOTROPIC) HYPERFINE COUPLING ON ATOM B"
        ICPFOR(II)=ISTENIB
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=STENIB(I)
        ENDDO
      ELSEIF (LAMB.EQ.6) THEN
        WRITE(6,*) "  WHICH IS NUCLEAR QUADRUPOLE "//
     1            "COUPLING ON ATOM A"
        ICPFOR(II)=IEQQA
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=EQQA(I)
        ENDDO
      ELSEIF (LAMB.EQ.7) THEN
        WRITE(6,*) "  WHICH IS NUCLEAR QUADRUPOLE "//
     1            "COUPLING ON ATOM B"
        ICPFOR(II)=IEQQB
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=EQQB(I)
        ENDDO
      ELSEIF (LAMB.EQ.8) THEN
        WRITE(6,*) "  WHICH IS SPIN-ROTATION COUPLING"
        ICPFOR(II)=ISDOTN
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=SDOTN(I)
        ENDDO
      ELSEIF (LAMB.EQ.9) THEN
        WRITE(6,*) "  WHICH IS LINEAR STARK EFFECT"
        ICPFOR(II)=IEFFLG
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=EFFLG(I)
        ENDDO
      ELSE
        WRITE(6,*) "  WHICH DOES NOT CORRESPOND TO A KNOWN POTENTIAL ",
     1             "TERM. VSTAR WILL RETURN 0 FOR THIS LAMBDA."
        ICPFOR(II)=0
        DO I=1,MAXPAR
          CPLPAR(I+(II-1)*MAXPAR)=0.0
        ENDDO
      ENDIF

      IF (LAMB.EQ.1) GOTO 16
      IF (ICPFOR(II).EQ.1) THEN
        WRITE(6,29)ICPFOR(II),CPLPAR(1+(II-1)*MAXPAR),
     1    CPLPAR(1+(II-1)*MAXPAR)*XMHZTOCM,CPLPAR(2+(II-1)*MAXPAR),
     2    CPLPAR(3+(II-1)*MAXPAR)
   29   FORMAT('  FUNCTIONAL FORM ',I2,' REQUESTED IS GAUSSIAN,'/
     1         '  V(R)=P(1)*EXP(-P(2)*(R-P(3))**2)'/
     2         '  WITH P(1)=',G12.5,' MHz = ',G12.5,' CM-1'/
     3         '       P(2)=',G12.5,' ANGSTROM**-2'/
     4         '       P(3)=',G12.5,' ANGSTROM'/)
        CPLPAR(1+(II-1)*MAXPAR)=CPLPAR(1+(II-1)*MAXPAR)*XMHZTOCM
      ELSE IF (ICPFOR(II).EQ.2) THEN
        WRITE(6,30)ICPFOR(II),CPLPAR(1+(II-1)*MAXPAR),
     1    CPLPAR(1+(II-1)*MAXPAR)*XMHZTOCM,CPLPAR(2+(II-1)*MAXPAR)
   30   FORMAT('  FUNCTIONAL FORM ',I2,' REQUESTED IS EXPONENTIAL,'/
     1         '  V(R)=P(1)*EXP(-P(2)*R)'/
     2         '  WITH P(1)=',G12.5,' MHz =',G12.5,' CM-1'/
     3         '       P(2)=',G12.5,' ANGSTROM**-1'/)
        CPLPAR(1+(II-1)*MAXPAR)=CPLPAR(1+(II-1)*MAXPAR)*XMHZTOCM
      ELSE IF (ICPFOR(II).EQ.3) THEN
        WRITE(6,33)ICPFOR(II),CPLPAR(1+(II-1)*MAXPAR),
     1    CPLPAR(1+(II-1)*MAXPAR)*XMHZTOCM,CPLPAR(2+(II-1)*MAXPAR),
     2    CPLPAR(3+(II-1)*MAXPAR)
   33   FORMAT('  FUNCTIONAL FORM ',I2,' REQUESTED IS LORENTZIAN-LIKE,'/
     1         '  V(R)=P(1)/(1.D0+(R-P(2))**2/P(3))**2'/
     2         '  WITH P(1)=',G12.5,' MHz = ',G12.5,' CM-1'/
     3         '       P(2)=',G12.5,' ANGSTROM'/
     4         '       P(3)=',G12.5,' ANGSTROM**2'/)
        CPLPAR(1+(II-1)*MAXPAR)=CPLPAR(1+(II-1)*MAXPAR)*XMHZTOCM
      ELSE IF (ICPFOR(II).EQ.0) THEN
        WRITE(6,32)ICPFOR(II)
   32   FORMAT('  FUNCTIONAL FORM ',I2,' REQUESTED MEANS'
     1         ' VSTAR WILL RETURN ZERO FOR THIS COUPLING TERM.')
      ELSE
        WRITE(6,31)ICPFOR(II)
   31   FORMAT('  FUNCTIONAL FORM ',I2,' REQUESTED FOR COUPLING TERM'
     1         ' IS UNRECOGNISED. STOPPING.')
        STOP
      ENDIF
16    CONTINUE
      RETURN
1000  write(6,*) 'potential file ',potfname,' not found'
      stop

      ENTRY VSLAM(MXLM)
      MXLAM=MXLM
c     ALLOCATE(LAMBDA(MXLAM))
      ALLOCATE(ICPFOR(MXLAM))
      ALLOCATE(CPLPAR(MAXPAR*MXLAM))
c     DO I=1,MXLAM
c       LAMBDA(I)=LAM(I)
c     ENDDO
      RETURN

C -------------------------------------------------------
       ENTRY VSTAR(II , X, SUM)
C -------------------------------------------------------
C  POTENTIAL IN CM-1 / ANGSTROMS
C  ALL RELEVANT PARAMETERS ALREADY CONVERTED TO CORRECT UNITS
       SUM=0D0
       IF (LAMBDA(II).EQ.1) THEN
         IF (IPOTL.EQ.1) THEN
           XX = X**2
       SUM_RKHS=V_RKHS(XX, NP0, MP0, LP0, NPOINTS, BETA0, R2PT, ALPHAS0)
           DISP_REF=TT_damp(x,b,3)*C6_REF/X**6+
     1      TT_damp(x,b,4)*C8_REF/X**8+TT_damp(x,b,5)*C10_REF/X**10
           SUM_SR=SUM_RKHS-DISP_REF
           IF (IASYMP.GT.1) THEN
             SUM_LR = -TT_damp(x,b,3)*C6/X**6
     1         -TT_damp(x,b,4)*C8/X**8 -TT_damp(x,b,5)*C10/X**10
           ELSE
             SUM_LR = -C6/RBOHR**6
           ENDIF
           sum=sum_sr+sum_lr
         ELSEIF (IPOTL.EQ.2) THEN
           SUM=SUM-TT_damp(x,b,3)*C6/X**6
           SUM=SUM-TT_damp(x,b,4)*C8/X**8
           SUM=SUM-TT_damp(x,b,5)*C10/X**10
           SUM=SUM+A*DEXP(-B*X)
         ELSEIF (IPOTL.EQ.-1) THEN
           SWITCH=FSWITCH(X,FSW1,FSW2)
           SUM_SR = V_RKHS(X,NP0,MP0, LP0, NPOINTS, BETA0, RPT, ALPHAS0)
           IF (IASYMP.GT.1) THEN
             SUM_LR = -C6/X**6 -C8/X**8 -C10/X**10
           ELSE
             SUM_LR = -C6/X**6
           ENDIF
           SUM = SUM_SR *(1D0-SWITCH)+SUM_LR*SWITCH
         ENDIF
       ELSE
         SUM = EVALCP(X,ICPFOR(II),CPLPAR((1+(II-1)*MAXPAR)))
       ENDIF
       RETURN
C  --------------------------------------------------------
C  DUMMY ROUTINES
C  --------------------------------------------------------
C --------------------------------------------------------
      ENTRY VSTAR1(II,X,SUM)
C --------------------------------------------------------
C --------------------------------------------------------
      ENTRY VSTAR2(II,X,SUM)
C --------------------------------------------------------
      WRITE(6,*) 'VSTAR: DERIVATIVES NOT IMPLEMENTED'
      RETURN
 2010 WRITE(6,*) ' ERROR OPENING THE FILE ',POTFNAME
      END
C --------------------------------------------------------
      FUNCTION TT_DAMP(R,B,N)
C --------------------------------------------------------
C FUNCTION TO EVALUATE TANG-TOENNIES DAMPING FUNCTIONS
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      SUM=0.0
      DO K=0,2*N
        SUM=SUM+((B*R)**K)/FACTORIAL(K)
      ENDDO
      SUM=SUM*EXP(-B*R)
      TT_DAMP=1.0-SUM
      RETURN
      END FUNCTION
C --------------------------------------------------------
      FUNCTION FACTORIAL(I)
C --------------------------------------------------------
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      SUM=1.0
      DO J=1,I
        SUM=SUM*J
      ENDDO
      FACTORIAL=SUM
      RETURN
      END FUNCTION
C ----------------------------------------------------
      FUNCTION EVALCP(X,IFORM,PARAMS)
C ----------------------------------------------------
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C FUNCTION TO EVALUATE COUPLING TERMS WITH A SIMPLE FUNCTIONAL FORM.
C FORM IS SPECIFIED BY IFORM AND PARAMS ARE IN PARAMS. CURRENT CODED
C FUNCTIONAL FORMS ARE:
C 1. GAUSSIAN
      PARAMETER (MAXPAR=4)
      DIMENSION PARAMS(MAXPAR)
      SUM=0.0
      IF (IFORM.EQ.0) THEN
        SUM=0.0
      ELSE IF (IFORM.EQ.1) THEN
        SUM=PARAMS(1)*DEXP(-PARAMS(2)*(X-PARAMS(3))**2)
      ELSE IF (IFORM.EQ.2) THEN
        SUM=PARAMS(1)*DEXP(-PARAMS(2)*X)
      ELSE IF (IFORM.EQ.3) THEN
        SUM=PARAMS(1)/(1.D0+(X-PARAMS(2))**2/PARAMS(3))**2
      END IF
      EVALCP=SUM
      RETURN
      END FUNCTION
C ----------------------------------------------------
      SUBROUTINE RK_INIT(NR,RPT,VPT,ALPHA,BETA,N,M,L,NFIX,ASYM)
C ----------------------------------------------------
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION IPIV(:),WORK(:),Q(:,:),RPT(NR),VPT(NR)
      DIMENSION BETA(1),ALPHA(NR)
      DIMENSION WORK2(:)
      ALLOCATABLE IPIV,WORK,Q,WORK2

      ALLOCATE(IPIV(NR))
      ALLOCATE(WORK(NR))
      ALLOCATE(WORK2(NR))
      ALLOCATE(Q(NR,NR))

      DO I=1,NR
        DO J=1,NR
          RS = MIN( RPT(I),RPT(J))
          RL = MAX( RPT(I),RPT(J))
          Q(I,J)=0.0D0
          DO K=0,N-1
            Q(I,J)=Q(I,J)+BETA(K+1)*(RS/RL)**K
          ENDDO
          Q(I,J)=Q(I,J)*(RL)**(-L*(M+1))
        ENDDO
      ENDDO
      CALL DCOPY (NR,VPT,1,WORK2,1)
      CALL DGESV (NR, 1, Q, NR, IPIV, VPT, NR, INFO)
      CALL DCOPY (NR,VPT,1,ALPHA,1)
      CALL DCOPY (NR,WORK2,1,VPT,1)
      DEALLOCATE(IPIV,WORK,WORK2,Q)
      END
C ----------------------------------------------------
      DOUBLE PRECISION FUNCTION V_RKHS(R,N,M,L,NR,BETA,RPT,ALPHA)
C ----------------------------------------------------
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION BETA(1),RPT(NR),ALPHA(NR)
      V = 0.0D0
      DO I=1,NR
        RS = MIN(R,RPT(I))
        RL = MAX(R,RPT(I))
        Q  = 0.0D0
        DO K=1,N
          Q = Q+ BETA(K)*(RS/RL)**(K-1)
        ENDDO
        Q = Q*(1.0D0/RL)**(L*(M+1))
        V = V + Q*ALPHA(I)
      ENDDO
      V_RKHS = V
      END

C ----------------------------------------------------
      DOUBLE PRECISION FUNCTION FSWITCH(R,A,B)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (PI2=1.570796326794897D0)
      IF (R.LE.A) THEN
        FSWITCH=0D0
      ELSEIF (R.GE.B) THEN
        FSWITCH=1D0
      ELSE
        X=((R-B)-(A-R))/(B-A)
        FSWITCH=0.5D0+0.25D0*DSIN(PI2*X)*(3D0-(DSIN(PI2*X))**2)
      ENDIF
      END
